/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.graphical.editors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.ConnectionCreationToolEntry;
import org.eclipse.gef.palette.MarqueeToolEntry;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.SelectionToolEntry;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.jboss.tools.smooks.configuration.SmooksConfigurationActivator;
import org.jboss.tools.smooks.configuration.editors.actions.ISmooksActionGrouper;
import org.jboss.tools.smooks.configuration.editors.uitls.SmooksUIUtils;
import org.jboss.tools.smooks.editor.ISmooksModelProvider;
import org.jboss.tools.smooks.gef.tree.model.TriggerConnection;
import org.jboss.tools.smooks.graphical.editors.Messages;
import org.jboss.tools.smooks.model.javabean12.BeanType;
import org.jboss.tools.smooks.model.smooks.ConditionType;
import org.jboss.tools.smooks.model.smooks.SmooksResourceListType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmooksGraphicalEditorPaletteRootCreator {
    protected AdapterFactoryEditingDomain editingDomain;
    protected SmooksResourceListType resourceList;
    protected ISmooksModelProvider smooksModelProvider;

    public SmooksGraphicalEditorPaletteRootCreator(ISmooksModelProvider provider, AdapterFactoryEditingDomain editingDomain, SmooksResourceListType resourceList) {
        this.editingDomain = editingDomain;
        this.resourceList = resourceList;
        this.smooksModelProvider = provider;
    }

    protected CreationFactory createConnectionCreationFactory() {
        return new CreationFactory(){

            public Object getObjectType() {
                return TriggerConnection.class;
            }

            public Object getNewObject() {
                return null;
            }
        };
    }

    public PaletteRoot createPaletteRoot() {
        PaletteRoot root = new PaletteRoot();
        PaletteDrawer drawer = new PaletteDrawer(Messages.SmooksGraphicalEditorPaletteRootCreator_General_Palette_Drawer);
        drawer.add((PaletteEntry)new SelectionToolEntry());
        drawer.add((PaletteEntry)new MarqueeToolEntry());
        CreationFactory factory = this.createConnectionCreationFactory();
        ImageRegistry imageRegistry = SmooksConfigurationActivator.getDefault().getImageRegistry();
        drawer.add((PaletteEntry)new ConnectionCreationToolEntry(Messages.SmooksGraphicalEditorPaletteRootCreator_Link_Tool_Text, Messages.SmooksGraphicalEditorPaletteRootCreator_Link_Tool_Tooltip, factory, imageRegistry.getDescriptor("icons/full/obj16/connection16.gif"), imageRegistry.getDescriptor("icons/full/obj16/connection24.gif")));
        root.add((PaletteEntry)drawer);
        this.createPaletteDrawer(root);
        return root;
    }

    private void createPaletteDrawer(PaletteRoot root) {
        if (this.resourceList == null) {
            return;
        }
        IEditingDomainItemProvider provider = (IEditingDomainItemProvider)this.editingDomain.getAdapterFactory().adapt((Notifier)this.resourceList, IEditingDomainItemProvider.class);
        if (provider != null) {
            Collection newChildrenDescripter = provider.getNewChildDescriptors((Object)this.resourceList, (EditingDomain)this.editingDomain, null);
            List<ISmooksActionGrouper> grouperList = this.getSmooksActionGrouper();
            for (ISmooksActionGrouper iSmooksActionGrouper : grouperList) {
                PaletteDrawer drawer = new PaletteDrawer(iSmooksActionGrouper.getGroupName());
                this.fillDrawer(drawer, newChildrenDescripter, iSmooksActionGrouper);
                root.add((PaletteEntry)drawer);
            }
        }
    }

    private void fillDrawer(PaletteDrawer drawer, Collection<?> allchildren, ISmooksActionGrouper grouper) {
        for (Object object : allchildren) {
            if (!grouper.belongsToGroup(object) || !(object instanceof CommandParameter)) continue;
            Object v = ((CommandParameter)object).getValue();
            v = AdapterFactoryEditingDomain.unwrap((Object)v);
            v = EcoreUtil.copy((EObject)((EObject)v));
            IEditingDomainItemProvider editDomainIemProvider = (IEditingDomainItemProvider)this.editingDomain.getAdapterFactory().adapt(v, IEditingDomainItemProvider.class);
            IItemLabelProvider itemLabelProvider = (IItemLabelProvider)this.editingDomain.getAdapterFactory().adapt(v, IItemLabelProvider.class);
            if (SmooksUIUtils.isUnSupportElement(this.smooksModelProvider.getPlatformVersion(), (EObject)v) || this.isIgnoreType(v)) continue;
            EClass clazz = ((EObject)v).eClass();
            Object newModel = ((CommandParameter)object).getValue();
            if (newModel instanceof FeatureMap.Entry) {
                newModel = FeatureMapUtil.createEntry((EStructuralFeature)((FeatureMap.Entry)newModel).getEStructuralFeature(), (Object)v);
            }
            String entryName = clazz.getName();
            ImageDescriptor smallImage = null;
            if (itemLabelProvider != null) {
                entryName = itemLabelProvider.getText(v);
                Object imageObj = itemLabelProvider.getImage(v);
                smallImage = ExtendedImageRegistry.getInstance().getImageDescriptor(imageObj);
            }
            CombinedTemplateCreationEntry toolEntry = new CombinedTemplateCreationEntry(entryName, entryName, (CreationFactory)new SmooksModelCreationFactory(newModel, ((CommandParameter)object).getFeature()), smallImage, smallImage);
            drawer.add((PaletteEntry)toolEntry);
            if (!this.needtToCreateChildrenEntry(v)) continue;
            this.fillDrawer(drawer, editDomainIemProvider.getNewChildDescriptors(v, (EditingDomain)this.editingDomain, null));
        }
    }

    private boolean isIgnoreType(Object element) {
        return element instanceof ConditionType;
    }

    private void fillDrawer(PaletteDrawer drawer, Collection<?> allchildren) {
        for (Object object : allchildren) {
            if (!(object instanceof CommandParameter)) continue;
            Object v = ((CommandParameter)object).getValue();
            v = AdapterFactoryEditingDomain.unwrap((Object)v);
            v = EcoreUtil.copy((EObject)((EObject)v));
            IItemLabelProvider itemLabelProvider = (IItemLabelProvider)this.editingDomain.getAdapterFactory().adapt(v, IItemLabelProvider.class);
            String entryName = null;
            ImageDescriptor smallImage = null;
            if (itemLabelProvider != null) {
                entryName = itemLabelProvider.getText(v);
                Object imageObj = itemLabelProvider.getImage(v);
                smallImage = ExtendedImageRegistry.getInstance().getImageDescriptor(imageObj);
            }
            if (SmooksUIUtils.isUnSupportElement(this.smooksModelProvider.getPlatformVersion(), (EObject)v) || this.isIgnoreType(v)) continue;
            EClass clazz = ((EObject)v).eClass();
            Object newModel = ((CommandParameter)object).getValue();
            if (newModel instanceof FeatureMap.Entry) {
                v = FeatureMapUtil.createEntry((EStructuralFeature)((FeatureMap.Entry)newModel).getEStructuralFeature(), (Object)v);
            }
            if (entryName == null) {
                entryName = clazz.getName();
            }
            EStructuralFeature feature = ((CommandParameter)object).getEStructuralFeature();
            CombinedTemplateCreationEntry toolEntry = new CombinedTemplateCreationEntry(entryName, entryName, (CreationFactory)new SmooksModelCreationFactory(v, feature), smallImage, smallImage);
            drawer.add((PaletteEntry)toolEntry);
            if (!this.needtToCreateChildrenEntry(v)) continue;
            IEditingDomainItemProvider provider = (IEditingDomainItemProvider)this.editingDomain.getAdapterFactory().adapt(v, IEditingDomainItemProvider.class);
            this.fillDrawer(drawer, provider.getNewChildDescriptors(v, (EditingDomain)this.editingDomain, null));
        }
    }

    private boolean needtToCreateChildrenEntry(Object element) {
        return element instanceof BeanType;
    }

    protected void fillActionGrouper(List<ISmooksActionGrouper> grouperList) {
    }

    protected List<ISmooksActionGrouper> getSmooksActionGrouper() {
        ArrayList<ISmooksActionGrouper> grouperList = new ArrayList<ISmooksActionGrouper>();
        this.fillActionGrouper(grouperList);
        return grouperList;
    }

    public class SmooksModelCreationFactory
    implements CreationFactory {
        private Object type = null;
        private Object model;

        public SmooksModelCreationFactory(Object model, Object type) {
            this.model = model;
            this.type = type;
        }

        public Object getNewObject() {
            return this.model;
        }

        public Object getObjectType() {
            return this.type;
        }
    }
}

