/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.graphical.editors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackEvent;
import org.eclipse.gef.commands.CommandStackEventListener;
import org.eclipse.gef.dnd.TemplateTransferDropTargetListener;
import org.eclipse.gef.editparts.FreeformGraphicalRootEditPart;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.jboss.tools.smooks.configuration.editors.IXMLStructuredObject;
import org.jboss.tools.smooks.configuration.editors.SelectorCreationDialog;
import org.jboss.tools.smooks.configuration.editors.javabean.JavaBeanModel;
import org.jboss.tools.smooks.configuration.editors.javabean.JavabeanContentProvider;
import org.jboss.tools.smooks.configuration.editors.javabean.JavabeanlabelProvider;
import org.jboss.tools.smooks.configuration.editors.uitls.SmooksUIUtils;
import org.jboss.tools.smooks.configuration.editors.xml.XMLStructuredDataContentProvider;
import org.jboss.tools.smooks.configuration.editors.xml.XMLStructuredDataLabelProvider;
import org.jboss.tools.smooks.configuration.validate.ISmooksModelValidateListener;
import org.jboss.tools.smooks.editor.ISmooksModelProvider;
import org.jboss.tools.smooks.editor.ISourceSynchronizeListener;
import org.jboss.tools.smooks.gef.common.RootModel;
import org.jboss.tools.smooks.gef.model.AbstractSmooksGraphicalModel;
import org.jboss.tools.smooks.gef.tree.editparts.TreeNodeEditPart;
import org.jboss.tools.smooks.gef.tree.figures.GraphAnimation;
import org.jboss.tools.smooks.gef.tree.figures.IMoveableModel;
import org.jboss.tools.smooks.gef.tree.model.TreeNodeConnection;
import org.jboss.tools.smooks.gef.tree.model.TreeNodeModel;
import org.jboss.tools.smooks.graphical.actions.AutoLayoutAction;
import org.jboss.tools.smooks.graphical.editors.ConnectionModelFactory;
import org.jboss.tools.smooks.graphical.editors.ConnectionModelFactoryImpl;
import org.jboss.tools.smooks.graphical.editors.GraphicalModelFactory;
import org.jboss.tools.smooks.graphical.editors.GraphicalModelFactoryImpl;
import org.jboss.tools.smooks.graphical.editors.IGraphicalEditorPart;
import org.jboss.tools.smooks.graphical.editors.ITaskNodeProvider;
import org.jboss.tools.smooks.graphical.editors.Messages;
import org.jboss.tools.smooks.graphical.editors.SmooksEditFactory;
import org.jboss.tools.smooks.graphical.editors.SmooksGraphicalEditorMenuContextProvider;
import org.jboss.tools.smooks.graphical.editors.SmooksTaskDetailsEditorSite;
import org.jboss.tools.smooks.graphical.editors.autolayout.IAutoLayout;
import org.jboss.tools.smooks.graphical.editors.commands.IgnoreException;
import org.jboss.tools.smooks.graphical.editors.editparts.RightClickSelectMarqueeDragTraker;
import org.jboss.tools.smooks.graphical.editors.editparts.SmooksGraphUtil;
import org.jboss.tools.smooks.graphical.editors.model.IValidatableModel;
import org.jboss.tools.smooks.graphical.editors.model.InputDataContianerModel;
import org.jboss.tools.smooks.graphical.editors.model.InputDataRootModel;
import org.jboss.tools.smooks.graphical.editors.model.InputDataTreeNodeModel;
import org.jboss.tools.smooks.graphical.editors.process.TaskType;
import org.jboss.tools.smooks.model.javabean12.BeanType;
import org.jboss.tools.smooks.model.javabean12.Javabean12Package;
import org.jboss.tools.smooks.model.javabean12.ValueType;
import org.jboss.tools.smooks.model.javabean12.WiringType;
import org.jboss.tools.smooks.model.smooks.AbstractReader;
import org.jboss.tools.smooks.model.smooks.DocumentRoot;
import org.jboss.tools.smooks.model.smooks.ParamType;
import org.jboss.tools.smooks.model.smooks.SmooksResourceListType;
import org.jboss.tools.smooks.model.validation10.RuleType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmooksGraphicalEditorPart
extends GraphicalEditor
implements ISelectionChangedListener,
ISourceSynchronizeListener,
IGraphicalEditorPart,
ITaskNodeProvider,
ISmooksModelValidateListener {
    private CommandStackListener emfCommandStackListener = null;
    public static final int EXECUTE_COMMAND = 0;
    public static final int REDO_COMMAND = 1;
    public static final int UNDO_COMMAND = 2;
    private static final int SOURCE_CONNECT_TYPE = 1;
    private static final int TARGET_CONNECT_TYPE = 0;
    private DefaultEditDomain editDomain = new DefaultEditDomain((IEditorPart)this);
    protected ISmooksModelProvider smooksModelProvider = null;
    protected RootModel root;
    protected SmooksResourceListType smooksResourceList;
    protected List<Object> inputDataList = null;
    protected GraphicalModelFactory graphicalModelFactory;
    protected ConnectionModelFactory connectionModelFactory;
    protected TaskType taskType;

    public SmooksGraphicalEditorPart(ISmooksModelProvider provider) {
        this.editDomain.setCommandStack(new CommandStack(){

            public void execute(org.eclipse.gef.commands.Command command) {
                try {
                    super.execute(command);
                }
                catch (Exception e) {
                    if (e instanceof IgnoreException) {
                        return;
                    }
                    throw new RuntimeException(e);
                }
            }
        });
        this.editDomain.getCommandStack().addCommandStackEventListener(new CommandStackEventListener(){

            public void stackChanged(CommandStackEvent event) {
                SmooksGraphicalEditorPart.this.firePropertyChange(257);
            }
        });
        this.smooksModelProvider = provider;
        this.setEditDomain(this.editDomain);
        this.createEMFCommandStackListener();
    }

    private void createEMFCommandStackListener() {
        this.emfCommandStackListener = new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                final Command mostRecentCommand = ((org.eclipse.emf.common.command.CommandStack)event.getSource()).getMostRecentCommand();
                final EventObject fe = event;
                SmooksGraphicalEditorPart.this.getEditorSite().getShell().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (mostRecentCommand != null) {
                            Command rawCommand = mostRecentCommand;
                            while (rawCommand instanceof CommandWrapper) {
                                rawCommand = ((CommandWrapper)rawCommand).getCommand();
                            }
                            int commandType = 0;
                            Command undoCommand = ((org.eclipse.emf.common.command.CommandStack)fe.getSource()).getUndoCommand();
                            Command redoCommand = ((org.eclipse.emf.common.command.CommandStack)fe.getSource()).getRedoCommand();
                            if (undoCommand != null || rawCommand.equals(undoCommand)) {
                                commandType = 0;
                            }
                            if (redoCommand != null || rawCommand.equals(redoCommand)) {
                                commandType = 2;
                            }
                            if (rawCommand instanceof CompoundCommand) {
                                List commandList = ((CompoundCommand)rawCommand).getCommandList();
                                for (Command command : commandList) {
                                    while (command instanceof CommandWrapper) {
                                        command = ((CommandWrapper)command).getCommand();
                                    }
                                    SmooksGraphicalEditorPart.this.handleInputParamChange(command);
                                    if (!(command instanceof SetCommand) && !(command instanceof AddCommand) && !(command instanceof DeleteCommand) && !(command instanceof RemoveCommand)) continue;
                                    SmooksGraphicalEditorPart.this.refershRecentAffectedModel(command, command.getAffectedObjects(), commandType);
                                }
                            } else if (rawCommand instanceof SetCommand || rawCommand instanceof AddCommand || rawCommand instanceof DeleteCommand || rawCommand instanceof RemoveCommand) {
                                SmooksGraphicalEditorPart.this.handleInputParamChange(rawCommand);
                                SmooksGraphicalEditorPart.this.refershRecentAffectedModel(rawCommand, mostRecentCommand.getAffectedObjects(), commandType);
                            }
                        }
                    }
                });
            }
        };
    }

    @Override
    public TaskType getTaskType() {
        return this.taskType;
    }

    @Override
    public void setTaskType(TaskType taskType) {
        this.taskType = taskType;
    }

    public void createPartControl(Composite parent) {
        IEditorSite site = this.getEditorSite();
        if (site instanceof SmooksTaskDetailsEditorSite) {
            FormPage page = ((SmooksTaskDetailsEditorSite)site).getParentEditor();
            FormToolkit tool = page.getManagedForm().getToolkit();
            Composite mainComposite = tool.createComposite(parent);
            mainComposite.setBackground(tool.getColors().getBorderColor());
            FillLayout fillLayout = new FillLayout();
            fillLayout.marginHeight = 1;
            fillLayout.marginWidth = 1;
            mainComposite.setLayout((Layout)fillLayout);
            super.createPartControl(mainComposite);
            return;
        }
        super.createPartControl(parent);
    }

    public GraphicalViewer getGraphicalViewer() {
        return super.getGraphicalViewer();
    }

    private void handleCommandStack(org.eclipse.emf.common.command.CommandStack commandStack) {
        if (this.emfCommandStackListener != null) {
            commandStack.addCommandStackListener(this.emfCommandStackListener);
        }
    }

    public void dispose() {
        if (this.smooksModelProvider != null) {
            this.smooksModelProvider.getEditingDomain().getCommandStack().removeCommandStackListener(this.emfCommandStackListener);
        }
        super.dispose();
    }

    protected void autoLayoutWhenCommandChange(Command command) {
        Collection affectedObjects = command.getAffectedObjects();
        boolean refreshInputModel = false;
        for (Object object : affectedObjects) {
            if (command instanceof AddCommand && this.needToLayoutWhenAddModel(object)) {
                refreshInputModel = true;
                break;
            }
            Collection deletedObjs = null;
            if (command instanceof DeleteCommand) {
                deletedObjs = ((DeleteCommand)command).getCollection();
            }
            if (command instanceof RemoveCommand) {
                deletedObjs = ((RemoveCommand)command).getCollection();
            }
            if (deletedObjs != null) {
                for (Object object2 : deletedObjs) {
                    if (!this.needToLayoutWhenRemoveModel(object2)) continue;
                    refreshInputModel = true;
                    break;
                }
            }
            if (refreshInputModel) break;
        }
        if (refreshInputModel) {
            this.autoLayout(true);
        }
    }

    protected boolean needToLayoutWhenAddModel(Object model) {
        return false;
    }

    protected boolean needToLayoutWhenRemoveModel(Object model) {
        return false;
    }

    protected void handleInputParamChange(Command command) {
        Collection affectedObjects = command.getAffectedObjects();
        boolean refreshInputModel = false;
        for (Object object : affectedObjects) {
            if (object instanceof ParamType && SmooksUIUtils.isInputParamType((ParamType)object)) {
                refreshInputModel = true;
                break;
            }
            if (object instanceof AbstractReader) {
                refreshInputModel = true;
                break;
            }
            Collection deletedObjs = null;
            if (command instanceof DeleteCommand) {
                deletedObjs = ((DeleteCommand)command).getCollection();
            }
            if (command instanceof RemoveCommand) {
                deletedObjs = ((RemoveCommand)command).getCollection();
            }
            if (deletedObjs != null) {
                for (Object object2 : deletedObjs) {
                    if (object2 instanceof ParamType && SmooksUIUtils.isInputParamType((ParamType)object2)) {
                        refreshInputModel = true;
                        break;
                    }
                    if (!(object2 instanceof AbstractReader)) continue;
                    refreshInputModel = true;
                    break;
                }
            }
            if (refreshInputModel) break;
        }
        if (refreshInputModel) {
            this.inputTypeChanged();
        }
    }

    public ConnectionModelFactory getConnectionModelFactory() {
        if (this.connectionModelFactory == null) {
            this.connectionModelFactory = this.createConnectionModelFactory();
        }
        return this.connectionModelFactory;
    }

    protected ConnectionModelFactory createConnectionModelFactory() {
        return new ConnectionModelFactoryImpl();
    }

    public void setConnectionModelFactory(ConnectionModelFactory connectionModelFactory) {
        this.connectionModelFactory = connectionModelFactory;
    }

    public GraphicalModelFactory getGraphicalModelFactory() {
        if (this.graphicalModelFactory == null) {
            this.graphicalModelFactory = this.createGraphicalModelFactory();
        }
        return this.graphicalModelFactory;
    }

    protected GraphicalModelFactory createGraphicalModelFactory() {
        return new GraphicalModelFactoryImpl();
    }

    public void setGraphicalModelFactory(GraphicalModelFactoryImpl graphicalModelFactory) {
        this.graphicalModelFactory = graphicalModelFactory;
    }

    protected void createActions() {
        super.createActions();
        AutoLayoutAction autoLayout = new AutoLayoutAction((IWorkbenchPart)this);
        autoLayout.setId("_smooks_auto_layout");
        this.getActionRegistry().registerAction((IAction)autoLayout);
        this.getSelectionActions().add(autoLayout.getId());
    }

    private void deleteRelatedConnection(AbstractSmooksGraphicalModel effecedNode, EStructuralFeature feature, SetCommand command) {
        Object sourceModel;
        AbstractSmooksGraphicalModel source;
        List<TreeNodeConnection> targetConnections;
        ArrayList<TreeNodeConnection> temp;
        EObject data = (EObject)AdapterFactoryEditingDomain.unwrap((Object)effecedNode.getData());
        if (feature.equals(SmooksUIUtils.getBeanIDRefFeature(data))) {
            List<TreeNodeConnection> sourceConnections = effecedNode.getSourceConnections();
            temp = new ArrayList<TreeNodeConnection>(sourceConnections);
            for (TreeNodeConnection treeNodeConnection : temp) {
                Object iddata;
                EStructuralFeature idfeature;
                AbstractSmooksGraphicalModel target = treeNodeConnection.getTargetNode();
                Object refValue = command.getValue();
                if (refValue == null) continue;
                String refID = refValue.toString();
                Object targetModel = AdapterFactoryEditingDomain.unwrap((Object)target.getData());
                if (!(targetModel instanceof EObject) || (idfeature = SmooksUIUtils.getBeanIDFeature((EObject)targetModel)) == null || (iddata = ((EObject)targetModel).eGet(idfeature)) == null || refID != null && refID.equals(iddata)) continue;
                target.getTargetConnections().remove(treeNodeConnection);
                effecedNode.getSourceConnections().remove(treeNodeConnection);
                target.fireConnectionChanged();
            }
        }
        if (feature.equals(SmooksUIUtils.getBeanIDFeature(data))) {
            targetConnections = effecedNode.getTargetConnections();
            temp = new ArrayList<TreeNodeConnection>(targetConnections);
            for (TreeNodeConnection treeNodeConnection : temp) {
                Object idRefData;
                EStructuralFeature idRefFeature;
                source = treeNodeConnection.getSourceNode();
                String beanID = command.getValue().toString();
                sourceModel = AdapterFactoryEditingDomain.unwrap((Object)source.getData());
                if (!(sourceModel instanceof EObject) || (idRefFeature = SmooksUIUtils.getBeanIDRefFeature((EObject)sourceModel)) == null || (idRefData = ((EObject)sourceModel).eGet(idRefFeature)) == null || beanID != null && beanID.equals(idRefData)) continue;
                source.getSourceConnections().remove(treeNodeConnection);
                effecedNode.getTargetConnections().remove(treeNodeConnection);
                source.fireConnectionChanged();
            }
        }
        if (feature.equals(SmooksUIUtils.getSelectorFeature(data))) {
            targetConnections = effecedNode.getTargetConnections();
            temp = new ArrayList<TreeNodeConnection>(targetConnections);
            for (TreeNodeConnection treeNodeConnection : temp) {
                source = treeNodeConnection.getSourceNode();
                if (!(source instanceof InputDataContianerModel) && !(source instanceof InputDataTreeNodeModel)) continue;
                String selector = command.getValue().toString();
                sourceModel = AdapterFactoryEditingDomain.unwrap((Object)source.getData());
                if (!(sourceModel instanceof IXMLStructuredObject)) continue;
                IXMLStructuredObject root = SmooksUIUtils.getRootParent((IXMLStructuredObject)sourceModel);
                IXMLStructuredObject oldNode = null;
                try {
                    oldNode = SmooksUIUtils.localXMLNodeWithPath(selector, root);
                }
                catch (Throwable throwable) {}
                if (oldNode == sourceModel) break;
                source.getSourceConnections().remove(treeNodeConnection);
                effecedNode.getTargetConnections().remove(treeNodeConnection);
                source.fireConnectionChanged();
            }
        }
    }

    public AbstractSmooksGraphicalModel findRelatedInputGraphicalModel(Object model) {
        if (model instanceof RuleType) {
            String selector = ((RuleType)model).getExecuteOn();
            for (Object inputData : this.inputDataList) {
                if (!(inputData instanceof IXMLStructuredObject)) continue;
                IXMLStructuredObject node = SmooksUIUtils.localXMLNodeWithPath(selector, (IXMLStructuredObject)inputData);
                AbstractSmooksGraphicalModel graphicalModel = this.findGraphicalModel(node);
                return graphicalModel;
            }
        }
        return null;
    }

    protected void refershRecentAffectedModel(Command command, Collection<?> affectedObjects, int commandType) {
        block2: for (Object object : affectedObjects) {
            Collection cccc;
            Collection<TreeNodeConnection> connections;
            EStructuralFeature feature;
            AbstractSmooksGraphicalModel node;
            object = AdapterFactoryEditingDomain.unwrap(object);
            if (commandType == 0 || commandType == 1) {
                AbstractSmooksGraphicalModel inputGraphicalModel;
                if (object instanceof SmooksResourceListType) {
                    AbstractSmooksGraphicalModel graphModel;
                    AbstractSmooksGraphicalModel inputGraphicalModel2;
                    Collection colletion;
                    if (command instanceof AddCommand) {
                        colletion = ((AddCommand)command).getCollection();
                        for (Object childModel : colletion) {
                            inputGraphicalModel2 = this.findRelatedInputGraphicalModel(childModel = AdapterFactoryEditingDomain.unwrap(childModel));
                            if (inputGraphicalModel2 != null) {
                                inputGraphicalModel2.fireVisualChanged();
                            }
                            if ((graphModel = this.createGraphModel(childModel)) == null) continue;
                            this.root.addTreeNode(graphModel);
                            this.applyGraphicalInformation(graphModel);
                            Collection<TreeNodeConnection> connections2 = this.createAllConnection(graphModel);
                            this.expandConnectedModels(connections2);
                        }
                    }
                    if (!(command instanceof DeleteCommand) && !(command instanceof RemoveCommand)) continue;
                    colletion = null;
                    if (command instanceof DeleteCommand) {
                        colletion = ((DeleteCommand)command).getCollection();
                    }
                    if (command instanceof RemoveCommand) {
                        colletion = ((RemoveCommand)command).getCollection();
                    }
                    for (Object childModel : colletion) {
                        inputGraphicalModel2 = this.findRelatedInputGraphicalModel(childModel = AdapterFactoryEditingDomain.unwrap(childModel));
                        if (inputGraphicalModel2 != null) {
                            inputGraphicalModel2.fireVisualChanged();
                        }
                        if ((graphModel = this.findGraphicalModel(childModel)) == null) continue;
                        AbstractSmooksGraphicalModel.disconnectAllConnections(graphModel);
                        this.root.removeTreeNode(graphModel);
                    }
                    continue;
                }
                object = AdapterFactoryEditingDomain.unwrap(object);
                node = this.findGraphicalModel(object);
                if (command instanceof SetCommand) {
                    if (node == null) continue;
                    node.fireVisualChanged();
                    feature = ((SetCommand)command).getFeature();
                    if (SmooksUIUtils.isRelatedConnectionFeature(feature)) {
                        this.deleteRelatedConnection(node, feature, (SetCommand)command);
                        connections = this.createConnection(node);
                        node.fireConnectionChanged();
                        this.expandConnectedModels(connections);
                    }
                }
                if (command instanceof AddCommand) {
                    inputGraphicalModel = this.findRelatedInputGraphicalModel(object);
                    if (inputGraphicalModel != null) {
                        inputGraphicalModel.fireVisualChanged();
                    }
                    Object owner = ((AddCommand)command).getOwner();
                    if ((owner = AdapterFactoryEditingDomain.unwrap((Object)owner)) instanceof SmooksResourceListType) {
                        AbstractSmooksGraphicalModel graphModel = this.createGraphModel(object);
                        if (graphModel == null) continue;
                        try {
                            this.root.addTreeNode(graphModel);
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                        this.applyGraphicalInformation(graphModel);
                        Collection<TreeNodeConnection> connections3 = this.createAllConnection(graphModel);
                        this.expandConnectedModels(connections3);
                    } else {
                        AbstractSmooksGraphicalModel ownerGraph = this.findGraphicalModel(owner);
                        if (ownerGraph != null) {
                            ownerGraph.fireChildrenChanged();
                        }
                    }
                    if (node == null) continue;
                    node.fireChildrenChanged();
                    node.fireConnectionChanged();
                }
                if (!(command instanceof DeleteCommand) && !(command instanceof RemoveCommand)) continue;
                inputGraphicalModel = this.findRelatedInputGraphicalModel(object);
                if (inputGraphicalModel != null) {
                    inputGraphicalModel.fireVisualChanged();
                }
                if (node == null) continue;
                node.fireChildrenChanged();
                continue;
            }
            if (commandType != 2) continue;
            object = AdapterFactoryEditingDomain.unwrap(object);
            node = this.findGraphicalModel(object);
            if (command instanceof AddCommand) {
                if (object instanceof SmooksResourceListType) {
                    cccc = ((AddCommand)command).getCollection();
                    for (Object object2 : cccc) {
                        AbstractSmooksGraphicalModel gmodel = this.findGraphicalModel(object2 = AdapterFactoryEditingDomain.unwrap(object2));
                        if (gmodel == null) continue;
                        this.root.removeTreeNode(gmodel);
                        break;
                    }
                } else if (node != null) {
                    node.fireChildrenChanged();
                }
            }
            if (command instanceof SetCommand) {
                if (node == null) continue;
                node.fireVisualChanged();
                feature = ((SetCommand)command).getFeature();
                if (SmooksUIUtils.isRelatedConnectionFeature(feature)) {
                    this.deleteRelatedConnection(node, feature, (SetCommand)command);
                    connections = this.createConnection(node);
                    node.fireConnectionChanged();
                    this.expandConnectedModels(connections);
                }
            }
            if (!(command instanceof DeleteCommand) && !(command instanceof RemoveCommand)) continue;
            cccc = null;
            if (command instanceof DeleteCommand) {
                cccc = ((DeleteCommand)command).getCollection();
            }
            if (command instanceof RemoveCommand) {
                cccc = ((RemoveCommand)command).getCollection();
            }
            for (Object object2 : cccc) {
                Collection<TreeNodeConnection> connections4;
                if (object != (object2 = AdapterFactoryEditingDomain.unwrap(object2))) continue;
                EObject owner = ((EObject)object).eContainer();
                if (owner instanceof SmooksResourceListType) {
                    AbstractSmooksGraphicalModel graphModel = this.createGraphModel(object = AdapterFactoryEditingDomain.unwrap(object));
                    if (graphModel == null) continue;
                    node = graphModel;
                    this.root.addTreeNode(graphModel);
                    connections4 = this.createAllConnection(graphModel);
                    this.expandConnectedModels(connections4);
                    this.applyGraphicalInformation(graphModel);
                    continue block2;
                }
                AbstractSmooksGraphicalModel ownernode = this.findGraphicalModel(owner);
                ownernode.fireChildrenChanged();
                node = this.findGraphicalModel(object);
                if (node == null) continue;
                connections4 = this.createAllConnection(node);
                this.expandConnectedModels(connections4);
                continue block2;
            }
        }
        this.autoLayoutWhenCommandChange(command);
    }

    private AbstractSmooksGraphicalModel findGraphicalModel(Object object) {
        return SmooksGraphUtil.findSmooksGraphModel(this.root, object);
    }

    public DefaultEditDomain getEditDomain() {
        return this.editDomain;
    }

    protected EditPartFactory createEdtiPartFactory() {
        return new SmooksEditFactory();
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        this.getGraphicalViewer().setEditDomain((EditDomain)this.editDomain);
        this.getGraphicalViewer().setEditPartFactory(this.createEdtiPartFactory());
        this.getGraphicalViewer().setRootEditPart((RootEditPart)new FreeformGraphicalRootEditPart(){

            public DragTracker getDragTracker(Request req) {
                return new RightClickSelectMarqueeDragTraker();
            }
        });
        this.getGraphicalViewer().addDropTargetListener((TransferDropTargetListener)new TemplateTransferDropTargetListener((EditPartViewer)this.getGraphicalViewer()));
        GraphicalViewerKeyHandler keyHandler = new GraphicalViewerKeyHandler(this.getGraphicalViewer());
        keyHandler.put(KeyStroke.getPressed((char)'\u007f', (int)0), this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId()));
        ContextMenuProvider provider = this.getContextMenuProvider();
        this.getGraphicalViewer().setContextMenu((MenuManager)provider);
        this.hookSelectionActions();
    }

    protected ContextMenuProvider getContextMenuProvider() {
        return new SmooksGraphicalEditorMenuContextProvider((EditPartViewer)this.getGraphicalViewer(), this.getActionRegistry());
    }

    private void hookSelectionActions() {
        Iterator actions = this.getActionRegistry().getActions();
        while (actions.hasNext()) {
            Object action = actions.next();
            if (!(action instanceof SelectionAction)) continue;
            ((SelectionAction)action).setSelectionProvider((ISelectionProvider)this.getGraphicalViewer());
        }
    }

    protected List<AbstractSmooksGraphicalModel> createInputDataGraphModel() {
        ArrayList<AbstractSmooksGraphicalModel> inputGraphModel = new ArrayList<AbstractSmooksGraphicalModel>();
        if (this.inputDataList != null && this.root != null) {
            for (Object object : this.inputDataList) {
                Object contentProvider = new XMLStructuredDataContentProvider();
                LabelProvider labelProvider = new XMLStructuredDataLabelProvider();
                InputDataRootModel containerModel = new InputDataRootModel();
                if (object instanceof JavaBeanModel) {
                    contentProvider = new JavabeanContentProvider();
                    labelProvider = new JavabeanlabelProvider();
                }
                containerModel.getChildren().add((IXMLStructuredObject)object);
                if (containerModel == null) continue;
                InputDataContianerModel container = new InputDataContianerModel(containerModel, (ITreeContentProvider)contentProvider, (ILabelProvider)labelProvider, this.getSmooksModelProvider());
                this.root.addTreeNode(container);
                inputGraphModel.add(container);
            }
        }
        return inputGraphModel;
    }

    protected void hookGraphicalViewer() {
        this.getSelectionSynchronizer().addViewer((EditPartViewer)this.getGraphicalViewer());
        this.getGraphicalViewer().addSelectionChangedListener((ISelectionChangedListener)this.getSelectionSynchronizer());
        this.getGraphicalViewer().addSelectionChangedListener((ISelectionChangedListener)this);
    }

    protected void initGraphicalModel() {
        if (this.root == null) {
            this.root = new RootModel();
        } else {
            this.root.removeAllTreeNode();
        }
        EObject obj = this.smooksModelProvider.getSmooksModel();
        if (obj == null) {
            return;
        }
        AdapterFactoryEditingDomain editingDomain = (AdapterFactoryEditingDomain)this.smooksModelProvider.getEditingDomain();
        if (this.inputDataList != null && obj != null && obj instanceof DocumentRoot && editingDomain != null) {
            this.createInputDataGraphModel();
            SmooksResourceListType listType = ((DocumentRoot)obj).getSmooksResourceList();
            EList arcList = listType.getAbstractResourceConfig();
            for (Object object : arcList) {
                AbstractSmooksGraphicalModel gmodel = this.createGraphModel(object);
                if (gmodel == null) continue;
                this.root.addTreeNode(gmodel);
            }
            this.getGraphicalViewer().setContents((Object)this.root);
        }
        List<TreeNodeConnection> connections = this.createConnectionModel();
        this.expandConnectedModels(connections);
        this.autoLayout(false);
        List<Diagnostic> diagnosticList = this.getSmooksModelProvider().getDiagnosticList();
        this.validateEnd(diagnosticList);
    }

    protected AbstractSmooksGraphicalModel createGraphModel(Object model) {
        Object gmodel;
        GraphicalModelFactory factory = this.getGraphicalModelFactory();
        if (factory != null && (gmodel = factory.createGraphicalModel(model, this.smooksModelProvider)) != null && gmodel instanceof AbstractSmooksGraphicalModel) {
            AbstractSmooksGraphicalModel graphicalModel = (AbstractSmooksGraphicalModel)gmodel;
            return graphicalModel;
        }
        return null;
    }

    protected List<TreeNodeConnection> createConnectionModel() {
        ArrayList<TreeNodeConnection> connections = new ArrayList<TreeNodeConnection>();
        if (this.root != null) {
            this.createConnection(this.root.getChildren(), connections);
        }
        return connections;
    }

    protected Collection<TreeNodeConnection> createAllConnection(AbstractSmooksGraphicalModel model) {
        block4: {
            try {
                if (model != null) break block4;
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        ArrayList<TreeNodeConnection> connections = new ArrayList<TreeNodeConnection>();
        Collection<TreeNodeConnection> c1 = this.createConnection(model);
        if (c1 != null) {
            connections.addAll(c1);
        }
        this.createConnection(model.getChildren(), connections);
        return connections;
    }

    public Collection<TreeNodeConnection> createConnection(AbstractSmooksGraphicalModel model) {
        Collection<TreeNodeConnection> cList;
        ConnectionModelFactory connectionModelFactory = this.getConnectionModelFactory();
        ArrayList<TreeNodeConnection> cs = new ArrayList<TreeNodeConnection>();
        if (connectionModelFactory != null && connectionModelFactory.hasConnection(model) && (cList = connectionModelFactory.createConnection(this.inputDataList, this.getSmooksResourceList(), this.root, model)) != null) {
            cs.addAll(cList);
        }
        if (cs.isEmpty()) {
            return null;
        }
        return cs;
    }

    public List<Object> getInputDataList() {
        if (this.inputDataList == null) {
            this.inputDataList = new ArrayList<Object>();
        }
        return this.inputDataList;
    }

    public void setInputDataList(List<Object> inputDataList) {
        this.inputDataList = inputDataList;
    }

    public ISmooksModelProvider getSmooksModelProvider() {
        return this.smooksModelProvider;
    }

    public void setSmooksModelProvider(ISmooksModelProvider smooksModelProvider) {
        this.smooksModelProvider = smooksModelProvider;
    }

    public EObject getSmooksResourceList() {
        if (this.smooksModelProvider != null) {
            SmooksResourceListType m = null;
            EObject smooksModel = this.smooksModelProvider.getSmooksModel();
            if (smooksModel instanceof DocumentRoot) {
                m = ((DocumentRoot)smooksModel).getSmooksResourceList();
            }
            return m;
        }
        return null;
    }

    public EditingDomain getEditingDomain() {
        if (this.smooksModelProvider != null) {
            return this.smooksModelProvider.getEditingDomain();
        }
        return null;
    }

    public void createConnection(List<AbstractSmooksGraphicalModel> children, List<TreeNodeConnection> connections) {
        for (AbstractSmooksGraphicalModel abstractSmooksGraphicalModel : children) {
            Collection<TreeNodeConnection> c;
            if (abstractSmooksGraphicalModel instanceof InputDataContianerModel) continue;
            if (this.canCreateConnection(abstractSmooksGraphicalModel) && (c = this.createConnection(abstractSmooksGraphicalModel)) != null) {
                connections.addAll(c);
            }
            List<AbstractSmooksGraphicalModel> cchildren = abstractSmooksGraphicalModel.getChildren();
            this.createConnection(cchildren, connections);
        }
    }

    private boolean canCreateConnection(AbstractSmooksGraphicalModel model) {
        return true;
    }

    protected void initSmooksData() {
        if (this.smooksModelProvider != null) {
            EObject obj = this.smooksModelProvider.getSmooksModel();
            this.smooksResourceList = null;
            if (obj instanceof DocumentRoot) {
                this.smooksResourceList = ((DocumentRoot)obj).getSmooksResourceList();
                this.inputDataList = SelectorCreationDialog.generateInputData(this.smooksResourceList);
            }
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.initSmooksData();
        if (this.smooksModelProvider != null) {
            this.handleCommandStack(this.smooksModelProvider.getEditingDomain().getCommandStack());
        }
    }

    protected void expandConnectedModels(Collection<TreeNodeConnection> connections) {
        if (connections == null || connections.isEmpty()) {
            return;
        }
        ArrayList<TreeNodeModel> expanedTreeNodeList = new ArrayList<TreeNodeModel>();
        for (TreeNodeConnection treeNodeConnection : connections) {
            AbstractSmooksGraphicalModel source = treeNodeConnection.getSourceNode();
            AbstractSmooksGraphicalModel target = treeNodeConnection.getTargetNode();
            Object data = source.getData();
            Object data2 = target.getData();
            if (source instanceof TreeNodeModel && data instanceof IXMLStructuredObject) {
                expanedTreeNodeList.add((TreeNodeModel)source);
            }
            if (!(target instanceof TreeNodeModel) || !(data2 instanceof IXMLStructuredObject)) continue;
            expanedTreeNodeList.add((TreeNodeModel)target);
        }
        EditPart rootEditPart = this.getGraphicalViewer().getContents();
        if (rootEditPart != null) {
            List childrenEditPart = rootEditPart.getChildren();
            for (Object object : childrenEditPart) {
                SmooksUIUtils.expandGraphTree(expanedTreeNodeList, (TreeNodeEditPart)object);
            }
        }
    }

    protected void initializeGraphicalViewer() {
        this.initGraphicalModel();
    }

    protected void applyGraphicalInformation(AbstractSmooksGraphicalModel graphicalModel) {
    }

    protected boolean needToAutoLayout(List<AbstractSmooksGraphicalModel> list) {
        return true;
    }

    public boolean autoLayout() {
        return this.autoLayout(false);
    }

    public boolean autoLayout(boolean animation) {
        final GraphAnimation graphAnimation = new GraphAnimation();
        HashMap<Object, Node> nodeMap = new HashMap<Object, Node>();
        DirectedGraph directedGraph = this.collectionGraphInformation(nodeMap);
        IAutoLayout layout = this.getAutoLayout();
        if (layout != null) {
            layout.visit(directedGraph);
            Iterator<Object> it = nodeMap.keySet().iterator();
            HashMap<IMoveableModel, Point> map = new HashMap<IMoveableModel, Point>();
            final ArrayList<GraphicalEditPart> figureList = new ArrayList<GraphicalEditPart>();
            while (it.hasNext()) {
                GraphicalEditPart part = (GraphicalEditPart)it.next();
                Node node = nodeMap.get(part);
                figureList.add(part);
                graphAnimation.recordInit(part);
                IMoveableModel graphicalModel = (IMoveableModel)part.getModel();
                map.put(graphicalModel, new Point(node.x, node.y));
                graphAnimation.recordFinal(part, new Rectangle(node.x, node.y, 0, 0));
            }
            IEditorSite editorSite = this.getEditorSite();
            if (animation && editorSite != null) {
                editorSite.getShell().getDisplay().syncExec(new Runnable(){

                    public void run() {
                        graphAnimation.start(figureList);
                    }
                });
            }
            for (IMoveableModel graphModel : map.keySet()) {
                Point p = (Point)map.get(graphModel);
                graphModel.setLocation(p);
            }
            return true;
        }
        return false;
    }

    public IAutoLayout getAutoLayout() {
        return null;
    }

    protected DirectedGraph collectionGraphInformation(HashMap<Object, Node> nodeMap) {
        DirectedGraph graph = new DirectedGraph();
        if (this.getGraphicalViewer() == null) {
            return graph;
        }
        EditPart rootEditorPart = this.getGraphicalViewer().getContents();
        List children = rootEditorPart.getChildren();
        for (Object object : children) {
            if (!(object instanceof GraphicalEditPart)) continue;
            IFigure figure = ((GraphicalEditPart)object).getFigure();
            Node node = new Node();
            node.data = object;
            nodeMap.put(object, node);
            node.height = figure.getPreferredSize().height;
            node.width = figure.getPreferredSize().width;
            graph.nodes.add((Object)node);
        }
        for (Object object : children) {
            for (GraphicalEditPart testEditPart : children) {
                Edge edge;
                Node node = nodeMap.get(object);
                Node testNode = nodeMap.get(testEditPart);
                if (node == null || testNode == null) continue;
                if (this.hasConnectionAssociation((GraphicalEditPart)object, testEditPart, 1)) {
                    edge = new Edge(node, testNode);
                    edge.data = testEditPart;
                    graph.edges.add((Object)edge);
                }
                if (!this.hasConnectionAssociation((GraphicalEditPart)object, testEditPart, 0)) continue;
                edge = new Edge(testNode, node);
                graph.edges.add((Object)edge);
            }
        }
        return graph;
    }

    private boolean hasAssociation(Object model, GraphicalEditPart editPart) {
        if (model == editPart.getModel()) {
            return true;
        }
        AbstractSmooksGraphicalModel grphicalModel = (AbstractSmooksGraphicalModel)editPart.getModel();
        if (!grphicalModel.getChildrenWithoutDynamic().isEmpty()) {
            List children = editPart.getChildren();
            for (GraphicalEditPart gpart : children) {
                if (!this.hasAssociation(model, gpart)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasConnectionAssociation(GraphicalEditPart editPart, GraphicalEditPart testEditPart, int connectType) {
        List sourceConnections = null;
        if (connectType == 1) {
            sourceConnections = editPart.getSourceConnections();
        }
        if (connectType == 0) {
            sourceConnections = editPart.getTargetConnections();
        }
        for (GraphicalEditPart object : sourceConnections) {
            TreeNodeConnection connection = (TreeNodeConnection)object.getModel();
            AbstractSmooksGraphicalModel testModel = null;
            if (connectType == 1) {
                testModel = connection.getTargetNode();
            }
            if (connectType == 0) {
                testModel = connection.getSourceNode();
            }
            if (!this.hasAssociation(testModel, testEditPart)) continue;
            return true;
        }
        AbstractSmooksGraphicalModel sourceGraphModel = (AbstractSmooksGraphicalModel)editPart.getModel();
        if (!sourceGraphModel.getChildrenWithoutDynamic().isEmpty()) {
            List children = editPart.getChildren();
            for (GraphicalEditPart childEditPart : children) {
                if (!this.hasConnectionAssociation(childEditPart, testEditPart, connectType)) continue;
                return true;
            }
        }
        return false;
    }

    public Object getAdapter(Class type) {
        if (type == ISmooksModelProvider.class) {
            return this.smooksModelProvider;
        }
        if (type == ITaskNodeProvider.class) {
            return this;
        }
        return super.getAdapter(type);
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.getEditDomain() != null && this.getEditDomain().getCommandStack() != null) {
            this.getEditDomain().getCommandStack().flush();
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        super.selectionChanged(part, selection);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateActions(this.getSelectionActions());
        ISelectionProvider provider = ((SmooksTaskDetailsEditorSite)this.getSite()).getMultiPageEditor().getSite().getSelectionProvider();
        if (provider != null) {
            provider.setSelection(event.getSelection());
        }
    }

    @Override
    public void sourceChange(Object model) {
        this.initGraphicalModel();
    }

    public SmooksResourceListType getSmooksResourceListType() {
        if (this.smooksModelProvider != null) {
            EObject obj = this.smooksModelProvider.getSmooksModel();
            this.smooksResourceList = null;
            if (obj instanceof DocumentRoot) {
                this.smooksResourceList = ((DocumentRoot)obj).getSmooksResourceList();
            }
            return this.smooksResourceList;
        }
        return null;
    }

    public void graphPropertyChange(EStructuralFeature featre, Object value) {
    }

    public void inputTypeChanged() {
        if (this.root != null && this.inputDataList != null) {
            List<Object> newInputDataList = SelectorCreationDialog.generateInputData(this.getSmooksResourceListType());
            ArrayList<InputDataContianerModel> inputs = new ArrayList<InputDataContianerModel>();
            List<AbstractSmooksGraphicalModel> children = this.root.getChildren();
            for (AbstractSmooksGraphicalModel abstractSmooksGraphicalModel : children) {
                if (!(abstractSmooksGraphicalModel instanceof InputDataContianerModel)) continue;
                inputs.add((InputDataContianerModel)abstractSmooksGraphicalModel);
            }
            for (InputDataContianerModel inputModel : inputs) {
                AbstractSmooksGraphicalModel.disconnectAllConnections(inputModel);
                this.root.removeTreeNode(inputModel);
            }
            this.inputDataList.clear();
            this.inputDataList.addAll(newInputDataList);
            List<AbstractSmooksGraphicalModel> inputGraphModel = this.createInputDataGraphModel();
            if (inputGraphModel != null && !inputGraphModel.isEmpty()) {
                List<TreeNodeConnection> connections = this.createConnectionModel();
                this.createConnection(inputGraphModel, connections);
                this.expandConnectedModels(connections);
            }
            this.autoLayout();
        }
    }

    @Override
    public String getID() {
        return null;
    }

    protected void cleanValidationMarker() {
        if (this.root == null) {
            return;
        }
        List<AbstractSmooksGraphicalModel> children = this.root.getChildren();
        for (AbstractSmooksGraphicalModel abstractSmooksGraphicalModel : children) {
            this.cleanValidationMarker(abstractSmooksGraphicalModel);
        }
    }

    protected void cleanValidationMarker(AbstractSmooksGraphicalModel model) {
        model.setSeverity(-1);
        model.getMessage().clear();
        List<AbstractSmooksGraphicalModel> children = model.getChildrenWithoutDynamic();
        for (AbstractSmooksGraphicalModel abstractSmooksGraphicalModel : children) {
            this.cleanValidationMarker(abstractSmooksGraphicalModel);
        }
    }

    @Override
    public void validateEnd(List<Diagnostic> diagnosticResult) {
        if (diagnosticResult == null) {
            return;
        }
        IEditorSite editorSite = this.getEditorSite();
        if (editorSite != null) {
            if (this.root == null) {
                return;
            }
            final List<Diagnostic> flist = diagnosticResult;
            Display display = editorSite.getShell().getDisplay();
            display.asyncExec(new Runnable(){

                public void run() {
                    SmooksGraphicalEditorPart.this.cleanValidationMarker();
                    for (Diagnostic diagnostic : flist) {
                        SmooksGraphicalEditorPart.this.refreshValidateResult(diagnostic);
                    }
                }
            });
        }
    }

    protected String getDiagnosticMessage(Diagnostic diagnostic) {
        List datas = diagnostic.getData();
        if (datas.size() == 2) {
            String message;
            Object obj;
            Object parentObj = datas.get(0);
            if (parentObj instanceof BeanType && (obj = datas.get(1)) == Javabean12Package.Literals.BEAN_TYPE__BEAN_ID && (message = diagnostic.getMessage()) != null && message.startsWith("The required feature")) {
                return Messages.SmooksJavaMappingGraphicalEditor_BeanIdEmptyErrormessage;
            }
            if (parentObj instanceof ValueType && (obj = datas.get(1)) == Javabean12Package.Literals.VALUE_TYPE__DATA && (message = diagnostic.getMessage()) != null && message.startsWith("The required feature")) {
                return Messages.SmooksJavaMappingGraphicalEditor_NodeMustLinkWithSource;
            }
            if (parentObj instanceof WiringType && (obj = datas.get(1)) == Javabean12Package.Literals.WIRING_TYPE__BEAN_ID_REF && (message = diagnostic.getMessage()) != null && message.startsWith("The required feature")) {
                return Messages.SmooksJavaMappingGraphicalEditor_NodeMustLinkWithJavaBean;
            }
        }
        return diagnostic.getMessage();
    }

    protected void refreshValidateResult(Diagnostic diagnostic) {
        int severity = diagnostic.getSeverity();
        String message = this.getDiagnosticMessage(diagnostic);
        if (severity == 4 || severity == 2) {
            List datas = diagnostic.getData();
            IValidatableModel obj = null;
            for (Object object : datas) {
                AbstractSmooksGraphicalModel graphModel;
                if (!((object = AdapterFactoryEditingDomain.unwrap(object)) instanceof EObject) || (graphModel = SmooksGraphUtil.findSmooksGraphModel(this.root, object)) == null) continue;
                obj = graphModel;
                boolean cfr_ignored_0 = graphModel instanceof IValidatableModel;
            }
            if (obj != null) {
                for (Object object : datas) {
                    if (!((object = AdapterFactoryEditingDomain.unwrap(object)) instanceof EAttribute) || obj == null || !(obj instanceof IValidatableModel)) continue;
                    obj.addMessage(message);
                }
                obj.setSeverity(severity);
            }
        }
        List children = diagnostic.getChildren();
        for (Diagnostic diagnostic2 : children) {
            this.refreshValidateResult(diagnostic2);
        }
    }

    @Override
    public void validateStart() {
    }
}

