/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.graphical.editors;

import java.util.List;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.ui.IEditorPart;
import org.jboss.tools.smooks.configuration.editors.actions.AbstractSmooksActionGrouper;
import org.jboss.tools.smooks.configuration.editors.actions.ISmooksActionGrouper;
import org.jboss.tools.smooks.editor.ISmooksModelProvider;
import org.jboss.tools.smooks.gef.model.AbstractSmooksGraphicalModel;
import org.jboss.tools.smooks.gef.tree.model.TreeContainerModel;
import org.jboss.tools.smooks.graphical.actions.xsltemplate.XSLActionCreator;
import org.jboss.tools.smooks.graphical.editors.ConnectionModelFactory;
import org.jboss.tools.smooks.graphical.editors.ConnectionModelFactoryImpl;
import org.jboss.tools.smooks.graphical.editors.GraphicalModelFactory;
import org.jboss.tools.smooks.graphical.editors.GraphicalModelFactoryImpl;
import org.jboss.tools.smooks.graphical.editors.Messages;
import org.jboss.tools.smooks.graphical.editors.SmooksGraphicalEditorPaletteRootCreator;
import org.jboss.tools.smooks.graphical.editors.SmooksGraphicalEditorPart;
import org.jboss.tools.smooks.graphical.editors.XSLLabelProvider;
import org.jboss.tools.smooks.graphical.editors.autolayout.IAutoLayout;
import org.jboss.tools.smooks.graphical.editors.autolayout.XSLMappingAutoLayout;
import org.jboss.tools.smooks.graphical.editors.model.xsl.XSLTemplateContentProvider;
import org.jboss.tools.smooks.graphical.editors.model.xsl.XSLTemplateGraphicalModel;
import org.jboss.tools.smooks.model.xsl.Xsl;

public class SmooksXSLTemplateGraphicalEditor
extends SmooksGraphicalEditorPart {
    private XSLMappingAutoLayout autoLayout = null;

    public SmooksXSLTemplateGraphicalEditor(ISmooksModelProvider provider) {
        super(provider);
    }

    public IAutoLayout getAutoLayout() {
        if (this.autoLayout == null) {
            this.autoLayout = new XSLMappingAutoLayout();
        }
        return this.autoLayout;
    }

    protected void createActions() {
        super.createActions();
        XSLActionCreator creator = new XSLActionCreator();
        creator.registXSLActions(this.getActionRegistry(), this.getSelectionActions(), (IEditorPart)this);
    }

    protected PaletteRoot getPaletteRoot() {
        SmooksGraphicalEditorPaletteRootCreator creator = new SmooksGraphicalEditorPaletteRootCreator(this.smooksModelProvider, (AdapterFactoryEditingDomain)this.smooksModelProvider.getEditingDomain(), this.getSmooksResourceListType()){

            @Override
            protected void fillActionGrouper(List<ISmooksActionGrouper> grouperList) {
                AbstractSmooksActionGrouper xslgrouper = new AbstractSmooksActionGrouper(){

                    public String getGroupName() {
                        return Messages.SmooksXSLTemplateGraphicalEditor_Group_Name;
                    }

                    protected boolean canAdd(Object value) {
                        return value instanceof Xsl;
                    }
                };
                grouperList.add(xslgrouper);
            }
        };
        return creator.createPaletteRoot();
    }

    protected ConnectionModelFactory createConnectionModelFactory() {
        return new XSLTemplateConnectionModelFactory();
    }

    protected GraphicalModelFactory createGraphicalModelFactory() {
        return new XSLTemplateGraphicalModelFactory();
    }

    private class XSLTemplateConnectionModelFactory
    extends ConnectionModelFactoryImpl {
        private XSLTemplateConnectionModelFactory() {
        }

        public boolean hasBeanIDConnection(AbstractSmooksGraphicalModel model) {
            return false;
        }

        public boolean hasSelectorConnection(AbstractSmooksGraphicalModel model) {
            return false;
        }
    }

    private class XSLTemplateGraphicalModelFactory
    extends GraphicalModelFactoryImpl {
        private XSLTemplateGraphicalModelFactory() {
        }

        public Object createGraphicalModel(Object model, ISmooksModelProvider provider) {
            if (this.canCreateGraphicalModel(model, provider)) {
                XSLTemplateGraphicalModel graphModel = null;
                AdapterFactoryEditingDomain editingDomain = (AdapterFactoryEditingDomain)provider.getEditingDomain();
                AdapterFactoryContentProvider contentProvider = new AdapterFactoryContentProvider(editingDomain.getAdapterFactory());
                ILabelProvider labelProvider = this.createLabelProvider(editingDomain.getAdapterFactory());
                if (model instanceof Xsl) {
                    graphModel = new XSLTemplateGraphicalModel(model, new XSLTemplateContentProvider((ITreeContentProvider)contentProvider), (ILabelProvider)new XSLLabelProvider(labelProvider), provider);
                    ((TreeContainerModel)graphModel).setHeaderVisable(true);
                }
                if (graphModel != null) {
                    return graphModel;
                }
                return super.createGraphicalModel(graphModel, provider);
            }
            return null;
        }
    }
}

