/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.graphical.editors;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.jboss.tools.smooks.configuration.editors.xml.TagPropertyObject;
import org.jboss.tools.smooks.configuration.editors.xml.XMLStructuredDataLabelProvider;
import org.jboss.tools.smooks.configuration.editors.xml.XSLModelAnalyzer;
import org.jboss.tools.smooks.configuration.editors.xml.XSLTagObject;
import org.jboss.tools.smooks.graphical.editors.Messages;
import org.jboss.tools.smooks.model.xsl.Xsl;

public class XSLLabelProvider
extends LabelProvider {
    private XMLStructuredDataLabelProvider provider = new XMLStructuredDataLabelProvider();
    private ILabelProvider parentLabelProvider = null;

    public XSLLabelProvider(ILabelProvider parentLabelProvider) {
        this.parentLabelProvider = parentLabelProvider;
    }

    public String getText(Object element) {
        if (element instanceof Xsl) {
            return this.parentLabelProvider.getText(element);
        }
        if (element instanceof TagPropertyObject) {
            String name = ((TagPropertyObject)element).getName();
            String value = ((TagPropertyObject)element).getValue();
            if (value == null || value.trim().length() == 0) {
                return String.valueOf(name) + Messages.XSLLabelProvider_Text_Null_Value;
            }
        }
        if (element instanceof XSLTagObject) {
            String name;
            if (XSLModelAnalyzer.isXSLTagObject((XSLTagObject)element) && ((XSLTagObject)element).isTemplateElement()) {
                String match = ((XSLTagObject)element).getMatchValue();
                name = ((XSLTagObject)element).getName();
                if (match != null && !"".equals(match = match.trim())) {
                    return String.valueOf(name) + " (" + match + ")";
                }
            }
            if (XSLModelAnalyzer.isXSLTagObject((XSLTagObject)element) && ((XSLTagObject)element).isApplyTemplatesElement()) {
                String select = ((XSLTagObject)element).getSelectValue();
                name = ((XSLTagObject)element).getName();
                if (select != null && !"".equals(select = select.trim())) {
                    return String.valueOf(name) + " -> " + select;
                }
            }
        }
        return this.provider.getText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof Xsl) {
            return this.parentLabelProvider.getImage(element);
        }
        return this.provider.getImage(element);
    }
}

