/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.graphical.editors.autolayout;

import java.util.ArrayList;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.jboss.tools.smooks.graphical.editors.autolayout.IAutoLayout;
import org.jboss.tools.smooks.graphical.editors.editparts.InputDataContainerEditPart;
import org.jboss.tools.smooks.graphical.editors.editparts.javamapping.JavaBeanEditPart;

public class JavaMappingAutoLayout
implements IAutoLayout {
    private int INPUT_JAVA_WIDTH = 200;
    private int SPACE_JAVA = 20;
    private int INIT_X = 50;
    private int INIT_Y = 50;

    public void visit(DirectedGraph graph) {
        NodeList nodeList = graph.nodes;
        int javaHeight = 0;
        Node inputNode = null;
        int java_y = this.INIT_Y;
        ArrayList<Node> javaNodes = new ArrayList<Node>();
        for (Node node : nodeList) {
            Object data = node.data;
            if (data instanceof JavaBeanEditPart) {
                javaHeight = javaHeight + this.SPACE_JAVA + node.height;
                node.y = java_y;
                java_y = java_y + this.SPACE_JAVA + node.height;
                javaNodes.add(node);
            }
            if (!(data instanceof InputDataContainerEditPart)) continue;
            inputNode = node;
        }
        javaHeight -= this.INIT_Y;
        int java_x = this.INIT_X;
        if (inputNode != null) {
            inputNode.x = this.INIT_X;
            int input_y = this.INIT_Y;
            if (javaHeight > inputNode.height) {
                int cha;
                input_y = cha = (javaHeight - inputNode.height) / 2;
            }
            inputNode.y = input_y;
            java_x = inputNode.x + inputNode.width + this.INPUT_JAVA_WIDTH;
        }
        for (Node node : javaNodes) {
            node.x = java_x;
        }
    }
}

