/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.graphical.editors.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IEditorPart;
import org.jboss.tools.smooks.configuration.editors.javabean.JavaBeanModel;
import org.jboss.tools.smooks.configuration.editors.uitls.SmooksUIUtils;
import org.jboss.tools.smooks.editor.ISmooksModelProvider;
import org.jboss.tools.smooks.gef.tree.command.GEFAdapterCommand;
import org.jboss.tools.smooks.graphical.editors.SmooksGraphicalEditorPart;
import org.jboss.tools.smooks.graphical.editors.commands.IgnoreException;
import org.jboss.tools.smooks.graphical.wizards.JavaBeanCreationWizard;
import org.jboss.tools.smooks.model.javabean12.BeanType;
import org.jboss.tools.smooks.model.javabean12.Javabean12Factory;
import org.jboss.tools.smooks.model.javabean12.ValueType;
import org.jboss.tools.smooks.model.javabean12.WiringType;
import org.jboss.tools.smooks.model.smooks.SmooksResourceListType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateJavaBeanModelCommand
extends GEFAdapterCommand {
    private IEditorPart editorPart = null;
    public static final int BEAN_TYPE = 2;
    private ISmooksModelProvider provider = null;
    boolean firstTime = true;

    public CreateJavaBeanModelCommand(EditingDomain domain, Command emfCommand, IEditorPart editorPart, ISmooksModelProvider provider) {
        super(domain, emfCommand);
        this.editorPart = editorPart;
        this.provider = provider;
    }

    @Override
    public void execute() {
        if (this.firstTime) {
            JavaBeanCreationWizard wizard = new JavaBeanCreationWizard(this.provider, null);
            if (this.editorPart != null && this.collections != null && this.owner != null && this.feature != null) {
                WizardDialog dialog = new WizardDialog(this.editorPart.getSite().getShell(), (IWizard)wizard);
                if (dialog.open() == 0) {
                    if (this.collections instanceof FeatureMap.Entry) {
                        ((FeatureMap.Entry)this.collections).getValue();
                    }
                    int type = 2;
                    SmooksResourceListType resourceListType = null;
                    if (this.editorPart instanceof SmooksGraphicalEditorPart) {
                        resourceListType = ((SmooksGraphicalEditorPart)this.editorPart).getSmooksResourceListType();
                    }
                    List<Object> models = this.createJavaBeanModel(type, wizard.getJavaBeanModel(), wizard.getBindings(), resourceListType, new ArrayList<String>());
                    ArrayList<FeatureMap.Entry> creationModels = new ArrayList<FeatureMap.Entry>();
                    if (this.collections instanceof FeatureMap.Entry) {
                        for (Object object : models) {
                            creationModels.add(FeatureMapUtil.createEntry((EStructuralFeature)((FeatureMap.Entry)this.collections).getEStructuralFeature(), (Object)object));
                        }
                    }
                    this.collections = creationModels;
                    this.emfCommand = AddCommand.create((EditingDomain)this.domain, (Object)this.owner, (Object)this.feature, creationModels);
                } else {
                    throw new IgnoreException();
                }
            }
            this.firstTime = false;
        }
        super.execute();
    }

    private List<Object> createJavaBeanModel(int type, JavaBeanModel parentBeanModel, Object[] properties, SmooksResourceListType resourceListType, List<String> ids) {
        ArrayList<Object> creationObject = new ArrayList<Object>();
        BeanType parent = null;
        if (type == 2) {
            parent = Javabean12Factory.eINSTANCE.createBeanType();
        }
        creationObject.add(parent);
        String beanID = this.generateBeanID(parentBeanModel, resourceListType, ids);
        ids.add(beanID);
        if (parent instanceof BeanType) {
            parent.setBeanId(beanID);
            parent.setClass(parentBeanModel.getBeanClassString());
            if (properties != null && properties.length > 0) {
                int i = 0;
                while (i < properties.length) {
                    Object beanPropertyObj = properties[i];
                    if (beanPropertyObj instanceof JavaBeanModel && this.belongsToMe(parentBeanModel, (JavaBeanModel)beanPropertyObj)) {
                        ValueType value;
                        JavaBeanModel beanProperty = (JavaBeanModel)beanPropertyObj;
                        if (beanProperty.isPrimitive()) {
                            value = Javabean12Factory.eINSTANCE.createValueType();
                            value.setProperty(beanProperty.getName());
                            parent.getValue().add((Object)value);
                        } else {
                            value = Javabean12Factory.eINSTANCE.createWiringType();
                            if (!parentBeanModel.isArray() && !parentBeanModel.isList()) {
                                value.setProperty(beanProperty.getName());
                            }
                            String refID = this.generateBeanID(beanProperty, resourceListType, ids);
                            value.setBeanIdRef(refID);
                            parent.getWiring().add((Object)value);
                            creationObject.addAll(this.createJavaBeanModel(type, beanProperty, properties, resourceListType, ids));
                        }
                    }
                    ++i;
                }
            } else if (parentBeanModel.isList()) {
                WiringType value = Javabean12Factory.eINSTANCE.createWiringType();
                parent.getWiring().add((Object)value);
            }
        }
        return creationObject;
    }

    private String generateBeanID(JavaBeanModel parentBeanModel, SmooksResourceListType listType, List<String> ids) {
        String pn = parentBeanModel.getName();
        int index = 1;
        while (this.idExsit(pn, listType, ids)) {
            pn = String.valueOf(pn) + String.valueOf(index);
            ++index;
        }
        return pn;
    }

    private boolean idExsit(String id, SmooksResourceListType listType, List<String> ids) {
        Collection<EObject> models = SmooksUIUtils.getBeanIdModelList((EObject)listType);
        for (EObject eObject : models) {
            Object obj;
            EStructuralFeature feature;
            if (eObject == null || (feature = SmooksUIUtils.getBeanIDFeature(eObject)) == null || (obj = eObject.eGet(feature)) == null) continue;
            String id1 = obj.toString();
            if (id == null || id1 == null || !id.equals(id1)) continue;
            return true;
        }
        for (String i : ids) {
            if (id == null || i == null || !id.equals(i)) continue;
            return true;
        }
        return false;
    }

    private boolean belongsToMe(JavaBeanModel parent, JavaBeanModel child) {
        if (parent != null && parent.isExpaned()) {
            return parent.getChildren().indexOf(child) != -1;
        }
        return false;
    }
}

