/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.graphical.editors.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.IEditorPart;
import org.jboss.tools.smooks.configuration.editors.IXMLStructuredObject;
import org.jboss.tools.smooks.configuration.editors.uitls.SmooksUIUtils;
import org.jboss.tools.smooks.configuration.editors.xml.AbstractXMLObject;
import org.jboss.tools.smooks.configuration.editors.xml.TagPropertyObject;
import org.jboss.tools.smooks.configuration.editors.xml.XSLTagObject;
import org.jboss.tools.smooks.gef.model.AbstractSmooksGraphicalModel;
import org.jboss.tools.smooks.gef.tree.editparts.TreeNodeEditPart;
import org.jboss.tools.smooks.gef.tree.model.TreeNodeConnection;
import org.jboss.tools.smooks.gef.tree.model.TreeNodeModel;
import org.jboss.tools.smooks.graphical.editors.SmooksGraphicalEditorPart;
import org.jboss.tools.smooks.graphical.editors.editparts.InputDataContainerEditPart;
import org.jboss.tools.smooks.graphical.editors.model.xsl.XSLNodeGraphicalModel;
import org.jboss.tools.smooks.graphical.editors.model.xsl.XSLTemplateGraphicalModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteXSLNodeCommand
extends Command {
    private AbstractSmooksGraphicalModel graphModel = null;
    private List<TreeNodeConnection> deletedConnections = null;
    private AbstractSmooksGraphicalModel parentModel = null;
    private EditPart parentEditPart = null;
    private EditPart hostEditPart;
    private int index = -1;

    public DeleteXSLNodeCommand(EditPart hostEditPart) {
        this.hostEditPart = hostEditPart;
        this.parentEditPart = this.hostEditPart.getParent();
        Object m = hostEditPart.getModel();
        if (m != null && m instanceof AbstractSmooksGraphicalModel) {
            this.graphModel = (AbstractSmooksGraphicalModel)m;
        }
    }

    public boolean canExecute() {
        AbstractXMLObject parent;
        if (this.hostEditPart == null) {
            return false;
        }
        if (this.graphModel == null) {
            return false;
        }
        if (this.graphModel.getParent() == null) {
            return false;
        }
        Object data = this.graphModel.getData();
        if (data instanceof XSLTagObject) {
            return true;
        }
        return data instanceof TagPropertyObject && (parent = ((TagPropertyObject)data).getParent()) != null && parent instanceof XSLTagObject;
    }

    public void dispose() {
        this.deletedConnections = null;
        super.dispose();
    }

    public void execute() {
        AbstractSmooksGraphicalModel parent;
        super.execute();
        if (this.deletedConnections != null) {
            this.deletedConnections.clear();
        } else {
            this.deletedConnections = new ArrayList<TreeNodeConnection>();
        }
        this.parentModel = parent = this.graphModel.getParent();
        AbstractSmooksGraphicalModel.disconnectAllConnections(this.graphModel, this.deletedConnections);
        this.index = parent.getChildrenWithoutDynamic().indexOf(this.graphModel);
        parent.removeChild(this.graphModel);
    }

    private void reconnectAllConnections() {
        if (this.deletedConnections != null) {
            for (TreeNodeConnection connection : this.deletedConnections) {
                connection.connect();
            }
        }
    }

    public void redo() {
        this.execute();
    }

    public void undo() {
        GraphicalViewer viewer;
        IEditorPart editor;
        List children;
        this.parentModel.addChild(this.index, this.graphModel);
        if (this.parentModel instanceof XSLTemplateGraphicalModel) {
            children = this.parentModel.getChildren();
            for (AbstractSmooksGraphicalModel abstractSmooksGraphicalModel : children) {
                if (!(abstractSmooksGraphicalModel instanceof XSLNodeGraphicalModel)) continue;
                this.graphModel = abstractSmooksGraphicalModel;
                break;
            }
        }
        children = this.parentEditPart.getChildren();
        for (EditPart childpart : children) {
            if (childpart.getModel() != this.graphModel) continue;
            this.hostEditPart = childpart;
            break;
        }
        if (this.parentModel instanceof XSLTemplateGraphicalModel && (editor = ((DefaultEditDomain)(viewer = (GraphicalViewer)this.hostEditPart.getViewer()).getEditDomain()).getEditorPart()) instanceof SmooksGraphicalEditorPart) {
            ArrayList<TreeNodeConnection> newConnections = new ArrayList<TreeNodeConnection>();
            ((SmooksGraphicalEditorPart)editor).createConnection(this.parentModel.getChildren(), newConnections);
            this.expandConnectionNodes(newConnections);
            return;
        }
        try {
            this.reconnectAllConnections();
            this.expandConnectionNodes(this.deletedConnections);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void expandConnectionNodes(List<TreeNodeConnection> connections) {
        if (connections == null || connections.isEmpty()) {
            return;
        }
        ArrayList<TreeNodeModel> expanedTreeNodeList = new ArrayList<TreeNodeModel>();
        for (TreeNodeConnection treeNodeConnection : connections) {
            AbstractSmooksGraphicalModel source = treeNodeConnection.getSourceNode();
            AbstractSmooksGraphicalModel target = treeNodeConnection.getTargetNode();
            Object data = source.getData();
            Object data2 = target.getData();
            if (source instanceof TreeNodeModel && data instanceof IXMLStructuredObject) {
                expanedTreeNodeList.add((TreeNodeModel)source);
            }
            if (!(target instanceof TreeNodeModel) || !(data2 instanceof IXMLStructuredObject)) continue;
            expanedTreeNodeList.add((TreeNodeModel)target);
        }
        if (this.hostEditPart != null) {
            if (this.hostEditPart instanceof TreeNodeEditPart) {
                SmooksUIUtils.expandGraphTree(expanedTreeNodeList, (TreeNodeEditPart)this.hostEditPart);
            }
            EditPart rootEditPart = this.hostEditPart.getViewer().getContents();
            List childrenEditPart = rootEditPart.getChildren();
            for (Object object : childrenEditPart) {
                if (!(object instanceof InputDataContainerEditPart)) continue;
                SmooksUIUtils.expandGraphTree(expanedTreeNodeList, (TreeNodeEditPart)object);
            }
        }
    }

    public boolean canUndo() {
        return this.parentModel != null;
    }
}

