/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.graphical.editors.editparts;

import java.beans.PropertyChangeEvent;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.jboss.tools.smooks.configuration.SmooksConfigurationActivator;
import org.jboss.tools.smooks.editor.ISmooksModelProvider;
import org.jboss.tools.smooks.gef.tree.editparts.TreeContainerEditPart;
import org.jboss.tools.smooks.gef.tree.figures.TreeContainerFigure;
import org.jboss.tools.smooks.gef.tree.model.TreeContainerModel;
import org.jboss.tools.smooks.gef.tree.model.TreeNodeModel;
import org.jboss.tools.smooks.graphical.editors.editparts.Messages;
import org.jboss.tools.smooks.graphical.editors.editparts.SmooksGraphUtil;
import org.jboss.tools.smooks.graphical.editors.model.InputDataContianerModel;

public class InputDataContainerEditPart
extends TreeContainerEditPart {
    private String inputType = null;

    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
    }

    protected String generateFigureID() {
        return SmooksGraphUtil.generateFigureID((TreeNodeModel)this.getModel());
    }

    protected IFigure createFigure() {
        TreeContainerFigure figure = new TreeContainerFigure((TreeContainerModel)this.getModel()){

            protected void addChildrenFigures() {
                Figure headerFigure1 = new Figure(){

                    protected void paintFigure(Graphics graphics) {
                        super.paintFigure(graphics);
                    }

                    public Dimension getPreferredSize(int hint, int hint2) {
                        Dimension size = super.getPreferredSize(hint, hint2);
                        int width = Math.max(size.width, 100);
                        return new Dimension(width, 25);
                    }
                };
                this.add((IFigure)headerFigure1);
                super.addChildrenFigures();
            }

            protected void drawHeaderFigure(Graphics graphics) {
            }

            protected void paintBorder(Graphics graphics) {
                if (this.isSelected() || this.isFocus()) {
                    graphics.setForegroundColor(ColorConstants.orange);
                } else {
                    graphics.setForegroundColor(FigureUtilities.darker((Color)ColorConstants.orange));
                }
                Point p2 = new Point();
                p2.setLocation(this.getBounds().getTopLeft().x, this.getBounds().getTopLeft().y);
                Point p1 = new Point();
                p1.setLocation(this.getBounds().getTopRight().x - 20, this.getBounds().getTopRight().y);
                graphics.drawLine(p1, p2);
                Point p3 = new Point();
                p3.setLocation(this.getBounds().getBottomLeft().x, this.getBounds().getBottomLeft().y - 1);
                graphics.drawLine(p2, p3);
                Point p4 = new Point();
                p4.setLocation(this.getBounds().getBottomRight().x - 1, this.getBounds().getBottomRight().y - 1);
                graphics.drawLine(p4, p3);
                Point p5 = new Point();
                p5.setLocation(this.getBounds().getTopRight().x - 1, this.getBounds().getTopRight().y + 20 - 1);
                graphics.drawLine(p4, p5);
                graphics.drawLine(p1, p5);
                Point p6 = new Point();
                p6.setLocation(p1.x, p5.y);
                graphics.drawLine(p5, p6);
                graphics.drawLine(p1, p6);
            }

            protected void paintFigure(Graphics graphics) {
                super.paintFigure(graphics);
            }
        };
        return figure;
    }

    protected void refreshVisuals() {
        InputDataContianerModel model = (InputDataContianerModel)this.getModel();
        ISmooksModelProvider provider = model.getSmooksModelProvider();
        if (provider != null) {
            Image image = SmooksConfigurationActivator.getDefault().getImageRegistry().get("icons/full/obj16/input_data_header.gif");
            String text = Messages.InputDataContainerEditPart_Input_Model;
            if (this.inputType != null && this.inputType.equals(provider.getInputType())) {
                super.refreshVisuals();
                return;
            }
            this.inputType = provider.getInputType();
            if (this.inputType.equals("input.java")) {
                image = SmooksConfigurationActivator.getDefault().getImageRegistry().get("icons/full/obj16/jcu_obj.gif");
                text = Messages.InputDataContainerEditPart_Java_Input_Model;
            }
            if (this.inputType.equals("input.xml")) {
                image = SmooksConfigurationActivator.getDefault().getImageRegistry().get("icons/full/obj16/XMLFile.gif");
                text = Messages.InputDataContainerEditPart_XML_Input_Model;
            }
            if (this.inputType.equals("input.xsd")) {
                image = SmooksConfigurationActivator.getDefault().getImageRegistry().get("icons/full/obj16/XSDFile.gif");
                text = Messages.InputDataContainerEditPart_XSD_Input_Model;
            }
            if (this.inputType.equals("input.csv")) {
                text = Messages.InputDataContainerEditPart_CSV_Input_Model;
            }
            if (this.inputType.equals("input.edi")) {
                text = Messages.InputDataContainerEditPart_EDI_Input_Model;
            }
            if (this.inputType.equals("input.json")) {
                text = Messages.InputDataContainerEditPart_JSON_Input_Model;
            }
            TreeContainerFigure figure = (TreeContainerFigure)this.getFigure();
            figure.getLabel().setTextAlignment(1);
            figure.setText(text);
            figure.setIcon(image);
        }
        super.refreshVisuals();
    }
}

