/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.graphical.editors.editparts.freemarker;

import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.editpolicies.FlowLayoutEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.jboss.tools.smooks.gef.model.AbstractSmooksGraphicalModel;
import org.jboss.tools.smooks.gef.tree.editparts.TreeNodeEditPart;
import org.jboss.tools.smooks.gef.tree.figures.TreeFigureExpansionEvent;
import org.jboss.tools.smooks.gef.tree.figures.TreeNodeFigure;
import org.jboss.tools.smooks.gef.tree.model.TreeNodeModel;
import org.jboss.tools.smooks.graphical.editors.commands.AddSmooksGraphicalModelCommand;
import org.jboss.tools.smooks.graphical.editors.commands.ChangeCSVNodeNameCommand;
import org.jboss.tools.smooks.graphical.editors.commands.DeleteSmooksGraphicalModelCommand;
import org.jboss.tools.smooks.graphical.editors.model.freemarker.CSVNodeModel;
import org.jboss.tools.smooks.graphical.editors.model.freemarker.FreemarkerCSVNodeGraphicalModel;

public class FreemarkerCSVNodeEditPart
extends TreeNodeEditPart {
    private Font csvRecordFont;

    public FreemarkerCSVNodeEditPart() {
        this.childrenLoaded = true;
    }

    public Font getCSVRecordLabelFont() {
        if (this.csvRecordFont == null) {
            FontData[] fds;
            IFigure figure = this.getFigure();
            FontData fd = new FontData();
            fd.setStyle(1);
            if (figure != null && (fds = figure.getFont().getFontData()) != null && fds.length > 0) {
                fd.setHeight(fds[0].getHeight());
                fd.setName(fds[0].getName());
                fd.setLocale(fds[0].getLocale());
            }
            this.csvRecordFont = new Font(null, fd);
        }
        return this.csvRecordFont;
    }

    public void deactivate() {
        super.deactivate();
        if (this.csvRecordFont != null) {
            this.csvRecordFont.dispose();
        }
    }

    protected IFigure createFigure() {
        CSVNodeModel node = (CSVNodeModel)((AbstractSmooksGraphicalModel)this.getModel()).getData();
        if (node.isRecord()) {
            TreeNodeFigure figure = new TreeNodeFigure((TreeNodeModel)this.getModel()){

                protected void initFigure() {
                    super.initFigure();
                    this.SPACE_INT = 0;
                    this.CLICKNODE_HEIGHT = 0;
                    this.CLICKNODE_WIDTH = 0;
                    this.expand = true;
                }

                public Dimension getPreferredSize(int hint, int hint2) {
                    this.expand = true;
                    return super.getPreferredSize(hint, hint2);
                }

                protected LayoutManager createLabelContainerLayout() {
                    ToolbarLayout tl = new ToolbarLayout();
                    tl.setVertical(false);
                    tl.setMinorAlignment(2);
                    return tl;
                }

                protected void drawClickFigure(IFigure clickFigure, Graphics graphics) {
                }

                protected boolean needClickFigure() {
                    Object data = this.getModel().getData();
                    return data instanceof CSVNodeModel && ((CSVNodeModel)data).isRecord();
                }

                protected boolean needSpaceFigure() {
                    Object data = this.getModel().getData();
                    return data instanceof CSVNodeModel && ((CSVNodeModel)data).isRecord();
                }

                protected ToolbarLayout createContentFigureLayout() {
                    ToolbarLayout layout = super.createContentFigureLayout();
                    layout.setVertical(true);
                    return layout;
                }

                protected ToolbarLayout createTreeNodeFigureLayout() {
                    ToolbarLayout layout = super.createTreeNodeFigureLayout();
                    layout.setMinorAlignment(0);
                    return layout;
                }

                public void collapsedNode() {
                }

                public void expandNode() {
                }
            };
            return figure;
        }
        return super.createFigure();
    }

    public void expandNode() {
        super.expandNode();
    }

    public void treeCollapsed(TreeFigureExpansionEvent event) {
        System.out.println();
    }

    public void treeExpanded(TreeFigureExpansionEvent event) {
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ComponentEditPolicy(){

            protected Command getDeleteCommand(GroupRequest request) {
                List editParts = request.getEditParts();
                for (EditPart editPart : editParts) {
                    AbstractSmooksGraphicalModel graphModel = (AbstractSmooksGraphicalModel)editPart.getModel();
                    Object data = graphModel.getData();
                    if (!((data = AdapterFactoryEditingDomain.unwrap((Object)data)) instanceof CSVNodeModel) || ((CSVNodeModel)data).isRecord()) continue;
                    DeleteSmooksGraphicalModelCommand deleteCommand = new DeleteSmooksGraphicalModelCommand(graphModel);
                    return deleteCommand;
                }
                return null;
            }
        });
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new FlowLayoutEditPolicy(){

            protected Command getCreateCommand(CreateRequest request) {
                Object model = request.getNewObject();
                Object graphModel = this.getHost().getModel();
                if (graphModel instanceof FreemarkerCSVNodeGraphicalModel) {
                    ILabelProvider provider = ((FreemarkerCSVNodeGraphicalModel)graphModel).getLabelProvider();
                    ITreeContentProvider provider1 = ((FreemarkerCSVNodeGraphicalModel)graphModel).getContentProvider();
                    IEditingDomainProvider provider2 = ((FreemarkerCSVNodeGraphicalModel)graphModel).getDomainProvider();
                    Object parentData = ((FreemarkerCSVNodeGraphicalModel)graphModel).getData();
                    if (parentData instanceof CSVNodeModel && ((CSVNodeModel)parentData).isRecord() && model instanceof CSVNodeModel && !((CSVNodeModel)model).isRecord()) {
                        FreemarkerCSVNodeGraphicalModel childGraphModel = new FreemarkerCSVNodeGraphicalModel(model, provider1, provider, provider2);
                        AddSmooksGraphicalModelCommand command = new AddSmooksGraphicalModelCommand((AbstractSmooksGraphicalModel)graphModel, childGraphModel);
                        return command;
                    }
                }
                return null;
            }

            protected Command createMoveChildCommand(EditPart child, EditPart after) {
                return null;
            }

            protected Command createAddCommand(EditPart child, EditPart after) {
                return null;
            }

            protected EditPolicy createChildEditPolicy(EditPart child) {
                return null;
            }

            protected boolean isHorizontal() {
                return false;
            }
        });
    }

    protected Command createDirectEditCommand(DirectEditRequest request) {
        Object value = request.getCellEditor().getValue();
        if (value != null && value instanceof String) {
            ChangeCSVNodeNameCommand command = new ChangeCSVNodeNameCommand((FreemarkerCSVNodeGraphicalModel)this.getModel(), value);
            return command;
        }
        return null;
    }

    protected boolean canDirectEdit() {
        Object data = ((AbstractSmooksGraphicalModel)this.getModel()).getData();
        return data instanceof CSVNodeModel && !((CSVNodeModel)data).isRecord();
    }

    protected void refreshVisuals() {
        AbstractSmooksGraphicalModel model = (AbstractSmooksGraphicalModel)this.getModel();
        TreeNodeFigure figure = (TreeNodeFigure)this.getFigure();
        Object data = model.getData();
        if (data instanceof CSVNodeModel && ((CSVNodeModel)data).isRecord()) {
            figure.setNodeLabelForegroundColor(ColorConstants.blue);
            figure.getLabel().setFont(this.getCSVRecordLabelFont());
        }
        super.refreshVisuals();
    }
}

