/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.graphical.editors.editparts.xsl;

import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.editpolicies.FlowLayoutEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.jboss.tools.smooks.configuration.SmooksConfigurationActivator;
import org.jboss.tools.smooks.configuration.editors.xml.AbstractXMLObject;
import org.jboss.tools.smooks.configuration.editors.xml.TagPropertyObject;
import org.jboss.tools.smooks.configuration.editors.xml.XSLModelAnalyzer;
import org.jboss.tools.smooks.configuration.editors.xml.XSLTagObject;
import org.jboss.tools.smooks.gef.model.AbstractSmooksGraphicalModel;
import org.jboss.tools.smooks.gef.tree.editparts.TreeNodeEditPart;
import org.jboss.tools.smooks.gef.tree.figures.TreeNodeFigure;
import org.jboss.tools.smooks.graphical.editors.commands.AddSmooksGraphicalModelCommand;
import org.jboss.tools.smooks.graphical.editors.commands.ChangeXSLNodeNameCommand;
import org.jboss.tools.smooks.graphical.editors.commands.DeleteXSLNodeCommand;
import org.jboss.tools.smooks.graphical.editors.model.xsl.XSLNodeGraphicalModel;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class XSLNodeEditPart
extends TreeNodeEditPart {
    private Font xslLabelFont = null;

    public void activate() {
        super.activate();
    }

    protected boolean canDirectEdit() {
        Object data = ((AbstractSmooksGraphicalModel)this.getModel()).getData();
        if (data instanceof AbstractXMLObject) {
            return !XSLModelAnalyzer.isXSLTagObject((AbstractXMLObject)data);
        }
        return false;
    }

    protected Command createDirectEditCommand(DirectEditRequest request) {
        Object value = request.getCellEditor().getValue();
        if (value != null && value instanceof String) {
            ChangeXSLNodeNameCommand command = new ChangeXSLNodeNameCommand((XSLNodeGraphicalModel)this.getModel(), value);
            return command;
        }
        return null;
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ComponentEditPolicy(){

            protected Command getDeleteCommand(GroupRequest request) {
                List editParts = request.getEditParts();
                for (EditPart editPart : editParts) {
                    AbstractSmooksGraphicalModel graphModel = (AbstractSmooksGraphicalModel)editPart.getModel();
                    Object data = graphModel.getData();
                    if ((data = AdapterFactoryEditingDomain.unwrap((Object)data)) instanceof XSLTagObject) {
                        DeleteXSLNodeCommand command = new DeleteXSLNodeCommand(editPart);
                        return command;
                    }
                    if (!(data instanceof TagPropertyObject)) continue;
                    DeleteXSLNodeCommand command = new DeleteXSLNodeCommand(editPart);
                    return command;
                }
                return null;
            }
        });
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new FlowLayoutEditPolicy(){

            protected Command getCreateCommand(CreateRequest request) {
                Object model = request.getNewObject();
                Object graphModel = this.getHost().getModel();
                AbstractXMLObject parentNode = (AbstractXMLObject)((XSLNodeGraphicalModel)graphModel).getData();
                if (parentNode instanceof TagPropertyObject) {
                    return null;
                }
                if (graphModel instanceof XSLNodeGraphicalModel) {
                    String namespace;
                    String name;
                    ILabelProvider provider = ((XSLNodeGraphicalModel)graphModel).getLabelProvider();
                    ITreeContentProvider provider1 = ((XSLNodeGraphicalModel)graphModel).getContentProvider();
                    IEditingDomainProvider provider2 = ((XSLNodeGraphicalModel)graphModel).getDomainProvider();
                    XSLNodeGraphicalModel childGraphModel = new XSLNodeGraphicalModel(model, provider1, provider, provider2);
                    if (model instanceof XSLTagObject) {
                        name = ((XSLTagObject)model).getName();
                        namespace = ((XSLTagObject)model).getNamespaceURI();
                        if (XSLModelAnalyzer.isXSLTagObject((XSLTagObject)parentNode) && XSLModelAnalyzer.isXSLTagObject((XSLTagObject)model) && !XSLNodeEditPart.this.canCreateAddCommand(name, parentNode.getName())) {
                            return null;
                        }
                        Element element = ((XSLTagObject)parentNode).getReferenceElement().getOwnerDocument().createElementNS(namespace, name);
                        ((XSLTagObject)model).setReferenceElement(element);
                    }
                    if (model instanceof TagPropertyObject) {
                        name = ((TagPropertyObject)model).getName();
                        namespace = ((TagPropertyObject)model).getNamespaceURI();
                        if (XSLModelAnalyzer.isXSLTagObject((XSLTagObject)parentNode)) {
                            return null;
                        }
                        Element parentElement = ((XSLTagObject)parentNode).getReferenceElement();
                        Attr element = parentElement.getOwnerDocument().createAttributeNS(namespace, name);
                        ((TagPropertyObject)model).setReferenceAttibute(element);
                    }
                    AddSmooksGraphicalModelCommand command = new AddSmooksGraphicalModelCommand((AbstractSmooksGraphicalModel)graphModel, childGraphModel);
                    return command;
                }
                return null;
            }

            protected Command createMoveChildCommand(EditPart child, EditPart after) {
                return null;
            }

            protected Command createAddCommand(EditPart child, EditPart after) {
                return null;
            }

            protected EditPolicy createChildEditPolicy(EditPart child) {
                return null;
            }

            protected boolean isHorizontal() {
                return false;
            }
        });
    }

    private boolean canCreateAddCommand(String nodeName, String parentNodeName) {
        if ("stylesheet".equals(parentNodeName)) {
            if ("attribute".equals(nodeName)) {
                return true;
            }
            if ("attribute-set".equals(nodeName)) {
                return true;
            }
            if ("decimal-format".equals(nodeName)) {
                return true;
            }
            if ("import".equals(nodeName)) {
                return true;
            }
            if ("include".equals(nodeName)) {
                return true;
            }
            if ("key".equals(nodeName)) {
                return true;
            }
            if ("namespace_alias".equals(nodeName)) {
                return true;
            }
            if ("output".equals(nodeName)) {
                return true;
            }
            if ("param".equals(nodeName)) {
                return true;
            }
            if ("preserve-space".equals(nodeName)) {
                return true;
            }
            if ("template".equals(nodeName)) {
                return true;
            }
            if ("variable".equals(nodeName)) {
                return true;
            }
        }
        if ("template".equals(parentNodeName)) {
            if ("apply-templates".equals(nodeName)) {
                return true;
            }
            if ("choose".equals(nodeName)) {
                return true;
            }
            if ("call-template".equals(nodeName)) {
                return true;
            }
            if ("comment".equals(nodeName)) {
                return true;
            }
            if ("copy".equals(nodeName)) {
                return true;
            }
            if ("copy-of".equals(nodeName)) {
                return true;
            }
            if ("element".equals(nodeName)) {
                return true;
            }
            if ("fallback".equals(nodeName)) {
                return true;
            }
            if ("for-each".equals(nodeName)) {
                return true;
            }
            if ("if".equals(nodeName)) {
                return true;
            }
            if ("message".equals(nodeName)) {
                return true;
            }
            if ("number".equals(nodeName)) {
                return true;
            }
            if ("text".equals(nodeName)) {
                return true;
            }
            if ("value-of".equals(nodeName)) {
                return true;
            }
            if ("processing-instruction".equals(nodeName)) {
                return true;
            }
        }
        return false;
    }

    public Font getXslLabelFont() {
        if (this.xslLabelFont == null) {
            FontData[] fds;
            IFigure figure = this.getFigure();
            FontData fd = new FontData();
            fd.setStyle(1);
            if (figure != null && (fds = figure.getFont().getFontData()) != null && fds.length > 0) {
                fd.setHeight(fds[0].getHeight());
                fd.setName(fds[0].getName());
                fd.setLocale(fds[0].getLocale());
            }
            this.xslLabelFont = new Font(null, fd);
        }
        return this.xslLabelFont;
    }

    public void deactivate() {
        super.deactivate();
        if (this.xslLabelFont != null) {
            this.xslLabelFont.dispose();
        }
    }

    protected void refreshVisuals() {
        AbstractSmooksGraphicalModel model = (AbstractSmooksGraphicalModel)this.getModel();
        TreeNodeFigure figure = (TreeNodeFigure)this.getFigure();
        Object data = model.getData();
        if (data instanceof XSLTagObject && XSLModelAnalyzer.isXSLTagObject((XSLTagObject)data)) {
            figure.setNodeLabelForegroundColor(ColorConstants.blue);
            figure.getLabel().setFont(this.getXslLabelFont());
        }
        super.refreshVisuals();
        if (data instanceof XSLTagObject) {
            if (((XSLTagObject)data).isTemplateElement()) {
                figure.setLabelImage(SmooksConfigurationActivator.getDefault().getImageRegistry().get("icons/full/obj16/xsl_template.gif"));
                figure.repaint();
            }
            if (((XSLTagObject)data).isApplyTemplatesElement()) {
                figure.setLabelImage(SmooksConfigurationActivator.getDefault().getImageRegistry().get("icons/full/obj16/xsl_template_apply.gif"));
                figure.repaint();
            }
            if (((XSLTagObject)data).isChoiceElement()) {
                figure.setLabelImage(SmooksConfigurationActivator.getDefault().getImageRegistry().get("icons/full/obj16/xsl_choice.gif"));
                figure.repaint();
            }
            if (((XSLTagObject)data).isSortElement()) {
                figure.setLabelImage(SmooksConfigurationActivator.getDefault().getImageRegistry().get("icons/full/obj16/xsl_sort.gif"));
                figure.repaint();
            }
            if (((XSLTagObject)data).isForeachElement()) {
                figure.setLabelImage(SmooksConfigurationActivator.getDefault().getImageRegistry().get("icons/full/obj16/xsl_foreach.gif"));
                figure.repaint();
            }
            if (((XSLTagObject)data).isIfElement()) {
                figure.setLabelImage(SmooksConfigurationActivator.getDefault().getImageRegistry().get("icons/full/obj16/xsl_if.gif"));
                figure.repaint();
            }
            if (((XSLTagObject)data).isStyleSheetElement()) {
                figure.setLabelImage(SmooksConfigurationActivator.getDefault().getImageRegistry().get("icons/full/obj16/xsl_stylesheet.gif"));
                figure.repaint();
            }
        }
    }
}

