/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.graphical.editors.model.xsl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.wst.xsl.core.XSLCore;
import org.jboss.tools.smooks.configuration.editors.uitls.SmooksUIUtils;
import org.jboss.tools.smooks.configuration.editors.xml.XSLTagObject;
import org.jboss.tools.smooks.gef.model.AbstractSmooksGraphicalModel;
import org.jboss.tools.smooks.gef.tree.model.TreeNodeModel;
import org.jboss.tools.smooks.graphical.editors.model.AbstractResourceConfigGraphModel;
import org.jboss.tools.smooks.graphical.editors.model.xsl.XSLNodeGraphicalModel;
import org.jboss.tools.smooks.graphical.editors.model.xsl.XSLTemplateContentProvider;
import org.jboss.tools.smooks.model.xsl.Template;
import org.jboss.tools.smooks.model.xsl.Xsl;
import org.jboss.tools.smooks10.model.smooks.util.SmooksModelUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSLTemplateGraphicalModel
extends AbstractResourceConfigGraphModel {
    public XSLTemplateGraphicalModel(Object data, ITreeContentProvider contentProvider, ILabelProvider labelProvider, IEditingDomainProvider domainProvider) {
        super(data, contentProvider, labelProvider, domainProvider);
    }

    @Override
    protected TreeNodeModel createChildModel(Object model, ITreeContentProvider contentProvider, ILabelProvider labelProvider) {
        return new XSLNodeGraphicalModel(model, contentProvider, labelProvider, this.domainProvider);
    }

    @Override
    public List<AbstractSmooksGraphicalModel> getChildren() {
        return super.getChildren();
    }

    @Override
    public void addChild(AbstractSmooksGraphicalModel node) {
        Object data;
        if (node instanceof XSLNodeGraphicalModel && (data = node.getData()) instanceof XSLTagObject) {
            Element element = ((XSLTagObject)data).getReferenceElement();
            Element rootElement = element.getOwnerDocument().getDocumentElement();
            String contents = XSLNodeGraphicalModel.getXSLContents(rootElement);
            Template template = ((Xsl)this.getData()).getTemplate();
            String filePath = SmooksModelUtils.getAnyTypeText((AnyType)template);
            if (filePath != null) {
                filePath = filePath.trim();
            }
            if (filePath != null && !"".equals(filePath)) {
                IFile file = SmooksUIUtils.getFile(filePath, SmooksUIUtils.getResource((EObject)template).getProject());
                if (file != null && XSLCore.isXSLFile((IFile)file) && file.exists()) {
                    try {
                        file.setContents((InputStream)new ByteArrayInputStream(contents.getBytes()), 1, null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                EditingDomain domain = this.domainProvider.getEditingDomain();
                SmooksModelUtils.setCDATAToSmooksType((EditingDomain)domain, (AnyType)template, (String)contents);
            }
            ((XSLTemplateContentProvider)this.contentProvider).cleanBuffer();
        }
        super.addChild(node);
    }

    @Override
    public void removeChild(AbstractSmooksGraphicalModel node) {
        if (node instanceof XSLNodeGraphicalModel) {
            Template template = ((Xsl)this.getData()).getTemplate();
            String filePath = SmooksModelUtils.getAnyTypeText((AnyType)template);
            if (filePath != null) {
                filePath = filePath.trim();
            }
            if (filePath != null && !"".equals(filePath)) {
                IFile file = SmooksUIUtils.getFile(filePath, SmooksUIUtils.getResource((EObject)template).getProject());
                if (file != null && XSLCore.isXSLFile((IFile)file) && file.exists()) {
                    try {
                        file.setContents((InputStream)new ByteArrayInputStream("".getBytes()), 1, null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                EditingDomain domain = this.domainProvider.getEditingDomain();
                SmooksModelUtils.setCDATAToSmooksType((EditingDomain)domain, (AnyType)template, null);
            }
            ((XSLTemplateContentProvider)this.contentProvider).cleanBuffer();
        }
        super.removeChild(node);
    }
}

