/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.graphical.editors.process;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.zest.core.viewers.IFigureProvider;
import org.eclipse.zest.core.viewers.ISelfStyleProvider;
import org.eclipse.zest.core.widgets.CGraphNode;
import org.eclipse.zest.core.widgets.GraphConnection;
import org.eclipse.zest.core.widgets.GraphNode;
import org.jboss.tools.smooks.configuration.SmooksConfigurationActivator;
import org.jboss.tools.smooks.configuration.editors.GraphicsConstants;
import org.jboss.tools.smooks.graphical.editors.SmooksProcessGraphicalEditor;
import org.jboss.tools.smooks.graphical.editors.TaskTypeManager;
import org.jboss.tools.smooks.graphical.editors.process.TaskNodeFigure;
import org.jboss.tools.smooks.graphical.editors.process.TaskType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessGraphicalViewerLabelProvider
extends LabelProvider
implements IFigureProvider,
ISelfStyleProvider {
    private SmooksProcessGraphicalEditor processEditor;

    public void dispose() {
        super.dispose();
    }

    public ProcessGraphicalViewerLabelProvider(SmooksProcessGraphicalEditor graph) {
        this.processEditor = graph;
    }

    public Image getImage(Object element) {
        if (element instanceof TaskType) {
            String id = ((TaskType)element).getId();
            List<TaskTypeManager.TaskTypeDescriptor> des = TaskTypeManager.getAllTaskList();
            for (TaskTypeManager.TaskTypeDescriptor taskTypeDescriptor : des) {
                if (!taskTypeDescriptor.getId().equals(id)) continue;
                return SmooksConfigurationActivator.getDefault().getImageRegistry().get(taskTypeDescriptor.getImagePath());
            }
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof TaskType) {
            String label = TaskTypeManager.getTaskLabel((TaskType)element);
            if (label == null) {
                label = ((TaskType)element).getId();
            }
            return label;
        }
        return "";
    }

    public IFigure getFigure(Object element) {
        if (element instanceof TaskType) {
            Image image = this.getImage(element);
            String text = this.getText(element);
            return new TaskNodeFigure(this.processEditor, image, text);
        }
        return null;
    }

    public void selfStyleConnection(Object element, GraphConnection connection) {
        connection.setLineColor(GraphicsConstants.BORDER_CORLOR);
    }

    private String getProblemMessage(List<String> message) {
        String m = null;
        if (message != null && !message.isEmpty()) {
            m = "";
            for (String string : message) {
                m = String.valueOf(m) + " - " + string + " \n";
            }
        }
        return m;
    }

    public void selfStyleNode(Object element, GraphNode node) {
        if (node instanceof CGraphNode) {
            IFigure figure = ((CGraphNode)node).getFigure();
            if (figure instanceof TaskNodeFigure && element instanceof TaskType) {
                int problem = ((TaskType)element).getProblemType();
                List<String> problemMessages = ((TaskType)element).getProblemMessages();
                String message = this.getProblemMessage(problemMessages);
                ImageRegistry ir = SmooksConfigurationActivator.getDefault().getImageRegistry();
                switch (problem) {
                    case 0: {
                        ((TaskNodeFigure)figure).getLabel().setIcon(null);
                        break;
                    }
                    case 1: {
                        ((TaskNodeFigure)figure).getLabel().setIcon(ir.get("icons/full/obj16/error_obj.gif"));
                        break;
                    }
                    case 2: {
                        ((TaskNodeFigure)figure).getLabel().setIcon(ir.get("icons/full/obj16/warning_obj.gif"));
                    }
                }
                ((TaskNodeFigure)figure).setProblemMessage(message);
            }
            Dimension size = figure.getLayoutManager().getPreferredSize(figure, -1, -1);
            figure.setSize(size);
        }
    }
}

