/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.graphical.editors.process;

import java.util.List;
import org.eclipse.draw2d.ActionEvent;
import org.eclipse.draw2d.ActionListener;
import org.eclipse.draw2d.Clickable;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.zest.core.widgets.CGraphNode;
import org.eclipse.zest.core.widgets.Graph;
import org.eclipse.zest.core.widgets.GraphItem;
import org.jboss.tools.smooks.configuration.SmooksConfigurationActivator;
import org.jboss.tools.smooks.configuration.editors.GraphicsConstants;
import org.jboss.tools.smooks.graphical.editors.SmooksProcessGraphicalEditor;

public class TaskNodeFigure
extends Figure {
    private Label problemTooltip;
    private IFigure mainFigure;
    private IFigure addTaskFigure;
    private Image image;
    private String labelText;
    private SmooksProcessGraphicalEditor processGraphicalViewerEditor;
    private Label label;
    private IFigure imageFigure;
    private Color oldLabelColor = null;
    private boolean showAddFigure = false;
    private Rectangle imageSourceRectangle = null;

    public TaskNodeFigure(SmooksProcessGraphicalEditor graph, Image image, String labelText) {
        this.image = image;
        this.labelText = labelText;
        this.processGraphicalViewerEditor = graph;
        this.problemTooltip = new Label();
        this.initFigure();
        this.hookTaskNodeFigure();
    }

    public void setProblemMessage(String message) {
        if (message == null) {
            this.setToolTip(null);
        } else {
            this.problemTooltip.setText(message);
            this.setToolTip((IFigure)this.problemTooltip);
        }
    }

    public Label getLabel() {
        return this.label;
    }

    private void hookTaskNodeFigure() {
        this.addTaskFigure.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent me) {
            }

            public void mouseEntered(MouseEvent me) {
                TaskNodeFigure.this.showAddFigure = true;
                TaskNodeFigure.this.imageSourceRectangle = null;
                TaskNodeFigure.this.addTaskFigure.repaint();
            }

            public void mouseExited(MouseEvent me) {
                TaskNodeFigure.this.showAddFigure = false;
                TaskNodeFigure.this.addTaskFigure.repaint();
            }

            public void mouseHover(MouseEvent me) {
            }

            public void mouseMoved(MouseEvent me) {
            }
        });
    }

    protected void initFigure() {
        this.initMainFigure();
        this.initAddTaskFigure();
        GridLayout girdlLayout = new GridLayout();
        girdlLayout.numColumns = 2;
        this.setLayoutManager((LayoutManager)girdlLayout);
        GridData d = new GridData(1040);
        this.add(this.mainFigure);
        this.add(this.addTaskFigure);
        girdlLayout.setConstraint(this.addTaskFigure, (Object)d);
    }

    private void initAddTaskFigure() {
        this.addTaskFigure = new Clickable(){

            protected void paintBorder(Graphics graphics) {
            }

            protected void paintFigure(Graphics graphics) {
                super.paintFigure(graphics);
                Rectangle rect = this.getBounds();
                Point center = rect.getCenter();
                if (!TaskNodeFigure.this.showAddFigure) {
                    graphics.fillRectangle(rect);
                    return;
                }
                Image image = SmooksConfigurationActivator.getDefault().getImageRegistry().get("icons/full/obj16/add_task_button.png");
                if (image != null) {
                    Point location = new Point(center.x - image.getBounds().width / 2, center.y - image.getBounds().height / 2);
                    graphics.drawImage(image, location);
                }
            }
        };
        ((Clickable)this.addTaskFigure).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (!TaskNodeFigure.this.showAddFigure) {
                    return;
                }
                Graph g = TaskNodeFigure.this.processGraphicalViewerEditor.getProcessGraphViewer().getGraphControl();
                TaskNodeFigure.this.processGraphicalViewerEditor.setNeedupdatewhenshow(false);
                List nodes = g.getNodes();
                for (GraphItem item : nodes) {
                    if (!(item instanceof CGraphNode) || TaskNodeFigure.this != ((CGraphNode)item).getFigure()) continue;
                    TaskNodeFigure.this.processGraphicalViewerEditor.updateProcessActions((ISelection)new StructuredSelection(item.getData()));
                    break;
                }
                Menu menu = TaskNodeFigure.this.processGraphicalViewerEditor.getProcessGraphViewer().getGraphControl().getMenu();
                menu.setVisible(true);
            }
        });
        this.addTaskFigure.setSize(16, 16);
    }

    private void initMainFigure() {
        this.mainFigure = new Figure();
        this.imageFigure = new Figure(){

            protected void paintFigure(Graphics graphics) {
                super.paintFigure(graphics);
                if (TaskNodeFigure.this.image != null) {
                    graphics.drawImage(TaskNodeFigure.this.image, this.getLocation());
                } else {
                    graphics.drawRectangle(0, 0, 24, 24);
                }
            }
        };
        if (this.image != null) {
            this.imageFigure.setSize(new Dimension(this.image.getBounds().width, this.image.getBounds().height));
        } else {
            this.imageFigure.setSize(24, 24);
        }
        this.mainFigure.add(this.imageFigure);
        this.label = new Label();
        this.label.setForegroundColor(GraphicsConstants.BORDER_CORLOR);
        this.label.setText(this.labelText);
        this.oldLabelColor = this.label.getForegroundColor();
        this.mainFigure.add((IFigure)this.label);
        ToolbarLayout layout = new ToolbarLayout(false);
        layout.setMinorAlignment(0);
        this.mainFigure.setLayoutManager((LayoutManager)layout);
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public String getLabelText() {
        return this.labelText;
    }

    public void setLabelText(String labelText) {
        this.labelText = labelText;
    }

    public void highlightLabel(Color highlightColor) {
        this.oldLabelColor = this.label.getForegroundColor();
        this.label.setForegroundColor(highlightColor);
        this.label.repaint();
    }

    public void unhighlightLabel() {
        if (this.oldLabelColor != null) {
            this.label.setForegroundColor(this.oldLabelColor);
            this.label.repaint();
        }
    }

    static /* synthetic */ Rectangle access$4(TaskNodeFigure taskNodeFigure) {
        return taskNodeFigure.imageSourceRectangle;
    }
}

