/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.graphical.editors.template;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.jboss.tools.smooks.configuration.editors.IXMLStructuredObject;
import org.jboss.tools.smooks.configuration.editors.uitls.SmooksUIUtils;
import org.jboss.tools.smooks.configuration.editors.xml.TagList;
import org.jboss.tools.smooks.configuration.editors.xml.TagObject;
import org.jboss.tools.smooks.editor.ISmooksModelProvider;
import org.jboss.tools.smooks.gef.model.AbstractSmooksGraphicalModel;
import org.jboss.tools.smooks.graphical.editors.model.freemarker.CSVNodeModel;
import org.jboss.tools.smooks.graphical.editors.model.freemarker.FreemarkerCSVNodeGraphicalModel;
import org.jboss.tools.smooks.graphical.editors.model.freemarker.FreemarkerModelAnalyzer;
import org.jboss.tools.smooks.graphical.editors.model.freemarker.FreemarkerTemplateGraphicalModel;
import org.jboss.tools.smooks.graphical.editors.model.freemarker.FreemarkerTemplateXMLModel;
import org.jboss.tools.smooks.graphical.editors.model.freemarker.FreemarkerXMLNodeGraphicalModel;
import org.jboss.tools.smooks.graphical.editors.template.IFreemarkerTemplateContentGraphModelProvider;
import org.jboss.tools.smooks.graphical.editors.template.Messages;
import org.jboss.tools.smooks.model.freemarker.Freemarker;
import org.jboss.tools.smooks.templating.model.ModelBuilder;
import org.jboss.tools.smooks.templating.model.ModelBuilderException;
import org.jboss.tools.smooks.templating.model.csv.CSVModelBuilder;
import org.jboss.tools.smooks.templating.model.xml.XMLSampleModelBuilder;
import org.jboss.tools.smooks.templating.model.xml.XSDModelBuilder;
import org.jboss.tools.smooks.templating.template.TemplateBuilder;
import org.jboss.tools.smooks.templating.template.csv.CSVFreeMarkerTemplateBuilder;
import org.jboss.tools.smooks.templating.template.exception.TemplateBuilderException;
import org.jboss.tools.smooks.templating.template.xml.XMLFreeMarkerTemplateBuilder;
import org.jboss.tools.smooks10.model.smooks.util.SmooksModelUtils;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreemarkerTemplateContentGraphModelProviderImpl
implements IFreemarkerTemplateContentGraphModelProvider {
    private TemplateBuilder templateBuilder = null;

    @Override
    public List<AbstractSmooksGraphicalModel> getFreemarkerTemplateContentGraphModel(FreemarkerTemplateGraphicalModel freemarkerGraphModel, ITreeContentProvider contentProvider, ILabelProvider labelProvider, ISmooksModelProvider smooksModelProvider) {
        Freemarker freemarker = (Freemarker)freemarkerGraphModel.getData();
        if (freemarker != null) {
            TemplateBuilder builder;
            String type;
            block9: {
                type = SmooksModelUtils.getTemplateType((Freemarker)freemarker);
                builder = this.getModelBuilder(freemarker);
                if (builder != null) break block9;
                return null;
            }
            try {
                Document rootDocument = builder.getModel();
                Class tagModelClass = null;
                if ("CSV".equals(type)) {
                    tagModelClass = CSVNodeModel.class;
                }
                if ("XML".equals(type)) {
                    tagModelClass = FreemarkerTemplateXMLModel.class;
                }
                TagList tagList = new FreemarkerModelAnalyzer().analyze(rootDocument, null, tagModelClass);
                return this.createGraphModel(type, tagList.getChildren(), contentProvider, labelProvider, smooksModelProvider, null);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ModelBuilderException e) {
                e.printStackTrace();
            }
            catch (TemplateBuilderException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    protected List<AbstractSmooksGraphicalModel> createGraphModel(String type, List<IXMLStructuredObject> datas, ITreeContentProvider contentProvider, ILabelProvider labelProvider, ISmooksModelProvider smooksModelProvider, AbstractSmooksGraphicalModel parentModel) {
        ArrayList<AbstractSmooksGraphicalModel> graphList = new ArrayList<AbstractSmooksGraphicalModel>();
        if (datas != null) {
            for (IXMLStructuredObject data : datas) {
                AbstractSmooksGraphicalModel graphModel = this.createFreemarkerTemplateGraphModel(type, data, contentProvider, labelProvider, smooksModelProvider);
                if (graphModel == null) continue;
                if (parentModel != null) {
                    parentModel.getChildrenWithoutDynamic().add(graphModel);
                    graphModel.setParent(parentModel);
                } else {
                    graphList.add(graphModel);
                }
                if (!(data instanceof TagObject)) continue;
                this.createGraphModel(type, ((TagObject)data).getChildren(), contentProvider, labelProvider, smooksModelProvider, graphModel);
            }
        }
        return graphList;
    }

    public TemplateBuilder getModelBuilder(Freemarker freemarker) throws InvocationTargetException, IOException, ModelBuilderException, TemplateBuilderException {
        if (this.templateBuilder == null) {
            String contents = SmooksModelUtils.getAnyTypeCDATA((AnyType)freemarker.getTemplate());
            String type = SmooksModelUtils.getTemplateType((Freemarker)freemarker);
            if ("CSV".equals(type)) {
                String[] fields = SmooksModelUtils.getFreemarkerCSVFileds((Freemarker)freemarker);
                CSVModelBuilder modelBuilder = new CSVModelBuilder(fields);
                CSVFreeMarkerTemplateBuilder builder1 = null;
                try {
                    builder1 = new CSVFreeMarkerTemplateBuilder((ModelBuilder)modelBuilder, SmooksModelUtils.getFreemarkerCSVSeperator((Freemarker)freemarker), SmooksModelUtils.getFreemarkerCSVQuote((Freemarker)freemarker), SmooksModelUtils.getFreemarkerCSVIncludeFieldNames((Freemarker)freemarker), contents);
                }
                catch (Exception exception) {
                    builder1 = new CSVFreeMarkerTemplateBuilder((ModelBuilder)modelBuilder, SmooksModelUtils.getFreemarkerCSVSeperator((Freemarker)freemarker), SmooksModelUtils.getFreemarkerCSVQuote((Freemarker)freemarker), SmooksModelUtils.getFreemarkerCSVIncludeFieldNames((Freemarker)freemarker));
                }
                this.templateBuilder = builder1;
            }
            if ("XML".equals(type)) {
                XSDModelBuilder builder;
                String fileType = SmooksModelUtils.getFreemarkerXMLFileType((Freemarker)freemarker);
                String filePath = SmooksModelUtils.getFreemarkerXMLFilePath((Freemarker)freemarker);
                String rootName = SmooksModelUtils.getFreemarkerXMLRootName((Freemarker)freemarker);
                String newFilePath = SmooksUIUtils.parseFilePath(filePath);
                if ("XSD".equals(fileType)) {
                    builder = new XSDModelBuilder(URI.createFileURI((String)newFilePath));
                    builder.setRootElementName(rootName);
                } else if ("XML".equals(fileType)) {
                    builder = new XMLSampleModelBuilder(URI.createFileURI((String)newFilePath));
                } else {
                    throw new IOException(String.valueOf(Messages.FreemarkerTemplateContentGraphModelProviderImpl_IOExceptionMessage) + fileType + "'.");
                }
                try {
                    this.templateBuilder = new XMLFreeMarkerTemplateBuilder((ModelBuilder)builder, contents);
                }
                catch (Exception exception) {
                    this.templateBuilder = new XMLFreeMarkerTemplateBuilder((ModelBuilder)builder);
                }
            }
        }
        return this.templateBuilder;
    }

    @Override
    public AbstractSmooksGraphicalModel createFreemarkerTemplateGraphModel(String type, Object data, ITreeContentProvider contentProvider, ILabelProvider labelProvider, ISmooksModelProvider smooksModelProvider) {
        if ("CSV".equals(type) && data instanceof TagObject) {
            return new FreemarkerCSVNodeGraphicalModel(data, contentProvider, labelProvider, smooksModelProvider);
        }
        if ("XML".equals(type)) {
            return new FreemarkerXMLNodeGraphicalModel(data, contentProvider, labelProvider, smooksModelProvider);
        }
        return null;
    }

    @Override
    public TemplateBuilder getTemplateBuilder(FreemarkerTemplateGraphicalModel freemarkerGraphModel) throws InvocationTargetException, IOException, ModelBuilderException, TemplateBuilderException {
        Object data = freemarkerGraphModel.getData();
        data = AdapterFactoryEditingDomain.unwrap((Object)data);
        Freemarker freemarker = (Freemarker)data;
        return this.getModelBuilder(freemarker);
    }
}

