/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.graphical.wizard.freemarker;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.smooks.graphical.wizard.freemarker.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreemarkerCSVCreationWizardPage
extends WizardPage {
    private List<FieldText> fieldsList = new ArrayList<FieldText>();
    private Text seperatorText;
    private Text quoteText;
    private Text fieldsText;
    private Button includeFieldNames;

    public FreemarkerCSVCreationWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public FreemarkerCSVCreationWizardPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.FreemarkerCSVCreationWizardPage_WizardTitle);
        this.setDescription(Messages.FreemarkerCSVCreationWizardPage_WizardDes);
    }

    public Text getFieldsText() {
        return this.fieldsText;
    }

    public void setFieldsText(Text fieldsText) {
        this.fieldsText = fieldsText;
    }

    public List<FieldText> getFieldsList() {
        return this.fieldsList;
    }

    public Text getSeperatorText() {
        return this.seperatorText;
    }

    public Text getQuoteText() {
        return this.quoteText;
    }

    public Button getIncludeFieldNames() {
        return this.includeFieldNames;
    }

    public void createControl(Composite parent) {
        this.fieldsList.clear();
        Composite mainComposite = new Composite(parent, 0);
        GridData gd = new GridData(1808);
        mainComposite.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        mainComposite.setLayout((Layout)layout);
        Label filedsLabel = new Label(mainComposite, 0);
        filedsLabel.setText(Messages.FreemarkerCSVCreationWizardPage_FieldsGroupText);
        this.fieldsText = new Text(mainComposite, 2048);
        gd = new GridData(768);
        this.fieldsText.setLayoutData((Object)gd);
        Label seperatorLabel = new Label(mainComposite, 0);
        seperatorLabel.setText(Messages.FreemarkerCSVCreationWizardPage_SeperatorCharLabel);
        this.seperatorText = new Text(mainComposite, 2048);
        gd = new GridData(1);
        this.seperatorText.setLayoutData((Object)gd);
        this.seperatorText.setTextLimit(1);
        Label quoteLabel = new Label(mainComposite, 0);
        quoteLabel.setText(Messages.FreemarkerCSVCreationWizardPage_QuoteCharLabel);
        this.quoteText = new Text(mainComposite, 2048);
        gd = new GridData(1);
        this.quoteText.setLayoutData((Object)gd);
        this.quoteText.setTextLimit(1);
        Label includeFieldNamesLabel = new Label(mainComposite, 0);
        includeFieldNamesLabel.setText(Messages.FreemarkerCSVCreationWizardPage_IncludeFieldNamesLabel);
        this.includeFieldNames = new Button(mainComposite, 16779296);
        gd = new GridData(1);
        this.includeFieldNames.setLayoutData((Object)gd);
        this.setControl((Control)mainComposite);
        this.seperatorText.setText(",");
        this.quoteText.setText("\"");
        this.seperatorText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FreemarkerCSVCreationWizardPage.this.updatePage();
            }
        });
        this.quoteText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FreemarkerCSVCreationWizardPage.this.updatePage();
            }
        });
        this.fieldsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FreemarkerCSVCreationWizardPage.this.updatePage();
            }
        });
        this.setPageComplete(false);
    }

    private void fillFieldsList(String fieldsString) {
        if (fieldsString == null || fieldsString.length() == 0) {
            return;
        }
        String input = fieldsString.toString();
        if ((input = input.trim()).indexOf(",") != -1) {
            String[] fields = input.split(",");
            if (fields != null && fields.length > 0) {
                int i = 0;
                while (i < fields.length) {
                    String field = fields[i];
                    if (field != null) {
                        field = field.trim();
                        this.fieldsList.add(new FieldText(field));
                    }
                    ++i;
                }
            }
        } else {
            this.fieldsList.add(new FieldText(input));
        }
    }

    protected void updatePage() {
        String error = null;
        String seperator = this.seperatorText.getText();
        String quote = this.quoteText.getText();
        String fields = this.fieldsText.getText();
        if (seperator == null || seperator.length() == 0) {
            error = Messages.FreemarkerCSVCreationWizardPage_SeperatorEmptyErrorMessage;
        }
        if (quote == null || quote.length() == 0) {
            error = Messages.FreemarkerCSVCreationWizardPage_QuoteEmptyErrorMessage;
        }
        if (seperator != null && seperator.length() > 1) {
            error = "Seperator must be only one character";
        }
        if (quote != null && quote.length() > 1) {
            error = "Quote must be only one character";
        }
        if (fields == null) {
            error = Messages.FreemarkerCSVCreationWizardPage_Error_Fields_Empty;
        } else if ("".equals(fields = fields.trim())) {
            error = Messages.FreemarkerCSVCreationWizardPage_Error_Fields_Empty;
        } else {
            char[] chars = fields.toCharArray();
            int i = 0;
            while (i < chars.length) {
                char c = chars[i];
                if (c != ',' && !Character.isLetterOrDigit(c)) {
                    error = String.valueOf(Messages.FreemarkerCSVCreationWizardPage_Error_Incorrect) + c + Messages.FreemarkerCSVCreationWizardPage_Error_Incorrect2;
                    break;
                }
                ++i;
            }
            String[] fieldsArray = fields.split(",");
            if (fieldsArray.length == 0) {
                error = Messages.FreemarkerCSVCreationWizardPage_Error_Fields_Empty;
            }
            int i2 = 0;
            while (i2 < fieldsArray.length) {
                String f = fieldsArray[i2];
                if (f == null || "".equals(f.trim())) {
                    error = Messages.FreemarkerCSVCreationWizardPage_Error_Fields_Empty;
                    break;
                }
                ++i2;
            }
        }
        this.setErrorMessage(error);
        this.setPageComplete(error == null);
    }

    class FieldText {
        private String text = null;

        public FieldText(String t) {
            this.setText(t);
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }
    }

    private class FieldsContentProvider
    implements IStructuredContentProvider {
        private FieldsContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return new Object[0];
        }
    }

    private class FieldsLabelProvider
    extends LabelProvider {
        private FieldsLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof FieldText) {
                return ((FieldText)element).getText();
            }
            return super.getText(element);
        }
    }
}

