/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.graphical.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.wizard.IWizardPage;
import org.jboss.tools.smooks.configuration.editors.javabean.JavaBeanModel;
import org.jboss.tools.smooks.configuration.editors.uitls.SmooksUIUtils;
import org.jboss.tools.smooks.editor.ISmooksModelProvider;
import org.jboss.tools.smooks.graphical.wizards.JavaBeanCreationWizardPage;
import org.jboss.tools.smooks.graphical.wizards.Messages;
import org.jboss.tools.smooks.graphical.wizards.SmooksCreationModelConfigureWizard;
import org.jboss.tools.smooks.model.javabean12.BeanType;
import org.jboss.tools.smooks.model.smooks.DocumentRoot;
import org.jboss.tools.smooks.model.smooks.SmooksResourceListType;

public class JavaBeanCreationWizard
extends SmooksCreationModelConfigureWizard {
    private JavaBeanCreationWizardPage wizardPage;
    private Object[] checedObjects = null;
    private JavaBeanModel javaBeanModel;

    public JavaBeanCreationWizard(ISmooksModelProvider modelProvider, Object model) {
        super(modelProvider, model);
        this.setWindowTitle(Messages.JavaBeanCreationWizard_WizardTitle);
    }

    public Object[] getBindings() {
        return this.checedObjects;
    }

    public JavaBeanModel getJavaBeanModel() {
        return this.javaBeanModel;
    }

    public void addPages() {
        EObject smooksModel = this.modelProvider.getSmooksModel();
        IJavaProject project = SmooksUIUtils.getJavaProject(smooksModel);
        EObject rootModel = this.modelProvider.getSmooksModel();
        ArrayList<String> ids = new ArrayList<String>();
        if (rootModel instanceof DocumentRoot) {
            SmooksResourceListType listType = ((DocumentRoot)rootModel).getSmooksResourceList();
            List<BeanType> beanTypeTypes = SmooksUIUtils.getBeanTypeList(listType);
            for (BeanType beanType : beanTypeTypes) {
                String id = beanType.getBeanId();
                if (id == null) continue;
                ids.add(id);
            }
        }
        if (project != null) {
            this.wizardPage = new JavaBeanCreationWizardPage("Java Bean Creation Page", project, ids);
            this.addPage((IWizardPage)this.wizardPage);
        }
    }

    public boolean performFinish() {
        this.checedObjects = this.wizardPage.getSelectionProperties();
        this.javaBeanModel = this.wizardPage.getJavaBeanModel();
        return true;
    }
}

