/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.graphical.wizards;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.jface.wizard.IWizardPage;
import org.jboss.tools.smooks.configuration.editors.uitls.SmooksUIUtils;
import org.jboss.tools.smooks.configuration.editors.xml.TagList;
import org.jboss.tools.smooks.configuration.editors.xml.TagObject;
import org.jboss.tools.smooks.configuration.editors.xml.XMLObjectAnalyzer;
import org.jboss.tools.smooks.configuration.editors.xml.XSDObjectAnalyzer;
import org.jboss.tools.smooks.editor.ISmooksModelProvider;
import org.jboss.tools.smooks.graphical.wizards.Messages;
import org.jboss.tools.smooks.graphical.wizards.SmooksCreationModelConfigureWizard;
import org.jboss.tools.smooks.graphical.wizards.XSLTemplateCreationWizardPage;
import org.jboss.tools.smooks.model.xsl.Template;
import org.jboss.tools.smooks.model.xsl.Xsl;
import org.jboss.tools.smooks.model.xsl.XslFactory;
import org.jboss.tools.smooks10.model.smooks.util.SmooksModelUtils;
import org.xml.sax.SAXException;

public class XSLTemplateCreationWizard
extends SmooksCreationModelConfigureWizard {
    private XSLTemplateCreationWizardPage page;
    private Xsl xslModel = null;

    public XSLTemplateCreationWizard(ISmooksModelProvider modelProvider, Object model) {
        super(modelProvider, model);
    }

    public void addPages() {
        super.addPages();
        if (this.page == null) {
            this.page = new XSLTemplateCreationWizardPage(Messages.XSLTemplateCreationWizard_page_name, this.modelProvider);
            this.addPage((IWizardPage)this.page);
        }
    }

    public Xsl getXslModel() {
        return this.xslModel;
    }

    public boolean performFinish() {
        int type = this.page.getTemplateType();
        this.xslModel = XslFactory.eINSTANCE.createXsl();
        this.xslModel.setApplyOnElement("#document");
        Template template = this.xslModel.getTemplate();
        if (type == 0) {
            return true;
        }
        if (type == 1) {
            SmooksModelUtils.setTextToAnyType((AnyType)template, (String)this.page.getExtenalFilePath());
        }
        if (type == 2) {
            String rootElement = this.page.getRootElementName();
            String filePath = this.page.getContentsFile();
            if (rootElement != null) {
                XSDObjectAnalyzer analyzer = new XSDObjectAnalyzer();
                try {
                    filePath = SmooksUIUtils.parseFilePath(filePath);
                    TagObject rootTag = analyzer.loadElement(filePath, rootElement);
                    if (rootTag != null) {
                        String contents = XSLTemplateCreationWizard.generateXSLContents(rootTag);
                        SmooksModelUtils.setCDATAToAnyType((AnyType)template, (String)contents);
                    }
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                XMLObjectAnalyzer analyzer = new XMLObjectAnalyzer();
                try {
                    filePath = SmooksUIUtils.parseFilePath(filePath);
                    TagList list = analyzer.analyze(filePath, null, null);
                    if (!list.getRootTagList().isEmpty()) {
                        TagObject rootTag = list.getRootTagList().get(0);
                        String contents = XSLTemplateCreationWizard.generateXSLContents(rootTag);
                        SmooksModelUtils.setCDATAToAnyType((AnyType)template, (String)contents);
                    }
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (ParserConfigurationException e) {
                    e.printStackTrace();
                }
                catch (SAXException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return true;
    }

    public static String generateXSLContents(TagObject tag) {
        String tagXML = tag.toString();
        StringBuffer buffer = new StringBuffer();
        buffer.append("<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" version=\"1.0\">\n");
        buffer.append("\t<xsl:template match=\"\\\">\n");
        buffer.append(tagXML);
        buffer.append("\t</xsl:template>\n");
        buffer.append("</xsl:stylesheet>");
        return buffer.toString();
    }
}

