/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.graphical.wizards;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.xsd.XSDElementDeclaration;
import org.jboss.tools.smooks.configuration.editors.ClassPathFileProcessor;
import org.jboss.tools.smooks.configuration.editors.CurrentProjecViewerFilter;
import org.jboss.tools.smooks.configuration.editors.FileSelectionWizard;
import org.jboss.tools.smooks.configuration.editors.uitls.SmooksUIUtils;
import org.jboss.tools.smooks.configuration.editors.xml.XSDListContentProvider;
import org.jboss.tools.smooks.configuration.editors.xml.XSDListLabelProvider;
import org.jboss.tools.smooks.configuration.editors.xml.XSDObjectAnalyzer;
import org.jboss.tools.smooks.editor.ISmooksModelProvider;
import org.jboss.tools.smooks.graphical.wizards.Messages;

public class XSLTemplateCreationWizardPage
extends WizardPage {
    public static final int TEMPLATE_TYPE_NONE = 0;
    public static final int TEMPLATE_TYPE_XSL = 1;
    public static final int TEMPLATE_TYPE_XML_XSD = 2;
    private Combo typeCombo;
    private CheckboxTableViewer tableViewer;
    private Button fileBrowseButton1;
    private Text contentFileText;
    private Text externalFileText;
    private Button fileBrowseButton;
    private ISmooksModelProvider smooksModelProvider = null;
    protected boolean fireEvent = true;
    protected String rootElementName;
    private static final Object EMPTY_TABLEVIEWER_INPUT = new Object();

    public XSLTemplateCreationWizardPage(String pageName, String title, ImageDescriptor titleImage, ISmooksModelProvider smooksModelProvider) {
        super(pageName, title, titleImage);
        this.smooksModelProvider = smooksModelProvider;
    }

    public XSLTemplateCreationWizardPage(String pageName, ISmooksModelProvider smooksModelProvider) {
        super(pageName);
        this.smooksModelProvider = smooksModelProvider;
    }

    public int getTemplateType() {
        return this.typeCombo.getSelectionIndex();
    }

    public String getExtenalFilePath() {
        return this.externalFileText.getText();
    }

    public String getRootElementName() {
        return this.rootElementName;
    }

    public String getContentsFile() {
        return this.contentFileText.getText();
    }

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        GridData gd = new GridData(1808);
        mainComposite.setLayoutData((Object)gd);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        mainComposite.setLayout((Layout)gridLayout);
        Label templateType = new Label(mainComposite, 0);
        templateType.setText(Messages.XSLTemplateCreationWizardPage_Label_Template_Type);
        this.typeCombo = new Combo(mainComposite, 2056);
        this.typeCombo.add("");
        this.typeCombo.add(Messages.XSLTemplateCreationWizardPage_Combo_External_File);
        this.typeCombo.add(Messages.XSLTemplateCreationWizardPage_Combo_Inner_Contents);
        this.typeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = XSLTemplateCreationWizardPage.this.typeCombo.getSelectionIndex();
                XSLTemplateCreationWizardPage.this.setEnabledToAllControls(true);
                if (index == 0) {
                    XSLTemplateCreationWizardPage.this.setEnabledToAllControls(false);
                }
                if (index == 1) {
                    XSLTemplateCreationWizardPage.this.disableInnerContentControls();
                }
                if (index == 2) {
                    XSLTemplateCreationWizardPage.this.disableExternalFileControls();
                }
                XSLTemplateCreationWizardPage.this.updatePage();
            }
        });
        gd = new GridData(768);
        this.typeCombo.setLayoutData((Object)gd);
        Label externalFilePathLabel = new Label(mainComposite, 0);
        externalFilePathLabel.setText(Messages.XSLTemplateCreationWizardPage_Label_External_Path);
        Composite externalFileComposite = new Composite(mainComposite, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        externalFileComposite.setLayout((Layout)gl);
        this.externalFileText = new Text(externalFileComposite, 2048);
        gd = new GridData(768);
        this.externalFileText.setLayoutData((Object)gd);
        this.externalFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                XSLTemplateCreationWizardPage.this.updatePage();
            }
        });
        this.fileBrowseButton = new Button(externalFileComposite, 0);
        this.fileBrowseButton.setText(Messages.XSLTemplateCreationWizardPage_Button_Browse);
        this.fileBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileSelectionWizard wizard = new FileSelectionWizard();
                wizard.setExtensionNames(new String[]{"xsl", "xslt"});
                EObject fm = XSLTemplateCreationWizardPage.this.smooksModelProvider.getSmooksModel();
                IResource resource = SmooksUIUtils.getResource(fm);
                Object[] initSelections = new Object[]{};
                if (resource != null) {
                    initSelections = new Object[]{resource};
                }
                wizard.setFilePathProcessor(new ClassPathFileProcessor());
                wizard.setInitSelections(initSelections);
                ArrayList<ViewerFilter> filterList = new ArrayList<ViewerFilter>();
                filterList.add(new CurrentProjecViewerFilter(resource));
                wizard.setViewerFilters(filterList);
                WizardDialog dialog = new WizardDialog(XSLTemplateCreationWizardPage.this.getShell(), (IWizard)wizard);
                if (dialog.open() == 0) {
                    XSLTemplateCreationWizardPage.this.externalFileText.setText(wizard.getFilePath());
                }
            }
        });
        gd = new GridData(768);
        externalFileComposite.setLayoutData((Object)gd);
        Label xslInnerContentFileLabel = new Label(mainComposite, 0);
        xslInnerContentFileLabel.setText(Messages.XSLTemplateCreationWizardPage_Label_XML_XSD_File);
        Composite xslInnerContentFileComposite = new Composite(mainComposite, 0);
        GridLayout gl1 = new GridLayout();
        gl1.numColumns = 2;
        gl1.marginHeight = 0;
        gl1.marginWidth = 0;
        xslInnerContentFileComposite.setLayout((Layout)gl1);
        this.contentFileText = new Text(xslInnerContentFileComposite, 2048);
        gd = new GridData(768);
        this.contentFileText.setLayoutData((Object)gd);
        this.contentFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String path = XSLTemplateCreationWizardPage.this.contentFileText.getText();
                XSLTemplateCreationWizardPage.this.tableViewer.getTable().setEnabled(true);
                try {
                    List<XSDElementDeclaration> elements = XSDObjectAnalyzer.loadAllElement(path);
                    if (elements == null || elements.isEmpty()) {
                        XSLTemplateCreationWizardPage.this.tableViewer.setInput(EMPTY_TABLEVIEWER_INPUT);
                        XSLTemplateCreationWizardPage.this.tableViewer.getTable().setEnabled(false);
                        XSLTemplateCreationWizardPage.this.rootElementName = null;
                    } else {
                        XSLTemplateCreationWizardPage.this.tableViewer.setInput(elements);
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                    XSLTemplateCreationWizardPage.this.tableViewer.setInput(EMPTY_TABLEVIEWER_INPUT);
                    XSLTemplateCreationWizardPage.this.tableViewer.getTable().setEnabled(false);
                    XSLTemplateCreationWizardPage.this.rootElementName = null;
                }
                catch (IOException iOException) {
                    XSLTemplateCreationWizardPage.this.tableViewer.setInput(EMPTY_TABLEVIEWER_INPUT);
                    XSLTemplateCreationWizardPage.this.tableViewer.getTable().setEnabled(false);
                    XSLTemplateCreationWizardPage.this.rootElementName = null;
                }
                XSLTemplateCreationWizardPage.this.updatePage();
            }
        });
        this.fileBrowseButton1 = new Button(xslInnerContentFileComposite, 0);
        this.fileBrowseButton1.setText(Messages.XSLTemplateCreationWizardPage_Button_Browse);
        this.fileBrowseButton1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileSelectionWizard wizard = new FileSelectionWizard();
                wizard.setExtensionNames(new String[]{"xml", "xsd"});
                EObject fm = XSLTemplateCreationWizardPage.this.smooksModelProvider.getSmooksModel();
                IResource resource = SmooksUIUtils.getResource(fm);
                Object[] initSelections = new Object[]{};
                if (resource != null) {
                    initSelections = new Object[]{resource};
                }
                wizard.setProcessFilePath(false);
                wizard.setInitSelections(initSelections);
                ArrayList<ViewerFilter> filterList = new ArrayList<ViewerFilter>();
                filterList.add(new CurrentProjecViewerFilter(resource));
                wizard.setViewerFilters(filterList);
                WizardDialog dialog = new WizardDialog(XSLTemplateCreationWizardPage.this.getShell(), (IWizard)wizard);
                if (dialog.open() == 0) {
                    XSLTemplateCreationWizardPage.this.contentFileText.setText(wizard.getFilePath());
                }
            }
        });
        gd = new GridData(768);
        xslInnerContentFileComposite.setLayoutData((Object)gd);
        Label chooseElementLabel = new Label(mainComposite, 0);
        chooseElementLabel.setText(Messages.XSLTemplateCreationWizardPage_Label_Choose_Root);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        chooseElementLabel.setLayoutData((Object)gd);
        this.tableViewer = CheckboxTableViewer.newCheckList((Composite)mainComposite, (int)2048);
        gd = new GridData(1808);
        gd.heightHint = 250;
        gd.horizontalSpan = 2;
        this.tableViewer.getControl().setLayoutData((Object)gd);
        this.tableViewer.setContentProvider((IContentProvider)new XSDListContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new XSDListLabelProvider());
        this.tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (!XSLTemplateCreationWizardPage.this.fireEvent) {
                    return;
                }
                XSLTemplateCreationWizardPage.this.rootElementName = null;
                XSLTemplateCreationWizardPage.this.fireEvent = false;
                XSLTemplateCreationWizardPage.this.tableViewer.setAllChecked(false);
                if (event.getChecked()) {
                    XSLTemplateCreationWizardPage.this.tableViewer.setChecked(event.getElement(), true);
                    XSLTemplateCreationWizardPage.this.rootElementName = ((XSDElementDeclaration)event.getElement()).getAliasName();
                }
                XSLTemplateCreationWizardPage.this.fireEvent = true;
                XSLTemplateCreationWizardPage.this.updatePage();
            }
        });
        this.setControl((Control)mainComposite);
        this.setEnabledToAllControls(false);
    }

    protected void updatePage() {
        String path;
        String error = null;
        int type = this.typeCombo.getSelectionIndex();
        if (type == 1 && ((path = this.externalFileText.getText()) == null || path.length() == 0)) {
            error = Messages.XSLTemplateCreationWizardPage_Error_External_Path_Empty;
        }
        if (type == 2) {
            Object input;
            path = this.contentFileText.getText();
            if (path == null || path.length() == 0) {
                error = Messages.XSLTemplateCreationWizardPage_Error_XSD_XML_Path_Empty;
            }
            if ((input = this.tableViewer.getInput()) != EMPTY_TABLEVIEWER_INPUT && this.tableViewer.getCheckedElements().length == 0) {
                error = Messages.XSLTemplateCreationWizardPage_Error_Root_Element_Empty;
            }
        }
        this.setErrorMessage(error);
        this.setPageComplete(error == null);
    }

    protected void disableExternalFileControls() {
        this.externalFileText.setEnabled(false);
        this.fileBrowseButton.setEnabled(false);
    }

    protected void disableInnerContentControls() {
        this.tableViewer.getTable().setEnabled(false);
        this.contentFileText.setEnabled(false);
        this.fileBrowseButton1.setEnabled(false);
    }

    protected void setEnabledToAllControls(boolean flag) {
        this.tableViewer.getTable().setEnabled(flag);
        this.contentFileText.setEnabled(flag);
        this.fileBrowseButton1.setEnabled(flag);
        this.externalFileText.setEnabled(flag);
        this.fileBrowseButton.setEnabled(flag);
    }
}

