/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.launch;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.jboss.tools.smooks.configuration.ProcessNodeType;
import org.jboss.tools.smooks.launch.serialize.ObjectSerializer;
import org.milyn.Smooks;
import org.milyn.payload.JavaResult;
import org.milyn.payload.StringResult;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmooksLauncher {
    public static final String LOCALIZED_FILE_NAME = "localizedMessage.properties";

    public static void main(String[] args) throws IOException, SAXException {
        Properties localizedMessages = SmooksLauncher.loadLocalizedMessages();
        if (args.length != 4) {
            throw new RuntimeException(localizedMessages.getProperty("SmooksLauncher_Error_Expected_Four_Args"));
        }
        if (args[1].equals("input.java")) {
            System.out.println(localizedMessages.getProperty("SmooksLauncher_Error_Do_Not_Support_Java_Inputs"));
        } else {
            File smooksConfig = new File(args[0]);
            File input = new File(args[2]);
            SmooksLauncher.assertFile(smooksConfig, "Smooks");
            SmooksLauncher.assertFile(input, "Input");
            Smooks smooks = new Smooks(smooksConfig.toURI().getPath());
            try {
                Set<ProcessNodeType> processNodeTypes = SmooksLauncher.fromNodeTypeString(args[3]);
                JavaResult javaResult = new JavaResult();
                boolean nothingDisplayed = true;
                if (processNodeTypes.contains((Object)ProcessNodeType.TEMPLATING)) {
                    StringResult stringResult = new StringResult();
                    smooks.filterSource((Source)new StreamSource(new FileInputStream(input)), new Result[]{stringResult, javaResult});
                    System.out.println("[" + localizedMessages.getProperty("SmooksLauncher_Templating_To_StreamResult") + " ...]");
                    System.out.println("    |--");
                    System.out.println(SmooksLauncher.indent(stringResult.toString()));
                    System.out.println("    |--\n");
                    nothingDisplayed = false;
                } else {
                    smooks.filterSource((Source)new StreamSource(new FileInputStream(input)), new Result[]{javaResult});
                }
                Collection<ObjectSerializer> serializedJavaResults = ObjectSerializer.serialize(javaResult);
                if (!serializedJavaResults.isEmpty()) {
                    System.out.println("[" + localizedMessages.getProperty("SmooksLauncher_Java_Mapping_Results") + "...]");
                    for (ObjectSerializer serializedJavaResult : serializedJavaResults) {
                        System.out.println("    |--");
                        System.out.println(SmooksLauncher.indent(serializedJavaResult.getSerializedForm()));
                        System.out.println("    |--");
                    }
                    nothingDisplayed = false;
                }
                if (nothingDisplayed) {
                    System.out.println(localizedMessages.getProperty("SmooksLauncher_Nothing_To_Display"));
                }
            }
            finally {
                smooks.close();
            }
        }
    }

    private static Properties loadLocalizedMessages() {
        Properties messages = new Properties();
        InputStream messageStream = SmooksLauncher.class.getResourceAsStream(LOCALIZED_FILE_NAME);
        try {
            try {
                messages.load(messageStream);
            }
            catch (IOException e) {
                System.out.println("Unexpected IOException reading classpath resource stream for 'localizedMessage.properties'. " + e.getMessage());
                e.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            try {
                messageStream.close();
            }
            catch (IOException iOException) {
                System.out.println("Unexpected IOException closing classpath resource stream for 'localizedMessage.properties'.");
            }
            throw throwable;
        }
        try {
            messageStream.close();
        }
        catch (IOException iOException) {
            System.out.println("Unexpected IOException closing classpath resource stream for 'localizedMessage.properties'.");
        }
        return messages;
    }

    private static void assertFile(File file, String name) {
        if (!file.exists()) {
            throw new RuntimeException("Specified '" + name + "' File '" + file.getAbsolutePath() + "' not found.");
        }
        if (file.isDirectory()) {
            throw new RuntimeException("Specified '" + name + "' File '" + file.getAbsolutePath() + "' is a Directory.");
        }
    }

    public static Set<ProcessNodeType> fromNodeTypeString(String nodeTypeString) {
        String[] tokens = nodeTypeString.split(",");
        HashSet<ProcessNodeType> nodeTypes = new HashSet<ProcessNodeType>();
        String[] stringArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            nodeTypes.add(ProcessNodeType.valueOf(token));
            ++n2;
        }
        return nodeTypes;
    }

    private static String indent(String in) throws IOException {
        BufferedReader lineReader = new BufferedReader(new StringReader(in));
        StringBuilder indentBuf = new StringBuilder();
        String line = lineReader.readLine();
        while (line != null) {
            indentBuf.append("    |").append(line);
            line = lineReader.readLine();
            if (line == null) continue;
            indentBuf.append('\n');
        }
        return indentBuf.toString();
    }
}

