/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.launch.serialize;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.AbstractXmlWriter;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.tools.smooks.launch.serialize.MarshallingStrategy;
import org.milyn.payload.JavaResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectSerializer
extends AbstractXmlWriter {
    private Object rootObject;
    private String rootBeanId;
    private List<Object> items = new ArrayList<Object>();
    private Set<String> referencedBeans = new LinkedHashSet<String>();
    private Map<String, Object> beanContext;
    private int indent = 0;
    private boolean writeNL = false;
    private String serializedForm;
    private StringWriter writer;

    public ObjectSerializer(Object object, String beanId, Map<String, Object> beanMap) {
        this.assertNotNull(object, "object");
        this.assertNotNull(beanId, "beanId");
        this.assertNotNull(beanMap, "beanMap");
        this.rootObject = object;
        this.rootBeanId = beanId;
        this.beanContext = beanMap;
        this.serializedForm = this.writeObject();
    }

    public static String serialize(Object object, Map<String, Object> beanMap) {
        ObjectSerializer serializer = new ObjectSerializer(object, object.getClass().getSimpleName(), beanMap);
        return serializer.getSerializedForm();
    }

    public static Collection<ObjectSerializer> serialize(JavaResult javaResult) {
        new StringBuilder();
        Map beanMap = javaResult.getResultMap();
        Set beanMapEntries = beanMap.entrySet();
        HashMap<String, ObjectSerializer> serializedObjectMap = new HashMap<String, ObjectSerializer>();
        Set beanNames = beanMap.keySet();
        for (Map.Entry beanMapEntry : beanMapEntries) {
            serializedObjectMap.put((String)beanMapEntry.getKey(), new ObjectSerializer(beanMapEntry.getValue(), (String)beanMapEntry.getKey(), beanMap));
        }
        Set serializedObjectMapEntries = serializedObjectMap.entrySet();
        for (Map.Entry serializedObjectMapEntry : serializedObjectMapEntries) {
            beanNames.removeAll(((ObjectSerializer)((Object)serializedObjectMapEntry.getValue())).getReferencedBeans());
        }
        if (!beanNames.isEmpty()) {
            ArrayList<ObjectSerializer> rootBeans = new ArrayList<ObjectSerializer>();
            for (String beanName : beanNames) {
                rootBeans.add((ObjectSerializer)((Object)serializedObjectMap.get(beanName)));
            }
            return rootBeans;
        }
        return serializedObjectMap.values();
    }

    public Set<String> getReferencedBeans() {
        return this.referencedBeans;
    }

    public String getSerializedForm() {
        return this.serializedForm;
    }

    private synchronized String writeObject() {
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
        MarshallingStrategy marshallingStrategy = new MarshallingStrategy(this);
        this.writer = new StringWriter();
        this.items.clear();
        this.referencedBeans.clear();
        xstream.setMarshallingStrategy((com.thoughtworks.xstream.MarshallingStrategy)marshallingStrategy);
        xstream.marshal(this.rootObject, (HierarchicalStreamWriter)this);
        return this.writer.toString();
    }

    public void startNode(String name, Class clazz) {
        if (this.writeNL) {
            this.writer.write("\n");
        }
        if (this.indent == 0) {
            this.writer.write("> " + this.rootBeanId);
        } else {
            this.writeIndent(this.indent);
            this.writer.write("> " + name);
        }
        this.writeNL = true;
        ++this.indent;
    }

    public void startNode(Object item) {
        this.items.add(item);
        String beanId = this.getBeanId(item, true);
        if (beanId != null) {
            this.writer.write(" (beanId = \"" + beanId + "\")");
            if (!beanId.equals(this.rootBeanId)) {
                this.referencedBeans.add(beanId);
            }
        }
    }

    private String getBeanId(Object item, boolean checkCollections) {
        Set<Map.Entry<String, Object>> beans = this.beanContext.entrySet();
        for (Map.Entry<String, Object> bean : beans) {
            if (bean.getValue() != item) continue;
            return bean.getKey();
        }
        if (checkCollections) {
            for (Map.Entry<String, Object> bean : beans) {
                Collection collectionBean;
                Object beanObj = bean.getValue();
                if (!(beanObj instanceof Collection) || !this.collectionContains(collectionBean = (Collection)beanObj, item)) continue;
                for (Object collectionItem : collectionBean) {
                    String beanId = this.getBeanId(collectionItem, false);
                    if (beanId == null) continue;
                    return beanId;
                }
            }
        }
        return null;
    }

    private boolean collectionContains(Collection collection, Object item) {
        for (Object object : collection) {
            if (object != item) continue;
            return true;
        }
        return false;
    }

    public void setValue(String text) {
        Object currentItem = this.items.get(this.items.size() - 1);
        if ((currentItem instanceof String || this.containsNonNumeric(text)) && !(currentItem instanceof Number)) {
            this.writer.write(" = \"" + text + "\"");
        } else if (currentItem instanceof Number) {
            Class<?> itemClass = currentItem.getClass();
            if (itemClass.getPackage() == Integer.class.getPackage()) {
                this.writer.write(" = " + text + itemClass.getSimpleName().charAt(0));
            } else {
                this.writer.write(" = " + text);
            }
        } else {
            this.writer.write(" = " + text);
        }
        this.writer.write("\n");
        this.writeNL = false;
    }

    public void endNode() {
        --this.indent;
    }

    public void startNode(String name) {
    }

    public void flush() {
        this.writer.flush();
    }

    private void writeIndent(int count) {
        int i = 0;
        while (i < count) {
            this.writer.write("    ");
            ++i;
        }
    }

    public void addAttribute(String name, String value) {
    }

    public void close() {
    }

    private boolean containsNonNumeric(String text) {
        int i = 0;
        while (i < text.length()) {
            if (!Character.isDigit(text.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void assertNotNull(Object object, String name) {
        if (object == null) {
            throw new IllegalArgumentException("ObjectSerializer argument '" + name + "' is null.");
        }
    }
}

