/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.templating.model;

import java.util.HashMap;
import java.util.Map;
import org.jboss.tools.smooks.templating.model.ModelBuilder;
import org.milyn.xml.DomUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ModelNodeResolver {
    private Map<String, Node> modelNodeMap = new HashMap<String, Node>();
    private Map<String, String> prefixMap = new HashMap<String, String>();

    public ModelNodeResolver(Document model) {
        this.buildModelNodeMap(model.getDocumentElement(), "");
    }

    public Node resolveNodeMapping(Node node) {
        return this.modelNodeMap.get(this.buildNodePath(node));
    }

    private Object buildNodePath(Node node) {
        StringBuilder pathBuilder = new StringBuilder();
        while (node != null && node.getNodeType() != 9) {
            if (!ModelBuilder.isInReservedNamespace(node)) {
                String nodeNS;
                if (pathBuilder.length() > 0) {
                    pathBuilder.insert(0, '/');
                }
                if ((nodeNS = node.getNamespaceURI()) != null && nodeNS.length() > 0) {
                    if (node.getNodeType() == 2) {
                        pathBuilder.insert(0, "@" + this.getPrefix(nodeNS) + ":" + ((Attr)node).getName());
                    } else {
                        pathBuilder.insert(0, String.valueOf(this.getPrefix(nodeNS)) + ":" + DomUtils.getName((Element)((Element)node)));
                    }
                } else if (node.getNodeType() == 2) {
                    pathBuilder.insert(0, "@" + ((Attr)node).getName());
                } else {
                    pathBuilder.insert(0, DomUtils.getName((Element)((Element)node)));
                }
            }
            node = ModelBuilder.getParentNode(node);
        }
        return pathBuilder.toString();
    }

    private void buildModelNodeMap(Element element, String parentPath) {
        String elementPath = parentPath;
        if (!ModelBuilder.isInReservedNamespace(element)) {
            String elNS = element.getNamespaceURI();
            if (parentPath.length() > 0) {
                parentPath = String.valueOf(parentPath) + "/";
            }
            if (elNS != null && elNS.length() > 0) {
                elementPath = String.valueOf(parentPath) + this.getPrefix(elNS) + ":" + DomUtils.getName((Element)element);
                this.modelNodeMap.put(elementPath, element);
            } else {
                elementPath = String.valueOf(parentPath) + DomUtils.getName((Element)element);
                this.modelNodeMap.put(elementPath, element);
            }
            NamedNodeMap attributes = element.getAttributes();
            int attrCount = attributes.getLength();
            int i = 0;
            while (i < attrCount) {
                Attr attribute = (Attr)attributes.item(i);
                if (!ModelBuilder.isInReservedNamespace(attribute)) {
                    String attrNS = attribute.getNamespaceURI();
                    if (attrNS != null && attrNS.length() > 0) {
                        this.modelNodeMap.put(String.valueOf(elementPath) + "/@" + this.getPrefix(attrNS) + ":" + attribute.getName(), attribute);
                    } else {
                        this.modelNodeMap.put(String.valueOf(elementPath) + "/@" + attribute.getName(), attribute);
                    }
                }
                ++i;
            }
        }
        NodeList children = element.getChildNodes();
        int childCount = children.getLength();
        int i = 0;
        while (i < childCount) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                this.buildModelNodeMap((Element)child, elementPath);
            }
            ++i;
        }
    }

    private String getPrefix(String nsURI) {
        String prefix = this.prefixMap.get(nsURI);
        if (prefix == null) {
            prefix = "ns" + this.prefixMap.size();
            this.prefixMap.put(nsURI, prefix);
        }
        return prefix;
    }
}

