/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.templating.template.xml;

import freemarker.core.TemplateElement;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import org.jboss.tools.smooks.templating.model.ModelBuilder;
import org.jboss.tools.smooks.templating.model.ModelBuilderException;
import org.jboss.tools.smooks.templating.model.ModelNodeResolver;
import org.jboss.tools.smooks.templating.template.CollectionMapping;
import org.jboss.tools.smooks.templating.template.Mapping;
import org.jboss.tools.smooks.templating.template.TemplateBuilder;
import org.jboss.tools.smooks.templating.template.ValueMapping;
import org.jboss.tools.smooks.templating.template.exception.TemplateBuilderException;
import org.jboss.tools.smooks.templating.template.util.FreeMarkerUtil;
import org.milyn.xml.DomUtils;
import org.milyn.xml.XmlUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLFreeMarkerTemplateBuilder
extends TemplateBuilder {
    private boolean omitXMLDeclaration = false;

    public XMLFreeMarkerTemplateBuilder(ModelBuilder modelBuilder) throws ModelBuilderException {
        super(modelBuilder);
    }

    public XMLFreeMarkerTemplateBuilder(ModelBuilder modelBuilder, String ftlTemplate) throws ModelBuilderException, TemplateBuilderException {
        super(modelBuilder);
        this.addMappings(ftlTemplate);
    }

    public TemplateBuilder setOmitXMLDeclaration(boolean omitXMLDeclaration) {
        this.omitXMLDeclaration = omitXMLDeclaration;
        return this;
    }

    public String buildTemplate() throws TemplateBuilderException {
        StringWriter templateWriter = new StringWriter();
        if (!this.omitXMLDeclaration) {
            try {
                ((Writer)templateWriter).write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            }
            catch (IOException e) {
                throw new IllegalStateException("Unexpected IOException when writing the XML Template.", e);
            }
        }
        this.writeElement(this.getModel().getDocumentElement(), 0, false, templateWriter);
        return ((Object)templateWriter).toString();
    }

    private void writeElement(Element element, int indent, boolean addNewline, Writer templateWriter) {
        try {
            if (ModelBuilder.isInReservedNamespace(element)) {
                this.writeElementChildren(element, indent, templateWriter);
            } else if (this.assertAddNodeToTemplate(element)) {
                if (addNewline) {
                    templateWriter.write(10);
                }
                Mapping mapping = this.getMapping(element);
                CollectionMapping collectionMapping = null;
                if (mapping instanceof CollectionMapping) {
                    collectionMapping = (CollectionMapping)mapping;
                    TemplateBuilder.writeIndent(indent, templateWriter);
                    templateWriter.write("<#list " + collectionMapping.getSrcPath() + " as " + collectionMapping.getCollectionItemName() + ">\n");
                }
                TemplateBuilder.writeIndent(indent, templateWriter);
                this.writeElementStart(element, templateWriter);
                if (this.writeElementChildren(element, indent + 1, templateWriter) > 0) {
                    TemplateBuilder.writeIndent(indent, templateWriter);
                    this.writeElementEnd(element, true, templateWriter);
                } else {
                    this.writeElementEnd(element, false, templateWriter);
                }
                if (collectionMapping != null) {
                    templateWriter.write("\n");
                    TemplateBuilder.writeIndent(indent, templateWriter);
                    templateWriter.write("</#list>");
                }
                TemplateBuilder.writeIndent(indent, templateWriter);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected IOException when writing the XML Template.", e);
        }
    }

    private void writeElementStart(Element element, Writer templateWriter) throws IOException {
        String prefix;
        templateWriter.write("<");
        templateWriter.write(element.getNodeName());
        NamedNodeMap attributes = element.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            Attr attribute = (Attr)attributes.item(i);
            if (!ModelBuilder.isInReservedNamespace(attribute)) {
                Mapping mapping = this.getMapping(attribute);
                if (mapping != null) {
                    this.writeAttribute(attribute.getNodeName(), FreeMarkerUtil.toFreeMarkerVariable((ValueMapping)mapping), templateWriter);
                } else if (ModelBuilder.isRequired(attribute)) {
                    this.writeAttribute(attribute.getNodeName(), attribute.getValue(), templateWriter);
                }
            }
            ++i;
        }
        String nsURI = element.getNamespaceURI();
        if (nsURI != null && !nsURI.equals("") && !this.assertNamespaceDeclOnStack(prefix = element.getPrefix(), nsURI, element)) {
            if (prefix != null) {
                this.writeAttribute("xmlns:" + prefix, nsURI, templateWriter);
            } else {
                this.writeAttribute("xmlns", nsURI, templateWriter);
            }
        }
    }

    private void writeAttribute(String name, String value, Writer templateWriter) throws IOException {
        char quoteChar = value.indexOf(34) != -1 ? (char)'\'' : '\"';
        templateWriter.write(32);
        templateWriter.write(name);
        templateWriter.write("=" + quoteChar);
        templateWriter.write(value);
        templateWriter.write(quoteChar);
    }

    private int writeElementChildren(Element element, int indent, Writer templateWriter) throws IOException {
        NodeList children = element.getChildNodes();
        int numElementsWritten = 0;
        if (children.getLength() == 0) {
            Mapping mapping = this.getMapping(element);
            if (ModelBuilder.getElementType(element) == ModelBuilder.ElementType.simple) {
                templateWriter.write(">");
                if (mapping != null) {
                    templateWriter.write(FreeMarkerUtil.toFreeMarkerVariable((ValueMapping)mapping));
                } else {
                    templateWriter.write("#required");
                }
            }
        } else {
            if (!ModelBuilder.isInReservedNamespace(element)) {
                templateWriter.write(">");
            }
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                if (child.getNodeType() == 1) {
                    this.writeElement((Element)child, indent, true, templateWriter);
                    ++numElementsWritten;
                }
                ++i;
            }
            if (!ModelBuilder.isInReservedNamespace(element)) {
                templateWriter.write(10);
            }
        }
        return numElementsWritten;
    }

    private void writeElementEnd(Element element, boolean hasChildren, Writer templateWriter) throws IOException {
        if (hasChildren || ModelBuilder.getElementType(element) == ModelBuilder.ElementType.simple) {
            templateWriter.write("</");
            templateWriter.write(element.getNodeName());
            templateWriter.write(">");
        } else {
            templateWriter.write(" />");
        }
    }

    private boolean assertNamespaceDeclOnStack(String prefix, String nsURI, Element element) {
        Node parent = element.getParentNode();
        while (parent != null) {
            if (prefix == null ? parent.getPrefix() == null && nsURI.equals(parent.getNamespaceURI()) : prefix.equals(parent.getPrefix()) && nsURI.equals(parent.getNamespaceURI())) {
                return true;
            }
            parent = parent.getParentNode();
        }
        return false;
    }

    private void addMappings(String ftlTemplate) throws TemplateBuilderException {
        Document templateDOM;
        Template template;
        try {
            template = new Template("ftlTemplate", (Reader)new StringReader(ftlTemplate), new Configuration());
        }
        catch (IOException e) {
            throw new TemplateBuilderException("Failed to parse the Supplied FreeMarker template.", e);
        }
        TemplateElement rootElement = template.getRootTreeNode();
        StringWriter templateRewriteBuffer = new StringWriter();
        this.rewriteTemplateElement(rootElement, templateRewriteBuffer);
        try {
            templateDOM = XmlUtil.parseStream((Reader)new StringReader(templateRewriteBuffer.toString()));
        }
        catch (Exception e) {
            throw new TemplateBuilderException("Error parsing rewritten FreeMarker template.", e);
        }
        this.addMappings(templateDOM.getDocumentElement(), new ModelNodeResolver(this.getModel()));
    }

    private void addMappings(Element element, ModelNodeResolver modelNodeResolver) throws TemplateBuilderException {
        if (TemplateBuilder.isListElement(element)) {
            this.addCollectionMapping(element, modelNodeResolver);
        } else if (!ModelBuilder.isInReservedNamespace(element)) {
            String elementText = DomUtils.getAllText((Element)element, (boolean)false);
            if (FreeMarkerUtil.isDollarVariable(elementText)) {
                this.addValueMapping(element, modelNodeResolver, elementText);
            }
            NamedNodeMap attributes = element.getAttributes();
            int attribCount = attributes.getLength();
            int i = 0;
            while (i < attribCount) {
                String attrValue;
                Attr attribute = (Attr)attributes.item(i);
                if (!ModelBuilder.isInReservedNamespace(attribute) && FreeMarkerUtil.isDollarVariable(attrValue = attribute.getValue())) {
                    this.addValueMapping(attribute, modelNodeResolver, attrValue);
                }
                ++i;
            }
        }
        NodeList children = element.getChildNodes();
        int childCount = children.getLength();
        int i = 0;
        while (i < childCount) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                this.addMappings((Element)child, modelNodeResolver);
            }
            ++i;
        }
    }

    private void rewriteTemplateElement(TemplateElement element, StringWriter templateRewriteBuffer) throws TemplateBuilderException {
        if (element.getNodeName().equals("IteratorBlock")) {
            String description = element.getDescription();
            if (!description.startsWith("list")) {
                throw new TemplateBuilderException("Unsupported XML template IteratorBlock type '" + description + "'.  Currently only support 'list' IteratorBlock nodes.");
            }
            String[] tokens = description.split(" +?");
            TemplateBuilder.writeListStart(templateRewriteBuffer, tokens[1], tokens[3]);
            Enumeration children = element.children();
            while (children != null && children.hasMoreElements()) {
                this.rewriteTemplateElement((TemplateElement)children.nextElement(), templateRewriteBuffer);
            }
            TemplateBuilder.writeListEnd(templateRewriteBuffer);
        } else {
            Enumeration children = element.children();
            if (children != null && children.hasMoreElements()) {
                while (children.hasMoreElements()) {
                    this.rewriteTemplateElement((TemplateElement)children.nextElement(), templateRewriteBuffer);
                }
            } else if (element.getClass().getSimpleName().equals("DollarVariable")) {
                templateRewriteBuffer.append(element.toString());
            } else {
                templateRewriteBuffer.append(element.getCanonicalForm());
            }
        }
    }
}

