/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.text.ext.hyperlink;

import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlinkPartitioner;
import org.jboss.tools.common.text.ext.hyperlink.HyperlinkRegion;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkRegion;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ComponentsHyperlinkPartitioner
extends AbstractHyperlinkPartitioner {
    public static final String BPM_DEFINITION_PARTITION = "org.jboss.tools.seam.text.ext.BPM_DEFINITION";
    public static final String DROOLS_RULE_PARTITION = "org.jboss.tools.seam.text.ext.DROOLS_RULE_DEFINITION";
    static final String textNodeName = "#text";
    static final String valueNodeName = "value";
    static final String processDefinitionsNodeName = "bpm:process-definitions";
    static final String pageflowDefinitionsNodeName = "bpm:pageflow-definitions";
    static final String propertyNodeName = "property";
    static final String propertyAttributeName = "name";
    static final String propertyAtt1 = "processDefinitions";
    static final String propertyAtt2 = "pageflowDefinitions";
    static final String droolsRuleFileNodeName = "drools:rule-files";

    public static Node getNode(IDocument document, int superOffset) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            Node node;
            smw.init(document);
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node node2 = node = Utils.findNodeForOffset((Node)xmlDocument, (int)superOffset);
            return node2;
        }
        finally {
            smw.dispose();
        }
    }

    public static String getType(Node node) {
        Node valueNode = node.getParentNode();
        if (valueNode == null) {
            return null;
        }
        Node parentNode = valueNode.getParentNode();
        if (parentNode == null) {
            return null;
        }
        if (node.getNodeName().equalsIgnoreCase(textNodeName) && valueNode.getNodeName().equalsIgnoreCase(valueNodeName)) {
            Node attribute;
            if (parentNode.getNodeName().equalsIgnoreCase(processDefinitionsNodeName) || parentNode.getNodeName().equalsIgnoreCase(pageflowDefinitionsNodeName)) {
                return BPM_DEFINITION_PARTITION;
            }
            if (parentNode.getNodeName().equalsIgnoreCase(droolsRuleFileNodeName)) {
                return DROOLS_RULE_PARTITION;
            }
            if (parentNode.getNodeName().equalsIgnoreCase(propertyNodeName) && (attribute = parentNode.getAttributes().getNamedItem(propertyAttributeName)) != null && (attribute.getNodeValue().equalsIgnoreCase(propertyAtt1) || attribute.getNodeValue().equalsIgnoreCase(propertyAtt2))) {
                return BPM_DEFINITION_PARTITION;
            }
        }
        return null;
    }

    protected IHyperlinkRegion parse(IDocument document, IHyperlinkRegion superRegion) {
        Node node = ComponentsHyperlinkPartitioner.getNode(document, superRegion.getOffset());
        String type = ComponentsHyperlinkPartitioner.getType(node);
        if (type == null) {
            return null;
        }
        IndexedRegion text = (IndexedRegion)node;
        int length = text.getLength();
        int offset = text.getStartOffset();
        String contentType = superRegion.getContentType();
        String axis = this.getAxis(document, superRegion);
        HyperlinkRegion hyperRegion = new HyperlinkRegion(offset, length, axis, contentType, type);
        return hyperRegion;
    }
}

