/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.text.ext.hyperlink;

import java.text.MessageFormat;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.jboss.tools.seam.core.IBijectedAttribute;
import org.jboss.tools.seam.core.IOpenableElement;
import org.jboss.tools.seam.core.IRole;
import org.jboss.tools.seam.core.ISeamComponent;
import org.jboss.tools.seam.core.ISeamComponentDeclaration;
import org.jboss.tools.seam.core.ISeamJavaComponentDeclaration;
import org.jboss.tools.seam.text.ext.SeamExtMessages;
import org.jboss.tools.seam.text.ext.SeamExtPlugin;

public class SeamComponentHyperlink
implements IHyperlink {
    private IRegion fRegion;
    private String fResourceName;
    private IJavaElement fElement;
    private IOpenableElement fOpenable;
    private String fLabel;
    private String fName;

    SeamComponentHyperlink(IRegion region, String resourceName, IJavaElement element, String name) {
        Assert.isNotNull((Object)region);
        Assert.isNotNull((Object)element);
        Assert.isNotNull((Object)name);
        this.fRegion = region;
        this.fResourceName = resourceName;
        this.fElement = element;
        this.fOpenable = null;
        this.fLabel = SeamExtMessages.SeamFactory;
        this.fName = name;
    }

    SeamComponentHyperlink(IRegion region, String resourceName, ISeamComponent element, String name) {
        Assert.isNotNull((Object)region);
        Assert.isNotNull((Object)element);
        Assert.isNotNull((Object)name);
        this.fRegion = region;
        this.fResourceName = resourceName;
        this.fElement = null;
        this.fLabel = SeamExtMessages.SeamComponent;
        this.fName = name;
        this.fOpenable = null;
        ISeamJavaComponentDeclaration javaDeclaration = element.getJavaDeclaration();
        if (javaDeclaration != null && javaDeclaration instanceof IOpenableElement) {
            this.fOpenable = (IOpenableElement)javaDeclaration;
        } else {
            Set declarations = element.getAllDeclarations();
            for (ISeamComponentDeclaration componentDeclaration : declarations) {
                if (!(componentDeclaration instanceof IOpenableElement)) continue;
                this.fOpenable = (IOpenableElement)componentDeclaration;
                break;
            }
        }
    }

    SeamComponentHyperlink(IRegion region, String resourceName, IBijectedAttribute element, String name) {
        Assert.isNotNull((Object)region);
        Assert.isNotNull((Object)element);
        Assert.isNotNull((Object)name);
        this.fRegion = region;
        this.fResourceName = resourceName;
        this.fElement = element.getSourceMember();
        this.fLabel = SeamExtMessages.SeamBijected;
        this.fName = name;
        this.fOpenable = null;
    }

    SeamComponentHyperlink(IRegion region, String resourceName, IRole element, String name) {
        Assert.isNotNull((Object)region);
        Assert.isNotNull((Object)element);
        Assert.isTrue((boolean)(element instanceof IOpenableElement));
        Assert.isNotNull((Object)name);
        this.fRegion = region;
        this.fResourceName = resourceName;
        this.fElement = null;
        this.fOpenable = (IOpenableElement)element;
        this.fLabel = SeamExtMessages.SeamRole;
        this.fName = name;
    }

    public IRegion getHyperlinkRegion() {
        return this.fRegion;
    }

    public void open() {
        if (this.fOpenable != null) {
            this.fOpenable.open();
            return;
        }
        if (this.fElement != null) {
            try {
                IEditorPart part = null;
                part = JavaUI.openInEditor((IJavaElement)this.fElement);
                if (part != null) {
                    JavaUI.revealInEditor((IEditorPart)part, (IJavaElement)this.fElement);
                }
            }
            catch (PartInitException e) {
                SeamExtPlugin.getPluginLog().logError((Throwable)e);
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    public String getTypeLabel() {
        return null;
    }

    public String getHyperlinkText() {
        String formattedIn = "";
        if (this.fResourceName != null && this.fResourceName.trim().length() > 0) {
            formattedIn = MessageFormat.format(SeamExtMessages.InResource, this.fResourceName);
        }
        return MessageFormat.format(SeamExtMessages.OpenSeamDeclarationAs, this.fName, this.fLabel, formattedIn);
    }
}

