/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.jboss.tools.seam.ui.SeamGuiPlugin;
import org.jboss.tools.seam.ui.SeamUIMessages;

public class SeamUiImages {
    private static SeamUiImages INSTANCE;
    public static final Image SCOPE_IMAGE;
    public static final Image PROJECT_IMAGE;
    public static final Image COMPONENT_IMAGE;
    public static final Image ROLE_IMAGE;
    public static final Image JAVA_IMAGE;
    public static final Image JAVA_BINARY_IMAGE;
    public static final Image PACKAGE_IMAGE;
    public static final Image FACTORY_IMAGE;
    public static String SEAM_CREATE_PROJECT_ACTION;
    private URL baseUrl;
    private SeamUiImages parentRegistry;

    static {
        try {
            INSTANCE = new SeamUiImages(new URL(SeamGuiPlugin.getDefault().getBundle().getEntry("/"), "icons/"));
        }
        catch (MalformedURLException e) {
            SeamGuiPlugin.getPluginLog().logError((Throwable)e);
        }
        SCOPE_IMAGE = SeamUiImages.getImage("view/scope.gif");
        PROJECT_IMAGE = SeamUiImages.getImage("view/seam_project.gif");
        COMPONENT_IMAGE = SeamUiImages.getImage("view/component.gif");
        ROLE_IMAGE = SeamUiImages.getImage("view/role.gif");
        JAVA_IMAGE = SeamUiImages.getImage("view/java.gif");
        JAVA_BINARY_IMAGE = SeamUiImages.getImage("view/java_binary.gif");
        PACKAGE_IMAGE = SeamUiImages.getImage("view/package.gif");
        FACTORY_IMAGE = SeamUiImages.getImage("view/factory.gif");
        SEAM_CREATE_PROJECT_ACTION = "view/seam_project_new.gif";
    }

    public static Image getImage(String key) {
        return INSTANCE.createImageDescriptor(key).createImage();
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        return INSTANCE.createImageDescriptor(key);
    }

    public static void setImageDescriptors(IAction action, String iconName) {
        action.setImageDescriptor(INSTANCE.createImageDescriptor(iconName));
    }

    public static SeamUiImages getInstance() {
        return INSTANCE;
    }

    protected SeamUiImages(URL registryUrl, SeamUiImages parent) {
        if (registryUrl == null) {
            throw new IllegalArgumentException(SeamUIMessages.SEAM_UI_IMAGESBASE_URL_FOR_IMAGE_REGISTRY_CANNOT_BE_NULL);
        }
        this.baseUrl = registryUrl;
        this.parentRegistry = parent;
    }

    protected SeamUiImages(URL url) {
        this(url, null);
    }

    public Image getImageByFileName(String key) {
        return this.createImageDescriptor(key).createImage();
    }

    public ImageDescriptor createImageDescriptor(String key) {
        try {
            return ImageDescriptor.createFromURL((URL)this.makeIconFileURL(key));
        }
        catch (MalformedURLException malformedURLException) {
            if (this.parentRegistry == null) {
                return ImageDescriptor.getMissingImageDescriptor();
            }
            return this.parentRegistry.createImageDescriptor(key);
        }
    }

    private URL makeIconFileURL(String name) throws MalformedURLException {
        if (name == null) {
            throw new MalformedURLException(SeamUIMessages.SEAM_UI_IMAGESIMAGE_NAME_CANNOT_BE_NULL);
        }
        return new URL(this.baseUrl, name);
    }
}

