/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.internal.project.facet;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;
import org.eclipse.wst.common.frameworks.internal.operations.ProjectCreationDataModelProviderNew;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.common.project.facet.ui.AbstractFacetWizardPage;
import org.eclipse.wst.common.project.facet.ui.IFacetWizardPage;
import org.eclipse.wst.common.project.facet.ui.ModifyFacetedProjectWizard;
import org.eclipse.wst.web.ui.internal.wizards.NewProjectDataModelFacetWizard;
import org.hibernate.eclipse.console.utils.DriverClassHelpers;
import org.jboss.tools.common.ui.IValidator;
import org.jboss.tools.common.ui.widget.editor.CompositeEditor;
import org.jboss.tools.common.ui.widget.editor.IFieldEditor;
import org.jboss.tools.common.ui.widget.editor.IFieldEditorFactory;
import org.jboss.tools.common.ui.widget.editor.ITaggedFieldEditor;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.core.SeamUtil;
import org.jboss.tools.seam.core.project.facet.SeamProjectPreferences;
import org.jboss.tools.seam.core.project.facet.SeamRuntime;
import org.jboss.tools.seam.core.project.facet.SeamRuntimeManager;
import org.jboss.tools.seam.core.project.facet.SeamVersion;
import org.jboss.tools.seam.internal.core.project.facet.SeamFacetInstallDataModelProvider;
import org.jboss.tools.seam.ui.SeamUIMessages;
import org.jboss.tools.seam.ui.internal.project.facet.DataModelSynchronizer;
import org.jboss.tools.seam.ui.internal.project.facet.DataModelValidatorDelegate;
import org.jboss.tools.seam.ui.internal.project.facet.SeamValidatorFactory;
import org.jboss.tools.seam.ui.wizard.SeamFormWizard;
import org.jboss.tools.seam.ui.wizard.SeamProjectWizard;
import org.jboss.tools.seam.ui.wizard.SeamWizardFactory;
import org.jboss.tools.seam.ui.wizard.SeamWizardUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeamInstallWizardPage
extends AbstractFacetWizardPage
implements IFacetWizardPage,
IDataModelListener {
    public static final String PAGE_DESCRIPTION = SeamUIMessages.SEAM_INSTALL_WIZARD_PAGE_CONFIGURE_SEAM_FACET_SETTINGS;
    private static final DriverClassHelpers HIBERNATE_HELPER = new DriverClassHelpers();
    private IDataModel model = null;
    private DataModelValidatorDelegate validatorDelegate;
    private IFieldEditor jBossSeamHomeEditor;
    private IFieldEditor jBossAsDeployAsEditor = IFieldEditorFactory.INSTANCE.createRadioEditor("seam.project.deployment.type", SeamUIMessages.SEAM_INSTALL_WIZARD_PAGE_DEPLOY_AS, Arrays.asList("war".toUpperCase(), "ear".toUpperCase()), Arrays.asList("war", "ear"), this.getDeployAsDefaultValue());
    private IFieldEditor connProfileSelEditor;
    private IFieldEditor jBossHibernateDbTypeEditor;
    private IFieldEditor dbSchemaName;
    private IFieldEditor dbCatalogName;
    private IFieldEditor dbTablesExists;
    private IFieldEditor recreateTablesOnDeploy;
    private IFieldEditor sessionBeanPkgNameditor = IFieldEditorFactory.INSTANCE.createTextEditor("action.package", SeamUIMessages.SEAM_INSTALL_WIZARD_PAGE_SESSION_BEAN_PACKAGE_NAME, "");
    private IFieldEditor entityBeanPkgNameditor = IFieldEditorFactory.INSTANCE.createTextEditor("model.package", SeamUIMessages.SEAM_INSTALL_WIZARD_PAGE_ENTITY_BEAN_PACKAGE_NAME, "com.mydomain.projectname.entity");
    private IFieldEditor createTestProjectCheckboxeditor = IFieldEditorFactory.INSTANCE.createCheckboxEditor("seam.test.project.creating", SeamUIMessages.SEAM_INSTALL_WIZARD_PAGE_CREATE_TEST_PROJECT, true);
    private IFieldEditor testsPkgNameditor = IFieldEditorFactory.INSTANCE.createTextEditor("test.package", SeamUIMessages.SEAM_INSTALL_WIZARD_PAGE_TEST_PACKAGE_NAME, "com.mydomain.projectname.test");
    private Group databaseGroup;
    private DataModelSynchronizer sync;
    private String jpaConnectioProfile;
    private boolean needToShowConnectionProfile = true;

    public SeamInstallWizardPage() {
        super(SeamUIMessages.SEAM_INSTALL_WIZARD_PAGE_SEAM_FACET);
        this.setTitle(SeamUIMessages.SEAM_INSTALL_WIZARD_PAGE_SEAM_FACET);
        this.setImageDescriptor(ImageDescriptor.createFromFile(SeamFormWizard.class, (String)"SeamWebProjectWizBan.png"));
        this.setDescription(PAGE_DESCRIPTION);
    }

    private String getDefaultDbType() {
        return SeamProjectPreferences.getStringPreference((String)"org.jboss.tools.seam.core.hibernate.default.db.type");
    }

    private Object getDeployAsDefaultValue() {
        String result = SeamProjectPreferences.getStringPreference((String)"org.jboss.tools.seam.core.project.default.deployment.type");
        if (!this.isNewProjectWizard()) {
            IFacetedProject facetedProject;
            ISelection sel = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
            IProject project = SeamWizardUtils.getInitialProject(sel);
            if (project == null) {
                SeamCorePlugin.getPluginLog().logError("Can't get project name to initialize SeamInstallWizardPage for ModifyFacetedProjectWizard");
                return result;
            }
            try {
                facetedProject = ProjectFacetsManager.create((IProject)project);
                if (facetedProject == null) {
                    SeamCorePlugin.getPluginLog().logError("Can't get faceted project to initialize SeamInstallWizardPage for ModifyFacetedProjectWizard");
                    return result;
                }
            }
            catch (CoreException e) {
                SeamCorePlugin.getPluginLog().logError((Throwable)e);
                return result;
            }
            IProjectFacetVersion webVersion = facetedProject.getProjectFacetVersion(IJ2EEFacetConstants.DYNAMIC_WEB_FACET);
            if (webVersion != null) {
                return "war";
            }
            return "ear";
        }
        return result;
    }

    private Object getConnectionProfileDefaultValue() {
        String defaultDs = SeamProjectPreferences.getStringPreference((String)"org.jboss.tools.seam.core.project.facet.default.conn.profile");
        return SeamInstallWizardPage.getConnectionProfileNameList().contains(defaultDs) ? defaultDs : "";
    }

    private static List<String> getConnectionProfileNameList() {
        IConnectionProfile[] profiles = ProfileManager.getInstance().getProfilesByCategory("org.eclipse.datatools.connectivity.db.category");
        ArrayList<String> names = new ArrayList<String>();
        IConnectionProfile[] iConnectionProfileArray = profiles;
        int n = profiles.length;
        int n2 = 0;
        while (n2 < n) {
            IConnectionProfile connectionProfile = iConnectionProfileArray[n2];
            names.add(connectionProfile.getName());
            ++n2;
        }
        return names;
    }

    public void setWizard(IWizard newWizard) {
        super.setWizard(newWizard);
    }

    public void setConfig(Object config) {
        this.model = (IDataModel)config;
        this.model.setProperty("hibernate.dialect", (Object)HIBERNATE_HELPER.getDialectClass(this.getDefaultDbType()));
    }

    public IDataModel getConfig() {
        return this.model;
    }

    public void transferStateToConfig() {
        String seamRuntimeName = this.jBossSeamHomeEditor.getValueAsString();
        SeamRuntime seamRuntime = SeamRuntimeManager.getInstance().findRuntimeByName(seamRuntimeName);
        if (seamRuntime != null) {
            SeamRuntimeManager.getInstance().setDefaultRuntime(seamRuntime);
        }
        if (this.connProfileSelEditor != null) {
            SeamCorePlugin.getDefault().getPluginPreferences().setValue("org.jboss.tools.seam.core.project.facet.default.conn.profile", this.connProfileSelEditor.getValueAsString());
        } else {
            SeamCorePlugin.getDefault().getPluginPreferences().setValue("org.jboss.tools.seam.core.project.facet.default.conn.profile", this.getJpaConnectionProfile());
            this.model.setStringProperty("seam.project.connection.profile", this.getJpaConnectionProfile());
        }
        if (this.jBossHibernateDbTypeEditor != null) {
            SeamCorePlugin.getDefault().getPluginPreferences().setValue("org.jboss.tools.seam.core.hibernate.default.db.type", this.jBossHibernateDbTypeEditor.getValueAsString());
        }
        SeamCorePlugin.getDefault().getPluginPreferences().setValue("org.jboss.tools.seam.core.project.default.deployment.type", this.jBossAsDeployAsEditor.getValueAsString());
    }

    private IProjectFacetVersion getJpaFacetVersion() {
        IFacetedProjectWorkingCopy facetedProject = ((ModifyFacetedProjectWizard)this.getWizard()).getFacetedProjectWorkingCopy();
        return facetedProject.getProjectFacetVersion(ProjectFacetsManager.getProjectFacet((String)"jpt.jpa"));
    }

    public void setJpaConnectionProfile(String jpaConnectioProfile) {
        this.jpaConnectioProfile = jpaConnectioProfile;
    }

    private String getJpaConnectionProfile() {
        if (this.jpaConnectioProfile != null) {
            return this.jpaConnectioProfile;
        }
        IProjectFacetVersion jpaVersion = this.getJpaFacetVersion();
        if (jpaVersion == null) {
            throw new NullPointerException("Jpa facet version is null");
        }
        try {
            Object config = this.context.getConfig(jpaVersion, IFacetedProject.Action.Type.INSTALL, this.context.getProjectName());
            if (config instanceof IDataModel) {
                return ((IDataModel)config).getStringProperty("JpaFacetDataModelProperties.CONNECTION");
            }
        }
        catch (CoreException e) {
            SeamCorePlugin.getPluginLog().logError((Throwable)e);
        }
        return null;
    }

    protected void registerEditor(IFieldEditor editor, Composite parent, int columns) {
        this.sync.register(editor);
        editor.doFillIntoGrid((Object)parent);
    }

    public List<String> getRuntimeNames(String version) {
        SeamRuntime[] rts = SeamRuntimeManager.getInstance().getRuntimes(SeamVersion.parseFromString((String)version));
        ArrayList<String> result = new ArrayList<String>();
        SeamRuntime[] seamRuntimeArray = rts;
        int n = rts.length;
        int n2 = 0;
        while (n2 < n) {
            SeamRuntime seamRuntime = seamRuntimeArray[n2];
            result.add(seamRuntime.getName());
            ++n2;
        }
        return result;
    }

    public void createControl(Composite parent) {
        this.sync = new DataModelSynchronizer(this.model);
        this.jBossSeamHomeEditor = SeamWizardFactory.createSeamRuntimeSelectionFieldEditor(new SeamVersion[0], SeamFacetInstallDataModelProvider.getSeamRuntimeDefaultValue((IDataModel)this.model), new NewSeamRuntimeAction());
        this.initializeDialogUnits((Control)parent);
        Composite root = new Composite(parent, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = false;
        GridLayout gridLayout = new GridLayout(1, false);
        root.setLayout((Layout)gridLayout);
        Group generalGroup = new Group(root, 0);
        generalGroup.setLayoutData((Object)gd);
        generalGroup.setText(SeamUIMessages.SEAM_INSTALL_WIZARD_PAGE_GENERAL);
        gridLayout = new GridLayout(3, false);
        generalGroup.setLayout((Layout)gridLayout);
        this.registerEditor(this.jBossSeamHomeEditor, (Composite)generalGroup, 3);
        this.registerEditor(this.jBossAsDeployAsEditor, (Composite)generalGroup, 3);
        gd = new GridData();
        gd.horizontalSpan = 1;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = false;
        this.databaseGroup = new Group(root, 0);
        this.databaseGroup.setLayoutData((Object)gd);
        this.databaseGroup.setText(SeamUIMessages.SEAM_INSTALL_WIZARD_PAGE_DATABASE);
        gridLayout = new GridLayout(4, false);
        this.databaseGroup.setLayout((Layout)gridLayout);
        this.jBossHibernateDbTypeEditor = IFieldEditorFactory.INSTANCE.createComboEditor("database.type", SeamUIMessages.SEAM_INSTALL_WIZARD_PAGE_DATABASE_TYPE, Arrays.asList(HIBERNATE_HELPER.getDialectNames()), (Object)this.getDefaultDbType(), false);
        this.registerEditor(this.jBossHibernateDbTypeEditor, (Composite)this.databaseGroup, 4);
        this.createDatabaseGoupControl();
        Group generationGroup = new Group(root, 0);
        gd = new GridData();
        gd.horizontalSpan = 1;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = false;
        generationGroup.setLayoutData((Object)gd);
        generationGroup.setText(SeamUIMessages.SEAM_INSTALL_WIZARD_PAGE_CODE_GENERATION);
        gridLayout = new GridLayout(3, false);
        generationGroup.setLayout((Layout)gridLayout);
        this.registerEditor(this.sessionBeanPkgNameditor, (Composite)generationGroup, 3);
        this.registerEditor(this.entityBeanPkgNameditor, (Composite)generationGroup, 3);
        this.registerEditor(this.createTestProjectCheckboxeditor, (Composite)generationGroup, 3);
        this.createTestProjectCheckboxeditor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent arg0) {
                Boolean value = (Boolean)SeamInstallWizardPage.this.createTestProjectCheckboxeditor.getValue();
                SeamInstallWizardPage.this.testsPkgNameditor.setEnabled(value.booleanValue());
            }
        });
        this.createTestProjectCheckboxeditor.setEnabled(this.isNewProjectWizard());
        this.registerEditor(this.testsPkgNameditor, (Composite)generationGroup, 3);
        this.setControl((Control)root);
        if (this.validatorDelegate == null) {
            this.validatorDelegate = new DataModelValidatorDelegate(this.model, (WizardPage)this);
            this.validatorDelegate.addValidatorForProperty(this.jBossSeamHomeEditor.getName(), SeamValidatorFactory.SEAM_RUNTIME_NAME_VALIDATOR);
            this.validatorDelegate.addValidatorForProperty(this.connProfileSelEditor.getName(), SeamValidatorFactory.CONNECTION_PROFILE_VALIDATOR);
            this.validatorDelegate.addValidatorForProperty(this.testsPkgNameditor.getName(), new PackageNameValidator(this.testsPkgNameditor.getName(), "tests"));
            this.validatorDelegate.addValidatorForProperty(this.entityBeanPkgNameditor.getName(), new PackageNameValidator(this.entityBeanPkgNameditor.getName(), "entity beans"));
            this.validatorDelegate.addValidatorForProperty(this.sessionBeanPkgNameditor.getName(), new PackageNameValidator(this.sessionBeanPkgNameditor.getName(), "session beans"));
            if (this.isNewProjectWizard()) {
                this.validatorDelegate.addValidatorForProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", new ProjectNamesDuplicationValidator("IFacetDataModelProperties.FACET_PROJECT_NAME"));
            }
            this.validatorDelegate.addValidatorForProperty("seam.project.deployment.type", this.getDeploymentTypeValidator(this.getWizard()));
        }
        Dialog.applyDialogFont((Control)parent);
        this.initDefaultWizardProperties();
        Object parentDm = this.model.getProperty("FacetInstallDataModelProvider.MASTER_PROJECT_DM");
        if (parentDm != null) {
            ((IDataModel)parentDm).addListener((IDataModelListener)this);
        }
    }

    public void createDatabaseGoupControl() {
        this.disposeControls(this.connProfileSelEditor);
        this.disposeControls(this.dbSchemaName);
        this.disposeControls(this.dbCatalogName);
        this.disposeControls(this.dbTablesExists);
        this.disposeControls(this.recreateTablesOnDeploy);
        if (!this.needToShowConnectionProfile) {
            this.connProfileSelEditor = null;
            this.dbSchemaName = null;
            this.dbCatalogName = null;
        } else {
            this.connProfileSelEditor = SeamWizardFactory.createConnectionProfileSelectionFieldEditor(this.getConnectionProfileDefaultValue(), new IValidator(){

                public Map<String, IStatus> validate(Object value, Object context) {
                    SeamInstallWizardPage.this.validate();
                    return SeamValidatorFactory.NO_ERRORS;
                }
            });
            this.dbSchemaName = IFieldEditorFactory.INSTANCE.createTextEditor("hibernate.default_schema", SeamUIMessages.SEAM_INSTALL_WIZARD_PAGE_DATABASE_SCHEMA_NAME, "");
            this.dbCatalogName = IFieldEditorFactory.INSTANCE.createTextEditor("hibernate.default_catalog", SeamUIMessages.SEAM_INSTALL_WIZARD_PAGE_DATABASE_CATALOG_NAME, "");
            this.jBossHibernateDbTypeEditor.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    SeamInstallWizardPage.this.model.setProperty("hibernate.dialect", (Object)HIBERNATE_HELPER.getDialectClass(evt.getNewValue().toString()));
                }
            });
            this.registerEditor(this.connProfileSelEditor, (Composite)this.databaseGroup, 4);
            this.registerEditor(this.dbSchemaName, (Composite)this.databaseGroup, 4);
            this.registerEditor(this.dbCatalogName, (Composite)this.databaseGroup, 4);
        }
        this.dbTablesExists = IFieldEditorFactory.INSTANCE.createCheckboxEditor("database.exists", SeamUIMessages.SEAM_INSTALL_WIZARD_PAGE_DB_TABLES_ALREADY_EXISTS, false);
        this.recreateTablesOnDeploy = IFieldEditorFactory.INSTANCE.createCheckboxEditor("database.drop", SeamUIMessages.SEAM_INSTALL_WIZARD_PAGE_RECREATE_DATABASE_TABLES_AND_DATA_ON_DEPLOY, false);
        this.registerEditor(this.dbTablesExists, (Composite)this.databaseGroup, 4);
        this.registerEditor(this.recreateTablesOnDeploy, (Composite)this.databaseGroup, 4);
        this.databaseGroup.getParent().layout(true);
    }

    private void disposeControls(IFieldEditor editor) {
        if (editor != null) {
            Object[] controls = editor.getEditorControls();
            int i = 0;
            while (i < controls.length) {
                Control control = (Control)controls[i];
                if (!control.isDisposed()) {
                    control.dispose();
                }
                ++i;
            }
            editor.dispose();
        }
    }

    private boolean isNewSeamProjectWizard() {
        return this.getWizard() == null || this.getWizard() instanceof SeamProjectWizard;
    }

    private boolean isNewProjectWizard() {
        return this.getWizard() == null || this.getWizard() instanceof NewProjectDataModelFacetWizard;
    }

    public void propertyChanged(DataModelEvent event) {
        if (event.getPropertyName().equals("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER")) {
            this.model.setStringProperty("seam.project.web.root.folder", event.getProperty().toString());
        } else if (event.getPropertyName().equals("IFacetDataModelProperties.FACET_PROJECT_NAME")) {
            String p = event.getProperty().toString();
            this.model.setStringProperty("project.name", p);
            this.model.setStringProperty("action.package", this.getSessionPkgName(p));
            this.model.setStringProperty("model.package", this.getEntityPkgName(p));
            this.model.setProperty("seam.test.project.creating", this.createTestProjectCheckboxeditor.getValue());
            this.model.setStringProperty("test.package", this.getTestPkgName(p));
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            boolean jpaFacetAdded;
            this.setCodeGenerationProperties();
            this.setDefaultSeamRuntime();
            boolean bl = jpaFacetAdded = this.getJpaFacetVersion() != null;
            if (jpaFacetAdded == this.needToShowConnectionProfile) {
                this.needToShowConnectionProfile = !jpaFacetAdded;
                this.createDatabaseGoupControl();
            }
            if (!this.needToShowConnectionProfile) {
                this.model.setStringProperty("seam.project.connection.profile", this.getJpaConnectionProfile());
            }
            this.validate();
        }
        super.setVisible(visible);
    }

    private void initDefaultWizardProperties() {
        this.setCodeGenerationProperties();
        this.setDefaultSeamRuntime();
        this.validate();
    }

    private void setCodeGenerationProperties() {
        String p = (String)this.model.getProperty("project.name");
        this.sessionBeanPkgNameditor.setValue((Object)this.getSessionPkgName(p));
        this.entityBeanPkgNameditor.setValue((Object)this.getEntityPkgName(p));
        this.testsPkgNameditor.setValue((Object)this.getTestPkgName(p));
    }

    private String getSessionPkgName(String projectName) {
        return "org.domain." + SeamUtil.getSeamPackageName((String)projectName) + ".session";
    }

    private String getEntityPkgName(String projectName) {
        return "org.domain." + SeamUtil.getSeamPackageName((String)projectName) + ".entity";
    }

    private String getTestPkgName(String projectName) {
        return "org.domain." + SeamUtil.getSeamPackageName((String)projectName) + ".test";
    }

    private void setDefaultSeamRuntime() {
        ITaggedFieldEditor runtimesField = (ITaggedFieldEditor)((CompositeEditor)this.jBossSeamHomeEditor).getEditors().get(1);
        Object oldValue = runtimesField.getValue();
        Object newValue = "";
        List<String> runtimes = this.getRuntimeNames(this.model.getProperty("IFacetDataModelProperties.FACET_VERSION_STR").toString());
        if (oldValue == null || !runtimes.contains(oldValue)) {
            String defaultRnt = SeamFacetInstallDataModelProvider.getSeamRuntimeDefaultValue((IDataModel)this.model);
            if (defaultRnt != null && runtimes.contains(defaultRnt)) {
                newValue = defaultRnt;
            } else if (!runtimes.isEmpty()) {
                newValue = runtimes.get(0);
            }
        } else {
            newValue = oldValue;
        }
        runtimesField.setValue(newValue);
        runtimesField.setTags(runtimes.toArray(new String[0]));
    }

    private void validate() {
        final IStatus message = this.validatorDelegate.getFirstValidationError();
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                if (message == null) {
                    SeamInstallWizardPage.this.setMessage(null);
                    SeamInstallWizardPage.this.setErrorMessage(null);
                    SeamInstallWizardPage.this.setPageComplete(true);
                    return;
                }
                if (message.getSeverity() == 4) {
                    SeamInstallWizardPage.this.setErrorMessage(message.getMessage());
                    SeamInstallWizardPage.this.setPageComplete(false);
                    return;
                }
                SeamInstallWizardPage.this.setErrorMessage(null);
                SeamInstallWizardPage.this.setMessage(message.getMessage(), 2);
                SeamInstallWizardPage.this.setPageComplete(true);
            }
        });
    }

    IValidator getDeploymentTypeValidator(IWizard wizard) {
        if (wizard instanceof NewProjectDataModelFacetWizard) {
            return new DeploymentTypeValidator("seam.project.deployment.type", ((NewProjectDataModelFacetWizard)wizard).getDataModel());
        }
        return new IValidator(){

            public Map<String, IStatus> validate(Object value, Object context) {
                return SeamValidatorFactory.NO_ERRORS;
            }
        };
    }

    public void finishPressed() {
        this.model.removeListener((IDataModelListener)this.validatorDelegate);
    }

    public String getSessionBeanPkgName() {
        return (String)this.sessionBeanPkgNameditor.getValue();
    }

    public String getEntityBeanPkgName() {
        return (String)this.entityBeanPkgNameditor.getValue();
    }

    public String getTestsPkgName() {
        return (String)this.testsPkgNameditor.getValue();
    }

    private Map<String, IStatus> doPackStatus(IStatus status, String propertyName, String message) {
        return SeamValidatorFactory.createErrormessage((String)propertyName, (IStatus)new Status(status.getSeverity(), "org.jboss.tools.seam.core", message));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DeploymentTypeValidator
    implements IValidator {
        String propertyName;
        IDataModel model;
        static final IProjectFacet EJB_FACET = ProjectFacetsManager.getProjectFacet((String)"jst.ejb");
        static final IProjectFacetVersion EJB_30 = EJB_FACET.getVersion("3.0");
        static final IProjectFacet EAR_FACET = ProjectFacetsManager.getProjectFacet((String)"jst.ear");
        static final IProjectFacetVersion EAR_50 = EAR_FACET.getVersion("5.0");

        public DeploymentTypeValidator(String propertyName, IDataModel model) {
            this.propertyName = propertyName;
            this.model = model;
        }

        public Map<String, IStatus> validate(Object value, Object context) {
            IRuntime rt;
            Object runtimeName;
            String deploymentType = value.toString();
            if (!("war".equals(deploymentType) || (runtimeName = this.model.getProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME")) == null || (rt = RuntimeManager.getRuntime((String)runtimeName.toString())).supports(EJB_30) && rt.supports(EAR_50))) {
                return SeamValidatorFactory.createErrormessage((String)this.propertyName, (IStatus)new Status(4, "org.jboss.tools.seam.core", NLS.bind((String)SeamUIMessages.SEAM_INSTALL_WIZARD_PAGE_CANNOT_USE_SELECTED_DEPLOYMENT6, (Object[])new String[]{deploymentType.toUpperCase(), runtimeName.toString()})));
            }
            return SeamValidatorFactory.NO_ERRORS;
        }
    }

    private class NewSeamRuntimeAction
    extends SeamWizardFactory.NewSeamRuntimeAction {
        private NewSeamRuntimeAction() {
        }

        protected IFieldEditor getRuntimeSelectionEditor() {
            return SeamInstallWizardPage.this.jBossSeamHomeEditor;
        }

        protected SeamVersion[] getSeamVersions() {
            String seamVersion = SeamInstallWizardPage.this.model.getProperty("IFacetDataModelProperties.FACET_VERSION_STR").toString();
            return new SeamVersion[]{SeamVersion.parseFromString((String)seamVersion)};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PackageNameValidator
    implements IValidator {
        String fieldName;
        String targetName;

        public PackageNameValidator(String fieldName, String targetName) {
            this.fieldName = fieldName;
            this.targetName = targetName;
        }

        public Map<String, IStatus> validate(Object value, Object context) {
            IStatus status = JavaConventions.validatePackageName((String)value.toString(), (String)"1.5", (String)"1.5");
            if ((6 & status.getSeverity()) != 0) {
                return SeamInstallWizardPage.this.doPackStatus(status, this.fieldName, NLS.bind((String)SeamUIMessages.SEAM_INSTALL_WIZARD_PAGE_PACKAGE_NAME_NOT_VALID, (Object)this.targetName));
            }
            return SeamValidatorFactory.NO_ERRORS;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ProjectNamesDuplicationValidator
    implements IValidator {
        String propertyName;

        public ProjectNamesDuplicationValidator(String propertyName) {
            this.propertyName = propertyName;
        }

        public Map<String, IStatus> validate(Object value, Object context) {
            String projectName = (String)value;
            String deployAs = SeamInstallWizardPage.this.model.getStringProperty("seam.project.deployment.type");
            String testProjectName = String.valueOf(projectName) + "-test";
            IStatus status = ProjectCreationDataModelProviderNew.validateName((String)testProjectName);
            if ((6 & status.getSeverity()) != 0) {
                return SeamInstallWizardPage.this.doPackStatus(status, this.propertyName, NLS.bind((String)SeamUIMessages.VALIDATOR_FACTORY_TEST_PROJECT_ALREADY_EXISTS, (Object)testProjectName));
            }
            if ("ear".equals(deployAs)) {
                String earProjectName = String.valueOf(projectName) + "-ear";
                status = ProjectCreationDataModelProviderNew.validateName((String)earProjectName);
                if ((6 & status.getSeverity()) != 0) {
                    return SeamInstallWizardPage.this.doPackStatus(status, this.propertyName, NLS.bind((String)SeamUIMessages.VALIDATOR_FACTORY_EAR_PROJECT_ALREADY_EXISTS, (Object)earProjectName));
                }
                String ejbProjectName = String.valueOf(projectName) + "-ejb";
                status = ProjectCreationDataModelProviderNew.validateName((String)ejbProjectName);
                if ((6 & status.getSeverity()) != 0) {
                    return SeamInstallWizardPage.this.doPackStatus(status, this.propertyName, NLS.bind((String)SeamUIMessages.VALIDATOR_FACTORY_EJB_PROJECT_ALREADY_EXISTS, (Object)ejbProjectName));
                }
            }
            return SeamValidatorFactory.NO_ERRORS;
        }
    }
}

