/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.internal.project.facet;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.ui.IValidator;
import org.jboss.tools.common.ui.ValidatorFactory;
import org.jboss.tools.seam.core.ISeamComponent;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.core.project.facet.SeamRuntime;
import org.jboss.tools.seam.core.project.facet.SeamRuntimeManager;
import org.jboss.tools.seam.ui.SeamUIMessages;

public class SeamValidatorFactory
extends ValidatorFactory {
    public static final IValidator JBOSS_SEAM_HOME_FOLDER_VALIDATOR = new IValidator(){

        public Map<String, IStatus> validate(Object value, Object context) {
            Map errors = FILE_SYSTEM_FOLDER_EXISTS.validate(value, context);
            if (!errors.isEmpty()) {
                errors = SeamValidatorFactory.createErrorMap();
                errors.put("seam.home.folder", new Status(4, "org.jboss.tools.seam.core", SeamUIMessages.VALIDATOR_FACTORY_SEAM_HOME_FOLDER_DOES_NOT_EXISTS));
                return errors;
            }
            String version = (String)context;
            if (version.startsWith("2.")) {
                File seamJarFile = new File(value.toString(), "lib/jboss-seam.jar");
                if (!seamJarFile.isFile()) {
                    errors = SeamValidatorFactory.createErrorMap();
                    errors.put("seam.home.folder", new Status(4, "org.jboss.tools.seam.core", SeamUIMessages.VALIDATOR_FACTORY_HOME_FOLDER_POINTS_TO_LOCATION_THAT_DOES_NOT_LOOK_LIKE_SEAM_HOME_FOLDER));
                }
            } else {
                File seamJarFile = new File(value.toString(), "jboss-seam.jar");
                if (!seamJarFile.isFile()) {
                    errors = SeamValidatorFactory.createErrorMap();
                    errors.put("seam.home.folder", new Status(4, "org.jboss.tools.seam.core", SeamUIMessages.VALIDATOR_FACTORY_HOME_FOLDER_POINTS_TO_LOCATION_THAT_DOES_NOT_LOOK_LIKE_SEAM_HOME_FOLDER));
                }
            }
            return errors;
        }
    };
    public static final IValidator JBOSS_AS_HOME_FOLDER_VALIDATOR = new IValidator(){

        public Map<String, IStatus> validate(Object value, Object context) {
            Map errors = FILE_SYSTEM_FOLDER_EXISTS.validate(value, context);
            if (!errors.isEmpty()) {
                errors = SeamValidatorFactory.createErrorMap();
                errors.put("jboss.home", new Status(4, "org.jboss.tools.seam.core", SeamUIMessages.VALIDATOR_FACTORY_JBOSS_AS_HOME_FOLDER_DOES_NOT_EXIST));
                return errors;
            }
            if (!new File(value.toString(), "bin/twiddle.jar").isFile()) {
                errors.put("jboss.home", new Status(4, "org.jboss.tools.seam.core", SeamUIMessages.VALIDATOR_FACTORY_JBOSS_AS_HOME_FOLDER_POINT_TO_LOCATION_THAT_DOES_NOT_LOOK_LIKE_JBOSS_AS_HOME_FOLDER));
            }
            return errors;
        }
    };
    public static final IValidator CLASS_QNAME_VALIDATOR = new IValidator(){

        public Map<String, IStatus> validate(Object value, Object context) {
            String classDecl = "class " + value.toString() + " {}";
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setSource(classDecl.toCharArray());
            parser.setProject((IJavaProject)context);
            CompilationUnit compilationUnit = (CompilationUnit)parser.createAST(null);
            IProblem[] problems = compilationUnit.getProblems();
            if (problems.length > 0) {
                return SeamValidatorFactory.createErrormessage((IStatus)new Status(4, "org.jboss.tools.seam.core", Messages.format((String)SeamUIMessages.VALIDATOR_FACTORY_COMPONENT_NAME_IS_NOT_VALID, (Object)problems[0].getMessage())));
            }
            return NO_ERRORS;
        }
    };
    public static final IValidator PACKAGE_NAME_VALIDATOR = new IValidator(){

        public Map<String, IStatus> validate(Object value, Object context) {
            IStatus status = JavaConventions.validatePackageName((String)value.toString(), (String)"1.5", (String)"1.5");
            if (status.getSeverity() == 4) {
                return SeamValidatorFactory.createErrormessage((IStatus)new Status(4, "org.jboss.tools.seam.core", Messages.format((String)NewWizardMessages.NewTypeWizardPage_error_InvalidPackageName, (Object)status.getMessage())));
            }
            return NO_ERRORS;
        }
    };
    public static final IValidator FILESYSTEM_FILE_EXISTS_VALIDATOR = new IValidator(){

        public Map<String, IStatus> validate(Object value, Object context) {
            return NO_ERRORS;
        }
    };
    public static final IValidator SEAM_COMPONENT_NAME_VALIDATOR = new IValidator(){

        public Map<String, IStatus> validate(Object value, Object context) {
            String[] segs;
            ISeamProject seamProject;
            ISeamComponent component;
            String name = value.toString();
            if (context != null && context instanceof ISeamProject && (component = (seamProject = (ISeamProject)context).getComponent(name)) != null) {
                return SeamValidatorFactory.createErrormessage((IStatus)new Status(4, "org.jboss.tools.seam.core", NLS.bind((String)SeamUIMessages.VALIDATOR_FACTORY_COMPONENT_ALREADY_EXISTS, (Object)name)));
            }
            String[] stringArray = segs = name.split("\\.");
            int n = segs.length;
            int n2 = 0;
            while (n2 < n) {
                String segm = stringArray[n2];
                if (!segm.trim().equals(segm)) {
                    return SeamValidatorFactory.createErrormessage((IStatus)new Status(4, "org.jboss.tools.seam.core", SeamUIMessages.VALIDATOR_FACTORY_NAME_IS_NOT_VALID));
                }
                IStatus status = JavaConventions.validateClassFileName((String)(String.valueOf(segm) + ".class"), (String)"1.5", (String)"1.5");
                if (!status.isOK()) {
                    return SeamValidatorFactory.createErrormessage((IStatus)new Status(4, "org.jboss.tools.seam.core", SeamUIMessages.VALIDATOR_FACTORY_NAME_IS_NOT_VALID));
                }
                ++n2;
            }
            return NO_ERRORS;
        }
    };
    public static final IValidator SEAM_JAVA_INTEFACE_NAME_CONVENTION_VALIDATOR = new IValidator(){

        public Map<String, IStatus> validate(Object value, Object context) {
            if (!(context instanceof Object[])) {
                throw new IllegalArgumentException("Context parameter should be instance of Object[]");
            }
            Object[] contextArray = (Object[])context;
            IProject project = (IProject)contextArray[1];
            IJavaProject jProject = JavaCore.create((IProject)project);
            IStatus status = JavaConventions.validateJavaTypeName((String)value.toString(), (String)SeamValidatorFactory.getCompilerSourceLevel((IJavaProject)jProject), (String)SeamValidatorFactory.getCompilerComplianceLevel((IJavaProject)jProject));
            if ((6 & status.getSeverity()) != 0) {
                return SeamValidatorFactory.createErrormessage((IStatus)new Status(4, "org.jboss.tools.seam.core", String.valueOf(SeamUIMessages.VALIDATOR_FACTORY_LOCAL_INTERFACE_NAME_IS_NOT_VALID) + status.getMessage()));
            }
            return NO_ERRORS;
        }
    };
    public static final IValidator SEAM_METHOD_NAME_VALIDATOR = new IValidator(){

        public Map<String, IStatus> validate(Object value, Object context) {
            if (!(context instanceof Object[])) {
                throw new IllegalArgumentException("Context parameter should be instance of Object[]");
            }
            Object[] contextArray = (Object[])context;
            String targetName = contextArray[0].toString();
            IProject project = (IProject)contextArray[1];
            IJavaProject jProject = JavaCore.create((IProject)project);
            IStatus status = JavaConventions.validateMethodName((String)value.toString(), (String)SeamValidatorFactory.getCompilerSourceLevel((IJavaProject)jProject), (String)SeamValidatorFactory.getCompilerComplianceLevel((IJavaProject)jProject));
            if (status.getSeverity() == 4) {
                return SeamValidatorFactory.createErrormessage((IStatus)new Status(4, "org.jboss.tools.seam.core", NLS.bind((String)SeamUIMessages.VALIDATOR_FACTORY_NAME_IS_NOT_VALID, (Object)targetName)));
            }
            return NO_ERRORS;
        }
    };
    public static final IValidator FILE_NAME_VALIDATOR = new IValidator(){

        public Map<String, IStatus> validate(Object value, Object context) {
            if (!(context instanceof Object[])) {
                throw new IllegalArgumentException("Context parameter should be instance of Object[]");
            }
            Object[] contextArray = (Object[])context;
            String targetName = contextArray[0].toString();
            IProject project = (IProject)contextArray[1];
            if ("".equals(value) || !project.getLocation().isValidSegment(value.toString())) {
                return SeamValidatorFactory.createErrormessage((IStatus)new Status(4, "org.jboss.tools.seam.core", NLS.bind((String)SeamUIMessages.VALIDATOR_FACTORY_NAME_IS_NOT_VALID, (Object)targetName)));
            }
            return NO_ERRORS;
        }
    };
    public static final IValidator SEAM_PROJECT_NAME_VALIDATOR = new IValidator(){

        public Map<String, IStatus> validate(Object value, Object context) {
            if (value == null || "".equals(value)) {
                return SeamValidatorFactory.createErrormessage((IStatus)new Status(4, "org.jboss.tools.seam.core", SeamUIMessages.VALIDATOR_FACTORY_PRJ_NOT_SELECTED));
            }
            IResource project = ResourcesPlugin.getWorkspace().getRoot().findMember(value.toString());
            if (project == null || !(project instanceof IProject) || !project.exists()) {
                return SeamValidatorFactory.createErrormessage((IStatus)new Status(4, "org.jboss.tools.seam.core", NLS.bind((String)SeamUIMessages.VALIDATOR_FACTORY_PROJECT_DOES_NOT_EXIST, (Object)value)));
            }
            IProject selection = (IProject)project;
            try {
                if (!selection.hasNature("org.jboss.tools.seam.core.seamnature") || SeamCorePlugin.getSeamPreferences((IProject)selection) == null || "".equals(SeamCorePlugin.getSeamPreferences((IProject)selection).get("seam.project.deployment.type", ""))) {
                    return SeamValidatorFactory.createErrormessage((IStatus)new Status(4, "org.jboss.tools.seam.core", NLS.bind((String)SeamUIMessages.VALIDATOR_FACTORY_SELECTED_PROJECT_IS_NOT_A_SEAM_WEB_PROJECT, (Object)project.getName())));
                }
            }
            catch (CoreException coreException) {
                return SeamValidatorFactory.createErrormessage((IStatus)new Status(4, "org.jboss.tools.seam.core", NLS.bind((String)SeamUIMessages.VALIDATOR_FACTORY_SELECTED_PRJ_IS_CLOSED, (Object)project.getName())));
            }
            return NO_ERRORS;
        }
    };
    public static final IValidator CONNECTION_PROFILE_VALIDATOR = new ConnectionProfileValidator(false);
    public static final IValidator CONNECTION_DRIVER_VALIDATOR = new ConnectionProfileValidator(true);
    public static final IValidator SEAM_RUNTIME_NAME_VALIDATOR = new IValidator(){

        public Map<String, IStatus> validate(Object value, Object context) {
            Map errors = NO_ERRORS;
            if (value == null || "".equals(value.toString().trim())) {
                errors = SeamValidatorFactory.createErrormessage((String)"seam.runtime.name", (IStatus)new Status(4, "org.jboss.tools.seam.core", SeamUIMessages.VALIDATOR_FACTORY_SEAM_RUNTIME_IS_NOT_SELECTED));
            } else {
                SeamRuntime rt = SeamRuntimeManager.getInstance().findRuntimeByName(value.toString());
                if (rt == null) {
                    errors = SeamValidatorFactory.createErrormessage((String)"seam.runtime.name", (IStatus)new Status(4, "org.jboss.tools.seam.core", NLS.bind((String)SeamUIMessages.VALIDATOR_FACTORY_CANNOT_FIND_SEAM_RUNTIME, (Object)value)));
                } else if (!new File(rt.getHomeDir()).exists()) {
                    errors = SeamValidatorFactory.createErrormessage((String)"seam.runtime.name", (IStatus)new Status(4, "org.jboss.tools.seam.core", NLS.bind((String)SeamUIMessages.VALIDATOR_FACTORY_SEAM_RT_HOME_DIR_IS_MISSING, (Object)value)));
                } else if (!new File(rt.getSeamGenDir()).exists()) {
                    errors = SeamValidatorFactory.createErrormessage((String)"seam.runtime.name", (IStatus)new Status(4, "org.jboss.tools.seam.core", NLS.bind((String)SeamUIMessages.VALIDATOR_FACTORY_SEAM_RT_TEMPLATES_DIR_IS_MISSING, (Object)value)));
                } else if (!new File(rt.getSrcTemplatesDir()).exists()) {
                    errors = SeamValidatorFactory.createErrormessage((String)"seam.runtime.name", (IStatus)new Status(4, "org.jboss.tools.seam.core", NLS.bind((String)SeamUIMessages.VALIDATOR_FACTORY_SEAM_RT_SRC_DIR_IS_MISSING, (Object)value)));
                } else if (!new File(rt.getViewTemplatesDir()).exists()) {
                    errors = SeamValidatorFactory.createErrormessage((String)"seam.runtime.name", (IStatus)new Status(4, "org.jboss.tools.seam.core", NLS.bind((String)SeamUIMessages.VALIDATOR_FACTORY_SEAM_RT_VIEW_DIR_IS_MISSING, (Object)value)));
                } else if (!new File(rt.getResourceTemplatesDir()).exists()) {
                    errors = SeamValidatorFactory.createErrormessage((String)"seam.runtime.name", (IStatus)new Status(4, "org.jboss.tools.seam.core", NLS.bind((String)SeamUIMessages.VALIDATOR_FACTORY_SEAM_RT_RESOURCES_DIR_IS_MISSING, (Object)value)));
                }
            }
            return errors;
        }
    };
    public static final IValidator SEAM_RUNTIME_VALIDATOR = new IValidator(){

        public Map<String, IStatus> validate(Object value, Object context) {
            Map errors = NO_ERRORS;
            if (value == null || "".equals(value)) {
                errors = SeamValidatorFactory.createErrormessage((IStatus)new Status(4, "org.jboss.tools.seam.core", SeamUIMessages.VALIDATOR_FACTORY_SEAM_RT_NOT_CONFIGURED));
            } else {
                SeamRuntime rt = SeamRuntimeManager.getInstance().findRuntimeByName(value.toString());
                if (rt == null) {
                    errors = SeamValidatorFactory.createErrormessage((IStatus)new Status(4, "org.jboss.tools.seam.core", NLS.bind((String)SeamUIMessages.VALIDATOR_FACTORY_SEAM_RT_CANNOT_BE_FOUND, (Object)value)));
                } else if (!new File(rt.getHomeDir()).exists()) {
                    errors = SeamValidatorFactory.createErrormessage((IStatus)new Status(4, "org.jboss.tools.seam.core", NLS.bind((String)SeamUIMessages.VALIDATOR_FACTORY_SEAM_RT_HOME_DIR_DOES_NOT_EXIST, (Object)value)));
                } else if (!new File(rt.getSeamGenDir()).exists()) {
                    errors = SeamValidatorFactory.createErrormessage((IStatus)new Status(4, "org.jboss.tools.seam.core", NLS.bind((String)SeamUIMessages.VALIDATOR_FACTORY_SEAM_RT_TEMPLATES_DIR_DOES_NOT_EXIST, (Object)value)));
                } else if (!new File(rt.getSrcTemplatesDir()).exists()) {
                    errors = SeamValidatorFactory.createErrormessage((IStatus)new Status(4, "org.jboss.tools.seam.core", NLS.bind((String)SeamUIMessages.VALIDATOR_FACTORY_SEAM_RT_SOURCE_TEMPLATES_DIR_DOES_NOT_EXIST, (Object)value)));
                } else if (!new File(rt.getViewTemplatesDir()).exists()) {
                    errors = SeamValidatorFactory.createErrormessage((IStatus)new Status(4, "org.jboss.tools.seam.core", NLS.bind((String)SeamUIMessages.VALIDATOR_FACTORY_SEAM_RT_VIE_TEMPLATE_DIR_DOES_NOT_EXIST, (Object)value)));
                }
            }
            return errors;
        }
    };

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConnectionProfileValidator
    implements IValidator {
        private boolean allowEmptyConnection;

        public ConnectionProfileValidator(boolean allowEmptyConnection) {
            this.allowEmptyConnection = allowEmptyConnection;
        }

        public Map<String, IStatus> validate(Object value, Object context) {
            if (!this.allowEmptyConnection && (value == null || "".equals(value.toString().trim()))) {
                return SeamValidatorFactory.createErrormessage((String)"seam.project.connection.profile", (IStatus)new Status(4, "org.jboss.tools.seam.core", SeamUIMessages.VALIDATOR_FACTORY_CONNECTION_PROFILE_IS_NOT_SELECTED));
            }
            IConnectionProfile connProfile = ProfileManager.getInstance().getProfileByName(value.toString());
            Properties props = connProfile.getBaseProperties();
            Object driverClass = props.get("org.eclipse.datatools.connectivity.db.driverClass");
            if (driverClass == null || "".equals(driverClass)) {
                return SeamValidatorFactory.createErrormessage((String)"seam.project.connection.profile", (IStatus)new Status(4, "org.jboss.tools.seam.core", NLS.bind((String)SeamUIMessages.VALIDATOR_FACTORY_DRIVER_CLASS_PROPERTY_IS_EMPTY_FOR_SELECTED_CONNECTION_PROFILE, (Object)value)));
            }
            return NO_ERRORS;
        }
    }
}

