/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.views;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;
import org.eclipse.ui.navigator.IExtensionStateModel;
import org.jboss.tools.seam.core.IRole;
import org.jboss.tools.seam.core.ISeamComponent;
import org.jboss.tools.seam.core.ISeamComponentDeclaration;
import org.jboss.tools.seam.core.ISeamElement;
import org.jboss.tools.seam.core.ISeamJavaComponentDeclaration;
import org.jboss.tools.seam.core.ISeamPackage;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.ISeamScope;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.core.event.ISeamProjectChangeListener;
import org.jboss.tools.seam.core.event.SeamProjectChangeEvent;
import org.jboss.tools.seam.ui.SeamGuiPlugin;
import org.jboss.tools.seam.ui.SeamUIMessages;

public abstract class AbstractSeamContentProvider
implements ITreeContentProvider,
ISeamProjectChangeListener,
ICommonContentProvider {
    protected Viewer viewer;
    IResourceChangeListener listener = new ResourceChangeListener();
    Set<ISeamProject> processed = new HashSet<ISeamProject>();
    private IExtensionStateModel fStateModel;
    IPropertyChangeListener scopePropertyListener;
    IPropertyChangeListener layoutPropertyListener;
    boolean isFlatLayout = true;
    boolean isScopeLable = false;

    public void init(ICommonContentExtensionSite commonContentExtensionSite) {
        this.fStateModel = commonContentExtensionSite.getExtensionStateModel();
        IMemento memento = commonContentExtensionSite.getMemento();
        this.restoreState(memento);
        this.scopePropertyListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("seam.scopePresentation".equals(event.getProperty()) && event.getNewValue() != null) {
                    boolean newValue = (Boolean)event.getNewValue();
                    AbstractSeamContentProvider.this.setIsScopeLable(newValue);
                }
            }
        };
        this.fStateModel.addPropertyChangeListener(this.scopePropertyListener);
        this.layoutPropertyListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("seam.packageStructure".equals(event.getProperty()) && event.getNewValue() != null) {
                    boolean newValue = (Boolean)event.getNewValue();
                    AbstractSeamContentProvider.this.setIsFlatLayout(newValue);
                }
            }
        };
        this.fStateModel.addPropertyChangeListener(this.layoutPropertyListener);
    }

    void setIsFlatLayout(boolean b) {
        this.isFlatLayout = b;
    }

    void setIsScopeLable(boolean b) {
        this.isScopeLable = b;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    boolean isNotShowingScopeNodes() {
        return this.isScopeLable;
    }

    boolean isPackageStructureFlat() {
        return this.isFlatLayout;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof ISeamComponentDeclaration) {
            return false;
        }
        return !(element instanceof IRole);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ISeamProject) {
            ISeamProject project = (ISeamProject)parentElement;
            if (this.isNotShowingScopeNodes()) {
                project.resolve();
                if (this.isPackageStructureFlat()) {
                    return project.getAllPackages().toArray(new Object[0]);
                }
                return project.getPackages().toArray(new Object[0]);
            }
            return project.getScopes();
        }
        if (parentElement instanceof ISeamScope) {
            ((ISeamScope)parentElement).getSeamProject().resolve();
            if (this.isPackageStructureFlat()) {
                return ((ISeamScope)parentElement).getAllPackages().toArray(new Object[0]);
            }
            return ((ISeamScope)parentElement).getPackages().toArray(new Object[0]);
        }
        if (parentElement instanceof ISeamPackage) {
            ISeamPackage p = (ISeamPackage)parentElement;
            ArrayList<Object> children = new ArrayList<Object>();
            for (ISeamComponent c : p.getComponents()) {
                children.add(c);
            }
            if (!this.isPackageStructureFlat()) {
                for (ISeamPackage pc : p.getPackages().values()) {
                    children.add(pc);
                }
            }
            return children.toArray(new Object[0]);
        }
        if (parentElement instanceof ISeamComponent) {
            ArrayList children = new ArrayList();
            Set ds = ((ISeamComponent)parentElement).getAllDeclarations();
            children.addAll(ds);
            for (ISeamComponentDeclaration d : ds) {
                if (!(d instanceof ISeamJavaComponentDeclaration)) continue;
                Set rs = ((ISeamJavaComponentDeclaration)d).getRoles();
                children.addAll(rs);
            }
            return children.toArray(new Object[0]);
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof IRole) {
            ISeamElement p = ((IRole)element).getParent();
            return p == null ? p : p.getParent();
        }
        if (element instanceof ISeamElement) {
            if (element instanceof ISeamComponent) {
                ISeamComponent c = (ISeamComponent)element;
                if (this.isNotShowingScopeNodes()) {
                    return c.getSeamProject().getPackage(c);
                }
                ISeamScope s = (ISeamScope)c.getParent();
                ISeamPackage p = s.getPackage(c);
                return p == null ? s : p;
            }
            return ((ISeamElement)element).getParent();
        }
        return null;
    }

    public void projectChanged(SeamProjectChangeEvent event) {
        if (this.viewer == null || this.viewer.getControl() == null || this.viewer.getControl().isDisposed()) {
            return;
        }
        Object o = event.getSource();
        if (o instanceof ISeamElement) {
            this.refresh(o);
        } else {
            SeamGuiPlugin.getPluginLog().logError(SeamUIMessages.ABSTRACT_SEAM_CONTENT_PROVIDER_SEAM_PROJECT_CHANGE_EVENT_OCCURS_BUT_NO_SORCE_OF_PROJECT_PROVIDED);
        }
    }

    void refresh(final Object o) {
        if (this.viewer == null || this.viewer.getControl() == null || this.viewer.getControl().isDisposed()) {
            return;
        }
        if (!(this.viewer instanceof StructuredViewer)) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (o == null) {
                    ((StructuredViewer)AbstractSeamContentProvider.this.viewer).refresh();
                } else {
                    ((StructuredViewer)AbstractSeamContentProvider.this.viewer).refresh(AbstractSeamContentProvider.this.getTreeObject(o));
                }
            }
        });
    }

    protected Object getTreeObject(Object source) {
        return source;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.listener);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.listener);
    }

    public void restoreState(IMemento memento) {
    }

    public void saveState(IMemento memento) {
    }

    public void dispose() {
        this.fStateModel.removePropertyChangeListener(this.layoutPropertyListener);
        this.fStateModel.removePropertyChangeListener(this.scopePropertyListener);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.listener);
        this.viewer = null;
        if (this.processed != null) {
            for (ISeamProject p : this.processed) {
                p.removeSeamProjectListener((ISeamProjectChangeListener)this);
            }
            this.processed.clear();
        }
        this.fStateModel.removePropertyChangeListener(this.layoutPropertyListener);
        this.fStateModel.removePropertyChangeListener(this.scopePropertyListener);
    }

    class ResourceChangeListener
    implements IResourceChangeListener {
        ResourceDeltaVisitor visitor;

        ResourceChangeListener() {
            this.visitor = new ResourceDeltaVisitor();
        }

        public void resourceChanged(IResourceChangeEvent event) {
            try {
                if (event.getDelta() == null) {
                    AbstractSeamContentProvider.this.refresh(null);
                } else {
                    event.getDelta().accept((IResourceDeltaVisitor)this.visitor);
                }
            }
            catch (CoreException e) {
                SeamCorePlugin.getPluginLog().logError((Throwable)e);
            }
        }
    }

    class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        ResourceDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResourceDelta[] cs;
            int kind = delta.getKind();
            IResource r = delta.getResource();
            if (kind == 1 || kind == 2) {
                if (r instanceof IProject) {
                    AbstractSeamContentProvider.this.refresh(null);
                }
            } else if (kind == 4 && (cs = delta.getAffectedChildren()) != null) {
                int i = 0;
                while (i < cs.length) {
                    IResource c = cs[i].getResource();
                    if (c instanceof IFile && c.getName().endsWith(".project")) {
                        AbstractSeamContentProvider.this.refresh(null);
                    }
                    ++i;
                }
            }
            return !(r instanceof IProject);
        }
    }
}

