/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.views.actions;

import java.util.Arrays;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.IExtensionActivationListener;
import org.eclipse.ui.navigator.IExtensionStateModel;
import org.eclipse.ui.navigator.INavigatorActivationService;
import org.jboss.tools.seam.core.SeamPreferences;
import org.jboss.tools.seam.ui.views.ViewConstants;
import org.jboss.tools.seam.ui.views.actions.SeamViewLayoutActionGroup;

public class ScopePresentationActionProvider
extends CommonActionProvider
implements ViewConstants {
    private ICommonActionExtensionSite fExtensionSite;
    IExtensionStateModel stateModel;
    private String fExtensionId;
    private IActionBars fActionBars;
    private boolean fEnabled = false;
    SeamViewLayoutActionGroup actionGroup;
    private IExtensionActivationListener fMenuUpdater = new IExtensionActivationListener(){

        public void onExtensionActivation(String viewerId, String[] theNavigatorExtensionIds, boolean isCurrentlyActive) {
            int search;
            if (ScopePresentationActionProvider.this.fExtensionSite != null && ScopePresentationActionProvider.this.fActionBars != null && (search = Arrays.binarySearch(theNavigatorExtensionIds, ScopePresentationActionProvider.this.fExtensionId)) > -1) {
                if (this.isMyViewer(viewerId)) {
                    if (this.wasEnabled(isCurrentlyActive)) {
                        ScopePresentationActionProvider.this.actionGroup.fillActionBars(ScopePresentationActionProvider.this.fActionBars);
                    } else if (this.wasDisabled(isCurrentlyActive)) {
                        ScopePresentationActionProvider.this.actionGroup.unfillActionBars(ScopePresentationActionProvider.this.fActionBars);
                    }
                }
                ScopePresentationActionProvider.this.fEnabled = isCurrentlyActive;
            }
        }

        private boolean isMyViewer(String viewerId) {
            String myViewerId = ScopePresentationActionProvider.this.fExtensionSite.getViewSite().getId();
            return myViewerId != null && myViewerId.equals(viewerId);
        }

        private boolean wasDisabled(boolean isActive) {
            return ScopePresentationActionProvider.this.fEnabled && !isActive;
        }

        private boolean wasEnabled(boolean isActive) {
            return !ScopePresentationActionProvider.this.fEnabled && isActive;
        }
    };

    public void init(ICommonActionExtensionSite site) {
        super.init(site);
        this.fExtensionSite = site;
        this.stateModel = site.getExtensionStateModel();
        this.actionGroup = new SeamViewLayoutActionGroup(this.fExtensionSite.getStructuredViewer(), this.stateModel);
        INavigatorActivationService activationService = this.fExtensionSite.getContentService().getActivationService();
        activationService.addExtensionActivationListener(this.fMenuUpdater);
        this.fExtensionId = this.fExtensionSite.getExtensionId();
        this.fEnabled = true;
    }

    public static void setPackageStructureFlat(boolean s) {
        IEclipsePreferences p = SeamPreferences.getInstance().getInstancePreferences();
        p.put("seam.packageStructure", s ? "editable" : "hierarchical");
    }

    public static void setScopePresentedAsLabel(boolean s) {
        IEclipsePreferences p = SeamPreferences.getInstance().getInstancePreferences();
        p.put("seam.scopePresentation", s ? "label" : "node");
    }

    public void fillActionBars(IActionBars actionBars) {
        this.fActionBars = actionBars;
        this.actionGroup.fillActionBars(actionBars);
    }

    public void dispose() {
        super.dispose();
        this.fExtensionSite.getContentService().getActivationService().removeExtensionActivationListener(this.fMenuUpdater);
    }

    void updateViewer() {
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                ScopePresentationActionProvider.this.getActionSite().getStructuredViewer().refresh();
            }
        });
    }

    public void restoreState(IMemento memento) {
        boolean isCurrentLayoutFlat = true;
        String state = null;
        if (memento != null) {
            state = memento.getString("seam-isFlatLayout");
        }
        if (state == null) {
            state = SeamPreferences.getInstance().getInstancePreference("seam.packageStructure");
        }
        isCurrentLayoutFlat = !"hierarchical".equals(state);
        this.setFlatLayout(isCurrentLayoutFlat);
        boolean isCurrentScopeLabel = false;
        state = null;
        if (memento != null) {
            state = memento.getString("seam-isScopeLabel");
        }
        if (state == null) {
            state = SeamPreferences.getInstance().getInstancePreference("seam.scopePresentation");
        }
        isCurrentScopeLabel = !"node".equals(state);
        this.setScopeLable(isCurrentScopeLabel);
    }

    public void saveState(IMemento aMemento) {
        super.saveState(aMemento);
        ScopePresentationActionProvider.setPackageStructureFlat(this.stateModel.getBooleanProperty("seam.packageStructure"));
        ScopePresentationActionProvider.setScopePresentedAsLabel(this.stateModel.getBooleanProperty("seam.scopePresentation"));
    }

    void setFlatLayout(boolean b) {
        this.stateModel.setBooleanProperty("seam.packageStructure", b);
        this.actionGroup.setFlatLayout(b);
    }

    void setScopeLable(boolean b) {
        this.stateModel.setBooleanProperty("seam.scopePresentation", b);
        this.actionGroup.setScopeLable(b);
    }
}

