/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.views.properties;

import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.jboss.tools.seam.core.ISeamComponent;
import org.jboss.tools.seam.ui.views.properties.SeamElementProperties;

public class SeamComponentProperties
extends SeamElementProperties {
    ISeamComponent element;
    static IPropertyDescriptor[] DESCRIPTORS = new IPropertyDescriptor[]{NAME_DESCRIPTOR, SCOPE_DESCRIPTOR, CLASS_DESCRIPTOR, PRECEDENCE_DESCRIPTOR, ENTITY_DESCRIPTOR};
    static IPropertyDescriptor[] ENTITY_DESCRIPTORS = new IPropertyDescriptor[]{NAME_DESCRIPTOR, SCOPE_DESCRIPTOR, CLASS_DESCRIPTOR, PRECEDENCE_DESCRIPTOR, ENTITY_DESCRIPTOR, STATEFUL_DESCRIPTOR};

    public SeamComponentProperties(ISeamComponent element) {
        this.element = element;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.element != null && this.element.isEntity()) {
            return ENTITY_DESCRIPTORS;
        }
        return DESCRIPTORS;
    }

    public Object getPropertyValue(Object id) {
        if (NAME.equals(id)) {
            return this.element.getName();
        }
        if (SCOPE.equals(id)) {
            return this.element.getScope().toString();
        }
        if (CLASS.equals(id)) {
            return this.element.getClassName();
        }
        if (PRECEDENCE.equals(id)) {
            return Precedence.getStringValue(this.element.getPrecedence());
        }
        if (ENTITY.equals(id)) {
            return "" + this.element.isEntity();
        }
        if (STATEFUL.equals(id)) {
            return "" + this.element.isStateful();
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Precedence {
        BUILT_IN(0),
        FRAMEWORK(10),
        APPLICATION(20),
        DEPLOYMENT(30),
        MOCK(40);

        int value;

        private Precedence(int value) {
            this.value = value;
        }

        static String getStringValue(int v) {
            int i = 0;
            while (i < Precedence.values().length) {
                if (v == Precedence.values()[i].value) {
                    return Precedence.values()[i].toString();
                }
                ++i;
            }
            return "" + v;
        }
    }
}

