/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.pages.editor.edit;

import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.FreeformViewport;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.graphics.Font;
import org.jboss.tools.common.gef.edit.GEFRootEditPart;
import org.jboss.tools.common.meta.action.XAction;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.event.XModelTreeEvent;
import org.jboss.tools.common.model.event.XModelTreeListener;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.common.model.ui.dnd.DnDUtil;
import org.jboss.tools.seam.pages.xml.model.SeamPagesPreference;
import org.jboss.tools.seam.ui.pages.SeamUiPagesPlugin;
import org.jboss.tools.seam.ui.pages.editor.PagesEditor;
import org.jboss.tools.seam.ui.pages.editor.ecore.pages.Link;
import org.jboss.tools.seam.ui.pages.editor.ecore.pages.Page;
import org.jboss.tools.seam.ui.pages.editor.edit.PageEditPolicy;
import org.jboss.tools.seam.ui.pages.editor.edit.PagesDiagramEditPart;
import org.jboss.tools.seam.ui.pages.editor.edit.PagesEditPart;
import org.jboss.tools.seam.ui.pages.editor.edit.ViewIDDirectEditPolicy;
import org.jboss.tools.seam.ui.pages.editor.edit.ViewIDEditManager;
import org.jboss.tools.seam.ui.pages.editor.edit.ViewIDEditorLocator;
import org.jboss.tools.seam.ui.pages.editor.figures.NodeFigure;
import org.jboss.tools.seam.ui.pages.editor.figures.PageFigure;

public class PageEditPart
extends PagesEditPart
implements PropertyChangeListener,
EditPartListener,
Adapter,
XModelTreeListener {
    private PageFigure fig = null;
    PagesEditor editor;
    Dimension size;

    public void setEditor(PagesEditor editor) {
        this.editor = editor;
    }

    public void doControlUp() {
    }

    public void doControlDown() {
    }

    public void doMouseHover(boolean cf) {
    }

    public void childAdded(EditPart child, int index) {
    }

    public void doMouseDown(Point mp) {
        FreeformViewport diagram = (FreeformViewport)((GEFRootEditPart)this.editor.getScrollingGraphicalViewer().getRootEditPart()).getFigure();
        Point mouseLocation = mp.scale(1.0 / ((GEFRootEditPart)this.editor.getScrollingGraphicalViewer().getRootEditPart()).getZoomManager().getZoom()).translate(-this.getPageFigure().getLocation().x, -this.getPageFigure().getLocation().y).translate(diagram.getClientArea().getLocation());
        if (mouseLocation.x < 15 && mouseLocation.y > this.getPageFigure().getSize().height - 15) {
            this.getPageModel().setParamsVisible(!this.getPageModel().isParamsVisible());
            this.refresh();
            this.fig.repaint();
        }
    }

    public void partActivated(EditPart editpart) {
    }

    public void partDeactivated(EditPart editpart) {
    }

    public void removingChild(EditPart child, int index) {
    }

    public void selectedStateChanged(EditPart editpart) {
        if (this.getSelected() == 2) {
            ((PagesDiagramEditPart)this.getParent()).setToFront((EditPart)this);
        }
    }

    public void nodeChanged(XModelTreeEvent event) {
        String path = event.getModelObject().getPath();
        if (path.equals(SeamPagesPreference.SEAM_PAGES_EDITOR_PATH)) {
            NodeFigure.nodeLabelFont = SeamPagesPreference.getFont((String)SeamPagesPreference.VIEW_PATH_FONT.getValue(), (Font)NodeFigure.nodeLabelFont);
            this.refreshVisuals();
        }
    }

    public void structureChanged(XModelTreeEvent event) {
    }

    public boolean isGroupListenerEnable() {
        return true;
    }

    private void refreshTargetLink(Link link) {
        if (link == null) {
            return;
        }
        PageEditPart gep = (PageEditPart)this.getViewer().getEditPartRegistry().get(link.getToElement());
        if (gep == null) {
            return;
        }
        gep.refreshTargetConnections();
    }

    protected AccessibleEditPart createAccessible() {
        return new AbstractGraphicalEditPart.AccessibleGraphicalEditPart(this){

            public void getName(AccessibleEvent e) {
                e.result = "EditPart";
            }

            public void getValue(AccessibleControlEvent e) {
            }
        };
    }

    protected List getModelTargetConnections() {
        return this.getPageModel().getInputLinks();
    }

    protected List getModelSourceConnections() {
        return this.getPageModel().getOutputLinks();
    }

    public void performRequest(Request req) {
        if ("open".equals(req.getType())) {
            SelectionRequest request = (SelectionRequest)req;
            Point mouseLocation = request.getLocation().translate(-this.getPageFigure().getLocation().x, -this.getPageFigure().getLocation().y);
            if (mouseLocation.x < 16 && mouseLocation.y > this.getPageFigure().getSize().height - 16) {
                this.getPageModel().setParamsVisible(!this.getPageModel().isParamsVisible());
                this.refresh();
                this.fig.repaint();
            } else {
                try {
                    XAction action = DnDUtil.getEnabledAction((XModelObject)((XModelObject)this.getPageModel().getData()), null, (String)"OpenPage");
                    if (action != null) {
                        action.executeHandler((XModelObject)this.getPageModel().getData(), null);
                    }
                }
                catch (XModelException e) {
                    SeamUiPagesPlugin.log(e);
                }
            }
        } else if (req.getType() == "init edit") {
            new ViewIDEditManager((GraphicalEditPart)this, new ViewIDEditorLocator((PageFigure)this.getFigure())).show();
        } else if (req.getType() == "direct edit") {
            new ViewIDEditManager((GraphicalEditPart)this, new ViewIDEditorLocator((PageFigure)this.getFigure()), true).show();
        }
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("NodeEditPolicy", null);
        this.installEditPolicy("Selection Feedback", null);
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new PageEditPolicy());
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new ViewIDDirectEditPolicy());
    }

    protected IFigure createFigure() {
        this.fig = new PageFigure(this.getPageModel());
        this.fig.setPageEditPart(this);
        return this.fig;
    }

    public PageFigure getPageFigure() {
        return (PageFigure)this.getFigure();
    }

    public Page getPageModel() {
        return (Page)this.getModel();
    }

    protected void refreshVisuals() {
        int width;
        String name;
        Point loc = this.getPageModel().getLocation();
        int height = this.getVisualHeight() + this.getPageModel().getOutputLinks().size() * 16;
        if (this.getPageModel().getOutputLinks().isEmpty()) {
            height = this.getVisualHeight() + 16;
        }
        if ((name = this.getPageModel().getName()) == null) {
            name = "";
        }
        if ((width = this.getIconWidth() + FigureUtilities.getTextExtents((String)name, (Font)NodeFigure.nodeLabelFont).width) < this.getMinimumWidth()) {
            width = this.getMinimumWidth();
        }
        this.size = new Dimension(width, height);
        this.adjustForGrid(loc);
        Rectangle r = new Rectangle(loc, this.size);
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)r);
    }

    private int getVisualHeight() {
        return 21;
    }

    private int getIconWidth() {
        return 30;
    }

    private int getMinimumWidth() {
        return 130;
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connEditPart) {
        ConnectionAnchor anc = this.getNodeFigure().getConnectionAnchor("1_IN");
        return anc;
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        Point pt = new Point(((DropRequest)request).getLocation());
        return this.getNodeFigure().getTargetConnectionAnchorAt(pt);
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connEditPart) {
        Link link = (Link)connEditPart.getModel();
        int index = this.getPageModel().getOutputLinks().indexOf((Object)link);
        return this.getNodeFigure().getConnectionAnchor(String.valueOf(index + 1) + "_OUT");
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        Point pt = new Point(((DropRequest)request).getLocation());
        return this.getNodeFigure().getSourceConnectionAnchorAt(pt);
    }

    protected void refreshChildren() {
        super.refreshChildren();
        int i = 0;
        while (i < this.getChildren().size()) {
            ((PageEditPart)this.getChildren().get(i)).refresh();
            ++i;
        }
    }

    public void activate() {
        if (this.isActive()) {
            return;
        }
        ((Notifier)this.getModel()).eAdapters().add((Object)this);
        PreferenceModelUtilities.getPreferenceModel().addModelTreeListener((XModelTreeListener)this);
        super.activate();
        if ("<initialize>".equals(this.getPageModel().getName())) {
            this.getPageModel().setName("");
            DirectEditRequest req = new DirectEditRequest();
            req.setType((Object)"init edit");
            this.performRequest((Request)req);
        }
    }

    public void deactivate() {
        if (!this.isActive()) {
            return;
        }
        ((Notifier)this.getModel()).eAdapters().remove((Object)this);
        PreferenceModelUtilities.getPreferenceModel().removeModelTreeListener((XModelTreeListener)this);
        super.deactivate();
    }

    public void notifyChanged(Notification notification) {
        this.refresh();
        this.refreshVisuals();
        this.getPageFigure().repaint();
        PagesDiagramEditPart diagram = (PagesDiagramEditPart)this.getParent().getRoot().getViewer().getEditPartRegistry().get(this.getPageModel().getParent());
        if (diagram != null) {
            diagram.refresh();
        }
    }

    public Notifier getTarget() {
        return null;
    }

    public boolean isAdapterForType(Object type) {
        return false;
    }

    public void setTarget(Notifier newTarget) {
    }
}

