/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.pages.editor.edit;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.FreeformViewport;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.CompoundSnapToHelper;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.LayerConstants;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToGeometry;
import org.eclipse.gef.SnapToGrid;
import org.eclipse.gef.SnapToGuides;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gef.tools.DeselectAllTracker;
import org.eclipse.gef.tools.MarqueeDragTracker;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.jboss.tools.common.model.event.XModelTreeEvent;
import org.jboss.tools.common.model.event.XModelTreeListener;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.seam.pages.xml.model.SeamPagesPreference;
import org.jboss.tools.seam.ui.pages.editor.ecore.pages.Page;
import org.jboss.tools.seam.ui.pages.editor.ecore.pages.PagesModel;
import org.jboss.tools.seam.ui.pages.editor.ecore.pages.PagesModelListener;
import org.jboss.tools.seam.ui.pages.editor.edit.ContainerEditPart;
import org.jboss.tools.seam.ui.pages.editor.edit.PageWrapper;
import org.jboss.tools.seam.ui.pages.editor.edit.PagesDiagramEditPolicy;
import org.jboss.tools.seam.ui.pages.editor.figures.DiagramFigure;

public class PagesDiagramEditPart
extends ContainerEditPart
implements LayerConstants,
PagesModelListener,
Adapter,
XModelTreeListener {
    private DiagramFigure fig;

    public boolean isGridVisible() {
        return SeamPagesPreference.SHOW_GRID.getValue().equals("yes");
    }

    public int getVisualGridStep() {
        return Integer.parseInt(SeamPagesPreference.GRID_STEP.getValue());
    }

    public void setModel(Object model) {
        super.setModel(model);
    }

    public PagesModel getPagesModel() {
        return (PagesModel)this.getModel();
    }

    public boolean isStrutsModelListenerEnabled() {
        return true;
    }

    public void setToFront(EditPart editPart) {
        int index = this.getChildren().indexOf(editPart);
        if (index == -1) {
            return;
        }
        if (index != this.getChildren().size() - 1) {
            this.reorderChild(editPart, this.getChildren().size() - 1);
        }
    }

    protected AccessibleEditPart createAccessible() {
        return new AbstractGraphicalEditPart.AccessibleGraphicalEditPart(this){

            public void getName(AccessibleEvent event) {
                event.result = "Pages Diagram";
            }
        };
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("NodeEditPolicy", null);
        this.installEditPolicy("GraphicalNodeEditPolicy", null);
        this.installEditPolicy("Selection Feedback", null);
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new PagesDiagramEditPolicy());
    }

    protected IFigure createFigure() {
        this.fig = new DiagramFigure(this);
        return this.fig;
    }

    public FreeformViewport getFreeformViewport() {
        return (FreeformViewport)this.getAncestor(this.fig, FreeformViewport.class);
    }

    public IFigure getAncestor(IFigure figure, Class cls) {
        DiagramFigure parent = this.fig;
        while (parent != null) {
            if (((Object)((Object)parent)).getClass().equals(cls)) {
                return parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    public DragTracker getDragTracker(Request req) {
        if (req instanceof SelectionRequest && ((SelectionRequest)req).getLastButtonPressed() == 3) {
            return new DeselectAllTracker((EditPart)this);
        }
        return new MarqueeDragTracker();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart editPart) {
        return null;
    }

    public ConnectionAnchor getSourceConnectionAnchor(int x, int y) {
        return null;
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart editPart) {
        return null;
    }

    public ConnectionAnchor getTargetConnectionAnchor(int x, int y) {
        return null;
    }

    public void nodeChanged(XModelTreeEvent event) {
        String path = event.getModelObject().getPath();
        if (path.equals(SeamPagesPreference.SEAM_PAGES_EDITOR_PATH)) {
            this.refresh();
        }
    }

    public void structureChanged(XModelTreeEvent event) {
    }

    protected void refreshVisuals() {
    }

    protected List getModelChildren() {
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        while (i < this.getPagesModel().getChildren().size()) {
            Page page;
            list.add(this.getPagesModel().getChildren().get(i));
            if (this.getPagesModel().getChildren().get(i) instanceof Page && !(page = (Page)this.getPagesModel().getChildren().get(i)).getChildren().isEmpty() && page.isParamsVisible()) {
                PageWrapper wrapper = page.getParamList();
                list.add(wrapper);
            }
            ++i;
        }
        return list;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == SnapToHelper.class) {
            ArrayList<Object> snapStrategies = new ArrayList<Object>();
            Boolean val = (Boolean)this.getViewer().getProperty("ruler$visibility");
            if (val != null && val.booleanValue()) {
                snapStrategies.add(new SnapToGuides((GraphicalEditPart)this));
            }
            if ((val = (Boolean)this.getViewer().getProperty("SnapToGeometry.isEnabled")) != null && val.booleanValue()) {
                snapStrategies.add(new SnapToGeometry((GraphicalEditPart)this));
            }
            if ((val = (Boolean)this.getViewer().getProperty("SnapToGrid.isEnabled")) != null && val.booleanValue()) {
                snapStrategies.add(new SnapToGrid((GraphicalEditPart)this));
            }
            if (snapStrategies.isEmpty()) {
                return null;
            }
            if (snapStrategies.size() == 1) {
                return (SnapToHelper)snapStrategies.get(0);
            }
            SnapToHelper[] ss = new SnapToHelper[snapStrategies.size()];
            int i = 0;
            while (i < snapStrategies.size()) {
                ss[i] = (SnapToHelper)snapStrategies.get(i);
                ++i;
            }
            return new CompoundSnapToHelper(ss);
        }
        return super.getAdapter(adapter);
    }

    public void activate() {
        if (this.isActive()) {
            return;
        }
        ((Notifier)this.getModel()).eAdapters().add((Object)this);
        PreferenceModelUtilities.getPreferenceModel().addModelTreeListener((XModelTreeListener)this);
        super.activate();
    }

    public void deactivate() {
        if (!this.isActive()) {
            return;
        }
        ((Notifier)this.getModel()).eAdapters().remove((Object)this);
        PreferenceModelUtilities.getPreferenceModel().removeModelTreeListener((XModelTreeListener)this);
        super.deactivate();
    }

    public void notifyChanged(Notification notification) {
        this.refresh();
        this.refreshVisuals();
    }

    public Notifier getTarget() {
        return null;
    }

    public boolean isAdapterForType(Object type) {
        return false;
    }

    public void setTarget(Notifier newTarget) {
    }
}

