/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.jboss.tools.common.meta.action.impl.SpecialWizardSupport;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.common.model.project.ext.IValueInfo;
import org.jboss.tools.common.model.project.ext.event.Change;
import org.jboss.tools.common.model.util.EclipseJavaUtil;
import org.jboss.tools.common.xml.XMLUtilities;
import org.jboss.tools.jst.web.model.project.ext.store.XMLStoreHelper;
import org.jboss.tools.seam.core.BeanType;
import org.jboss.tools.seam.core.BijectedAttributeType;
import org.jboss.tools.seam.core.IBijectedAttribute;
import org.jboss.tools.seam.core.IRole;
import org.jboss.tools.seam.core.ISeamComponentMethod;
import org.jboss.tools.seam.core.ISeamContextVariable;
import org.jboss.tools.seam.core.ISeamElement;
import org.jboss.tools.seam.core.ISeamJavaComponentDeclaration;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.ScopeType;
import org.jboss.tools.seam.core.SeamComponentMethodType;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.internal.core.BijectedAttribute;
import org.jboss.tools.seam.internal.core.DataModelSelectionAttribute;
import org.jboss.tools.seam.internal.core.Role;
import org.jboss.tools.seam.internal.core.SeamComponentDeclaration;
import org.jboss.tools.seam.internal.core.SeamComponentMethod;
import org.jboss.tools.seam.internal.core.SeamJavaContextVariable;
import org.jboss.tools.seam.internal.core.SeamObject;
import org.jboss.tools.seam.internal.core.SeamProject;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeamJavaComponentDeclaration
extends SeamComponentDeclaration
implements ISeamJavaComponentDeclaration {
    public static final String PATH_OF_STATEFUL = "stateful";
    protected String className = null;
    protected ScopeType scopeType = ScopeType.UNSPECIFIED;
    Map<BeanType, IValueInfo> types = null;
    protected int precedence = 20;
    protected IType type;
    protected Set<IBijectedAttribute> bijectedAttributes = new HashSet<IBijectedAttribute>();
    protected Set<ISeamComponentMethod> componentMethods = new HashSet<ISeamComponentMethod>();
    protected Set<IRole> roles = new HashSet<IRole>();
    static final Map<String, Integer> NAMED_PRECEDENCES = new HashMap<String, Integer>();
    static String ATTR_CLASS_NAME;

    static {
        NAMED_PRECEDENCES.put("Install.BUILT_IN", 0);
        NAMED_PRECEDENCES.put("Install.FRAMEWORK", 10);
        NAMED_PRECEDENCES.put("Install.APPLICATION", 20);
        NAMED_PRECEDENCES.put("Install.DEPLOYMENT", 30);
        NAMED_PRECEDENCES.put("Install.MOCK", 40);
        ATTR_CLASS_NAME = "class-name";
    }

    public void setType(IType type) {
        this.type = type;
    }

    @Override
    public ScopeType getScope() {
        if (this.scopeType != null && this.scopeType != ScopeType.UNSPECIFIED) {
            return this.scopeType;
        }
        if (this.isEntity() || this.isStateful()) {
            return ScopeType.CONVERSATION;
        }
        if (this.isOfType(BeanType.STATELESS) || this.isOfType(BeanType.MESSAGE_DRIVEN)) {
            return ScopeType.STATELESS;
        }
        return ScopeType.EVENT;
    }

    public void setScope(String scope) {
        if (scope == null || scope.length() == 0) {
            this.scopeType = ScopeType.UNSPECIFIED;
        } else {
            try {
                this.scopeType = ScopeType.valueOf(scope.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.scopeType = ScopeType.UNSPECIFIED;
            }
        }
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    @Override
    public void addBijectedAttribute(IBijectedAttribute attribute) {
        this.bijectedAttributes.add(attribute);
        this.adopt(attribute);
    }

    @Override
    public void addMethod(ISeamComponentMethod method) {
        this.componentMethods.add(method);
        this.adopt(method);
    }

    @Override
    public void addRole(IRole role) {
        this.roles.add(role);
        this.adopt(role);
    }

    @Override
    public Set<IBijectedAttribute> getBijectedAttributes() {
        return this.bijectedAttributes;
    }

    @Override
    public Set<IBijectedAttribute> getBijectedAttributesByName(String name) {
        HashSet<IBijectedAttribute> result = null;
        for (IBijectedAttribute a : this.getBijectedAttributes()) {
            if (!name.equals(a.getName())) continue;
            if (result == null) {
                result = new HashSet<IBijectedAttribute>();
            }
            result.add(a);
        }
        return result;
    }

    @Override
    public Set<IBijectedAttribute> getBijectedAttributesByType(BijectedAttributeType type) {
        HashSet<IBijectedAttribute> result = null;
        for (IBijectedAttribute a : this.getBijectedAttributes()) {
            if (!a.isOfType(type)) continue;
            if (result == null) {
                result = new HashSet<IBijectedAttribute>();
            }
            result.add(a);
        }
        return result;
    }

    @Override
    public Set<ISeamComponentMethod> getMethods() {
        return this.componentMethods;
    }

    @Override
    public Set<ISeamComponentMethod> getMethodsByType(SeamComponentMethodType type) {
        Set<ISeamComponentMethod> s;
        HashSet<ISeamComponentMethod> result = null;
        HashSet<String> names = null;
        for (ISeamComponentMethod a : this.getMethods()) {
            if (!a.isOfType(type)) continue;
            if (result == null) {
                result = new HashSet<ISeamComponentMethod>();
                names = new HashSet<String>();
            }
            result.add(a);
            if (a.getSourceMember() == null) continue;
            names.add(a.getSourceMember().getElementName());
        }
        ISeamJavaComponentDeclaration superDeclaration = this.getSuperDeclaration();
        if (superDeclaration != null && (s = superDeclaration.getMethodsByType(type)) != null) {
            for (ISeamComponentMethod a : s) {
                if (a.getSourceMember() == null) continue;
                String n = a.getSourceMember().getElementName();
                if (names != null && names.contains(n)) continue;
                if (result == null) {
                    result = new HashSet();
                    names = new HashSet();
                }
                result.add(a);
                if (a.getSourceMember() == null) continue;
                names.add(a.getSourceMember().getElementName());
            }
        }
        return result;
    }

    public ISeamJavaComponentDeclaration getSuperDeclaration() {
        if (this.type == null) {
            return null;
        }
        String superclass = null;
        try {
            superclass = this.type.getSuperclassName();
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        if (superclass == null || "java.lang.Object".equals(superclass)) {
            return null;
        }
        if (superclass.indexOf(46) < 0) {
            superclass = EclipseJavaUtil.resolveType((IType)this.type, (String)superclass);
        }
        if (superclass != null && superclass.equals(this.type.getFullyQualifiedName())) {
            return null;
        }
        SeamProject p = (SeamProject)this.getSeamProject();
        return p == null ? null : p.getJavaComponentDeclaration(superclass);
    }

    @Override
    public Set<IRole> getRoles() {
        return this.roles;
    }

    @Override
    public boolean isOfType(BeanType type) {
        return this.types != null && this.types.containsKey(type);
    }

    @Override
    public boolean isEntity() {
        return this.isOfType(BeanType.ENTITY);
    }

    @Override
    public boolean isStateful() {
        return this.isOfType(BeanType.STATEFUL);
    }

    @Override
    public boolean isStateless() {
        return this.isOfType(BeanType.STATELESS);
    }

    @Override
    public void removeBijectedAttribute(IBijectedAttribute attribute) {
        this.bijectedAttributes.remove(attribute);
    }

    @Override
    public void removeMethod(ISeamComponentMethod method) {
        this.componentMethods.remove(method);
    }

    @Override
    public void removeRole(IRole role) {
        this.roles.remove(role);
    }

    public IMember getSourceMember() {
        return this.type;
    }

    @Override
    public List<Change> merge(ISeamElement s) {
        List changes = super.merge(s);
        SeamJavaComponentDeclaration jd = (SeamJavaComponentDeclaration)s;
        if (!this.stringsEqual(this.className, jd.className)) {
            changes = Change.addChange(changes, (Change)new Change((Object)this, "class", (Object)this.className, (Object)jd.className));
            this.className = jd.className;
        }
        if (this.scopeType != jd.scopeType) {
            changes = Change.addChange((List)changes, (Change)new Change((Object)this, "scope", (Object)this.scopeType, (Object)jd.scopeType));
            this.scopeType = jd.scopeType;
        }
        if (this.precedence != jd.precedence) {
            changes = Change.addChange((List)changes, (Change)new Change((Object)this, "precedence", (Object)this.precedence, (Object)jd.precedence));
            this.precedence = jd.precedence;
        }
        if (this.type != jd.type) {
            this.type = jd.type;
        }
        if (!this.typesAreEqual(this.types, jd.types)) {
            changes = Change.addChange((List)changes, (Change)new Change((Object)this, "types", this.types, jd.types));
        }
        this.types = jd.types;
        Change children = new Change((Object)this, null, null, null);
        this.mergeComponentMethods(jd, children);
        this.mergeBijected(jd, children);
        this.mergeRoles(jd, children);
        changes = Change.addChange((List)changes, (Change)children);
        return changes;
    }

    public void mergeBijected(SeamJavaComponentDeclaration jd, Change children) {
        HashMap<Object, BijectedAttribute> bijectedMap = new HashMap<Object, BijectedAttribute>();
        for (IBijectedAttribute r : this.bijectedAttributes) {
            bijectedMap.put(((SeamObject)((Object)r)).getId(), (BijectedAttribute)r);
        }
        for (IBijectedAttribute r : jd.bijectedAttributes) {
            ISeamProject p;
            BijectedAttribute loaded = (BijectedAttribute)r;
            BijectedAttribute current = (BijectedAttribute)bijectedMap.remove(loaded.getId());
            if (current == null) {
                this.adopt(loaded);
                this.bijectedAttributes.add(loaded);
                ISeamProject p2 = this.getSeamProject();
                if (p2 != null && loaded.isContextVariable()) {
                    p2.addVariable(loaded);
                }
                Change change = new Change((Object)this, null, null, (Object)loaded);
                children.addChildren(Change.addChange(null, (Change)change));
                continue;
            }
            boolean wasOut = current.isContextVariable();
            boolean isOut = loaded.isContextVariable();
            List<Change> rc = current.merge(loaded);
            if (rc != null) {
                children.addChildren(rc);
            }
            if (wasOut == isOut || (p = this.getSeamProject()) == null) continue;
            if (wasOut) {
                p.removeVariable(current);
            }
            if (!isOut) continue;
            p.addVariable(current);
        }
        for (IBijectedAttribute r : bijectedMap.values()) {
            this.bijectedAttributes.remove(r);
            ISeamProject p = this.getSeamProject();
            if (p != null) {
                p.removeVariable(r);
            }
            Change change = new Change((Object)this, null, (Object)r, null);
            children.addChildren(Change.addChange(null, (Change)change));
        }
    }

    public void mergeRoles(SeamJavaComponentDeclaration jd, Change children) {
        HashMap<Object, Role> roleMap = new HashMap<Object, Role>();
        for (IRole r : this.roles) {
            roleMap.put(((SeamObject)((Object)r)).getId(), (Role)r);
        }
        for (IRole r : jd.roles) {
            Role loaded = (Role)r;
            Role current = (Role)roleMap.remove(loaded.getId());
            if (current == null) {
                this.adopt(loaded);
                this.roles.add(loaded);
                ISeamProject p = this.getSeamProject();
                if (p != null) {
                    p.addVariable(loaded);
                }
                Change change = new Change((Object)this, null, null, (Object)loaded);
                children.addChildren(Change.addChange(null, (Change)change));
                continue;
            }
            List<Change> rc = current.merge(loaded);
            if (rc == null) continue;
            children.addChildren(rc);
        }
        for (IRole r : roleMap.values()) {
            this.roles.remove(r);
            ISeamProject p = this.getSeamProject();
            if (p != null) {
                p.removeVariable(r);
            }
            Change change = new Change((Object)this, null, (Object)r, null);
            children.addChildren(Change.addChange(null, (Change)change));
        }
    }

    public void mergeComponentMethods(SeamJavaComponentDeclaration jd, Change children) {
        HashMap<Object, SeamComponentMethod> methodsMap = new HashMap<Object, SeamComponentMethod>();
        for (ISeamComponentMethod r : this.componentMethods) {
            methodsMap.put(((SeamObject)((Object)r)).getId(), (SeamComponentMethod)r);
        }
        for (ISeamComponentMethod r : jd.componentMethods) {
            SeamComponentMethod loaded = (SeamComponentMethod)r;
            SeamComponentMethod current = (SeamComponentMethod)methodsMap.remove(loaded.getId());
            if (current == null) {
                this.adopt(loaded);
                this.componentMethods.add(loaded);
                Change change = new Change((Object)this, null, null, (Object)loaded);
                children.addChildren(Change.addChange(null, (Change)change));
                continue;
            }
            List<Change> rc = current.merge(loaded);
            if (rc == null) continue;
            children.addChildren(rc);
        }
        for (ISeamComponentMethod r : methodsMap.values()) {
            this.componentMethods.remove(r);
            Change change = new Change((Object)this, null, (Object)r, null);
            children.addChildren(Change.addChange(null, (Change)change));
        }
    }

    boolean typesAreEqual(Map<BeanType, IValueInfo> types1, Map<BeanType, IValueInfo> types2) {
        if (types1 == null || types2 == null) {
            return types2 == types1;
        }
        if (types1.size() != types2.size()) {
            return false;
        }
        for (BeanType t : types1.keySet()) {
            if (types2.containsKey(t)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getPrecedence() {
        return this.precedence;
    }

    @Override
    public void setPrecedence(int precedence) {
        this.precedence = precedence;
    }

    public void setScope(IValueInfo value) {
        this.attributes.put("scope", value);
        this.setScope(value == null ? null : value.getValue());
    }

    public void setPrecedence(IValueInfo value) {
        String p;
        this.attributes.put("precedence", value);
        String string = p = value == null ? null : value.getValue();
        if (p == null) {
            this.setPrecedence(0);
            return;
        }
        Integer i = NAMED_PRECEDENCES.get(p);
        if (i == null) {
            try {
                i = Integer.parseInt(p);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        this.setPrecedence(i == null ? -1 : i);
    }

    public void setTypes(Map<BeanType, IValueInfo> types) {
        this.types = types;
    }

    @Override
    public Set<ISeamContextVariable> getDeclaredVariables() {
        HashSet<ISeamContextVariable> set = new HashSet<ISeamContextVariable>();
        set.addAll(this.roles);
        for (IBijectedAttribute a : this.bijectedAttributes) {
            if (!a.isContextVariable()) continue;
            set.add(a);
        }
        return set;
    }

    @Override
    public void open() {
        if (this.type == null) {
            return;
        }
        if (!this.type.exists()) {
            ServiceDialog d = PreferenceModelUtilities.getPreferenceModel().getService();
            d.showDialog("Warning", "Type " + this.type.getElementName() + " does not exist.", new String[]{SpecialWizardSupport.OK}, null, 2);
            return;
        }
        try {
            JavaUI.openInEditor((IJavaElement)this.type);
        }
        catch (CoreException e) {
            SeamCorePlugin.getPluginLog().logError((Throwable)e);
        }
    }

    @Override
    public SeamJavaComponentDeclaration clone() throws CloneNotSupportedException {
        SeamJavaComponentDeclaration c = (SeamJavaComponentDeclaration)super.clone();
        if (this.types != null) {
            c.types = new HashMap<BeanType, IValueInfo>();
            c.types.putAll(this.types);
        }
        c.bijectedAttributes = new HashSet<IBijectedAttribute>();
        for (IBijectedAttribute a : this.bijectedAttributes) {
            c.addBijectedAttribute(a.clone());
        }
        c.componentMethods = new HashSet<ISeamComponentMethod>();
        for (ISeamComponentMethod m : this.componentMethods) {
            c.addMethod(m.clone());
        }
        c.roles = new HashSet<IRole>();
        for (IRole r : this.roles) {
            c.addRole(r.clone());
        }
        return c;
    }

    @Override
    public String getXMLClass() {
        return "java";
    }

    @Override
    public Element toXML(Element parent, Properties context) {
        SeamObject o;
        Element b;
        Element element = super.toXML(parent, context);
        if (this.scopeType != null) {
            element.setAttribute("scope", this.scopeType.toString());
        }
        if (this.types != null) {
            Element e_types = XMLUtilities.createElement((Element)element, (String)"bean-types");
            for (BeanType beanType : this.types.keySet()) {
                IValueInfo v = this.types.get(beanType);
                if (v == null) continue;
                Element e_type = XMLUtilities.createElement((Element)e_types, (String)"bean-type");
                e_type.setAttribute("name", beanType.toString());
                XMLStoreHelper.saveValueInfo((Element)e_type, (IValueInfo)v, (Properties)context);
            }
        }
        element.setAttribute("precedence", "" + this.precedence);
        if (this.type != null && this.type != this.id) {
            XMLStoreHelper.saveType((Element)element, (IType)this.type, (String)"type", (Properties)context);
        }
        if (this.type != null) {
            context.put("type", this.type);
        }
        if (!(this.className == null || this.type != null && this.className.equals(this.type.getFullyQualifiedName()))) {
            element.setAttribute(ATTR_CLASS_NAME, this.className);
        }
        if (!this.bijectedAttributes.isEmpty()) {
            b = XMLUtilities.createElement((Element)element, (String)"bijected");
            for (IBijectedAttribute iBijectedAttribute : this.bijectedAttributes) {
                o = (SeamObject)((Object)iBijectedAttribute);
                o.toXML(b, context);
            }
        }
        if (!this.componentMethods.isEmpty()) {
            b = XMLUtilities.createElement((Element)element, (String)"methods");
            for (ISeamComponentMethod iSeamComponentMethod : this.componentMethods) {
                o = (SeamObject)((Object)iSeamComponentMethod);
                o.toXML(b, context);
            }
        }
        if (!this.roles.isEmpty()) {
            b = XMLUtilities.createElement((Element)element, (String)"roles");
            for (IRole iRole : this.roles) {
                o = (SeamObject)((Object)iRole);
                o.toXML(b, context);
            }
        }
        context.remove("type");
        return element;
    }

    @Override
    public void loadXML(Element element, Properties context) {
        SeamObject a;
        Element[] cs;
        String v;
        Element[] e_type;
        super.loadXML(element, context);
        this.setScope(element.getAttribute("scope"));
        Element e_types = XMLUtilities.getUniqueChild((Element)element, (String)"bean-types");
        if (e_types != null) {
            this.types = new HashMap<BeanType, IValueInfo>();
            e_type = XMLUtilities.getChildren((Element)e_types, (String)"bean-type");
            int i = 0;
            while (i < e_type.length) {
                block21: {
                    IValueInfo value;
                    String name = e_type[i].getAttribute("name");
                    BeanType t = null;
                    try {
                        t = BeanType.valueOf(name);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        break block21;
                    }
                    if (t != null && (value = XMLStoreHelper.loadValueInfo((Element)e_type[i], (Properties)context)) != null) {
                        this.types.put(t, value);
                    }
                }
                ++i;
            }
        }
        if (element.hasAttribute("precedence") && (v = element.getAttribute("precedence")) != null && v.length() > 0) {
            try {
                this.precedence = Integer.parseInt(v);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((e_type = XMLUtilities.getUniqueChild((Element)element, (String)"type")) != null) {
            this.type = XMLStoreHelper.loadType((Element)e_type, (Properties)context);
        } else if (this.id instanceof IType) {
            this.type = (IType)this.id;
        }
        if (this.type != null) {
            context.put("type", this.type);
        }
        if (element.hasAttribute(ATTR_CLASS_NAME)) {
            this.className = element.getAttribute(ATTR_CLASS_NAME);
        } else if (this.type != null) {
            this.className = this.type.getFullyQualifiedName();
        }
        Element b = XMLUtilities.getUniqueChild((Element)element, (String)"bijected");
        if (b != null) {
            cs = XMLUtilities.getChildren((Element)b, (String)"bijected-attribute");
            int i = 0;
            while (i < cs.length) {
                String cls = cs[i].getAttribute("class");
                BijectedAttribute a2 = null;
                a2 = "datamodel".equals(cls) ? new DataModelSelectionAttribute() : new BijectedAttribute();
                a2.loadXML(cs[i], context);
                this.addBijectedAttribute(a2);
                ++i;
            }
        }
        if ((b = XMLUtilities.getUniqueChild((Element)element, (String)"methods")) != null) {
            cs = XMLUtilities.getChildren((Element)b, (String)"method");
            int i = 0;
            while (i < cs.length) {
                a = new SeamComponentMethod();
                ((SeamComponentMethod)a).loadXML(cs[i], context);
                this.addMethod((ISeamComponentMethod)((Object)a));
                ++i;
            }
        }
        if ((b = XMLUtilities.getUniqueChild((Element)element, (String)"roles")) != null) {
            cs = XMLUtilities.getChildren((Element)b, (String)"role");
            int i = 0;
            while (i < cs.length) {
                a = new Role();
                ((SeamJavaContextVariable)a).loadXML(cs[i], context);
                this.addRole((IRole)((Object)a));
                ++i;
            }
        }
        context.remove("type");
    }
}

