/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core;

import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.project.ext.event.Change;
import org.jboss.tools.common.xml.XMLUtilities;
import org.jboss.tools.jst.web.model.project.ext.store.XMLStoreHelper;
import org.jboss.tools.seam.core.ISeamElement;
import org.jboss.tools.seam.core.ISeamProject;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeamObject
implements ISeamElement {
    protected Object id;
    protected IPath source;
    protected IResource resource = null;
    protected ISeamElement parent;

    @Override
    public ISeamProject getSeamProject() {
        return this.parent == null ? null : this.parent.getSeamProject();
    }

    public Object getId() {
        return this.id;
    }

    public void setId(Object id) {
        this.id = id;
    }

    public void setSourcePath(IPath path) {
        this.source = path;
    }

    @Override
    public IPath getSourcePath() {
        if (this.source == null && this.parent != null) {
            return this.parent.getSourcePath();
        }
        return this.source;
    }

    @Override
    public IResource getResource() {
        if (this.resource != null) {
            return this.resource;
        }
        if (this.source != null) {
            this.resource = ResourcesPlugin.getWorkspace().getRoot().getFile(this.source);
        }
        if (this.resource == null && this.parent != null) {
            return this.parent.getResource();
        }
        return this.resource;
    }

    @Override
    public ISeamElement getParent() {
        return this.parent;
    }

    public void setParent(ISeamElement parent) {
        this.parent = parent;
    }

    protected void adopt(ISeamElement child) {
        if (child.getSeamProject() != null && child.getSeamProject() != this.getSeamProject()) {
            return;
        }
        ((SeamObject)child).setParent(this);
    }

    @Override
    public List<Change> merge(ISeamElement s) {
        SeamObject o = (SeamObject)s;
        this.source = o.source;
        this.id = o.id;
        this.resource = o.resource;
        return null;
    }

    @Override
    public SeamObject clone() throws CloneNotSupportedException {
        SeamObject c = (SeamObject)super.clone();
        c.parent = null;
        return c;
    }

    public String getXMLName() {
        return "object";
    }

    public String getXMLClass() {
        return null;
    }

    @Override
    public Element toXML(Element parent, Properties context) {
        Element element = XMLUtilities.createElement((Element)parent, (String)this.getXMLName());
        if (this.getXMLClass() != null) {
            element.setAttribute("class", this.getXMLClass());
        }
        if (this.source != null && !this.source.equals(context.get("path"))) {
            element.setAttribute("path", this.source.toString());
        }
        if (this.id != null) {
            if (this.id instanceof String) {
                Element eid = XMLUtilities.createElement((Element)element, (String)"id");
                eid.setAttribute("class", "string");
                eid.setAttribute("value", this.id.toString());
            } else if (this.id instanceof IType) {
                XMLStoreHelper.saveType((Element)element, (IType)((IType)this.id), (String)"id", (Properties)context);
            } else if (this.id instanceof IField) {
                XMLStoreHelper.saveField((Element)element, (IField)((IField)this.id), (String)"id", (Properties)context);
            } else if (this.id instanceof IMethod) {
                XMLStoreHelper.saveMethod((Element)element, (IMethod)((IMethod)this.id), (String)"id", (Properties)context);
            } else if (this.id instanceof XModelObject) {
                XModelObject o = (XModelObject)this.id;
                XMLStoreHelper.saveModelObject((Element)element, (XModelObject)o, (String)"id", (Properties)context);
            }
        }
        return element;
    }

    @Override
    public void loadXML(Element element, Properties context) {
        String s = element.getAttribute("path");
        this.source = s != null && s.length() > 0 ? new Path(s) : (IPath)context.get("path");
        Element e_id = XMLUtilities.getUniqueChild((Element)element, (String)"id");
        if (e_id != null) {
            String cls = e_id.getAttribute("class");
            if ("string".equals(cls)) {
                this.id = e_id.getAttribute("string");
            } else if ("type".equals(cls)) {
                this.id = XMLStoreHelper.loadType((Element)e_id, (Properties)context);
            } else if ("field".equals(cls)) {
                this.id = XMLStoreHelper.loadField((Element)e_id, (Properties)context);
            } else if ("method".equals(cls)) {
                this.id = XMLStoreHelper.loadMethod((Element)e_id, (Properties)context);
            } else if ("model-object".equals(cls)) {
                this.id = XMLStoreHelper.loadModelObject((Element)e_id, (Properties)context);
            }
        }
    }

    public Object getAdapter(Class cls) {
        return null;
    }
}

