/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core;

import java.util.List;
import java.util.Properties;
import org.jboss.tools.common.model.project.ext.IValueInfo;
import org.jboss.tools.common.model.project.ext.event.Change;
import org.jboss.tools.jst.web.model.project.ext.store.XMLStoreHelper;
import org.jboss.tools.seam.core.ISeamElement;
import org.jboss.tools.seam.core.event.ISeamValueString;
import org.jboss.tools.seam.internal.core.SeamObject;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeamValueString
extends SeamObject
implements ISeamValueString {
    IValueInfo value;
    String currentValue;

    @Override
    public IValueInfo getValue() {
        return this.value;
    }

    public void setValue(IValueInfo value) {
        this.value = value;
        if (value != null) {
            this.currentValue = value.getValue();
        }
    }

    @Override
    public List<Change> merge(ISeamElement s) {
        List changes = super.merge(s);
        SeamValueString v = (SeamValueString)s;
        String v1 = this.currentValue;
        String v2 = v.value.getValue();
        if (v1 == null || !v1.equals(v2)) {
            changes = Change.addChange(changes, (Change)new Change((Object)this, "value", (Object)v1, (Object)v2));
        }
        this.setValue(v.value);
        return changes;
    }

    @Override
    public SeamValueString clone() throws CloneNotSupportedException {
        SeamValueString c = (SeamValueString)super.clone();
        return c;
    }

    @Override
    public String getXMLName() {
        return "value";
    }

    @Override
    public String getXMLClass() {
        return null;
    }

    @Override
    public Element toXML(Element parent, Properties context) {
        Element element = super.toXML(parent, context);
        if (this.value != null) {
            XMLStoreHelper.saveValueInfo((Element)element, (IValueInfo)this.value, (Properties)context);
        }
        return element;
    }

    @Override
    public void loadXML(Element element, Properties context) {
        super.loadXML(element, context);
        this.setValue(XMLStoreHelper.loadValueInfo((Element)element, (Properties)context));
    }
}

