/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core.el;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.graphics.Image;
import org.jboss.tools.common.el.core.ca.AbstractELCompletionEngine;
import org.jboss.tools.common.el.core.model.ELExpression;
import org.jboss.tools.common.el.core.model.ELInstance;
import org.jboss.tools.common.el.core.model.ELInvocationExpression;
import org.jboss.tools.common.el.core.model.ELObjectType;
import org.jboss.tools.common.el.core.model.ELPropertyInvocation;
import org.jboss.tools.common.el.core.parser.ELParserFactory;
import org.jboss.tools.common.el.core.parser.ELParserUtil;
import org.jboss.tools.common.el.core.resolver.ELCompletionEngine;
import org.jboss.tools.common.el.core.resolver.ELResolutionImpl;
import org.jboss.tools.common.el.core.resolver.ELSegment;
import org.jboss.tools.common.el.core.resolver.ElVarSearcher;
import org.jboss.tools.common.el.core.resolver.JavaMemberELSegment;
import org.jboss.tools.common.el.core.resolver.TypeInfoCollector;
import org.jboss.tools.common.text.TextProposal;
import org.jboss.tools.seam.core.IBijectedAttribute;
import org.jboss.tools.seam.core.ISeamComponent;
import org.jboss.tools.seam.core.ISeamContextShortVariable;
import org.jboss.tools.seam.core.ISeamContextVariable;
import org.jboss.tools.seam.core.ISeamMessages;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.ISeamXmlFactory;
import org.jboss.tools.seam.core.ScopeType;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.internal.core.el.SeamExpressionResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SeamELCompletionEngine
extends AbstractELCompletionEngine<ISeamContextVariable> {
    private static final Image SEAM_EL_PROPOSAL_IMAGE = SeamCorePlugin.getDefault().getImage("images/ca/icons_Seam_EL.gif");
    private static final Image SEAM_MESSAGES_PROPOSAL_IMAGE = SeamCorePlugin.getDefault().getImage("images/ca/icons_Message_Bundles.gif");
    private static ELParserFactory factory = ELParserUtil.getJbossFactory();

    public Image getELProposalImage() {
        return SEAM_EL_PROPOSAL_IMAGE;
    }

    public ELParserFactory getParserFactory() {
        return factory;
    }

    protected void log(Exception e) {
        SeamCorePlugin.getPluginLog().logError((Throwable)e);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public List<ISeamContextVariable> resolveSeamVariableFromEL(ISeamProject project, IFile file, String el) throws BadLocationException, StringIndexOutOfBoundsException {
        block6: {
            resolvedVariables /* !! */  = new ArrayList<ISeamContextVariable>();
            if (!el.startsWith("#{")) {
                el = "#{" + el + "}";
            }
            if ((is = (model = (parser = SeamELCompletionEngine.factory.createParser()).parse(el)).getInstances()).size() < 1) {
                return resolvedVariables /* !! */ ;
            }
            ex = ((ELInstance)is.get(0)).getExpression();
            if (!(ex instanceof ELInvocationExpression)) {
                return resolvedVariables /* !! */ ;
            }
            expr = (ELInvocationExpression)ex;
            isIncomplete = expr.getType() == ELObjectType.EL_PROPERTY_INVOCATION && ((ELPropertyInvocation)expr).getName() == null;
            left = expr;
            scope = SeamELCompletionEngine.getScope(project, (IResource)file);
            if (expr.getLeft() != null || !isIncomplete) ** GOTO lbl22
            resolvedVariables /* !! */  = this.resolveVariables(project, scope, expr, true, true);
            break block6;
lbl-1000:
            // 1 sources

            {
                resolvedVars = new ArrayList<E>();
                resolvedVars = this.resolveVariables(project, scope, left, left == expr, true);
                if (resolvedVars != null && !resolvedVars.isEmpty()) {
                    resolvedVariables /* !! */  = resolvedVars;
                    break;
                }
                left = left.getLeft();
lbl22:
                // 2 sources

                ** while (left != null)
            }
        }
        if (left != expr) {
            resolvedVariables /* !! */ .clear();
        }
        return resolvedVariables /* !! */ ;
    }

    public List<ISeamContextVariable> resolveVariables(IFile file, ELInvocationExpression expr, boolean isFinal, boolean onlyEqualNames) {
        ISeamProject project = SeamCorePlugin.getSeamProject(file.getProject(), false);
        ScopeType scope = SeamELCompletionEngine.getScope(project, (IResource)file);
        return this.resolveVariables(project, scope, expr, isFinal, onlyEqualNames);
    }

    protected TypeInfoCollector.MemberInfo getMemberInfoByVariable(ISeamContextVariable var, boolean onlyEqualNames) {
        return SeamExpressionResolver.getMemberInfoByVariable(var, true, this);
    }

    protected void setImage(TextProposal proposal, ISeamContextVariable var) {
        if (SeamELCompletionEngine.isSeamMessagesComponentVariable(var)) {
            proposal.setImage(SEAM_MESSAGES_PROPOSAL_IMAGE);
        } else {
            proposal.setImage(this.getELProposalImage());
        }
    }

    protected boolean isSingularAttribute(ISeamContextVariable var) {
        return var instanceof IBijectedAttribute;
    }

    protected void setImage(TextProposal kbProposal, TypeInfoCollector.MemberPresentation proposal) {
        if (proposal.getMember() instanceof SeamExpressionResolver.MessagesInfo) {
            kbProposal.setImage(SEAM_MESSAGES_PROPOSAL_IMAGE);
        } else {
            super.setImage(kbProposal, proposal);
        }
    }

    protected boolean isSingularMember(TypeInfoCollector.MemberInfo mbr) {
        return mbr instanceof SeamExpressionResolver.MessagesInfo;
    }

    protected void processSingularMember(TypeInfoCollector.MemberInfo mbr, Set<TextProposal> kbProposals) {
        if (mbr instanceof SeamExpressionResolver.MessagesInfo) {
            TreeSet<String> keys = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            keys.addAll(((SeamExpressionResolver.MessagesInfo)mbr).getKeys());
            for (String key : keys) {
                TextProposal proposal;
                if (key == null || key.length() == 0) continue;
                if (key.indexOf(46) != -1) {
                    proposal = new TextProposal();
                    proposal.setReplacementString("['" + key + "']");
                    proposal.setImage(SEAM_MESSAGES_PROPOSAL_IMAGE);
                    kbProposals.add(proposal);
                    continue;
                }
                proposal = new TextProposal();
                proposal.setReplacementString(key);
                proposal.setImage(SEAM_MESSAGES_PROPOSAL_IMAGE);
                kbProposals.add(proposal);
            }
        }
    }

    protected void filterSingularMember(TypeInfoCollector.MemberInfo mbr, Set<TypeInfoCollector.MemberPresentation> proposalsToFilter) {
        Collection<String> keys = ((SeamExpressionResolver.MessagesInfo)mbr).getKeys();
        for (String key : keys) {
            proposalsToFilter.add(new TypeInfoCollector.MemberPresentation(key, mbr));
        }
    }

    public static ScopeType getScope(ISeamProject project, IResource resource) {
        if (project == null || resource == null) {
            return null;
        }
        if (!"java".equals(resource.getFileExtension())) {
            return null;
        }
        Set<ISeamComponent> components = project.getComponentsByPath(resource.getFullPath());
        if (components.size() > 1) {
            return null;
        }
        Iterator<ISeamComponent> iterator = components.iterator();
        if (iterator.hasNext()) {
            ISeamComponent component = iterator.next();
            return component.getScope();
        }
        return null;
    }

    public List<ISeamContextVariable> resolveVariables(ISeamProject project, ScopeType scope, ELInvocationExpression expr, boolean isFinal, boolean onlyEqualNames) {
        List<Object> resolvedVars = new ArrayList();
        if (project == null) {
            return new ArrayList<ISeamContextVariable>();
        }
        String varName = expr.toString();
        if (varName != null) {
            resolvedVars = SeamExpressionResolver.resolveVariables(project, scope, varName, onlyEqualNames);
        }
        if (resolvedVars != null && !resolvedVars.isEmpty()) {
            ArrayList<ISeamContextVariable> newResolvedVars = new ArrayList<ISeamContextVariable>();
            for (ISeamContextVariable iSeamContextVariable : resolvedVars) {
                if (!isFinal) {
                    if (!varName.equals(iSeamContextVariable.getName())) continue;
                    newResolvedVars.add(iSeamContextVariable);
                    continue;
                }
                newResolvedVars.add(iSeamContextVariable);
            }
            return newResolvedVars;
        }
        return new ArrayList<ISeamContextVariable>();
    }

    public String getJavaElementExpression(IDocument document, int offset, IRegion region, int start, int end) throws StringIndexOutOfBoundsException {
        if (document == null || document.get() == null || offset > document.get().length()) {
            return null;
        }
        ELInvocationExpression expr = SeamELCompletionEngine.findExpressionAtOffset((IDocument)document, (int)(region.getOffset() + region.getLength()), (int)start, (int)end);
        if (expr == null) {
            return null;
        }
        ELInvocationExpression left = expr;
        while (left != null && left.getLeft() != null) {
            left = left.getLeft();
        }
        String prefixPart = document.get().substring(expr.getStartPosition(), offset);
        while (left != null) {
            String varText = left.getText();
            if (varText != null && varText.startsWith(prefixPart)) {
                return varText;
            }
            if (left == expr) break;
            left = (ELInvocationExpression)left.getParent();
        }
        return null;
    }

    public List<IJavaElement> getJavaElementsForExpression(ISeamProject project, IFile file, String expression) throws BadLocationException, StringIndexOutOfBoundsException {
        ELExpression expr = this.parseOperand(expression);
        if (!(expr instanceof ELInvocationExpression)) {
            return new ArrayList<IJavaElement>();
        }
        return this.getJavaElementsForELOperandTokens(project, file, (ELInvocationExpression)expr);
    }

    public List<IJavaElement> getJavaElementsForELOperandTokens(ISeamProject project, IFile file, ELInvocationExpression expr) throws BadLocationException, StringIndexOutOfBoundsException {
        IJavaElement el;
        ELSegment segment;
        ArrayList<IJavaElement> res = new ArrayList<IJavaElement>();
        ElVarSearcher varSearcher = new ElVarSearcher(file, (ELCompletionEngine)this);
        List vars = varSearcher.findAllVars(file, expr.getStartPosition());
        ELResolutionImpl resolution = this.resolveELOperand(file, (ELExpression)expr, true, vars, varSearcher);
        if (resolution.isResolved() && (segment = resolution.getLastSegment()) instanceof JavaMemberELSegment && (el = ((JavaMemberELSegment)segment).getJavaElement()) != null) {
            res.add(el);
            return res;
        }
        return res;
    }

    public static ISeamMessages getSeamMessagesComponentVariable(ISeamContextVariable variable) {
        if (variable instanceof ISeamMessages) {
            return (ISeamMessages)variable;
        }
        if (variable instanceof ISeamXmlFactory) {
            ISeamProject p;
            ISeamXmlFactory factory = (ISeamXmlFactory)variable;
            String value = factory.getValue();
            if (value != null && value.length() > 0) {
                if (value.startsWith("#{") || value.startsWith("${")) {
                    value = value.substring(2);
                }
                if (value.endsWith("}")) {
                    value = value.substring(0, value.length() - 1);
                }
            }
            if (value != null && value.length() > 0 && (p = factory.getSeamProject()) != null) {
                List<ISeamContextVariable> resolvedValues = SeamExpressionResolver.resolveVariables(p, null, value, true);
                for (ISeamContextVariable var : resolvedValues) {
                    if (!var.getName().equals(value) || !(var instanceof ISeamMessages)) continue;
                    return (ISeamMessages)var;
                }
            }
        } else if (variable instanceof ISeamContextShortVariable) {
            ISeamContextShortVariable sv = (ISeamContextShortVariable)variable;
            return SeamELCompletionEngine.getSeamMessagesComponentVariable(sv.getOriginal());
        }
        return null;
    }

    public static boolean isSeamMessagesComponentVariable(ISeamContextVariable variable) {
        return SeamELCompletionEngine.getSeamMessagesComponentVariable(variable) != null;
    }

    protected boolean isStaticMethodsCollectingEnabled() {
        return true;
    }
}

