/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core.project.facet;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.tools.ant.types.FilterSetCollection;
import org.apache.tools.ant.util.FileUtils;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.seam.core.SeamCoreMessages;
import org.jboss.tools.seam.core.SeamCorePlugin;

public class AntCopyUtils {
    public static void copyFilesAndFolders(File sourceFolder, File destinationFolder, FilterSetCollection set, boolean override) {
        AntCopyUtils.copyFilesAndFolders(sourceFolder, destinationFolder, null, set, override);
    }

    public static void copyFilesAndFolders(File sourceFolder, File destinationFolder, FileSetFileFilter fileSetFilter, FilterSetCollection filterSetCollection, boolean override) {
        File[] files;
        if (!sourceFolder.exists()) {
            throw new IllegalArgumentException(NLS.bind((String)SeamCoreMessages.ANT_COPY_UTILS_COPY_FAILED, (Object)sourceFolder));
        }
        File[] fileArray = files = fileSetFilter == null ? sourceFolder.listFiles() : sourceFolder.listFiles(fileSetFilter);
        if (files == null && fileSetFilter == null) {
            throw new IllegalArgumentException(NLS.bind((String)SeamCoreMessages.ANT_COPY_UTILS_COULD_NOT_FIND_FOLDER, (Object)sourceFolder));
        }
        File[] fileArray2 = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray2[n2];
            if (file.isDirectory()) {
                AntCopyUtils.copyFilesAndFolders(file, new File(destinationFolder, file.getName()), fileSetFilter, filterSetCollection, override);
            } else {
                try {
                    if (!destinationFolder.exists()) {
                        destinationFolder.mkdirs();
                    }
                    FileUtils.getFileUtils().copyFile(file, new File(destinationFolder, file.getName()), filterSetCollection, override);
                }
                catch (IOException e) {
                    SeamCorePlugin.getPluginLog().logError((Throwable)e);
                }
            }
            ++n2;
        }
        if (files.length == 0 && !destinationFolder.exists()) {
            destinationFolder.mkdir();
        }
    }

    public static void copyFileToFolder(File source, File dest, boolean override) {
        AntCopyUtils.copyFileToFolder(source, dest, new FilterSetCollection(), override);
    }

    public static void copyFileToFolder(File source, File dest, FilterSetCollection filterSetCollection, boolean override) {
        try {
            File destFile = new File(dest, source.getName());
            if (!source.getCanonicalPath().equals(destFile.getCanonicalPath())) {
                FileUtils.getFileUtils().copyFile(source, destFile, filterSetCollection, override);
            }
        }
        catch (IOException e) {
            SeamCorePlugin.getPluginLog().logError((Throwable)e);
        }
    }

    public static void copyFileToFile(File source, File dest, FilterSetCollection filterSetCollection, boolean override) {
        try {
            FileUtils.getFileUtils().copyFile(source, dest, filterSetCollection, override);
        }
        catch (IOException e) {
            SeamCorePlugin.getPluginLog().logError((Throwable)e);
        }
    }

    public static void copyFiles(File source, File dest, FileFilter filter, boolean override) {
        dest.mkdir();
        File[] listFiles = source.listFiles(filter);
        if (listFiles == null) {
            throw new IllegalArgumentException(NLS.bind((String)SeamCoreMessages.ANT_COPY_UTILS_COULD_NOT_FIND_FOLDER, (Object)source));
        }
        File[] fileArray = listFiles;
        int n = listFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!file.isDirectory()) {
                try {
                    FileUtils.getFileUtils().copyFile(file, new File(dest, file.getName()), new FilterSetCollection(), override);
                }
                catch (IOException e) {
                    SeamCorePlugin.getPluginLog().logError((Throwable)e);
                }
            }
            ++n2;
        }
    }

    public static void copyFiles(File source, File dest, FileFilter filter) {
        AntCopyUtils.copyFiles(source, dest, filter, true);
    }

    public static void copyFiles(String[] files, File dest) {
        AntCopyUtils.copyFiles(files, dest, true);
    }

    public static void copyFiles(String[] files, File dest, boolean override) {
        String[] stringArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            File file = new File(fileName);
            if (file.exists() && file.isFile()) {
                AntCopyUtils.copyFileToFolder(file, dest, null, override);
            } else {
                try {
                    SeamCorePlugin.getPluginLog().logError(NLS.bind((String)SeamCoreMessages.ANT_COPY_UTILS_CANNOT_COPY_JDBC_DRIVER_JAR, (Object)file.getCanonicalPath()));
                }
                catch (IOException e) {
                    SeamCorePlugin.getPluginLog().logError((Throwable)e);
                }
            }
            ++n2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FileSet {
        File dir = null;
        List<Pattern> include = new ArrayList<Pattern>();
        List<Pattern> exclude = new ArrayList<Pattern>();

        public FileSet(String dir) {
            this.dir = new File(dir);
        }

        public FileSet(File dir) {
            this.dir = dir;
        }

        public FileSet(FileSet template) {
            this.addTemplate(template);
        }

        public void addTemplate(FileSet template) {
            this.include.addAll(template.getIncluded());
            this.exclude.addAll(template.getExcluded());
        }

        public FileSet() {
        }

        public FileSet add(FileSet set) {
            this.addTemplate(set);
            return this;
        }

        public FileSet dir(String dir) {
            this.dir = new File(dir);
            return this;
        }

        public FileSet dir(File dir) {
            this.dir = dir;
            return this;
        }

        public FileSet include(String pattern) {
            this.include.add(Pattern.compile(pattern));
            return this;
        }

        public FileSet exclude(String pattern) {
            this.exclude.add(Pattern.compile(pattern));
            return this;
        }

        public boolean isIncluded(String file) {
            int i = this.dir.getAbsolutePath().length() + 1;
            String relatedPath = file.substring(i);
            for (Pattern pattern : this.include) {
                if (!pattern.matcher(relatedPath.replace('\\', '/')).matches()) continue;
                return !this.isExcluded(relatedPath);
            }
            return false;
        }

        public boolean isExcluded(String file) {
            for (Pattern pattern : this.exclude) {
                if (!pattern.matcher(file.replace('\\', '/')).matches()) continue;
                return true;
            }
            return false;
        }

        public List<Pattern> getExcluded() {
            return Collections.unmodifiableList(this.exclude);
        }

        public List<Pattern> getIncluded() {
            return Collections.unmodifiableList(this.include);
        }

        public File getDir() {
            return this.dir;
        }
    }

    public static class FileSetFileFilter
    implements FileFilter {
        FileSet set;

        public FileSetFileFilter(FileSet set) {
            this.set = set;
        }

        public boolean accept(File pathname) {
            return this.set.isIncluded(pathname.getAbsolutePath());
        }
    }
}

