/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core.refactoring;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.ltk.core.refactoring.Change;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.internal.core.refactoring.SeamProjectChange;
import org.osgi.service.prefs.BackingStoreException;

public class SeamJavaPackageRenameChange
extends SeamProjectChange {
    protected static String[] PACKAGE_NAME_PROPERTIES = new String[]{"model.package", "action.package", "test.package"};
    protected static String[] SOURCE_NAME_PROPERTIES = new String[]{"model.sources", "action.sources", "test.sources"};
    private IPackageFragmentRoot source;
    private String newName;
    private String oldName;
    private List<Integer> relevantPropertyIndexes = new ArrayList<Integer>();

    public SeamJavaPackageRenameChange(IProject project, IPackageFragmentRoot source, String newName, String oldName) {
        super(project);
        this.source = source;
        this.newName = newName;
        this.oldName = oldName;
        IEclipsePreferences ps = this.getSeamPreferences();
        int i = 0;
        while (i < PACKAGE_NAME_PROPERTIES.length) {
            String name = ps.get(PACKAGE_NAME_PROPERTIES[i], null);
            if (name != null && (oldName.equals(name) || name.startsWith(String.valueOf(oldName) + "."))) {
                this.relevantPropertyIndexes.add(new Integer(i));
            }
            ++i;
        }
    }

    public boolean isRelevant() {
        return !this.relevantPropertyIndexes.isEmpty();
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        if (!this.isRelevant()) {
            return null;
        }
        try {
            pm.beginTask(this.getName(), 1);
            IEclipsePreferences ps = this.getSeamPreferences();
            for (Integer index : this.relevantPropertyIndexes) {
                String packageProperty;
                String name;
                String sourceFolderProperty = ps.get(SOURCE_NAME_PROPERTIES[index], null);
                if (!this.source.getResource().getFullPath().toString().equals(sourceFolderProperty) || (name = ps.get(packageProperty = PACKAGE_NAME_PROPERTIES[index], null)) == null) continue;
                if (this.oldName.equals(name)) {
                    ps.put(packageProperty, this.newName);
                    continue;
                }
                if (!name.startsWith(String.valueOf(this.oldName) + ".")) continue;
                ps.put(packageProperty, String.valueOf(this.newName) + name.substring(this.oldName.length()));
            }
            try {
                ps.flush();
            }
            catch (BackingStoreException e) {
                SeamCorePlugin.getPluginLog().logError((Throwable)e);
            }
            SeamJavaPackageRenameChange seamJavaPackageRenameChange = new SeamJavaPackageRenameChange(this.project, this.source, this.oldName, this.newName);
            return seamJavaPackageRenameChange;
        }
        finally {
            pm.done();
        }
    }
}

