/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core.scanner.java;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.jboss.tools.common.model.project.ext.IValueInfo;
import org.jboss.tools.common.model.project.ext.impl.ValueInfo;
import org.jboss.tools.seam.core.BeanType;
import org.jboss.tools.seam.core.BijectedAttributeType;
import org.jboss.tools.seam.core.SeamComponentMethodType;
import org.jboss.tools.seam.internal.core.BijectedAttribute;
import org.jboss.tools.seam.internal.core.DataModelSelectionAttribute;
import org.jboss.tools.seam.internal.core.Role;
import org.jboss.tools.seam.internal.core.SeamAnnotatedFactory;
import org.jboss.tools.seam.internal.core.SeamComponentMethod;
import org.jboss.tools.seam.internal.core.SeamJavaComponentDeclaration;
import org.jboss.tools.seam.internal.core.scanner.LoadedDeclarations;
import org.jboss.tools.seam.internal.core.scanner.java.ASTVisitorImpl;
import org.jboss.tools.seam.internal.core.scanner.java.AnnotatedASTNode;
import org.jboss.tools.seam.internal.core.scanner.java.JavaScanner;
import org.jboss.tools.seam.internal.core.scanner.java.ResolvedAnnotation;
import org.jboss.tools.seam.internal.core.scanner.java.RolesVisitor;
import org.jboss.tools.seam.internal.core.scanner.java.SeamAnnotations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentBuilder
implements SeamAnnotations {
    LoadedDeclarations ds = null;
    AnnotatedASTNode<?> annotatedType = null;
    Set<AnnotatedASTNode<FieldDeclaration>> annotatedFields = null;
    Set<AnnotatedASTNode<MethodDeclaration>> annotatedMethods = null;
    SeamJavaComponentDeclaration component = new SeamJavaComponentDeclaration();

    public ComponentBuilder(LoadedDeclarations ds, ASTVisitorImpl.TypeData visitor) {
        this.ds = ds;
        this.annotatedType = visitor.annotatedType;
        this.annotatedFields = visitor.annotatedFields;
        this.annotatedMethods = visitor.annotatedMethods;
        String n = visitor.type.getElementName();
        n = JavaScanner.getResolvedType(visitor.type, n);
        ds.getComponents().add(this.component);
        this.component.setType(visitor.type);
        this.component.setId(visitor.type);
        this.component.setClassName(n);
    }

    void process() {
        if (this.annotatedType == null) {
            return;
        }
        ResolvedAnnotation[] as = this.annotatedType.getAnnotations();
        if (as != null) {
            int i = 0;
            while (i < as.length) {
                String type = as[i].getType();
                if ("org.jboss.seam.annotations.Name".equals(type)) {
                    this.component.setName((IValueInfo)ValueInfo.getValueInfo((Annotation)as[i].getAnnotation(), null));
                } else if ("org.jboss.seam.annotations.Scope".equals(type)) {
                    int q;
                    ValueInfo scope = ValueInfo.getValueInfo((Annotation)as[i].getAnnotation(), null);
                    if (scope != null && scope.getValue() != null && (q = scope.getValue().lastIndexOf(46)) >= 0) {
                        scope.setValue(scope.getValue().substring(q + 1).toLowerCase());
                    }
                    this.component.setScope((IValueInfo)scope);
                } else if ("org.jboss.seam.annotations.Install".equals(type)) {
                    this.component.setPrecedence((IValueInfo)ValueInfo.getValueInfo((Annotation)as[i].getAnnotation(), (String)"precedence"));
                }
                ++i;
            }
        }
        if (as != null) {
            HashMap<BeanType, IValueInfo> types = new HashMap<BeanType, IValueInfo>();
            int i = 0;
            while (i < BeanType.values().length) {
                Annotation a = this.findAnnotation(this.annotatedType, BeanType.values()[i].getAnnotationType());
                if (a != null) {
                    ValueInfo v = new ValueInfo();
                    v.setValue("true");
                    v.valueStartPosition = a.getStartPosition();
                    v.valueLength = a.getLength();
                    types.put(BeanType.values()[i], (IValueInfo)v);
                }
                ++i;
            }
            if (!types.isEmpty()) {
                this.component.setTypes(types);
            }
        }
        this.processFactories();
        this.processBijections();
        this.processComponentMethods();
        this.processRoles();
    }

    void processFactories() {
        for (AnnotatedASTNode<MethodDeclaration> n : this.annotatedMethods) {
            Annotation a = this.findAnnotation(n, "org.jboss.seam.annotations.Factory");
            if (a == null) continue;
            MethodDeclaration m = n.getNode();
            ValueInfo factoryName = ValueInfo.getValueInfo((Annotation)a, null);
            if (factoryName == null) {
                factoryName = new ValueInfo();
                factoryName.setValue(this.toPropertyName(m.getName().getIdentifier(), "get"));
                factoryName.valueLength = m.getName().getLength();
                factoryName.valueStartPosition = m.getName().getStartPosition();
            }
            ValueInfo scope = ValueInfo.getValueInfo((Annotation)a, (String)"scope");
            ValueInfo autoCreate = ValueInfo.getValueInfo((Annotation)a, (String)"autoCreate");
            SeamAnnotatedFactory factory = new SeamAnnotatedFactory();
            factory.setParentDeclaration(this.component);
            IMethod im = this.findMethod(m);
            factory.setSourceMember((IMember)im);
            factory.setId(im);
            factory.setSourcePath(this.component.getSourcePath());
            factory.setName((IValueInfo)factoryName);
            if (autoCreate != null) {
                factory.setAutoCreate(true);
            }
            if (scope != null) {
                factory.setScope((IValueInfo)scope);
            }
            ValueInfo _a = new ValueInfo();
            _a.setValue("org.jboss.seam.annotations.Factory");
            _a.valueStartPosition = a.getStartPosition();
            _a.valueLength = a.getLength();
            factory.addAttribute("org.jboss.seam.annotations.Factory", (IValueInfo)_a);
            this.ds.getFactories().add(factory);
        }
    }

    private String toPropertyName(String methodName, String prefix) {
        if (methodName == null) {
            return methodName;
        }
        if (methodName.startsWith(prefix) && methodName.length() > prefix.length()) {
            String root = methodName.substring(prefix.length());
            return String.valueOf(root.substring(0, 1).toLowerCase()) + root.substring(1);
        }
        return methodName;
    }

    void processBijections() {
        BijectedAttribute att;
        MethodDeclaration m;
        boolean isDataModelSelectionType;
        Annotation main;
        HashMap<BijectedAttributeType, Annotation> as = new HashMap<BijectedAttributeType, Annotation>();
        ArrayList<BijectedAttributeType> types = new ArrayList<BijectedAttributeType>();
        for (AnnotatedASTNode<MethodDeclaration> annotatedASTNode : this.annotatedMethods) {
            main = this.getBijectedType(annotatedASTNode, as, types);
            if (as.isEmpty()) continue;
            isDataModelSelectionType = !((BijectedAttributeType)types.get(0)).isUsingMemberName();
            m = annotatedASTNode.getNode();
            att = this.createBijectedAttribute(types);
            Annotation in = (Annotation)as.get(BijectedAttributeType.IN);
            Annotation out = (Annotation)as.get(BijectedAttributeType.OUT);
            Annotation data = (Annotation)as.get(BijectedAttributeType.DATA_BINDER);
            this.addLocation(att, in, "org.jboss.seam.annotations.In");
            this.addLocation(att, out, "org.jboss.seam.annotations.Out");
            this.addLocation(att, data, "org.jboss.seam.annotations.datamodel.DataModel");
            ValueInfo name = ValueInfo.getValueInfo((Annotation)main, null);
            att.setValue((IValueInfo)name);
            if (name == null || isDataModelSelectionType || name.getValue() == null || name.getValue().length() == 0) {
                name = new ValueInfo();
                name.valueStartPosition = m.getStartPosition();
                name.valueLength = m.getLength();
                name.setValue(m.getName().getIdentifier());
                if (in != null) {
                    name.setValue(this.toPropertyName(name.getValue(), "set"));
                } else if (out != null || data != null) {
                    name.setValue(this.toPropertyName(name.getValue(), "get"));
                }
            }
            att.setName((IValueInfo)name);
            ValueInfo scope = ValueInfo.getValueInfo((Annotation)main, (String)"scope");
            if (scope != null) {
                att.setScope((IValueInfo)scope);
            }
            IMethod im = this.findMethod(m);
            att.setSourceMember((IMember)im);
            att.setId(im);
        }
        for (AnnotatedASTNode<MethodDeclaration> annotatedASTNode : this.annotatedFields) {
            main = this.getBijectedType(annotatedASTNode, as, types);
            if (as.isEmpty()) continue;
            isDataModelSelectionType = !((BijectedAttributeType)types.get(0)).isUsingMemberName();
            m = (FieldDeclaration)annotatedASTNode.getNode();
            att = this.createBijectedAttribute(types);
            this.addLocation(att, (Annotation)as.get(BijectedAttributeType.IN), "org.jboss.seam.annotations.In");
            this.addLocation(att, (Annotation)as.get(BijectedAttributeType.OUT), "org.jboss.seam.annotations.Out");
            this.addLocation(att, (Annotation)as.get(BijectedAttributeType.DATA_BINDER), "org.jboss.seam.annotations.datamodel.DataModel");
            ValueInfo name = ValueInfo.getValueInfo((Annotation)main, null);
            att.setValue((IValueInfo)name);
            if (name == null || isDataModelSelectionType || name.getValue() == null || name.getValue().length() == 0) {
                name = new ValueInfo();
                name.valueStartPosition = m.getStartPosition();
                name.valueLength = m.getLength();
                name.setValue(this.getFieldName((FieldDeclaration)m));
            }
            att.setName((IValueInfo)name);
            ValueInfo scope = ValueInfo.getValueInfo((Annotation)main, (String)"scope");
            if (scope != null) {
                att.setScope((IValueInfo)scope);
            }
            IField f = this.findField((FieldDeclaration)m);
            att.setSourceMember((IMember)f);
            att.setId(f);
        }
    }

    private Annotation getBijectedType(AnnotatedASTNode<?> n, Map<BijectedAttributeType, Annotation> as, List<BijectedAttributeType> types) {
        as.clear();
        types.clear();
        Annotation main = null;
        int i = 0;
        while (i < BijectedAttributeType.values().length) {
            Annotation a = this.findAnnotation(n, BijectedAttributeType.values()[i].getAnnotationType());
            if (a != null) {
                as.put(BijectedAttributeType.values()[i], a);
                if (main == null) {
                    main = a;
                }
                types.add(BijectedAttributeType.values()[i]);
            }
            ++i;
        }
        return main;
    }

    private BijectedAttribute createBijectedAttribute(List<BijectedAttributeType> types) {
        boolean isDataModelSelectionType = !types.get(0).isUsingMemberName();
        BijectedAttribute att = !isDataModelSelectionType ? new BijectedAttribute() : new DataModelSelectionAttribute();
        this.component.addBijectedAttribute(att);
        att.setTypes(types.toArray(new BijectedAttributeType[0]));
        return att;
    }

    private void addLocation(BijectedAttribute att, Annotation a, String name) {
        if (a != null) {
            ValueInfo _a = new ValueInfo();
            _a.setValue(name);
            _a.valueStartPosition = a.getStartPosition();
            _a.valueLength = a.getLength();
            att.addAttribute(name, (IValueInfo)_a);
        }
    }

    void processComponentMethods() {
        for (AnnotatedASTNode<MethodDeclaration> n : this.annotatedMethods) {
            SeamComponentMethod cm = null;
            int i = 0;
            while (i < SeamComponentMethodType.values().length) {
                SeamComponentMethodType type = SeamComponentMethodType.values()[i];
                Annotation a = this.findAnnotation(n, type.getAnnotationType());
                if (a != null) {
                    if (cm == null) {
                        cm = new SeamComponentMethod();
                        this.component.addMethod(cm);
                        MethodDeclaration m = n.getNode();
                        IMethod im = this.findMethod(m);
                        cm.setSourceMember((IMember)im);
                        cm.setId(im);
                    }
                    cm.getTypes().add(type);
                }
                ++i;
            }
        }
    }

    void processRoles() {
        ResolvedAnnotation[] as;
        Annotation roles = this.findAnnotation(this.annotatedType, "org.jboss.seam.annotations.Roles");
        if (roles != null) {
            RolesVisitor visitor = new RolesVisitor((IType)this.component.getSourceMember());
            roles.accept((ASTVisitor)visitor);
            List<Annotation> rs = visitor.annotations;
            if (rs != null) {
                for (Annotation role : rs) {
                    this.createRole(role);
                }
            }
        }
        if ((as = this.annotatedType.getAnnotations()) != null) {
            int i = 0;
            while (i < as.length) {
                if ("org.jboss.seam.annotations.Role".equals(as[i].getType())) {
                    this.createRole(as[i].getAnnotation());
                }
                ++i;
            }
        }
    }

    void createRole(Annotation role) {
        Role r = new Role();
        r.setSourcePath(this.component.getSourcePath());
        r.setSourceMember(this.component.getSourceMember());
        ValueInfo name = ValueInfo.getValueInfo((Annotation)role, (String)"name");
        if (name == null) {
            return;
        }
        r.setId(this.component.getName() + ":" + name.getValue());
        r.setName((IValueInfo)name);
        ValueInfo scope = ValueInfo.getValueInfo((Annotation)role, (String)"scope");
        if (scope != null) {
            r.setScope((IValueInfo)scope);
        }
        this.component.addRole(r);
    }

    private Annotation findAnnotation(AnnotatedASTNode<?> n, String type) {
        ResolvedAnnotation[] as = n.getAnnotations();
        if (as == null) {
            return null;
        }
        int i = 0;
        while (i < as.length) {
            if (type.equals(as[i].getType())) {
                return as[i].getAnnotation();
            }
            ++i;
        }
        return null;
    }

    private IMethod findMethod(MethodDeclaration m) {
        if (m == null || m.getName() == null) {
            return null;
        }
        IType type = (IType)this.component.getSourceMember();
        IMethod[] ms = null;
        try {
            ms = type.getMethods();
        }
        catch (JavaModelException javaModelException) {}
        String name = m.getName().getIdentifier();
        if (ms != null) {
            int i = 0;
            while (i < ms.length) {
                if (name.equals(ms[i].getElementName())) {
                    int s = m.getStartPosition() + m.getLength() / 2;
                    try {
                        ISourceRange range = ms[i].getSourceRange();
                        if (range == null) {
                            return ms[i];
                        }
                        int b = range.getOffset();
                        int e = b + range.getLength();
                        if (s >= b && s <= e) {
                            return ms[i];
                        }
                    }
                    catch (JavaModelException javaModelException) {
                        return ms[i];
                    }
                }
                ++i;
            }
        }
        return null;
    }

    private IField findField(FieldDeclaration f) {
        if (f == null || this.getFieldName(f) == null) {
            return null;
        }
        IType type = (IType)this.component.getSourceMember();
        IField[] fs = null;
        try {
            fs = type.getFields();
        }
        catch (JavaModelException javaModelException) {}
        String name = this.getFieldName(f);
        if (fs != null) {
            int i = 0;
            while (i < fs.length) {
                if (name.equals(fs[i].getElementName())) {
                    int s = f.getStartPosition() + f.getLength() / 2;
                    try {
                        ISourceRange range = fs[i].getSourceRange();
                        if (range == null) {
                            return fs[i];
                        }
                        int b = range.getOffset();
                        int e = b + range.getLength();
                        if (s >= b && s <= e) {
                            return fs[i];
                        }
                    }
                    catch (JavaModelException javaModelException) {
                        return fs[i];
                    }
                }
                ++i;
            }
        }
        return null;
    }

    String getFieldName(FieldDeclaration node) {
        int i = 0;
        List fragments = node.fragments();
        if (i < fragments.size()) {
            VariableDeclaration vd = (VariableDeclaration)fragments.get(i);
            String name = vd.getName().getIdentifier();
            return name;
        }
        return null;
    }
}

