/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core.scanner.java;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTRequestor;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.model.util.EclipseJavaUtil;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.SeamCoreMessages;
import org.jboss.tools.seam.internal.core.scanner.IFileScanner;
import org.jboss.tools.seam.internal.core.scanner.LoadedDeclarations;
import org.jboss.tools.seam.internal.core.scanner.ScannerException;
import org.jboss.tools.seam.internal.core.scanner.java.ASTVisitorImpl;
import org.jboss.tools.seam.internal.core.scanner.java.ComponentBuilder;
import org.jboss.tools.seam.internal.core.scanner.java.PackageInfoRequestor;

public class JavaScanner
implements IFileScanner {
    public boolean isRelevant(IFile resource) {
        return resource.getName().endsWith(".java");
    }

    public boolean isLikelyComponentSource(IFile f) {
        if (!f.isSynchronized(0) || !f.exists()) {
            return false;
        }
        String content = FileUtil.readFile((File)f.getLocation().toFile());
        if (content == null) {
            return false;
        }
        int a = content.indexOf("org.jboss.seam.annotations.");
        if (a < 0 && (a = content.indexOf("javax.ejb.")) < 0) {
            return false;
        }
        int i = content.indexOf("@");
        return i >= 0;
    }

    public LoadedDeclarations parse(IFile f, ISeamProject sp) throws ScannerException {
        ICompilationUnit u = null;
        try {
            u = this.getCompilationUnit(f);
        }
        catch (CoreException e) {
            throw new ScannerException(NLS.bind((String)SeamCoreMessages.JAVA_SCANNER_CANNOT_GET_COMPILATION_UNIT_FOR, (Object)f), e);
        }
        if (u == null) {
            return null;
        }
        ICompilationUnit[] us = new ICompilationUnit[]{u};
        ASTParser p = ASTParser.newParser((int)3);
        p.setSource(u);
        p.setResolveBindings(true);
        if ("package-info.java".equals(f.getFullPath().lastSegment())) {
            PackageInfoRequestor requestor = new PackageInfoRequestor((IResource)f);
            p.createASTs(us, new String[0], (ASTRequestor)requestor, null);
            return requestor.getDeclarations();
        }
        ASTRequestorImpl requestor = new ASTRequestorImpl((IResource)f);
        p.createASTs(us, new String[0], (ASTRequestor)requestor, null);
        return requestor.getDeclarations();
    }

    private ICompilationUnit getCompilationUnit(IFile f) throws CoreException {
        IProject project = f.getProject();
        IJavaProject javaProject = (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature");
        IResource[] rs = EclipseResourceUtil.getJavaSourceRoots((IProject)project);
        int i = 0;
        while (i < rs.length) {
            if (rs[i].getFullPath().isPrefixOf(f.getFullPath())) {
                IJavaElement ep;
                IPath path = f.getFullPath().removeFirstSegments(rs[i].getFullPath().segmentCount());
                IJavaElement e = javaProject.findElement(path);
                if (e == null && path.lastSegment().equals("package-info.java") && (ep = javaProject.findElement(path.removeLastSegments(1))) instanceof IPackageFragment) {
                    e = ((IPackageFragment)ep).getCompilationUnit("package-info.java");
                }
                if (e instanceof ICompilationUnit) {
                    return (ICompilationUnit)e;
                }
            }
            ++i;
        }
        return null;
    }

    static String getResolvedType(IType type, String n) {
        String result = EclipseJavaUtil.resolveType((IType)type, (String)n);
        return result == null ? n : result;
    }

    class ASTRequestorImpl
    extends ASTRequestor {
        private ASTVisitorImpl visitor = new ASTVisitorImpl();
        LoadedDeclarations ds = new LoadedDeclarations();
        IResource resource;
        IPath sourcePath;

        public ASTRequestorImpl(IResource resource) {
            this.resource = resource;
            this.sourcePath = resource.getFullPath();
        }

        public LoadedDeclarations getDeclarations() {
            return this.ds;
        }

        public void acceptAST(ICompilationUnit source, CompilationUnit ast) {
            IType[] ts = null;
            try {
                ts = source.getTypes();
            }
            catch (JavaModelException javaModelException) {}
            if (ts == null || ts.length == 0) {
                return;
            }
            int i = 0;
            while (i < ts.length) {
                block8: {
                    this.visitor.setType(null);
                    int f = 0;
                    try {
                        f = ts[i].getFlags();
                    }
                    catch (JavaModelException javaModelException) {
                        break block8;
                    }
                    if (Flags.isPublic((int)f)) {
                        this.visitor.setType(ts[i]);
                        ast.accept((ASTVisitor)this.visitor);
                        if (this.visitor.hasSeamComponent()) {
                            this.processTypeData(this.visitor.root);
                        }
                    }
                }
                ++i;
            }
        }

        private void processTypeData(ASTVisitorImpl.TypeData data) {
            if (data.hasSeamComponentItself()) {
                ComponentBuilder b = new ComponentBuilder(this.ds, data);
                b.component.setSourcePath(this.sourcePath);
                b.component.setResource(this.resource);
                b.process();
            }
            for (ASTVisitorImpl.TypeData c : data.children) {
                this.processTypeData(c);
            }
        }
    }
}

