/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.jboss.tools.common.el.core.resolver.TypeInfoCollector;
import org.jboss.tools.common.java.IJavaSourceReference;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.text.ITextSourceReference;
import org.jboss.tools.jst.web.kb.IKbProject;
import org.jboss.tools.jst.web.kb.KbProjectFactory;
import org.jboss.tools.jst.web.kb.internal.KbProject;
import org.jboss.tools.jst.web.kb.internal.validation.ContextValidationHelper;
import org.jboss.tools.jst.web.kb.internal.validation.ValidatingProjectSet;
import org.jboss.tools.jst.web.kb.internal.validation.ValidatorManager;
import org.jboss.tools.jst.web.kb.validation.IValidatingProjectSet;
import org.jboss.tools.jst.web.kb.validation.IValidationContext;
import org.jboss.tools.jst.web.kb.validation.ValidationUtil;
import org.jboss.tools.seam.core.BijectedAttributeType;
import org.jboss.tools.seam.core.IBijectedAttribute;
import org.jboss.tools.seam.core.ISeamAnnotatedFactory;
import org.jboss.tools.seam.core.ISeamComponent;
import org.jboss.tools.seam.core.ISeamComponentDeclaration;
import org.jboss.tools.seam.core.ISeamComponentMethod;
import org.jboss.tools.seam.core.ISeamContextVariable;
import org.jboss.tools.seam.core.ISeamFactory;
import org.jboss.tools.seam.core.ISeamJavaComponentDeclaration;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.ISeamProperty;
import org.jboss.tools.seam.core.ISeamXmlComponentDeclaration;
import org.jboss.tools.seam.core.ISeamXmlFactory;
import org.jboss.tools.seam.core.ScopeType;
import org.jboss.tools.seam.core.SeamComponentMethodType;
import org.jboss.tools.seam.core.SeamCoreMessages;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.core.SeamPreferences;
import org.jboss.tools.seam.core.SeamProjectsSet;
import org.jboss.tools.seam.core.SeamUtil;
import org.jboss.tools.seam.core.project.facet.SeamRuntime;
import org.jboss.tools.seam.internal.core.DataModelSelectionAttribute;
import org.jboss.tools.seam.internal.core.SeamComponentDeclaration;
import org.jboss.tools.seam.internal.core.SeamProject;
import org.jboss.tools.seam.internal.core.SeamTextSourceReference;
import org.jboss.tools.seam.internal.core.validation.SeamValidationErrorManager;
import org.jboss.tools.seam.internal.core.validation.SeamValidationMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeamCoreValidator
extends SeamValidationErrorManager
implements org.jboss.tools.jst.web.kb.validation.IValidator {
    public static final String ID = "org.jboss.tools.seam.core.CoreValidator";
    private ISeamProject seamProject;
    private String projectName;

    public String getId() {
        return ID;
    }

    public IValidatingProjectSet getValidatingProjects(IProject project) {
        return SeamCoreValidator.getSeamValidatingProjects(project);
    }

    public static IValidatingProjectSet getSeamValidatingProjects(IProject project) {
        ISeamProject seamProject;
        SeamProjectsSet set = new SeamProjectsSet(project);
        IProject war = set.getWarProject();
        IValidationContext rootContext = null;
        if (war != null && war.isAccessible()) {
            IKbProject kbProject = KbProjectFactory.getKbProject((IProject)war, (boolean)false);
            if (kbProject != null) {
                rootContext = kbProject.getValidationContext();
            } else {
                KbProject.checkKBBuilderInstalled((IResource)war);
                ISeamProject seamProject2 = SeamCorePlugin.getSeamProject(war, false);
                if (seamProject2 != null) {
                    rootContext = seamProject2.getValidationContext();
                }
            }
        }
        if (rootContext == null && (seamProject = SeamCorePlugin.getSeamProject(project, false)) != null) {
            rootContext = seamProject.getValidationContext();
        }
        ArrayList<IProject> projects = new ArrayList<IProject>();
        IProject[] array = set.getAllProjects();
        int i = 0;
        while (i < array.length) {
            if (array[i].isAccessible()) {
                projects.add(array[i]);
            }
            ++i;
        }
        return new ValidatingProjectSet(project, projects, rootContext);
    }

    public boolean shouldValidate(IProject project) {
        try {
            return project != null && project.isAccessible() && project.hasNature("org.jboss.tools.seam.core.seamnature");
        }
        catch (CoreException e) {
            SeamCorePlugin.getDefault().logError(e);
            return false;
        }
    }

    public void init(IProject project, ContextValidationHelper validationHelper, IValidator manager, IReporter reporter) {
        super.init(project, validationHelper, manager, reporter);
        SeamProjectsSet set = new SeamProjectsSet(project);
        IProject warProject = set.getWarProject();
        if (warProject.isAccessible()) {
            this.seamProject = SeamCorePlugin.getSeamProject(warProject, false);
            this.projectName = this.seamProject.getProject().getName();
        }
    }

    private boolean isPreferencesEnabled(IProject project) {
        return SeamPreferences.shouldValidateCore(project);
    }

    public IStatus validate(Set<IFile> changedFiles, IProject project, ContextValidationHelper validationHelper, ValidatorManager manager, IReporter reporter) throws ValidationException {
        this.init(project, validationHelper, (IValidator)manager, reporter);
        if (this.seamProject == null) {
            return this.OK_STATUS;
        }
        this.displaySubtask(SeamValidationMessages.SEARCHING_RESOURCES, new String[]{this.projectName});
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        HashSet<ISeamComponent> checkedComponents = new HashSet<ISeamComponent>();
        HashSet<String> markedDuplicateFactoryNames = new HashSet<String>();
        HashSet<Object> resources = new HashSet<Object>();
        HashSet<IPath> newResources = new HashSet<IPath>();
        boolean validateUnnamedResources = false;
        for (IFile currentFile : changedFiles) {
            Object linkedResources;
            if (reporter.isCancelled()) break;
            if (!validateUnnamedResources) {
                String string = currentFile.getName().toLowerCase();
                boolean bl = validateUnnamedResources = string.endsWith(".java") || string.endsWith(".properties") || string.equals("components.xml");
            }
            if (!ValidationUtil.checkFileExtensionForJavaAndXml((IFile)currentFile)) continue;
            resources.add(currentFile.getFullPath());
            Set<String> set = this.getVariablesNameByResource(currentFile.getFullPath());
            Set oldDeclarationsOfChangedFile = this.validationContext.getVariableNamesByCoreResource(currentFile.getFullPath(), true);
            for (String newVariableName : set) {
                linkedResources = this.validationContext.getCoreResourcesByVariableName(newVariableName, false);
                if (linkedResources != null) {
                    resources.addAll((Collection<Object>)linkedResources);
                }
                resources.addAll(this.getAllResourceOfComponent(currentFile.getFullPath()));
            }
            Set oldVariablesNamesOfChangedFile = this.validationContext.getVariableNamesByCoreResource(currentFile.getFullPath(), false);
            if (oldVariablesNamesOfChangedFile != null) {
                for (String name : oldVariablesNamesOfChangedFile) {
                    Set linkedResources2 = this.validationContext.getCoreResourcesByVariableName(name, false);
                    if (linkedResources2 == null) continue;
                    resources.addAll(linkedResources2);
                }
            }
            if (oldDeclarationsOfChangedFile != null) {
                linkedResources = oldDeclarationsOfChangedFile.iterator();
                while (linkedResources.hasNext()) {
                    String name;
                    name = (String)linkedResources.next();
                    this.validationContext.addVariableNameForELValidation(name);
                }
            }
            newResources.add(currentFile.getFullPath());
        }
        this.validationContext.removeLinkedCoreResources(resources);
        IFile[] filesToValidate = new IFile[resources.size()];
        int i = 0;
        for (IPath iPath : resources) {
            filesToValidate[i] = root.getFile(iPath);
            this.removeAllMessagesFromResource((IResource)filesToValidate[i++]);
        }
        i = 0;
        for (IPath iPath : resources) {
            this.validateComponent(iPath, checkedComponents, newResources);
            this.validateFactory(iPath, markedDuplicateFactoryNames);
            this.validateXMLVersion(filesToValidate[i++]);
        }
        if (validateUnnamedResources) {
            Set set = this.validationContext.getUnnamedCoreResources();
            newResources.addAll(set);
            for (IPath path : newResources) {
                IFile file = root.getFile(path);
                if (file == null || !file.exists()) continue;
                if (!resources.contains(path)) {
                    this.removeAllMessagesFromResource((IResource)file);
                }
                this.displaySubtask(SeamValidationMessages.VALIDATING_RESOURCE, new String[]{this.projectName, path.toString()});
                Set<ISeamJavaComponentDeclaration> declarations = ((SeamProject)this.seamProject).findJavaDeclarations(path);
                for (ISeamJavaComponentDeclaration d : declarations) {
                    this.validateMethodsOfUnknownComponent(d);
                }
            }
        }
        return this.OK_STATUS;
    }

    public IStatus validateAll(IProject project, ContextValidationHelper validationHelper, ValidatorManager manager, IReporter reporter) throws ValidationException {
        ISeamJavaComponentDeclaration[] values;
        Object object;
        ISeamComponent[] components;
        this.init(project, validationHelper, (IValidator)manager, reporter);
        if (this.seamProject == null) {
            return this.OK_STATUS;
        }
        this.removeAllMessagesFromResource((IResource)this.seamProject.getProject());
        ISeamComponent[] iSeamComponentArray = components = this.seamProject.getComponents();
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            ISeamComponent component = iSeamComponentArray[n2];
            if (reporter.isCancelled()) {
                return this.OK_STATUS;
            }
            Set<ISeamComponentDeclaration> declarations = component.getAllDeclarations();
            object = declarations.iterator();
            if (object.hasNext()) {
                ISeamComponentDeclaration cfr_ignored_0 = (ISeamComponentDeclaration)object.next();
                this.validateComponent(component);
            }
            ++n2;
        }
        ISeamFactory[] factories = this.seamProject.getFactories();
        HashSet<String> markedDuplicateFactoryNames = new HashSet<String>();
        object = factories;
        int n3 = factories.length;
        int n4 = 0;
        while (n4 < n3) {
            Object factory = object[n4];
            if (reporter.isCancelled()) {
                return this.OK_STATUS;
            }
            this.validateFactory((ISeamFactory)factory, markedDuplicateFactoryNames);
            ++n4;
        }
        ISeamJavaComponentDeclaration[] iSeamJavaComponentDeclarationArray = values = ((SeamProject)this.seamProject).getAllJavaComponentDeclarations();
        int n5 = values.length;
        n3 = 0;
        while (n3 < n5) {
            ISeamJavaComponentDeclaration d = iSeamJavaComponentDeclarationArray[n3];
            if (reporter.isCancelled()) {
                return this.OK_STATUS;
            }
            this.displaySubtask(SeamValidationMessages.VALIDATING_CLASS, new String[]{this.projectName, d.getClassName()});
            this.validateMethodsOfUnknownComponent(d);
            ++n3;
        }
        return this.OK_STATUS;
    }

    private void validateFactory(IPath sourceFilePath, Set<String> markedDuplicateFactoryNames) {
        Set<ISeamFactory> factories = this.seamProject.getFactoriesByPath(sourceFilePath);
        for (ISeamFactory factory : factories) {
            this.validateFactory(factory, markedDuplicateFactoryNames);
        }
    }

    private void validateFactory(ISeamFactory factory, Set<String> markedDuplicateFactoryNames) {
        if (SeamUtil.isJar(factory.getSourcePath())) {
            return;
        }
        String factoryName = factory.getName();
        if (factoryName != null) {
            this.displaySubtask(SeamValidationMessages.VALIDATING_FACTORY, new String[]{this.projectName, factoryName});
        }
        if (factory instanceof ISeamAnnotatedFactory) {
            this.validateAnnotatedFactory((ISeamAnnotatedFactory)factory, markedDuplicateFactoryNames);
        } else {
            this.validateXmlFactory((ISeamXmlFactory)factory, markedDuplicateFactoryNames);
        }
    }

    private void validateXmlFactory(ISeamXmlFactory factory, Set<String> markedDuplicateFactoryNames) {
        String name = factory.getName();
        if (name == null) {
            SeamCorePlugin.getDefault().logError(NLS.bind((String)SeamCoreMessages.SEAM_CORE_VALIDATOR_FACTORY_METHOD_MUST_HAVE_NAME, (Object)factory.getResource()));
            return;
        }
        this.validateFactoryName(factory, name, markedDuplicateFactoryNames, false);
    }

    private void validateAnnotatedFactory(ISeamAnnotatedFactory factory, Set<String> markedDuplicateFactoryNames) {
        IMember sourceMember = factory.getSourceMember();
        if (sourceMember instanceof IMethod) {
            String factoryName = factory.getName();
            if (factoryName == null) {
                SeamCorePlugin.getDefault().logError(NLS.bind((String)SeamCoreMessages.SEAM_CORE_VALIDATOR_FACTORY_METHOD_MUST_HAVE_NAME, (Object)factory.getResource()));
                return;
            }
            this.validateFactoryName(factory, factoryName, markedDuplicateFactoryNames, true);
        }
    }

    private void validateFactoryName(ISeamFactory factory, String factoryName, Set<String> markedDuplicateFactoryNames, boolean validateUnknownName) {
        IMember sourceMember;
        ScopeType factoryScope = factory.getScope();
        Set<ISeamContextVariable> variables = this.seamProject.getVariablesByName(factoryName);
        boolean unknownVariable = true;
        boolean firstDuplicateVariableWasMarked = false;
        for (ISeamContextVariable variable : variables) {
            if (variable instanceof ISeamFactory) {
                if (variable == factory || markedDuplicateFactoryNames.contains(factoryName) || factoryScope != variable.getScope() && factoryScope.getPriority() <= variable.getScope().getPriority()) continue;
                ITextSourceReference location = null;
                if (!firstDuplicateVariableWasMarked) {
                    firstDuplicateVariableWasMarked = true;
                    this.validationContext.addLinkedCoreResource(factoryName, factory.getSourcePath(), true);
                    location = SeamUtil.getLocationOfName(factory);
                    this.addError(SeamValidationMessages.DUPLICATE_VARIABLE_NAME, SeamPreferences.DUPLICATE_VARIABLE_NAME, new String[]{factoryName}, location, factory.getResource());
                }
                if (SeamUtil.isJar(variable.getSourcePath())) continue;
                IResource resource = SeamUtil.getComponentResourceWithName(variable);
                this.validationContext.addLinkedCoreResource(factoryName, resource.getFullPath(), true);
                location = SeamUtil.getLocationOfName(variable);
                this.addError(SeamValidationMessages.DUPLICATE_VARIABLE_NAME, SeamPreferences.DUPLICATE_VARIABLE_NAME, new String[]{factoryName}, location, resource);
                continue;
            }
            unknownVariable = false;
        }
        if (firstDuplicateVariableWasMarked) {
            markedDuplicateFactoryNames.add(factoryName);
        }
        boolean voidReturnType = false;
        if (factory instanceof ISeamAnnotatedFactory && (sourceMember = ((ISeamAnnotatedFactory)factory).getSourceMember()) instanceof IMethod) {
            IMethod method = (IMethod)sourceMember;
            try {
                String returnType = method.getReturnType();
                if ("V".equals(returnType)) {
                    voidReturnType = true;
                }
            }
            catch (JavaModelException e) {
                SeamCorePlugin.getDefault().logError(SeamCoreMessages.SEAM_CORE_VALIDATOR_ERROR_VALIDATING_SEAM_CORE, e);
            }
        }
        if (unknownVariable && validateUnknownName && voidReturnType) {
            this.validationContext.addLinkedCoreResource(factoryName, factory.getSourcePath(), true);
            this.addError(SeamValidationMessages.UNKNOWN_FACTORY_NAME, SeamPreferences.UNKNOWN_FACTORY_NAME, new String[]{factoryName}, SeamUtil.getLocationOfName(factory), factory.getResource());
        }
    }

    private void validateComponent(IPath sourceFilePath, Set<ISeamComponent> checkedComponents, Set<IPath> unnamedResources) {
        Set<ISeamComponent> components = this.seamProject.getComponentsByPath(sourceFilePath);
        if (components.isEmpty()) {
            unnamedResources.add(sourceFilePath);
            return;
        }
        for (ISeamComponent component : components) {
            if (checkedComponents.contains(component)) continue;
            this.validateComponent(component);
            checkedComponents.add(component);
        }
    }

    private Set<String> getVariablesNameByResource(IPath resourcePath) {
        Set<ISeamContextVariable> variables = this.seamProject.getVariablesByPath(resourcePath);
        HashSet<String> result = new HashSet<String>();
        if (variables != null) {
            for (ISeamContextVariable variable : variables) {
                String name = variable.getName();
                result.add(name);
            }
        }
        return result;
    }

    private Set<IPath> getAllResourceOfComponent(IPath sourceComponentFilePath) {
        HashSet<IPath> result = new HashSet<IPath>();
        Set<ISeamComponent> components = this.seamProject.getComponentsByPath(sourceComponentFilePath);
        for (ISeamComponent component : components) {
            Set<ISeamComponentDeclaration> declarations = component.getAllDeclarations();
            for (ISeamComponentDeclaration seamComponentDeclaration : declarations) {
                result.add(seamComponentDeclaration.getResource().getFullPath());
            }
        }
        return result;
    }

    private void validateComponent(ISeamComponent component) {
        ISeamJavaComponentDeclaration firstJavaDeclaration = component.getJavaDeclaration();
        if (firstJavaDeclaration != null) {
            boolean source;
            String componentName = component.getName();
            if (componentName != null) {
                this.displaySubtask(SeamValidationMessages.VALIDATING_COMPONENT, new String[]{this.projectName, componentName});
            }
            HashMap<Integer, ISeamJavaComponentDeclaration> usedPrecedences = new HashMap<Integer, ISeamJavaComponentDeclaration>();
            HashSet<ISeamJavaComponentDeclaration> markedDeclarations = new HashSet<ISeamJavaComponentDeclaration>();
            int firstJavaDeclarationPrecedence = firstJavaDeclaration.getPrecedence();
            usedPrecedences.put(firstJavaDeclarationPrecedence, firstJavaDeclaration);
            Set<ISeamComponentDeclaration> declarations = component.getAllDeclarations();
            for (ISeamComponentDeclaration declaration : declarations) {
                boolean sourceJavaDeclaration;
                if (!(declaration instanceof ISeamJavaComponentDeclaration)) continue;
                ISeamJavaComponentDeclaration jd = (ISeamJavaComponentDeclaration)declaration;
                IType type = (IType)jd.getSourceMember();
                boolean bl = sourceJavaDeclaration = !type.isBinary();
                if (sourceJavaDeclaration) {
                    this.validationContext.addLinkedCoreResource(componentName, declaration.getSourcePath(), true);
                    try {
                        IType[] superTypes = TypeInfoCollector.getSuperTypes((IType)type).getSuperTypes();
                        int i = 0;
                        while (superTypes != null && i < superTypes.length) {
                            if (!superTypes[i].isBinary()) {
                                IPath path = superTypes[i].getResource().getFullPath();
                                this.validationContext.addLinkedCoreResource(componentName, path, true);
                            }
                            ++i;
                        }
                    }
                    catch (JavaModelException e) {
                        SeamCorePlugin.getPluginLog().logError((Throwable)e);
                    }
                }
                if (declaration == firstJavaDeclaration) continue;
                ISeamJavaComponentDeclaration javaDeclaration = (ISeamJavaComponentDeclaration)declaration;
                int javaDeclarationPrecedence = javaDeclaration.getPrecedence();
                ISeamJavaComponentDeclaration checkedDeclaration = (ISeamJavaComponentDeclaration)usedPrecedences.get(javaDeclarationPrecedence);
                if (checkedDeclaration == null) {
                    usedPrecedences.put(javaDeclarationPrecedence, javaDeclaration);
                    continue;
                }
                if (!sourceJavaDeclaration) continue;
                boolean sourceCheckedDeclaration = !((IType)checkedDeclaration.getSourceMember()).isBinary();
                IResource javaDeclarationResource = javaDeclaration.getResource();
                if (!markedDeclarations.contains(checkedDeclaration) && sourceCheckedDeclaration) {
                    IResource checkedDeclarationResource = checkedDeclaration.getResource();
                    ITextSourceReference location = ((SeamComponentDeclaration)((Object)checkedDeclaration)).getLocationFor("name");
                    if (!SeamUtil.isEmptyLocation(location)) {
                        this.addError(SeamValidationMessages.NONUNIQUE_COMPONENT_NAME_MESSAGE, SeamPreferences.NONUNIQUE_COMPONENT_NAME, new String[]{componentName}, location, checkedDeclarationResource);
                    }
                    markedDeclarations.add(checkedDeclaration);
                }
                markedDeclarations.add(javaDeclaration);
                ITextSourceReference location = ((SeamComponentDeclaration)((Object)javaDeclaration)).getLocationFor("name");
                if (SeamUtil.isEmptyLocation(location)) continue;
                this.addError(SeamValidationMessages.NONUNIQUE_COMPONENT_NAME_MESSAGE, SeamPreferences.NONUNIQUE_COMPONENT_NAME, new String[]{componentName}, location, javaDeclarationResource);
            }
            boolean bl = source = !((IType)firstJavaDeclaration.getSourceMember()).isBinary();
            if (source) {
                this.validateJavaDeclaration(component, firstJavaDeclaration);
            }
        }
        this.validateXmlComponentDeclarations(component);
    }

    private void validateXmlComponentDeclarations(ISeamComponent component) {
        String componentName = component.getName();
        if (componentName != null) {
            HashMap<String, ISeamXmlComponentDeclaration> usedPrecedences = new HashMap<String, ISeamXmlComponentDeclaration>();
            HashSet<ISeamXmlComponentDeclaration> markedDeclarations = new HashSet<ISeamXmlComponentDeclaration>();
            HashSet<ISeamJavaComponentDeclaration> markedJavaDeclarations = new HashSet<ISeamJavaComponentDeclaration>();
            Set<ISeamXmlComponentDeclaration> declarations = component.getXmlDeclarations();
            ISeamXmlComponentDeclaration firstNamedDeclaration = null;
            for (ISeamXmlComponentDeclaration declaration : declarations) {
                if (SeamUtil.isJar(declaration)) {
                    return;
                }
                this.validationContext.addLinkedCoreResource(componentName, declaration.getSourcePath(), true);
                String precedence = declaration.getPrecedence();
                if (firstNamedDeclaration == null && declaration.getName() != null) {
                    firstNamedDeclaration = declaration;
                    usedPrecedences.put(precedence, declaration);
                }
                if (declaration.getName() != null && firstNamedDeclaration != declaration) {
                    ISeamXmlComponentDeclaration checkedDeclaration = (ISeamXmlComponentDeclaration)usedPrecedences.get(precedence);
                    if (checkedDeclaration == null) {
                        usedPrecedences.put(precedence, declaration);
                    } else {
                        if (!markedDeclarations.contains(checkedDeclaration)) {
                            IResource checkedDeclarationResource = checkedDeclaration.getResource();
                            ITextSourceReference location = ((SeamComponentDeclaration)((Object)checkedDeclaration)).getLocationFor("name");
                            if (!SeamUtil.isEmptyLocation(location)) {
                                this.addError(SeamValidationMessages.NONUNIQUE_COMPONENT_NAME_MESSAGE, SeamPreferences.NONUNIQUE_COMPONENT_NAME, new String[]{componentName}, location, checkedDeclarationResource);
                            }
                            markedDeclarations.add(checkedDeclaration);
                        }
                        markedDeclarations.add(declaration);
                        ITextSourceReference location = ((SeamComponentDeclaration)((Object)declaration)).getLocationFor("name");
                        if (!SeamUtil.isEmptyLocation(location)) {
                            this.addError(SeamValidationMessages.NONUNIQUE_COMPONENT_NAME_MESSAGE, SeamPreferences.NONUNIQUE_COMPONENT_NAME, new String[]{componentName}, location, declaration.getResource());
                        }
                    }
                }
                Set<ISeamContextVariable> vars = this.seamProject.getVariablesByName(componentName);
                for (ISeamContextVariable variable : vars) {
                    if (!(variable instanceof ISeamComponent)) continue;
                    ISeamComponent c = (ISeamComponent)variable;
                    Set<ISeamComponentDeclaration> decls = c.getAllDeclarations();
                    for (ISeamComponentDeclaration dec : decls) {
                        ITextSourceReference location;
                        String javaPrecedence;
                        if (!(dec instanceof ISeamJavaComponentDeclaration)) continue;
                        ISeamJavaComponentDeclaration javaDec = (ISeamJavaComponentDeclaration)dec;
                        if (declaration.getClassName() == null || javaDec.getName() == null || !javaDec.getName().equals(declaration.getName()) || !(javaPrecedence = "" + javaDec.getPrecedence()).equals(precedence)) continue;
                        if (!markedJavaDeclarations.contains(javaDec)) {
                            markedJavaDeclarations.add(javaDec);
                            location = ((SeamComponentDeclaration)((Object)javaDec)).getLocationFor("name");
                            this.addError(SeamValidationMessages.NONUNIQUE_COMPONENT_NAME_MESSAGE, SeamPreferences.NONUNIQUE_COMPONENT_NAME, new String[]{componentName}, location, javaDec.getResource());
                        }
                        if (markedDeclarations.contains(declaration)) continue;
                        markedDeclarations.add(declaration);
                        location = ((SeamComponentDeclaration)((Object)declaration)).getLocationFor("name");
                        this.addError(SeamValidationMessages.NONUNIQUE_COMPONENT_NAME_MESSAGE, SeamPreferences.NONUNIQUE_COMPONENT_NAME, new String[]{componentName}, location, declaration.getResource());
                    }
                }
                String className = declaration.getClassName();
                IType type = null;
                if (className != null) {
                    try {
                        IProject p = this.seamProject.getProject();
                        type = EclipseResourceUtil.getJavaProject((IProject)p).findType(className);
                        if (type == null) {
                            ITextSourceReference location = ((SeamComponentDeclaration)((Object)declaration)).getLocationFor("class");
                            if (SeamUtil.isEmptyLocation(location)) {
                                location = ((SeamComponentDeclaration)((Object)declaration)).getLocationFor("name");
                            }
                            if (SeamUtil.isEmptyLocation(location)) {
                                location = declaration;
                            }
                            if (!declaration.isClassNameGuessed()) {
                                this.addError(SeamValidationMessages.UNKNOWN_COMPONENT_CLASS_NAME, SeamPreferences.UNKNOWN_COMPONENT_CLASS_NAME, new String[]{className}, location, declaration.getResource());
                            } else {
                                this.addError(SeamValidationMessages.UNKNOWN_COMPONENT_CLASS_NAME, SeamPreferences.UNKNOWN_COMPONENT_CLASS_NAME_GUESS, new String[]{className}, location, declaration.getResource());
                            }
                            return;
                        }
                        if (!type.isBinary()) {
                            this.validationContext.addLinkedCoreResource(componentName, type.getResource().getFullPath(), true);
                        }
                    }
                    catch (JavaModelException e) {
                        SeamCorePlugin.getDefault().logError(SeamCoreMessages.SEAM_CORE_VALIDATOR_ERROR_VALIDATING_SEAM_CORE, e);
                    }
                }
                Collection<ISeamProperty> properties = declaration.getProperties();
                for (ISeamProperty property : properties) {
                    boolean ok;
                    IMember member;
                    if (SeamUtil.isJar(property)) {
                        return;
                    }
                    String name = property.getName();
                    if (name == null) {
                        return;
                    }
                    if (type == null && component.getJavaDeclaration() != null && (member = component.getJavaDeclaration().getSourceMember()) instanceof IType) {
                        type = (IType)member;
                    }
                    if (type == null) continue;
                    boolean bl = ok = type.isBinary() || SeamUtil.findProperty(type, name) != null;
                    if (ok) continue;
                    this.addError(SeamValidationMessages.UNKNOWN_COMPONENT_PROPERTY, SeamPreferences.UNKNOWN_COMPONENT_PROPERTY, new String[]{type.getElementName(), componentName, name}, property, declaration.getResource());
                }
            }
        }
    }

    private void validateEntityComponent(ISeamComponent component) {
        if (component.isEntity()) {
            ISeamJavaComponentDeclaration javaDeclaration = component.getJavaDeclaration();
            ScopeType scope = component.getScope();
            if (scope == ScopeType.STATELESS) {
                ITextSourceReference location = this.getScopeLocation(component);
                this.addError(SeamValidationMessages.ENTITY_COMPONENT_WRONG_SCOPE, SeamPreferences.ENTITY_COMPONENT_WRONG_SCOPE, new String[]{component.getName()}, location, javaDeclaration.getResource());
            }
        }
    }

    private ITextSourceReference getScopeLocation(ISeamComponent component) {
        ISeamJavaComponentDeclaration javaDeclaration = component.getJavaDeclaration();
        ITextSourceReference location = ((SeamComponentDeclaration)((Object)javaDeclaration)).getLocationFor("scope");
        if (SeamUtil.isEmptyLocation(location)) {
            location = this.getNameLocation(javaDeclaration);
        }
        return location;
    }

    private ITextSourceReference getNameLocation(IJavaSourceReference source) {
        int length = 0;
        int offset = 0;
        try {
            length = source.getSourceMember().getNameRange().getLength();
            offset = source.getSourceMember().getNameRange().getOffset();
        }
        catch (JavaModelException e) {
            SeamCorePlugin.getDefault().logError(SeamCoreMessages.SEAM_CORE_VALIDATOR_ERROR_VALIDATING_SEAM_CORE, e);
        }
        return new SeamTextSourceReference(length, offset);
    }

    private void validateStatefulComponent(ISeamComponent component) {
        if (component.isStateful()) {
            ISeamJavaComponentDeclaration javaDeclaration = component.getJavaDeclaration();
            this.validateStatefulComponentMethods(SeamComponentMethodType.DESTROY, component, SeamValidationMessages.STATEFUL_COMPONENT_DOES_NOT_CONTAIN_DESTROY, SeamPreferences.STATEFUL_COMPONENT_DOES_NOT_CONTENT_DESTROY);
            this.validateStatefulComponentMethods(SeamComponentMethodType.REMOVE, component, SeamValidationMessages.STATEFUL_COMPONENT_DOES_NOT_CONTAIN_REMOVE, SeamPreferences.STATEFUL_COMPONENT_DOES_NOT_CONTENT_REMOVE);
            ScopeType scope = component.getScope();
            if (scope == ScopeType.PAGE || scope == ScopeType.STATELESS) {
                ITextSourceReference location = this.getScopeLocation(component);
                this.addError(SeamValidationMessages.STATEFUL_COMPONENT_WRONG_SCOPE, SeamPreferences.STATEFUL_COMPONENT_WRONG_SCOPE, new String[]{component.getName()}, location, javaDeclaration.getResource());
            }
            this.validateDuplicateComponentMethod(SeamComponentMethodType.REMOVE, component, SeamValidationMessages.DUPLICATE_REMOVE, SeamPreferences.DUPLICATE_REMOVE);
        }
    }

    private void validateStatefulComponentMethods(SeamComponentMethodType methodType, ISeamComponent component, String message, String preferenceKey) {
        ISeamJavaComponentDeclaration javaDeclaration = component.getJavaDeclaration();
        ITextSourceReference classNameLocation = this.getNameLocation(javaDeclaration);
        Set<ISeamComponentMethod> methods = javaDeclaration.getMethodsByType(methodType);
        if (methods == null || methods.isEmpty()) {
            this.addError(message, preferenceKey, new String[]{component.getName()}, classNameLocation, javaDeclaration.getResource());
        }
    }

    private void validateDuplicateComponentMethods(ISeamComponent component) {
        this.validateDuplicateComponentMethod(SeamComponentMethodType.DESTROY, component, SeamValidationMessages.DUPLICATE_DESTROY, SeamPreferences.DUPLICATE_DESTROY);
        this.validateDuplicateComponentMethod(SeamComponentMethodType.CREATE, component, SeamValidationMessages.DUPLICATE_CREATE, SeamPreferences.DUPLICATE_CREATE);
        this.validateDuplicateComponentMethod(SeamComponentMethodType.UNWRAP, component, SeamValidationMessages.DUPLICATE_UNWRAP, SeamPreferences.DUPLICATE_UNWRAP);
    }

    private void validateDuplicateComponentMethod(SeamComponentMethodType methodType, ISeamComponent component, String message, String preferenceKey) {
        ISeamJavaComponentDeclaration javaDeclaration = component.getJavaDeclaration();
        Set<ISeamComponentMethod> methods = javaDeclaration.getMethodsByType(methodType);
        if (methods != null && methods.size() > 1) {
            for (ISeamComponentMethod method : methods) {
                if (!javaDeclaration.getSourcePath().equals((Object)method.getSourcePath())) continue;
                IMethod javaMethod = (IMethod)method.getSourceMember();
                String methodName = javaMethod.getElementName();
                ITextSourceReference methodNameLocation = this.getNameLocation(method);
                this.addError(message, preferenceKey, new String[]{methodName}, methodNameLocation, javaDeclaration.getResource());
            }
        }
    }

    private void validateJavaDeclaration(ISeamComponent component, ISeamJavaComponentDeclaration declaration) {
        this.validateBijections(declaration);
        this.validateStatefulComponent(component);
        this.validateDuplicateComponentMethods(component);
        this.validateEntityComponent(component);
        this.validateDestroyMethod(component);
    }

    private void validateBijections(ISeamJavaComponentDeclaration declaration) {
        Set<IBijectedAttribute> bijections = declaration.getBijectedAttributes();
        if (bijections == null) {
            return;
        }
        for (IBijectedAttribute bijection : bijections) {
            if (bijection.isOfType(BijectedAttributeType.DATA_MODEL_SELECTION) || bijection.isOfType(BijectedAttributeType.DATA_MODEL_SELECTION_INDEX)) {
                this.validateDataModelSelection(declaration, bijection);
                continue;
            }
            this.validateInAndOut(declaration, bijection);
        }
    }

    private void validateInAndOut(ISeamJavaComponentDeclaration declaration, IBijectedAttribute bijection) {
        String name = bijection.getName();
        if (name == null || name.startsWith("#{") || name.startsWith("${")) {
            return;
        }
        if (bijection.isOfType(BijectedAttributeType.IN)) {
            ISeamProject parentProject;
            this.validationContext.addLinkedCoreResource(name, declaration.getSourcePath(), false);
            Set<ISeamContextVariable> variables = this.seamProject.getVariablesByName(name);
            if ((variables == null || variables.size() < 1) && (parentProject = this.seamProject.getParentProject()) != null) {
                variables = parentProject.getVariablesByName(name);
            }
            if (variables == null || variables.size() < 1) {
                IResource declarationResource = declaration.getResource();
                Object nameRef = this.getNameLocation(bijection);
                if (nameRef == null) {
                    nameRef = bijection;
                }
                this.addError(SeamValidationMessages.UNKNOWN_VARIABLE_NAME, SeamPreferences.UNKNOWN_VARIABLE_NAME, new String[]{name}, (ITextSourceReference)nameRef, declarationResource);
            }
        } else {
            this.validationContext.addLinkedCoreResource(name, declaration.getSourcePath(), true);
        }
    }

    private void validateDataModelSelection(ISeamJavaComponentDeclaration declaration, IBijectedAttribute bijection) {
        String dataModelName = bijection.getValue();
        String selectionName = bijection.getName();
        this.validationContext.addLinkedCoreResource(selectionName, declaration.getSourcePath(), false);
        if (dataModelName == null) {
            Set<IBijectedAttribute> dataBinders = declaration.getBijectedAttributesByType(BijectedAttributeType.DATA_BINDER);
            if (dataBinders != null && dataBinders.size() > 1) {
                for (IBijectedAttribute dataBinder : dataBinders) {
                    this.addError(SeamValidationMessages.MULTIPLE_DATA_BINDER, SeamPreferences.MULTIPLE_DATA_BINDER, (ITextSourceReference)dataBinder, declaration.getResource());
                }
            }
        } else {
            this.validationContext.addLinkedCoreResource(dataModelName, declaration.getSourcePath(), true);
            Set<IBijectedAttribute> dataBinders = declaration.getBijectedAttributesByName(dataModelName);
            if (dataBinders != null) {
                for (IBijectedAttribute dataBinder : dataBinders) {
                    if (!dataBinder.isOfType(BijectedAttributeType.DATA_BINDER) && !dataBinder.isOfType(BijectedAttributeType.OUT)) continue;
                    return;
                }
            }
            this.addError(SeamValidationMessages.UNKNOWN_DATA_MODEL, SeamPreferences.UNKNOWN_DATA_MODEL, new String[]{dataModelName}, SeamUtil.getLocationOfAttribute(bijection, DataModelSelectionAttribute.VALUE), declaration.getResource());
        }
    }

    private void validateMethodsOfUnknownComponent(ISeamJavaComponentDeclaration declaration) {
        if (this.seamProject.getComponentsByPath(declaration.getSourcePath()).isEmpty()) {
            IMember member = declaration.getSourceMember();
            try {
                if (member != null && !Flags.isAbstract((int)member.getFlags())) {
                    this.validateMethodOfUnknownComponent(SeamComponentMethodType.CREATE, declaration, SeamValidationMessages.CREATE_DOESNT_BELONG_TO_COMPONENT, SeamPreferences.CREATE_DOESNT_BELONG_TO_COMPONENT);
                    this.validateMethodOfUnknownComponent(SeamComponentMethodType.UNWRAP, declaration, SeamValidationMessages.UNWRAP_DOESNT_BELONG_TO_COMPONENT, SeamPreferences.UNWRAP_DOESNT_BELONG_TO_COMPONENT);
                    this.validateMethodOfUnknownComponent(SeamComponentMethodType.OBSERVER, declaration, SeamValidationMessages.OBSERVER_DOESNT_BELONG_TO_COMPONENT, SeamPreferences.OBSERVER_DOESNT_BELONG_TO_COMPONENT);
                }
            }
            catch (JavaModelException e) {
                SeamCorePlugin.getPluginLog().logError((Throwable)e);
            }
        }
        this.validationContext.removeUnnamedCoreResource(declaration.getSourcePath());
    }

    private void validateDestroyMethod(ISeamComponent component) {
        if (component.isStateless()) {
            ISeamJavaComponentDeclaration javaDeclaration = component.getJavaDeclaration();
            Set<ISeamComponentMethod> methods = javaDeclaration.getMethodsByType(SeamComponentMethodType.DESTROY);
            if (methods == null) {
                return;
            }
            for (ISeamComponentMethod method : methods) {
                IMethod javaMethod = (IMethod)method.getSourceMember();
                String methodName = javaMethod.getElementName();
                if (!javaDeclaration.getSourcePath().equals((Object)javaMethod.getPath())) continue;
                this.validationContext.addLinkedCoreResource(component.getName(), javaDeclaration.getSourcePath(), true);
                ITextSourceReference methodNameLocation = this.getNameLocation(method);
                this.addError(SeamValidationMessages.DESTROY_METHOD_BELONGS_TO_STATELESS_SESSION_BEAN, SeamPreferences.DESTROY_METHOD_BELONGS_TO_STATELESS_SESSION_BEAN, new String[]{methodName}, methodNameLocation, method.getResource());
            }
        }
    }

    private void validateMethodOfUnknownComponent(SeamComponentMethodType methodType, ISeamJavaComponentDeclaration declaration, String message, String preferenceKey) {
        Set<ISeamComponentMethod> methods = declaration.getMethodsByType(methodType);
        if (methods != null && !methods.isEmpty()) {
            for (ISeamComponentMethod method : methods) {
                IMethod javaMethod = (IMethod)method.getSourceMember();
                String methodName = javaMethod.getElementName();
                if (!declaration.getSourcePath().equals((Object)javaMethod.getPath())) continue;
                ITextSourceReference methodNameLocation = this.getNameLocation(method);
                this.addError(message, preferenceKey, new String[]{methodName}, methodNameLocation, method.getResource());
                this.validationContext.addUnnamedCoreResource(declaration.getSourcePath());
            }
        } else {
            this.validationContext.removeUnnamedCoreResource(declaration.getSourcePath());
        }
    }

    private void validateXMLVersion(IFile file) {
        String ext = file.getFileExtension();
        if (!"xml".equals(ext)) {
            return;
        }
        XModelObject o = EclipseResourceUtil.createObjectForResource((IResource)file);
        if (o == null) {
            return;
        }
        if (!o.getModelEntity().getName().startsWith("FileSeamComponent")) {
            return;
        }
        Set<String> vs = this.getXMLVersions(o);
        SeamRuntime runtime = this.seamProject.getRuntime();
        if (runtime == null) {
            return;
        }
        String version = runtime.getVersion().toString();
        String wrongVersion = null;
        for (String v : vs) {
            if (v.startsWith(version)) continue;
            wrongVersion = v;
            break;
        }
        if (wrongVersion != null) {
            this.addError(SeamValidationMessages.INVALID_XML_VERSION, SeamPreferences.INVALID_XML_VERSION, new String[]{wrongVersion, version}, (IResource)file);
        }
    }

    private Set<String> getXMLVersions(XModelObject o) {
        HashSet<String> result = new HashSet<String>();
        if (o.getModelEntity().getName().endsWith("11")) {
            result.add("1.1");
            return result;
        }
        String sl = o.getAttributeValue("xsi:schemaLocation");
        int i = 0;
        while (i >= 0 && i < sl.length()) {
            int k;
            int j = sl.indexOf(45, i);
            if (j < 0 || (k = sl.indexOf(".xsd", j)) < 0) break;
            String v = sl.substring(j + 1, k);
            if (this.isVersion(v)) {
                result.add(v);
            }
            i = k;
        }
        return result;
    }

    private boolean isVersion(String s) {
        if (s.length() == 0) {
            return false;
        }
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c != '.' && !Character.isDigit(c)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

