/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core.validation;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.operations.WorkbenchContext;
import org.eclipse.wst.validation.internal.operations.WorkbenchReporter;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidatorJob;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.jboss.tools.jst.web.kb.internal.validation.ValidationErrorManager;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.internal.core.validation.SeamValidationMessages;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SeamEarProjectValidator
implements IValidatorJob {
    private static final String MODULE_NODE_NAME = "module";
    private static final String JAVA_NODE_NAME = "java";
    private static final String SEAM_JAR_NAME = "jboss-seam.jar";
    private static final String[] JARS = new String[]{"el-ri", "jbpm", "drools-core", "drools-compiler", "janino", "antlr", "commons-jci-core", "commons-jci-janino", "stringtemplate", "jboss-el", "jbpm-jpdl", "mvel14", "richfaces-api"};

    public ISchedulingRule getSchedulingRule(IValidationContext helper) {
        return null;
    }

    public IStatus validateInJob(IValidationContext helper, IReporter reporter) throws ValidationException {
        IProject project = ((WorkbenchContext)helper).getProject();
        if (!project.isAccessible()) {
            return OK_STATUS;
        }
        WorkbenchReporter.removeAllMessages((IResource)project, (String[])new String[]{this.getClass().getName()}, null);
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        IVirtualReference[] rs = component.getReferences();
        int i = 0;
        while (i < rs.length) {
            ISeamProject seamProject;
            IVirtualFolder folder;
            IVirtualComponent c = rs[i].getReferencedComponent();
            if (c != null && (folder = c.getRootFolder()) != null && (seamProject = SeamCorePlugin.getSeamProject(folder.getProject(), false)) != null) {
                IFolder f;
                IVirtualFolder earRootFolder = component.getRootFolder().getFolder((IPath)new Path("/"));
                if (earRootFolder == null || (f = (IFolder)earRootFolder.getUnderlyingFolder()) == null) break;
                this.validateApplicationXml(f.findMember((IPath)new Path("META-INF/application.xml")));
                break;
            }
            ++i;
        }
        return OK_STATUS;
    }

    private void validateApplicationXml(IResource applicationXml) {
        block16: {
            if (applicationXml == null || !(applicationXml instanceof IFile) || !applicationXml.exists()) {
                return;
            }
            IModelManager manager = StructuredModelManager.getModelManager();
            if (manager == null) {
                return;
            }
            IStructuredModel model = null;
            try {
                model = manager.getModelForRead((IFile)applicationXml);
                if (!(model instanceof IDOMModel)) break block16;
                IDOMModel domModel = (IDOMModel)model;
                IDOMDocument document = domModel.getDocument();
                Element root = document.getDocumentElement();
                if (root == null) {
                    return;
                }
                try {
                    NodeList children = root.getChildNodes();
                    int i = 0;
                    while (i < children.getLength()) {
                        Node curentValidatedNode = children.item(i);
                        if (1 == curentValidatedNode.getNodeType() && MODULE_NODE_NAME.equals(curentValidatedNode.getNodeName())) {
                            NodeList moduleChildren = curentValidatedNode.getChildNodes();
                            int j = 0;
                            while (j < moduleChildren.getLength()) {
                                Node child = moduleChildren.item(j);
                                if (1 == child.getNodeType() && JAVA_NODE_NAME.equals(child.getNodeName())) {
                                    this.validateJavaModule(applicationXml, child);
                                }
                                ++j;
                            }
                        }
                        ++i;
                    }
                }
                catch (CoreException e) {
                    SeamCorePlugin.getDefault().logError(e);
                }
                catch (IOException e) {
                    SeamCorePlugin.getDefault().logError(e);
                }
            }
            finally {
                if (model != null) {
                    model.releaseFromRead();
                }
            }
        }
    }

    private void validateJavaModule(IResource file, Node node) {
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (3 == child.getNodeType()) {
                IStructuredDocumentRegion strRegion = ((IDOMNode)child).getFirstStructuredDocumentRegion();
                ITextRegionList regions = strRegion.getRegions();
                int j = 0;
                while (j < regions.size()) {
                    ITextRegion region = regions.get(j);
                    if (region.getType() == "XML_CONTENT") {
                        String text = strRegion.getFullText(region);
                        int offset = strRegion.getStartOffset() + region.getStart();
                        this.validateJarName(file, text, offset);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void validateJarName(IResource file, String text, int offset) {
        String jarName = text.trim();
        TextFileDocumentProvider documentProvider = new TextFileDocumentProvider();
        int jarIndex = 0;
        while (jarIndex < JARS.length) {
            int position = offset + text.indexOf(jarName);
            int length = jarName.length();
            if (SEAM_JAR_NAME.equals(jarName)) {
                ValidationErrorManager.addError((String)SeamValidationMessages.INVALID_JAR_MODULE_IN_APPLICATION_XML, (int)1, (String[])new String[]{jarName}, (int)length, (int)position, (IResource)file, (TextFileDocumentProvider)documentProvider, (String)"markedSeamProject", this.getClass());
                break;
            }
            if (jarName.startsWith(JARS[jarIndex])) {
                ValidationErrorManager.addError((String)SeamValidationMessages.INVALID_JAR_MODULE_IN_APPLICATION_XML, (int)2, (String[])new String[]{jarName}, (int)length, (int)position, (IResource)file, (TextFileDocumentProvider)documentProvider, (String)"markedSeamProject", this.getClass());
                break;
            }
            ++jarIndex;
        }
    }

    public void cleanup(IReporter reporter) {
    }

    public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
        this.validateInJob(helper, reporter);
    }
}

