/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core.validation;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.operations.WorkbenchContext;
import org.eclipse.wst.validation.internal.operations.WorkbenchReporter;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.validation.internal.provisional.core.IValidatorJob;
import org.jboss.tools.jst.web.kb.internal.validation.ContextValidationHelper;
import org.jboss.tools.jst.web.kb.internal.validation.ProblemMessage;
import org.jboss.tools.jst.web.kb.internal.validation.ValidationErrorManager;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.core.SeamPreferences;
import org.jboss.tools.seam.core.project.facet.SeamRuntimeManager;
import org.jboss.tools.seam.internal.core.refactoring.SeamProjectChange;
import org.jboss.tools.seam.internal.core.validation.SeamValidationErrorManager;
import org.jboss.tools.seam.internal.core.validation.SeamValidationMessages;

public class SeamProjectPropertyValidator
implements IValidatorJob {
    private ValidationErrorManager errorManager;
    private Set<String> validatedProjects = new HashSet<String>();
    private static Set<String> beingValidatedProjects = new HashSet<String>();
    private IReporter reporter;

    public ISchedulingRule getSchedulingRule(IValidationContext helper) {
        return null;
    }

    public IStatus validateInJob(IValidationContext helper, IReporter reporter) throws ValidationException {
        this.validatedProjects.clear();
        try {
            this.reporter = reporter;
            IProject project = ((WorkbenchContext)helper).getProject();
            if (!project.isAccessible()) {
                IStatus iStatus = OK_STATUS;
                return iStatus;
            }
            ISeamProject seamProject = SeamCorePlugin.getSeamProject(project, false);
            this.errorManager = new SeamValidationErrorManager(){

                protected Class getMarkerOwner() {
                    return SeamProjectPropertyValidator.this.getClass();
                }

                public void init(IProject project, ContextValidationHelper validationHelper, IValidator manager, IReporter reporter) {
                    this.setRootProject(project);
                    this.setValidationManager(manager);
                    this.setReporter(reporter);
                    this.setMarkerId("markedSeamProject");
                }
            };
            this.errorManager.init(project, null, (IValidator)this, reporter);
            if (seamProject != null) {
                this.validateSeamProject(seamProject);
            }
            IProject[] ps = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            String projectName = project.getName();
            int i = 0;
            while (i < ps.length) {
                if (ps[i] != project) {
                    this.validateProject(projectName, ps[i]);
                }
                ++i;
            }
        }
        finally {
            this.finishValidating();
        }
        return OK_STATUS;
    }

    private synchronized void finishValidating() {
        beingValidatedProjects.removeAll(this.validatedProjects);
    }

    private synchronized boolean canStartValidating(IProject project) {
        String name = project.getName();
        if (this.validatedProjects.contains(name) || beingValidatedProjects.contains(name)) {
            return false;
        }
        this.validatedProjects.add(name);
        beingValidatedProjects.add(name);
        return true;
    }

    private void validateProject(String nameOfChangedProject, IProject checkingProject) {
        ISeamProject seamProject = SeamCorePlugin.getSeamProject(checkingProject, false);
        if (seamProject == null) {
            return;
        }
        IEclipsePreferences pref = SeamCorePlugin.getSeamPreferences(checkingProject);
        int i = 0;
        while (i < SeamProjectChange.PROJECT_NAME_PROPERTIES.length) {
            if (nameOfChangedProject.equals(pref.get(SeamProjectChange.PROJECT_NAME_PROPERTIES[i], null))) {
                this.validateSeamProject(seamProject);
                return;
            }
            ++i;
        }
        i = 0;
        while (i < SeamProjectChange.FOLDER_PROPERTIES.length) {
            if (pref.get(SeamProjectChange.FOLDER_PROPERTIES[i], "").startsWith("/" + nameOfChangedProject + "/")) {
                this.validateSeamProject(seamProject);
                return;
            }
            ++i;
        }
    }

    public static boolean isProjectNameValid(String projectName, boolean canBeEmpty) {
        IProject project;
        if (projectName == null || projectName.length() == 0) {
            return canBeEmpty;
        }
        return new Path("/").isValidSegment(projectName) && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)).exists();
    }

    public static boolean isFolderPathValid(String folderPath, boolean canBeEmpty) {
        IResource folder;
        if (folderPath == null || folderPath.length() == 0) {
            return canBeEmpty;
        }
        return new Path("/").isValidPath(folderPath) && (folder = ResourcesPlugin.getWorkspace().getRoot().findMember(folderPath)) != null && folder instanceof IContainer && folder.exists();
    }

    public static boolean isPackageNameValid(String packageName, boolean canBeEmpty) {
        if (packageName == null || packageName.length() == 0) {
            return canBeEmpty;
        }
        IStatus status = JavaConventions.validatePackageName((String)packageName, (String)"1.5", (String)"1.5");
        return status.getSeverity() != 4;
    }

    public static boolean isConnectionProfileValid(String profilerName, boolean canBeEmpty) {
        IConnectionProfile[] profiles;
        if (profilerName == null || profilerName.length() == 0) {
            return canBeEmpty;
        }
        IConnectionProfile[] iConnectionProfileArray = profiles = ProfileManager.getInstance().getProfilesByCategory("org.eclipse.datatools.connectivity.db.category");
        int n = profiles.length;
        int n2 = 0;
        while (n2 < n) {
            IConnectionProfile connectionProfile = iConnectionProfileArray[n2];
            if (profilerName.equals(connectionProfile.getName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void validateProjectName(IProject targetProject, String projectName, boolean canBeEmpty, String messageId) {
        if (!SeamProjectPropertyValidator.isProjectNameValid(projectName, canBeEmpty)) {
            this.errorManager.addError(messageId, SeamPreferences.INVALID_PROJECT_SETTINGS, new String[]{projectName != null ? projectName : "", targetProject.getName()}, (IResource)targetProject);
        }
    }

    private void validateSorceFolder(IProject targetProject, String folderPath, String packageName, String srcFolderMessageID, String packageMessageId) {
        if (!SeamProjectPropertyValidator.isFolderPathValid(folderPath, true)) {
            this.errorManager.addError(srcFolderMessageID, SeamPreferences.INVALID_PROJECT_SETTINGS, new String[]{folderPath != null ? folderPath : "", targetProject.getName()}, (IResource)targetProject);
        }
        if (!SeamProjectPropertyValidator.isPackageNameValid(packageName, true)) {
            this.errorManager.addError(packageMessageId, SeamPreferences.INVALID_PROJECT_SETTINGS, new String[]{packageName != null ? packageName : "", targetProject.getName()}, (IResource)targetProject);
        }
    }

    private void validateSeamProject(ISeamProject seamProject) {
        IProject project = seamProject.getProject();
        if (!project.isAccessible()) {
            return;
        }
        if (!this.canStartValidating(project)) {
            return;
        }
        WorkbenchReporter.removeAllMessages((IResource)project, (String[])new String[]{this.getClass().getName()}, null);
        if (!SeamPreferences.shouldValidateSettings(project)) {
            return;
        }
        ProblemMessage problemMessage = new ProblemMessage(SeamValidationMessages.VALIDATING_PROJECT, 2, new String[]{project.getName()});
        this.reporter.displaySubtask((IValidator)this, (IMessage)problemMessage);
        IEclipsePreferences pref = SeamCorePlugin.getSeamPreferences(project);
        String parentProject = pref.get("seam.parent.project", null);
        if (parentProject != null) {
            this.validateProjectName(project, parentProject, false, SeamValidationMessages.INVALID_PARENT_PROJECT);
        } else {
            String viewFolder;
            String settingVersion = pref.get("seam.project.settings.version", "1.0");
            String seamRuntimeName = pref.get("seam.runtime.name", null);
            if (seamRuntimeName != null && seamRuntimeName.length() > 0 && SeamRuntimeManager.getInstance().findRuntimeByName(seamRuntimeName) == null) {
                this.errorManager.addError(SeamValidationMessages.INVALID_SEAM_RUNTIME, SeamPreferences.INVALID_PROJECT_SETTINGS, new String[]{seamRuntimeName != null ? seamRuntimeName : "", project.getName()}, (IResource)project);
            }
            if ("ear".equals(pref.get("seam.project.deployment.type", null))) {
                this.validateProjectName(project, pref.get("seam.ejb.project", null), true, SeamValidationMessages.INVALID_EJB_PROJECT);
            }
            if (!SeamProjectPropertyValidator.isFolderPathValid(viewFolder = pref.get("seam.project.web.root.folder", null), true)) {
                this.errorManager.addError(SeamValidationMessages.INVALID_WEBFOLDER, SeamPreferences.INVALID_PROJECT_SETTINGS, new String[]{viewFolder != null ? viewFolder : "", project.getName()}, (IResource)project);
            }
            this.validateSorceFolder(project, pref.get("model.sources", null), pref.get("model.package", null), SeamValidationMessages.INVALID_MODEL_SRC, SeamValidationMessages.INVALID_MODEL_PACKAGE_NAME);
            this.validateSorceFolder(project, pref.get("action.sources", null), pref.get("action.package", null), SeamValidationMessages.INVALID_ACTION_SRC, SeamValidationMessages.INVALID_ACTION_PACKAGE_NAME);
            String createTestString = pref.get("seam.test.creating", null);
            if (settingVersion.equals("1.0") || "true".equals(createTestString)) {
                this.validateProjectName(project, pref.get("seam.test.project", null), true, SeamValidationMessages.INVALID_TEST_PROJECT);
                this.validateSorceFolder(project, pref.get("test.sources", null), pref.get("test.package", null), SeamValidationMessages.INVALID_TEST_SRC, SeamValidationMessages.INVALID_TEST_PACKAGE_NAME);
            }
        }
    }

    public void cleanup(IReporter reporter) {
    }

    public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
        this.validateInJob(helper, reporter);
    }
}

