/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.xml.ds.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.XModelEntity;
import org.jboss.tools.common.meta.constraint.impl.XAttributeConstraintAList;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.common.xml.XMLUtilities;
import org.jboss.tools.seam.xml.ds.model.DSConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DSFileLoaderUtil
extends XModelObjectLoaderUtil
implements DSConstants {
    static Set<String> beforeXADatasourceProperty;
    static Set<String> beforeConnectionProperty;
    static Set<String> beforeConfigProperty;
    static Map<String, Set<String>> propertiesToMove;

    static {
        String[] beforeConnectionNames;
        String[] beforeConfigNames;
        beforeXADatasourceProperty = new HashSet<String>();
        beforeConnectionProperty = new HashSet<String>();
        beforeConfigProperty = new HashSet<String>();
        propertiesToMove = new HashMap<String, Set<String>>();
        beforeXADatasourceProperty.add("xa-datasource-class");
        String[] stringArray = beforeConfigNames = new String[]{"connection-definition", "rar-name", "track-connection-by-tx", "xa-transaction", "local-transaction", "jndi-name"};
        int n = beforeConfigNames.length;
        int n2 = 0;
        while (n2 < n) {
            String n3 = stringArray[n2];
            beforeConfigProperty.add(n3);
            ++n2;
        }
        String[] stringArray2 = beforeConnectionNames = new String[]{"driver-class", "transaction-isolation"};
        int n4 = beforeConnectionNames.length;
        n = 0;
        while (n < n4) {
            String n5 = stringArray2[n];
            beforeConnectionProperty.add(n5);
            ++n;
        }
        propertiesToMove.put("xa-datasource-property", beforeXADatasourceProperty);
        propertiesToMove.put("connection-property", beforeConnectionProperty);
        propertiesToMove.put("config-property", beforeConfigProperty);
    }

    protected boolean isSaveable(XModelEntity entity, String n, String v, String dv) {
        if (v == null) {
            return false;
        }
        if (v.length() == 0 || v.equals(dv)) {
            XAttribute attr = entity.getAttribute(n);
            return attr != null && "always".equals(attr.getProperty("save"));
        }
        return super.isSaveable(entity, n, v, dv);
    }

    public boolean save(Element parent, XModelObject o) {
        if (!this.needToSave(o)) {
            return true;
        }
        return super.save(parent, o);
    }

    public boolean saveChildren(Element element, XModelObject o) {
        boolean b = super.saveChildren(element, o);
        this.moveProperties(element);
        return b;
    }

    protected boolean needToSave(XModelObject o) {
        String s = o.getModelEntity().getProperty("saveDefault");
        if (!"false".equals(s)) {
            return true;
        }
        if (this.hasSetAttributes(o)) {
            return true;
        }
        return o.getChildren().length > 0;
    }

    private boolean hasSetAttributes(XModelObject o) {
        XAttribute[] as = o.getModelEntity().getAttributes();
        int i = 0;
        while (i < as.length) {
            String v;
            String xml = as[i].getXMLName();
            if (xml != null && xml.length() != 0 && !"NAME".equals(xml) && (v = o.getAttributeValue(as[i].getName())) != null && v.length() > 0) {
                return true;
            }
            ++i;
        }
        String finalComment = o.get("#final-comment");
        return finalComment != null && finalComment.length() > 0;
    }

    public void saveAttribute(Element element, String xmlname, String value) {
        if ("track-connection-by-tx".equals(xmlname) || "no-tx-separate-pools".equals(xmlname)) {
            XMLUtilities.createElement((Element)element, (String)xmlname);
        } else if ("transaction".equals(xmlname)) {
            if (value.length() > 0) {
                XMLUtilities.createElement((Element)element, (String)value);
            }
        } else if ("security-type".equals(xmlname)) {
            if (value.length() > 0) {
                XMLUtilities.createElement((Element)element, (String)value);
            }
        } else if ("security-domain".equals(xmlname)) {
            Element e = XMLUtilities.getUniqueChild((Element)element, (String)"security-domain");
            if (e == null) {
                e = XMLUtilities.getUniqueChild((Element)element, (String)"security-domain-and-application");
            }
            if (e != null) {
                super.saveAttribute(e, "#text", value);
            }
        } else {
            super.saveAttribute(element, xmlname, value);
        }
    }

    public String getAttribute(Element element, String xmlname, XAttribute attr) {
        if ("track-connection-by-tx".equals(xmlname) || "no-tx-separate-pools".equals(xmlname)) {
            return XMLUtilities.getUniqueChild((Element)element, (String)xmlname) != null ? "true" : "false";
        }
        if ("transaction".equals(xmlname) || "security-type".equals(xmlname)) {
            String[] vs = ((XAttributeConstraintAList)attr.getConstraint()).getValues();
            int i = 0;
            while (i < vs.length) {
                if (XMLUtilities.getUniqueChild((Element)element, (String)vs[i]) != null) {
                    return vs[i];
                }
                ++i;
            }
            return "";
        }
        if ("security-domain".equals(xmlname)) {
            XAttribute a = attr.getModelEntity().getAttribute("security-type");
            String[] vs = ((XAttributeConstraintAList)a.getConstraint()).getValues();
            int i = 0;
            while (i < vs.length) {
                if (XMLUtilities.getUniqueChild((Element)element, (String)vs[i]) != null) {
                    return super.getAttribute(element, String.valueOf(vs[i]) + ".#text");
                }
                ++i;
            }
            return "";
        }
        return super.getAttribute(element, xmlname, attr);
    }

    protected Set<String> getAllowedChildren(XModelEntity entity) {
        int i;
        String[] vs;
        Set children = super.getAllowedChildren(entity);
        XAttribute a = entity.getAttribute("track-connection-by-tx");
        if (a != null) {
            children.add(a.getXMLName());
        }
        if ((a = entity.getAttribute("transaction")) != null) {
            vs = ((XAttributeConstraintAList)a.getConstraint()).getValues();
            i = 0;
            while (i < vs.length) {
                children.add(vs[i]);
                ++i;
            }
        }
        if ((a = entity.getAttribute("security-type")) != null) {
            vs = ((XAttributeConstraintAList)a.getConstraint()).getValues();
            i = 0;
            while (i < vs.length) {
                children.add(vs[i]);
                ++i;
            }
        }
        return children;
    }

    void moveProperties(Element parent) {
        NodeList ns = parent.getChildNodes();
        String childName = null;
        int i = 0;
        while (i < ns.getLength()) {
            String name;
            Node n = ns.item(i);
            if (n instanceof Element && propertiesToMove.containsKey(name = n.getNodeName())) {
                childName = name;
                break;
            }
            ++i;
        }
        if (childName != null) {
            this.moveChildren(parent, childName, propertiesToMove.get(childName));
        }
    }

    void moveChildren(Element parent, String childName, Set<String> namesBeforeChild) {
        Element[] ps = XMLUtilities.getChildren((Element)parent, (String)childName);
        if (ps == null || ps.length == 0) {
            return;
        }
        Node after = null;
        Node before = null;
        NodeList ns = parent.getChildNodes();
        int i = 0;
        while (i < ns.getLength()) {
            Node n = ns.item(i);
            if (n instanceof Element) {
                if (namesBeforeChild.contains(n.getNodeName())) {
                    after = n;
                } else if (after != null) {
                    before = n;
                    break;
                }
            }
            ++i;
        }
        if (before == null || before == ps[0]) {
            return;
        }
        i = 0;
        while (i < ps.length) {
            parent.insertBefore(ps[i], before);
            ++i;
        }
    }
}

