/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.core;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.jboss.tools.common.log.BaseUIPlugin;
import org.jboss.tools.common.log.IPluginLog;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.event.ISeamProjectChangeListener;
import org.jboss.tools.seam.core.event.SeamProjectChangeEvent;
import org.jboss.tools.seam.internal.core.SeamProject;
import org.osgi.framework.BundleContext;

public class SeamCorePlugin
extends BaseUIPlugin {
    public static final String PLUGIN_ID = "org.jboss.tools.seam.core";
    private static SeamCorePlugin plugin;
    public static final String CA_SEAM_EL_IMAGE_PATH = "images/ca/icons_Seam_EL.gif";
    public static final String CA_SEAM_MESSAGES_IMAGE_PATH = "images/ca/icons_Message_Bundles.gif";
    static final String M2_FACET_ID = "jboss.m2";
    IResourceChangeListener resourceChangeListener = new RCL();
    private static List<ISeamProjectChangeListener> listeners;

    static {
        listeners = new ArrayList<ISeamProjectChangeListener>();
    }

    public SeamCorePlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        SeamCorePlugin.cleanCachedProjects();
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener);
    }

    static void cleanCachedProjects() {
        File[] fs;
        IPath path = SeamCorePlugin.getDefault().getStateLocation();
        File file = new File(path.toFile(), "projects");
        if (file.isDirectory() && (fs = file.listFiles()) != null) {
            int i = 0;
            while (i < fs.length) {
                if (fs[i].isFile()) {
                    String n = fs[i].getName();
                    IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(n);
                    if (p == null || !p.isAccessible()) {
                        fs[i].delete();
                    }
                }
                ++i;
            }
        }
    }

    public void stop(BundleContext context) throws Exception {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        super.stop(context);
    }

    public static SeamCorePlugin getDefault() {
        return plugin;
    }

    public static IPluginLog getPluginLog() {
        return SeamCorePlugin.getDefault();
    }

    public static ISeamProject getSeamProject(IProject project, boolean resolve) {
        if (project == null || !project.exists() || !project.isOpen()) {
            return null;
        }
        try {
            if (!project.hasNature("org.jboss.tools.seam.core.seamnature")) {
                return null;
            }
        }
        catch (CoreException coreException) {
            return null;
        }
        try {
            ISeamProject seamProject = (ISeamProject)project.getNature("org.jboss.tools.seam.core.seamnature");
            if (resolve) {
                seamProject.resolve();
            }
            return seamProject;
        }
        catch (CoreException e) {
            SeamCorePlugin.getPluginLog().logError((Throwable)e);
            return null;
        }
    }

    public static IEclipsePreferences getSeamPreferences(IProject project) {
        ProjectScope projectScope = new ProjectScope(project);
        return projectScope.getNode(PLUGIN_ID);
    }

    public static IStatus createErrorStatus(String message, Throwable exception) {
        return new Status(4, PLUGIN_ID, -1, message, exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSeamProjectListener(ISeamProjectChangeListener listener) {
        List<ISeamProjectChangeListener> list = listeners;
        synchronized (list) {
            if (listeners.contains(listener)) {
                return;
            }
            listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSeamProjectListener(ISeamProjectChangeListener listener) {
        List<ISeamProjectChangeListener> list = listeners;
        synchronized (list) {
            listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fire(SeamProjectChangeEvent event) {
        ISeamProjectChangeListener[] ls = null;
        List<ISeamProjectChangeListener> list = listeners;
        synchronized (list) {
            ls = listeners.toArray(new ISeamProjectChangeListener[0]);
        }
        if (ls != null) {
            int i = 0;
            while (i < ls.length) {
                ls[i].projectChanged(event);
                ++i;
            }
        }
    }

    public boolean hasM2Facet(IProject project) {
        try {
            return FacetedProjectFramework.hasProjectFacet((IProject)project, (String)M2_FACET_ID);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    class RCL
    implements IResourceChangeListener {
        RCL() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IProject p;
            SeamProject sp;
            IResource r;
            if ((event.getType() == 4 || event.getType() == 2) && (r = event.getResource()) instanceof IProject && (sp = (SeamProject)SeamCorePlugin.getSeamProject(p = (IProject)r, false)) != null) {
                sp.clearStorage();
            }
        }
    }
}

