/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core;

import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.jboss.tools.common.model.project.ext.event.Change;
import org.jboss.tools.seam.core.ISeamComponentMethod;
import org.jboss.tools.seam.core.ISeamElement;
import org.jboss.tools.seam.core.SeamComponentMethodType;
import org.jboss.tools.seam.internal.core.SeamObject;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeamComponentMethod
extends SeamObject
implements ISeamComponentMethod {
    Set<SeamComponentMethodType> types = new HashSet<SeamComponentMethodType>();
    IMember javaSource = null;
    static String ATTR_COMP_TYPES = "comp-types";

    @Override
    public Set<SeamComponentMethodType> getTypes() {
        return this.types;
    }

    @Override
    public boolean isOfType(SeamComponentMethodType type) {
        return this.types.contains(type);
    }

    public IMember getSourceMember() {
        return this.javaSource;
    }

    public void setSourceMember(IMember javaSource) {
        this.javaSource = javaSource;
    }

    public int getLength() {
        block4: {
            if (this.javaSource == null) {
                return 0;
            }
            try {
                if (this.javaSource.getSourceRange() != null) break block4;
                return 0;
            }
            catch (JavaModelException javaModelException) {
                return 0;
            }
        }
        return this.javaSource.getSourceRange().getLength();
    }

    @Override
    public IResource getResource() {
        if (this.resource == null) {
            if (this.javaSource == null) {
                return super.getResource();
            }
            this.resource = this.javaSource.getResource();
        }
        return this.resource;
    }

    public int getStartPosition() {
        block4: {
            if (this.javaSource == null) {
                return 0;
            }
            try {
                if (this.javaSource.getSourceRange() != null) break block4;
                return 0;
            }
            catch (JavaModelException javaModelException) {
                return 0;
            }
        }
        return this.javaSource.getSourceRange().getOffset();
    }

    @Override
    public List<Change> merge(ISeamElement s) {
        List changes = super.merge(s);
        SeamComponentMethod m = (SeamComponentMethod)s;
        if (!this.typesAreEqual(this.types, m.types)) {
            changes = Change.addChange(changes, (Change)new Change((Object)this, "types", this.types, m.types));
            this.types = m.types;
        }
        return changes;
    }

    boolean typesAreEqual(Set<SeamComponentMethodType> types1, Set<SeamComponentMethodType> types2) {
        if (types1 == null || types2 == null) {
            return types2 == types1;
        }
        if (types1.size() != types2.size()) {
            return false;
        }
        for (SeamComponentMethodType t : types2) {
            if (types1.contains(t)) continue;
            return false;
        }
        return true;
    }

    @Override
    public SeamComponentMethod clone() throws CloneNotSupportedException {
        SeamComponentMethod c = (SeamComponentMethod)super.clone();
        c.types = new HashSet<SeamComponentMethodType>();
        c.types.addAll(this.types);
        return c;
    }

    @Override
    public String getXMLName() {
        return "method";
    }

    @Override
    public Element toXML(Element parent, Properties context) {
        Element element = super.toXML(parent, context);
        if (this.types != null) {
            StringBuffer sb = new StringBuffer();
            for (SeamComponentMethodType t : this.types) {
                sb.append(t.toString()).append(';');
            }
            element.setAttribute(ATTR_COMP_TYPES, sb.toString());
        }
        return element;
    }

    @Override
    public void loadXML(Element element, Properties context) {
        String v;
        super.loadXML(element, context);
        if (this.id instanceof IMember) {
            this.javaSource = (IMember)this.id;
        }
        if (element.hasAttribute(ATTR_COMP_TYPES) && (v = element.getAttribute(ATTR_COMP_TYPES)) != null && v.length() > 0) {
            String[] cs = v.split(";");
            int i = 0;
            while (i < cs.length) {
                this.types.add(SeamComponentMethodType.valueOf(cs[i]));
                ++i;
            }
        }
    }
}

