/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core.project.facet;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.jboss.ide.eclipse.as.core.modules.SingleDeployableFactory;
import org.jboss.ide.eclipse.as.core.server.internal.DeployableServerBehavior;
import org.jboss.tools.seam.core.SeamCoreMessages;

public class DataSourceXmlDeployer
extends Job {
    IProject project = null;
    IServer s = null;
    IPath deploy = null;

    public DataSourceXmlDeployer(IProject project, IServer s, IPath deploy) {
        super(SeamCoreMessages.DATA_SOURCE_XML_DEPLOYER_DEPLOYING_DATASOURCE_TO_SERVER);
        this.project = project;
        this.setUser(true);
        this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        this.s = s;
        this.deploy = deploy;
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (this.s == null) {
            return new Status(2, "org.jboss.tools.seam.core", SeamCoreMessages.DATA_SOURCE_XML_DEPLOYER_NO_SERVER_SELECTED_TO_DEPLOY_DATASOURCE_TO);
        }
        DeployableServerBehavior deployer = (DeployableServerBehavior)this.s.loadAdapter(DeployableServerBehavior.class, null);
        if (deployer == null) {
            return new Status(2, "org.jboss.tools.seam.core", SeamCoreMessages.DATA_SOURCE_XML_DEPLOYER_SERVER_DID_NOT_SUPPORT_DEPLOY_OF_DATASOURCE);
        }
        Path projectPath = new Path("/" + this.project.getName());
        IPath append = projectPath.append(this.deploy);
        if (SingleDeployableFactory.makeDeployable((IPath)append)) {
            try {
                IModule module = SingleDeployableFactory.findModule((IPath)append);
                IServerWorkingCopy copy = this.s.createWorkingCopy();
                copy.modifyModules(new IModule[]{module}, new IModule[0], (IProgressMonitor)new NullProgressMonitor());
                IServer saved = copy.save(false, (IProgressMonitor)new NullProgressMonitor());
                saved.publish(1, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException ce) {
                return new Status(2, "org.jboss.tools.seam.core", String.valueOf(SeamCoreMessages.DATA_SOURCE_XML_DEPLOYER_COULD_NOT_DEPLOY_DATASOURCE) + append, (Throwable)ce);
            }
            return Status.OK_STATUS;
        }
        return new Status(2, "org.jboss.tools.seam.core", String.valueOf(SeamCoreMessages.DATA_SOURCE_XML_DEPLOYER_COULD_NOT_DEPLOY_DATASOURCE) + append);
    }
}

