/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core.refactoring;

import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.jboss.tools.common.el.core.model.ELExpression;
import org.jboss.tools.common.el.core.model.ELInvocationExpression;
import org.jboss.tools.common.el.core.resolver.ELCompletionEngine;
import org.jboss.tools.common.el.core.resolver.ELContext;
import org.jboss.tools.common.el.core.resolver.ELResolution;
import org.jboss.tools.common.el.core.resolver.ELResolver;
import org.jboss.tools.common.el.core.resolver.ELResolverFactoryManager;
import org.jboss.tools.common.el.core.resolver.ELSegment;
import org.jboss.tools.common.el.core.resolver.ElVarSearcher;
import org.jboss.tools.common.el.core.resolver.IVariable;
import org.jboss.tools.common.el.core.resolver.SimpleELContext;
import org.jboss.tools.jsf.el.refactoring.RefactorSearcher;
import org.jboss.tools.seam.core.ISeamComponent;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.ISeamXmlComponentDeclaration;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.core.SeamProjectsSet;

public abstract class SeamRefactorSearcher
extends RefactorSearcher {
    private SeamProjectsSet projectsSet;
    protected ISeamComponent seamComponent;

    public SeamRefactorSearcher(IFile file, String name) {
        super(file, name);
        this.projectsSet = new SeamProjectsSet(file.getProject());
    }

    public SeamRefactorSearcher(IFile file, String name, IJavaElement element) {
        this(file, name);
        this.javaElement = element;
    }

    public SeamRefactorSearcher(IFile file, String name, ISeamComponent component) {
        this(file, name);
        this.seamComponent = component;
    }

    protected IProject[] getProjects() {
        return this.projectsSet.getAllProjects();
    }

    protected IContainer getViewFolder(IProject project) {
        if (project.equals((Object)this.projectsSet.getWarProject())) {
            return this.projectsSet.getDefaultViewsFolder();
        }
        if (project.equals((Object)this.projectsSet.getEarProject())) {
            return this.projectsSet.getDefaultEarViewsFolder();
        }
        return null;
    }

    protected boolean isFileCorrect(IFile file) {
        if (!file.isSynchronized(0)) {
            return false;
        }
        if (file.isPhantom()) {
            return false;
        }
        return !file.isReadOnly();
    }

    protected void checkMatch(IFile file, ELExpression operand, int offset, int length) {
        if (this.javaElement != null && operand != null) {
            this.resolve(file, operand, offset - this.getOffset((ELInvocationExpression)operand));
        } else if (this.seamComponent != null && operand != null) {
            this.resolveComponentsReferences(file, operand, offset - this.getOffset((ELInvocationExpression)operand));
        } else {
            this.match(file, offset, length);
        }
    }

    protected void updateEnvironment(IProject project) {
        if (this.seamComponent == null) {
            return;
        }
        ISeamProject seamProject = SeamCorePlugin.getSeamProject(project, true);
        if (seamProject == null) {
            return;
        }
        ISeamComponent oldComponent = this.seamComponent;
        if (oldComponent.getJavaDeclaration() != null) {
            this.seamComponent = this.getComponent(seamProject, oldComponent.getName(), (IFile)oldComponent.getJavaDeclaration().getResource());
        } else {
            for (ISeamXmlComponentDeclaration xDecl : oldComponent.getXmlDeclarations()) {
                this.seamComponent = this.getComponent(seamProject, oldComponent.getName(), (IFile)xDecl.getResource());
                if (this.seamComponent == null) continue;
                return;
            }
        }
        if (this.seamComponent == null) {
            this.seamComponent = oldComponent;
        }
    }

    private ISeamComponent getComponent(ISeamProject seamProject, String name, IFile file) {
        Set<ISeamComponent> components = seamProject.getComponentsByPath(file.getFullPath());
        for (ISeamComponent component : components) {
            if (!component.getName().equals(name)) continue;
            return component;
        }
        return null;
    }

    private void resolveComponentsReferences(IFile file, ELExpression operand, int offset) {
        ELResolver[] resolvers;
        ELResolver[] eLResolverArray = resolvers = ELResolverFactoryManager.getInstance().getResolvers((IResource)file);
        int n = resolvers.length;
        int n2 = 0;
        while (n2 < n) {
            ELResolver resolver = eLResolverArray[n2];
            if (resolver instanceof ELCompletionEngine) {
                SimpleELContext context = new SimpleELContext();
                context.setResource(file);
                context.setElResolvers(resolvers);
                List vars = ElVarSearcher.findAllVars((ELContext)context, (int)offset, (ELResolver)resolver);
                context.setVars(vars);
                ELResolution resolution = resolver.resolve((ELContext)context, operand, offset);
                List segments = resolution.findSegmentsByVariable((IVariable)this.seamComponent);
                for (ELSegment segment : segments) {
                    this.match(file, offset + segment.getSourceReference().getStartPosition(), segment.getSourceReference().getLength());
                }
            }
            ++n2;
        }
    }
}

