/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core.refactoring;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.internal.core.refactoring.Messages;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.jboss.tools.common.el.core.model.ELInvocationExpression;
import org.jboss.tools.common.el.core.model.ELPropertyInvocation;
import org.jboss.tools.common.text.ITextSourceReference;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.seam.core.BijectedAttributeType;
import org.jboss.tools.seam.core.IBijectedAttribute;
import org.jboss.tools.seam.core.ISeamComponent;
import org.jboss.tools.seam.core.ISeamFactory;
import org.jboss.tools.seam.core.ISeamJavaComponentDeclaration;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.ISeamXmlComponentDeclaration;
import org.jboss.tools.seam.core.SeamCoreMessages;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.core.SeamProjectsSet;
import org.jboss.tools.seam.core.SeamUtil;
import org.jboss.tools.seam.internal.core.SeamComponentDeclaration;
import org.jboss.tools.seam.internal.core.refactoring.SeamRefactorSearcher;

public abstract class SeamRenameProcessor
extends RenameProcessor {
    protected static final String JAVA_EXT = "java";
    protected static final String XML_EXT = "xml";
    protected static final String XHTML_EXT = "xhtml";
    protected static final String JSP_EXT = "jsp";
    protected static final String PROPERTIES_EXT = "properties";
    protected static final RefactoringParticipant[] EMPTY_REF_PARTICIPANT = new RefactoringParticipant[0];
    protected static final String SEAM_PROPERTIES_FILE = "seam.properties";
    protected RefactoringStatus status;
    protected CompositeChange rootChange;
    protected TextFileChange lastChange;
    protected IFile declarationFile = null;
    protected SeamProjectsSet projectsSet;
    private String newName;
    private String oldName;
    private SeamSearcher searcher = null;
    protected ISeamComponent component;
    ArrayList<String> keys = new ArrayList();

    protected SeamSearcher getSearcher() {
        if (this.searcher == null) {
            this.searcher = new SeamSearcher(this.declarationFile, this.getOldName());
        }
        return this.searcher;
    }

    public void setNewName(String newName) {
        this.newName = newName;
    }

    protected String getNewName() {
        return this.newName;
    }

    protected void setOldName(String oldName) {
        this.oldName = oldName;
    }

    public String getOldName() {
        return this.oldName;
    }

    protected TextFileChange getChange(IFile file) {
        if (this.lastChange != null && this.lastChange.getFile().equals((Object)file)) {
            return this.lastChange;
        }
        int i = 0;
        while (i < this.rootChange.getChildren().length) {
            TextFileChange change = (TextFileChange)this.rootChange.getChildren()[i];
            if (change.getFile().equals((Object)file)) {
                this.lastChange = change;
                return this.lastChange;
            }
            ++i;
        }
        this.lastChange = new TextFileChange(file.getName(), file);
        MultiTextEdit root = new MultiTextEdit();
        this.lastChange.setEdit((TextEdit)root);
        this.rootChange.add((Change)this.lastChange);
        return this.lastChange;
    }

    protected void findDeclarations(ISeamComponent component) throws CoreException {
        IProject[] projects;
        this.changeDeclarations(component);
        if (this.declarationFile == null) {
            return;
        }
        this.projectsSet = new SeamProjectsSet(this.declarationFile.getProject());
        IProject[] iProjectArray = projects = this.projectsSet.getAllProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            ISeamComponent comp;
            IProject project = iProjectArray[n2];
            ISeamProject seamProject = SeamCorePlugin.getSeamProject(project, true);
            if (seamProject != null && (comp = seamProject.getComponent(this.getOldName())) != null) {
                this.changeDeclarations(comp);
            }
            ++n2;
        }
    }

    protected void findAnnotations() {
        IProject[] projects;
        if (this.declarationFile == null) {
            this.status.addFatalError(Messages.format((String)SeamCoreMessages.SEAM_RENAME_PROCESSOR_DECLARATION_NOT_FOUND, (Object)this.getOldName()));
            return;
        }
        ISeamProject seamProject = SeamCorePlugin.getSeamProject(this.declarationFile.getProject(), true);
        if (seamProject == null) {
            return;
        }
        this.findInFactoryAnnotations(seamProject);
        IProject[] iProjectArray = projects = this.projectsSet.getAllProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            ISeamProject sProject = SeamCorePlugin.getSeamProject(project, true);
            if (sProject != null) {
                this.findInFactoryAnnotations(sProject);
            }
            ++n2;
        }
    }

    private void findInFactoryAnnotations(ISeamProject seamProject) {
        this.findAnnotations(seamProject, BijectedAttributeType.IN, "org.jboss.seam.annotations.In");
        this.findFactories(seamProject);
    }

    private void findFactories(ISeamProject seamProject) {
        Set<ISeamFactory> factorySet = seamProject.getFactoriesByName(this.getOldName());
        for (ISeamFactory factory : factorySet) {
            this.changeFactory(factory);
        }
    }

    private void findAnnotations(ISeamProject seamProject, BijectedAttributeType type, String locationPath) {
        Set<IBijectedAttribute> attributes = seamProject.getBijectedAttributesByName(this.getOldName(), type);
        for (IBijectedAttribute attribute : attributes) {
            ITextSourceReference location = attribute.getLocationFor(locationPath);
            this.changeAnnotation(location, (IFile)attribute.getResource());
        }
    }

    private void changeFactory(ISeamFactory factory) {
        IFile file = (IFile)factory.getResource();
        if (file.getFileExtension().equalsIgnoreCase(JAVA_EXT)) {
            ITextSourceReference location = factory.getLocationFor("org.jboss.seam.annotations.Factory");
            this.changeAnnotation(location, file);
        } else {
            ITextSourceReference location = factory.getLocationFor("name");
            this.changeXMLNode(location, file);
        }
    }

    private boolean isBadLocation(ITextSourceReference location, IFile file) {
        boolean flag;
        if (location == null) {
            flag = true;
        } else {
            boolean bl = flag = location.getStartPosition() == 0 && location.getLength() == 0;
        }
        if (flag) {
            this.status.addFatalError(Messages.format((String)SeamCoreMessages.SEAM_RENAME_PROCESSOR_LOCATION_NOT_FOUND, (Object)file.getFullPath().toString()));
        }
        return flag;
    }

    private void changeXMLNode(ITextSourceReference location, IFile file) {
        if (this.isBadLocation(location, file)) {
            return;
        }
        if (!this.isFileCorrect(file)) {
            return;
        }
        String content = null;
        try {
            content = FileUtil.readStream((IFile)file);
        }
        catch (CoreException e) {
            SeamCorePlugin.getDefault().logError(e);
        }
        String text = content.substring(location.getStartPosition(), location.getStartPosition() + location.getLength());
        if (text.startsWith("<")) {
            int position = text.lastIndexOf("/>");
            if (position < 0) {
                position = text.lastIndexOf(">");
            }
            this.change(file, location.getStartPosition() + position, 0, " name=\"" + this.getNewName() + "\"");
        } else {
            this.change(file, location.getStartPosition(), location.getLength(), this.getNewName());
        }
    }

    private void changeAnnotation(ITextSourceReference location, IFile file) {
        if (this.isBadLocation(location, file)) {
            return;
        }
        if (!this.isFileCorrect(file)) {
            return;
        }
        String content = null;
        try {
            content = FileUtil.readStream((IFile)file);
        }
        catch (CoreException e) {
            SeamCorePlugin.getDefault().logError(e);
        }
        String text = content.substring(location.getStartPosition(), location.getStartPosition() + location.getLength());
        int openBracket = text.indexOf("(");
        int openQuote = text.indexOf("\"");
        if (openBracket >= 0) {
            int closeBracket = text.indexOf(")", openBracket);
            int equals = text.indexOf("=", openBracket);
            int value = text.indexOf("value", openBracket);
            if (closeBracket == openBracket + 1) {
                String newText = "\"" + this.getNewName() + "\"";
                this.change(file, location.getStartPosition() + openBracket + 1, 0, newText);
            } else if (value > 0) {
                String newText = text.replace(this.getOldName(), this.getNewName());
                this.change(file, location.getStartPosition(), location.getLength(), newText);
            } else if (equals > 0) {
                String newText = "value=\"" + this.getNewName() + "\",";
                this.change(file, location.getStartPosition() + openBracket + 1, 0, newText);
            } else {
                String newText = text.replace(this.getOldName(), this.getNewName());
                this.change(file, location.getStartPosition(), location.getLength(), newText);
            }
        } else if (openQuote >= 0) {
            int closeQuota = text.indexOf("\"", openQuote);
            if (closeQuota == openQuote + 1) {
                String newText = "\"" + this.getNewName() + "\"";
                this.change(file, location.getStartPosition() + openQuote + 1, 0, newText);
            } else {
                String newText = text.replace(this.getOldName(), this.getNewName());
                this.change(file, location.getStartPosition(), location.getLength(), newText);
            }
        } else {
            String newText = "(\"" + this.getNewName() + "\")";
            this.change(file, location.getStartPosition() + location.getLength(), 0, newText);
        }
    }

    private void changeDeclarations(ISeamComponent component) throws CoreException {
        if (component.getJavaDeclaration() != null) {
            this.renameJavaDeclaration(component.getJavaDeclaration());
        }
        Set<ISeamXmlComponentDeclaration> xmlDecls = component.getXmlDeclarations();
        for (ISeamXmlComponentDeclaration xmlDecl : xmlDecls) {
            this.renameXMLDeclaration(xmlDecl);
        }
    }

    protected void checkDeclarations(ISeamComponent component) throws CoreException {
        if (component.getJavaDeclaration() != null) {
            if (component.getJavaDeclaration().getResource() == null) {
                this.status.addFatalError(Messages.format((String)SeamCoreMessages.SEAM_RENAME_PROCESSOR_COMPONENT_HAS_BROKEN_DECLARATION, (Object[])new String[]{component.getName()}));
            } else if (SeamUtil.isJar(component.getJavaDeclaration()) && component.getJavaDeclaration().getName() != null) {
                this.status.addInfo(Messages.format((String)SeamCoreMessages.SEAM_RENAME_PROCESSOR_COMPONENT_HAS_DECLARATION_FROM_JAR, (Object[])new String[]{component.getName(), component.getJavaDeclaration().getResource().getFullPath().toString()}));
            }
        }
        Set<ISeamXmlComponentDeclaration> xmlDecls = component.getXmlDeclarations();
        for (ISeamXmlComponentDeclaration xmlDecl : xmlDecls) {
            if (xmlDecl.getResource() == null) {
                this.status.addFatalError(Messages.format((String)SeamCoreMessages.SEAM_RENAME_PROCESSOR_COMPONENT_HAS_BROKEN_DECLARATION, (Object[])new String[]{component.getName()}));
                continue;
            }
            if (!SeamUtil.isJar(xmlDecl) || xmlDecl.getName() == null) continue;
            this.status.addInfo(Messages.format((String)SeamCoreMessages.SEAM_RENAME_PROCESSOR_COMPONENT_HAS_DECLARATION_FROM_JAR, (Object[])new String[]{component.getName(), xmlDecl.getResource().getFullPath().toString()}));
        }
    }

    protected boolean isFileCorrect(IFile file) {
        if (!file.isSynchronized(0)) {
            this.status.addFatalError(Messages.format((String)SeamCoreMessages.SEAM_RENAME_PROCESSOR_OUT_OF_SYNC_FILE, (Object)file.getFullPath().toString()));
            return false;
        }
        if (file.isPhantom()) {
            this.status.addFatalError(Messages.format((String)SeamCoreMessages.SEAM_RENAME_PROCESSOR_ERROR_PHANTOM_FILE, (Object)file.getFullPath().toString()));
            return false;
        }
        if (file.isReadOnly()) {
            this.status.addFatalError(Messages.format((String)SeamCoreMessages.SEAM_RENAME_PROCESSOR_ERROR_READ_ONLY_FILE, (Object)file.getFullPath().toString()));
            return false;
        }
        return true;
    }

    private void renameJavaDeclaration(ISeamJavaComponentDeclaration javaDecl) throws CoreException {
        ITextSourceReference location;
        IFile file = (IFile)javaDecl.getResource();
        if (file != null && !SeamUtil.isJar(javaDecl) && (location = ((SeamComponentDeclaration)((Object)javaDecl)).getLocationFor("name")) != null && !this.isBadLocation(location, file)) {
            this.change(file, location.getStartPosition(), location.getLength(), "\"" + this.getNewName() + "\"");
        }
        this.declarationFile = file;
    }

    private void renameXMLDeclaration(ISeamXmlComponentDeclaration xmlDecl) throws CoreException {
        ITextSourceReference location;
        IFile file = (IFile)xmlDecl.getResource();
        if (file != null && !SeamUtil.isJar(xmlDecl) && (location = ((SeamComponentDeclaration)((Object)xmlDecl)).getLocationFor("name")) != null && !this.isBadLocation(location, file)) {
            this.changeXMLNode(location, file);
        }
        if (this.declarationFile == null) {
            this.declarationFile = file;
        }
    }

    private boolean checkFolder(IResource resource, IResource[] sources, IPath output) {
        IResource[] iResourceArray = sources;
        int n = sources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource folder = iResourceArray[n2];
            if (resource.equals((Object)folder)) {
                return false;
            }
            ++n2;
        }
        return !resource.getFullPath().equals((Object)output);
    }

    protected void renameComponent(IProgressMonitor pm, ISeamComponent component) throws CoreException {
        pm.beginTask("", 3);
        this.clearChanges();
        this.findDeclarations(component);
        if (this.status.hasFatalError()) {
            return;
        }
        pm.worked(1);
        this.findAnnotations();
        if (this.status.hasFatalError()) {
            return;
        }
        pm.worked(1);
        this.getSearcher().findELReferences();
        pm.done();
    }

    protected void renameSeamContextVariable(IProgressMonitor pm, IFile sourceFile) throws CoreException {
        pm.beginTask("", 2);
        this.clearChanges();
        this.declarationFile = sourceFile;
        this.findOutDataModelFactory();
        if (this.status.hasFatalError()) {
            return;
        }
        pm.worked(1);
        this.getSearcher().findELReferences();
        pm.done();
    }

    protected void findOutDataModelFactory() {
        IProject[] projects;
        if (this.declarationFile == null) {
            return;
        }
        ISeamProject seamProject = SeamCorePlugin.getSeamProject(this.declarationFile.getProject(), true);
        if (seamProject == null) {
            return;
        }
        IProject[] iProjectArray = projects = this.projectsSet.getAllProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            ISeamProject sProject = SeamCorePlugin.getSeamProject(project, true);
            if (sProject != null) {
                this.findAnnotations(sProject, BijectedAttributeType.OUT, "org.jboss.seam.annotations.Out");
                this.findAnnotations(sProject, BijectedAttributeType.DATA_BINDER, "org.jboss.seam.annotations.datamodel.DataModel");
                this.findFactories(sProject);
            }
            ++n2;
        }
    }

    private void clearChanges() {
        this.keys.clear();
    }

    private void change(IFile file, int offset, int length, String text) {
        String key = String.valueOf(file.getFullPath().toString()) + " " + offset;
        if (!this.keys.contains(key)) {
            TextFileChange change = this.getChange(file);
            ReplaceEdit edit = new ReplaceEdit(offset, length, text);
            change.addEdit((TextEdit)edit);
            this.keys.add(key);
        }
    }

    class SeamSearcher
    extends SeamRefactorSearcher {
        public SeamSearcher(IFile declarationFile, String oldName) {
            super(declarationFile, oldName);
        }

        protected boolean isFileCorrect(IFile file) {
            return SeamRenameProcessor.this.isFileCorrect(file);
        }

        protected void match(IFile file, int offset, int length) {
            SeamRenameProcessor.this.change(file, offset, length, SeamRenameProcessor.this.newName);
        }

        protected ELInvocationExpression findComponentReference(ELInvocationExpression invocationExpression) {
            if (this.seamComponent != null) {
                return invocationExpression;
            }
            ELInvocationExpression invExp = invocationExpression;
            while (invExp != null) {
                if (invExp instanceof ELPropertyInvocation) {
                    if (((ELPropertyInvocation)invExp).getQualifiedName() != null && ((ELPropertyInvocation)invExp).getQualifiedName().equals(this.propertyName)) {
                        return invExp;
                    }
                    invExp = invExp.getLeft();
                    continue;
                }
                invExp = invExp.getLeft();
            }
            return null;
        }
    }
}

