/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core.scanner.java;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.jboss.tools.common.model.util.EclipseJavaUtil;
import org.jboss.tools.seam.internal.core.scanner.Util;
import org.jboss.tools.seam.internal.core.scanner.java.AnnotatedASTNode;
import org.jboss.tools.seam.internal.core.scanner.java.JavaScanner;
import org.jboss.tools.seam.internal.core.scanner.java.ResolvedAnnotation;
import org.jboss.tools.seam.internal.core.scanner.java.SeamAnnotations;

public class ASTVisitorImpl
extends ASTVisitor
implements SeamAnnotations {
    public TypeData root = null;
    TypeData current = null;

    public void setType(IType type) {
        this.root = new TypeData();
        this.root.type = type;
    }

    public boolean hasSeamComponent() {
        return this.root.hasSeamComponent();
    }

    public boolean visit(SingleMemberAnnotation node) {
        if (this.current.innerLock > 0) {
            return false;
        }
        String type = this.resolveType((Annotation)node);
        if (Util.isSeamAnnotationType(type) && this.current.currentAnnotatedNode != null) {
            this.current.currentAnnotatedNode.addAnnotation(new ResolvedAnnotation(type, (Annotation)node));
        }
        return false;
    }

    public boolean visit(NormalAnnotation node) {
        if (this.current.innerLock > 0) {
            return false;
        }
        String type = this.resolveType((Annotation)node);
        if (Util.isSeamAnnotationType(type) && this.current.currentAnnotatedNode != null) {
            this.current.currentAnnotatedNode.addAnnotation(new ResolvedAnnotation(type, (Annotation)node));
        }
        return false;
    }

    public boolean visit(MarkerAnnotation node) {
        if (this.current.innerLock > 0) {
            return false;
        }
        String type = this.resolveType((Annotation)node);
        if (Util.isSeamAnnotationType(type) && this.current.currentAnnotatedNode != null) {
            this.current.currentAnnotatedNode.addAnnotation(new ResolvedAnnotation(type, (Annotation)node));
        }
        return true;
    }

    boolean checkAnnotationType(Annotation node, String annotationType) {
        String n = this.resolveType(node);
        return n != null && n.equals(annotationType);
    }

    String resolveType(Annotation node) {
        return ASTVisitorImpl.resolveType(this.current.type, node);
    }

    static String resolveType(IType type, Annotation node) {
        Name nm = node.getTypeName();
        if (nm instanceof SimpleName) {
            SimpleName sn = (SimpleName)nm;
            String n = sn.getIdentifier();
            if (type != null) {
                return JavaScanner.getResolvedType(type, n);
            }
        } else if (nm instanceof QualifiedName) {
            QualifiedName qn = (QualifiedName)nm;
            return qn.getFullyQualifiedName();
        }
        return null;
    }

    public boolean visit(Block node) {
        return false;
    }

    public boolean visit(TypeDeclaration node) {
        return this._visit((AbstractTypeDeclaration)node);
    }

    public boolean visit(EnumDeclaration node) {
        return this._visit((AbstractTypeDeclaration)node);
    }

    public boolean visit(AnnotationTypeDeclaration node) {
        return this._visit((AbstractTypeDeclaration)node);
    }

    private boolean _visit(AbstractTypeDeclaration node) {
        block14: {
            IType t;
            block15: {
                String n;
                block13: {
                    if (this.current == null) {
                        n = node.getName().getFullyQualifiedName();
                        if (n != null && n.indexOf(46) < 0) {
                            n = EclipseJavaUtil.resolveType((IType)this.root.type, (String)n);
                        }
                        String nr = this.root.type.getFullyQualifiedName();
                        if (n == null || !n.equals(nr)) {
                            return false;
                        }
                        this.current = this.root;
                    }
                    if (this.current.annotatedType != null) break block13;
                    this.current.annotatedType = new AnnotatedASTNode<AbstractTypeDeclaration>(node);
                    this.current.currentAnnotatedNode = this.current.annotatedType;
                    break block14;
                }
                n = node.getName().getFullyQualifiedName();
                if (n != null && n.indexOf(46) < 0) {
                    n = EclipseJavaUtil.resolveType((IType)this.current.type, (String)n);
                }
                IType[] ts = null;
                try {
                    ts = this.current.type.getTypes();
                }
                catch (JavaModelException javaModelException) {}
                t = null;
                if (ts == null) break block15;
                int i = 0;
                while (t == null && i < ts.length) {
                    block16: {
                        try {
                            if (!Flags.isStatic((int)ts[i].getFlags())) {
                            }
                        }
                        catch (JavaModelException javaModelException) {}
                        break block16;
                        String ni = ts[i].getFullyQualifiedName();
                        if (ni != null) {
                            ni = ni.replace('$', '.');
                        }
                        if (n != null && n.equals(ni)) {
                            t = ts[i];
                        }
                    }
                    ++i;
                }
            }
            if (t == null) {
                ++this.current.innerLock;
                return false;
            }
            TypeData d = new TypeData();
            d.type = t;
            d.parent = this.current;
            this.current.children.add(d);
            this.current = d;
            this.current.annotatedType = new AnnotatedASTNode<AbstractTypeDeclaration>(node);
            this.current.currentAnnotatedNode = this.current.annotatedType;
        }
        return true;
    }

    public void endVisit(TypeDeclaration node) {
        this._endVisit((AbstractTypeDeclaration)node);
    }

    public void endVisit(AnnotationTypeDeclaration node) {
        this._endVisit((AbstractTypeDeclaration)node);
    }

    public void endVisit(EnumDeclaration node) {
        this._endVisit((AbstractTypeDeclaration)node);
    }

    public void _endVisit(AbstractTypeDeclaration node) {
        if (this.current == null) {
            return;
        }
        if (this.current.currentAnnotatedNode != null && this.current.currentAnnotatedNode.node == node) {
            this.current.currentAnnotatedNode = null;
            this.current = this.current.parent;
        } else {
            --this.current.innerLock;
        }
    }

    public boolean visit(FieldDeclaration node) {
        if (this.current == null || this.current.innerLock > 0) {
            return false;
        }
        this.current.currentAnnotatedField = new AnnotatedASTNode<FieldDeclaration>(node);
        this.current.currentAnnotatedNode = this.current.currentAnnotatedField;
        return true;
    }

    public void endVisit(FieldDeclaration node) {
        if (this.current == null || this.current.innerLock > 0) {
            return;
        }
        if (this.current.currentAnnotatedField != null && this.current.currentAnnotatedField.getAnnotations() != null) {
            this.current.annotatedFields.add(this.current.currentAnnotatedField);
        }
        this.current.currentAnnotatedField = null;
        this.current.currentAnnotatedNode = this.current.annotatedType;
    }

    public boolean visit(MethodDeclaration node) {
        if (this.current == null || this.current.innerLock > 0) {
            return false;
        }
        this.current.currentAnnotatedMethod = new AnnotatedASTNode<MethodDeclaration>(node);
        this.current.currentAnnotatedNode = this.current.currentAnnotatedMethod;
        return true;
    }

    public void endVisit(MethodDeclaration node) {
        if (this.current == null || this.current.innerLock > 0) {
            return;
        }
        if (this.current.currentAnnotatedMethod != null && this.current.currentAnnotatedMethod.getAnnotations() != null) {
            this.current.annotatedMethods.add(this.current.currentAnnotatedMethod);
        }
        this.current.currentAnnotatedMethod = null;
        this.current.currentAnnotatedNode = this.current.annotatedType;
    }

    public static class TypeData {
        TypeData parent = null;
        List<TypeData> children = new ArrayList<TypeData>();
        public IType type;
        int innerLock = 0;
        public AnnotatedASTNode<AbstractTypeDeclaration> annotatedType = null;
        public Set<AnnotatedASTNode<FieldDeclaration>> annotatedFields = new HashSet<AnnotatedASTNode<FieldDeclaration>>();
        public Set<AnnotatedASTNode<MethodDeclaration>> annotatedMethods = new HashSet<AnnotatedASTNode<MethodDeclaration>>();
        AnnotatedASTNode<?> currentAnnotatedNode = null;
        AnnotatedASTNode<FieldDeclaration> currentAnnotatedField = null;
        AnnotatedASTNode<MethodDeclaration> currentAnnotatedMethod = null;

        public boolean hasSeamComponentItself() {
            if (!this.annotatedFields.isEmpty() || !this.annotatedMethods.isEmpty()) {
                return true;
            }
            return this.annotatedType != null && this.annotatedType.getAnnotations() != null;
        }

        public boolean hasSeamComponent() {
            if (this.hasSeamComponentItself()) {
                return true;
            }
            for (TypeData c : this.children) {
                if (!c.hasSeamComponent()) continue;
                return true;
            }
            return false;
        }
    }
}

